/* CodeMirror, copyright (c) by Marijn Haverbeke and others. Distributed under an MIT license: http://codemirror.net/LICENSE */
!function(global, factory) {
    "object" == typeof exports && "undefined" != typeof module ? module.exports = factory() : "function" == typeof define && define.amd ? define(factory) : (global = "undefined" != typeof globalThis ? globalThis : global || self).CodeMirror = factory();
}(this, function() {
    "use strict";
    var userAgent = navigator.userAgent, platform = navigator.platform, gecko = /gecko\/\d/i.test(userAgent), ie_upto10 = /MSIE \d/.test(userAgent), ie_11up = /Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(userAgent), edge = /Edge\/(\d+)/.exec(userAgent), ie = ie_upto10 || ie_11up || edge, ie_version = ie && (ie_upto10 ? document.documentMode || 6 : +(edge || ie_11up)[1]), webkit = !edge && /WebKit\//.test(userAgent), ie_upto10 = webkit && /Qt\/\d+\.\d+/.test(userAgent), chrome = !edge && /Chrome\/(\d+)/.exec(userAgent), chrome_version = chrome && +chrome[1], presto = /Opera\//.test(userAgent), safari = /Apple Computer/.test(navigator.vendor), mac_geMountainLion = /Mac OS X 1\d\D([8-9]|\d\d)\D/.test(userAgent), phantom = /PhantomJS/.test(userAgent), ios = safari && (/Mobile\/\w+/.test(userAgent) || 2 < navigator.maxTouchPoints), android = /Android/.test(userAgent), mobile = ios || android || /webOS|BlackBerry|Opera Mini|Opera Mobi|IEMobile/i.test(userAgent), mac = ios || /Mac/.test(platform), chromeOS = /\bCrOS\b/.test(userAgent), windows = /win/i.test(platform), ie_11up = presto && userAgent.match(/Version\/(\d*\.\d*)/), flipCtrlCmd = ((ie_11up = ie_11up && Number(ie_11up[1])) && 15 <= ie_11up && (webkit = !(presto = !1)), 
    mac && (ie_upto10 || presto && (null == ie_11up || ie_11up < 12.11))), captureRightClick = gecko || ie && 9 <= ie_version;
    function classTest(cls) {
        return new RegExp("(^|\\s)" + cls + "(?:$|\\s)\\s*");
    }
    var rmClass = function(node, cls) {
        var after, current = node.className, cls = classTest(cls).exec(current);
        cls && (after = current.slice(cls.index + cls[0].length), node.className = current.slice(0, cls.index) + (after ? cls[1] + after : ""));
    };
    function removeChildren(e) {
        for (var count = e.childNodes.length; 0 < count; --count) e.removeChild(e.firstChild);
        return e;
    }
    function removeChildrenAndAdd(parent, e) {
        return removeChildren(parent).appendChild(e);
    }
    function elt(tag, content, className, style) {
        var e = document.createElement(tag);
        if (className && (e.className = className), style && (e.style.cssText = style), 
        "string" == typeof content) e.appendChild(document.createTextNode(content)); else if (content) for (var i = 0; i < content.length; ++i) e.appendChild(content[i]);
        return e;
    }
    function eltP(tag, content, className, style) {
        tag = elt(tag, content, className, style);
        return tag.setAttribute("role", "presentation"), tag;
    }
    function contains(parent, child) {
        if (3 == child.nodeType && (child = child.parentNode), parent.contains) return parent.contains(child);
        do {
            if ((child = 11 == child.nodeType ? child.host : child) == parent) return !0;
        } while (child = child.parentNode);
    }
    function activeElt() {
        var activeElement;
        try {
            activeElement = document.activeElement;
        } catch (e) {
            activeElement = document.body || null;
        }
        for (;activeElement && activeElement.shadowRoot && activeElement.shadowRoot.activeElement; ) activeElement = activeElement.shadowRoot.activeElement;
        return activeElement;
    }
    function addClass(node, cls) {
        var current = node.className;
        classTest(cls).test(current) || (node.className += (current ? " " : "") + cls);
    }
    function joinClasses(a, b) {
        for (var as = a.split(" "), i = 0; i < as.length; i++) as[i] && !classTest(as[i]).test(b) && (b += " " + as[i]);
        return b;
    }
    var range = document.createRange ? function(node, start, end, endNode) {
        var r = document.createRange();
        return r.setEnd(endNode || node, end), r.setStart(node, start), r;
    } : function(node, start, end) {
        var r = document.body.createTextRange();
        try {
            r.moveToElementText(node.parentNode);
        } catch (e) {
            return r;
        }
        return r.collapse(!0), r.moveEnd("character", end), r.moveStart("character", start), 
        r;
    }, selectInput = function(node) {
        node.select();
    };
    function bind(f) {
        var args = Array.prototype.slice.call(arguments, 1);
        return function() {
            return f.apply(null, args);
        };
    }
    function copyObj(obj, target, overwrite) {
        for (var prop in target = target || {}, obj) !obj.hasOwnProperty(prop) || !1 === overwrite && target.hasOwnProperty(prop) || (target[prop] = obj[prop]);
        return target;
    }
    function countColumn(string, end, tabSize, startIndex, startValue) {
        null == end && -1 == (end = string.search(/[^\s\u00a0]/)) && (end = string.length);
        for (var i = startIndex || 0, n = startValue || 0; ;) {
            var nextTab = string.indexOf("\t", i);
            if (nextTab < 0 || end <= nextTab) return n + (end - i);
            n = (n += nextTab - i) + (tabSize - n % tabSize), i = nextTab + 1;
        }
    }
    ios ? selectInput = function(node) {
        node.selectionStart = 0, node.selectionEnd = node.value.length;
    } : ie && (selectInput = function(node) {
        try {
            node.select();
        } catch (_e) {}
    });
    function Delayed() {
        this.id = null, this.f = null, this.time = 0, this.handler = bind(this.onTimeout, this);
    }
    function indexOf(array, elt) {
        for (var i = 0; i < array.length; ++i) if (array[i] == elt) return i;
        return -1;
    }
    Delayed.prototype.onTimeout = function(self) {
        self.id = 0, self.time <= +new Date() ? self.f() : setTimeout(self.handler, self.time - +new Date());
    };
    var scrollerGap = 50, Pass = {
        toString: function() {
            return "CodeMirror.Pass";
        }
    }, sel_dontScroll = {
        scroll: !(Delayed.prototype.set = function(ms, f) {
            this.f = f;
            f = +new Date() + ms;
            (!this.id || f < this.time) && (clearTimeout(this.id), this.id = setTimeout(this.handler, ms), 
            this.time = f);
        })
    }, sel_mouse = {
        origin: "*mouse"
    }, sel_move = {
        origin: "+move"
    };
    function findColumn(string, goal, tabSize) {
        for (var pos = 0, col = 0; ;) {
            var nextTab = string.indexOf("\t", pos), skipped = (nextTab = -1 == nextTab ? string.length : nextTab) - pos;
            if (nextTab == string.length || goal <= col + skipped) return pos + Math.min(skipped, goal - col);
            if (col += nextTab - pos, pos = nextTab + 1, goal <= (col += tabSize - col % tabSize)) return pos;
        }
    }
    var spaceStrs = [ "" ];
    function spaceStr(n) {
        for (;spaceStrs.length <= n; ) spaceStrs.push(lst(spaceStrs) + " ");
        return spaceStrs[n];
    }
    function lst(arr) {
        return arr[arr.length - 1];
    }
    function map(array, f) {
        for (var out = [], i = 0; i < array.length; i++) out[i] = f(array[i], i);
        return out;
    }
    function nothing() {}
    function createObj(base, props) {
        base = Object.create ? Object.create(base) : (nothing.prototype = base, 
        new nothing());
        return props && copyObj(props, base), base;
    }
    var nonASCIISingleCaseWordChar = /[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;
    function isWordCharBasic(ch) {
        return /\w/.test(ch) || "\x80" < ch && (ch.toUpperCase() != ch.toLowerCase() || nonASCIISingleCaseWordChar.test(ch));
    }
    function isWordChar(ch, helper) {
        return helper ? !!(-1 < helper.source.indexOf("\\w") && isWordCharBasic(ch)) || helper.test(ch) : isWordCharBasic(ch);
    }
    function isEmpty(obj) {
        for (var n in obj) if (obj.hasOwnProperty(n) && obj[n]) return;
        return 1;
    }
    var extendingChars = /[\u0300-\u036f\u0483-\u0489\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u065e\u0670\u06d6-\u06dc\u06de-\u06e4\u06e7\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u07a6-\u07b0\u07eb-\u07f3\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0900-\u0902\u093c\u0941-\u0948\u094d\u0951-\u0955\u0962\u0963\u0981\u09bc\u09be\u09c1-\u09c4\u09cd\u09d7\u09e2\u09e3\u0a01\u0a02\u0a3c\u0a41\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a70\u0a71\u0a75\u0a81\u0a82\u0abc\u0ac1-\u0ac5\u0ac7\u0ac8\u0acd\u0ae2\u0ae3\u0b01\u0b3c\u0b3e\u0b3f\u0b41-\u0b44\u0b4d\u0b56\u0b57\u0b62\u0b63\u0b82\u0bbe\u0bc0\u0bcd\u0bd7\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0cbc\u0cbf\u0cc2\u0cc6\u0ccc\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0d3e\u0d41-\u0d44\u0d4d\u0d57\u0d62\u0d63\u0dca\u0dcf\u0dd2-\u0dd4\u0dd6\u0ddf\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0eb9\u0ebb\u0ebc\u0ec8-\u0ecd\u0f18\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86\u0f87\u0f90-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039\u103a\u103d\u103e\u1058\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085\u1086\u108d\u109d\u135f\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u180b-\u180d\u18a9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193b\u1a17\u1a18\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80\u1b81\u1ba2-\u1ba5\u1ba8\u1ba9\u1c2c-\u1c33\u1c36\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1dc0-\u1de6\u1dfd-\u1dff\u200c\u200d\u20d0-\u20f0\u2cef-\u2cf1\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua66f-\ua672\ua67c\ua67d\ua6f0\ua6f1\ua802\ua806\ua80b\ua825\ua826\ua8c4\ua8e0-\ua8f1\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc\uaa29-\uaa2e\uaa31\uaa32\uaa35\uaa36\uaa43\uaa4c\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uabe5\uabe8\uabed\udc00-\udfff\ufb1e\ufe00-\ufe0f\ufe20-\ufe26\uff9e\uff9f]/;
    function isExtendingChar(ch) {
        return 768 <= ch.charCodeAt(0) && extendingChars.test(ch);
    }
    function skipExtendingChars(str, pos, dir) {
        for (;(dir < 0 ? 0 < pos : pos < str.length) && isExtendingChar(str.charAt(pos)); ) pos += dir;
        return pos;
    }
    function findFirst(pred, from, to) {
        for (var dir = to < from ? -1 : 1; ;) {
            if (from == to) return from;
            var midF = (from + to) / 2, midF = dir < 0 ? Math.ceil(midF) : Math.floor(midF);
            if (midF == from) return pred(midF) ? from : to;
            pred(midF) ? to = midF : from = midF + dir;
        }
    }
    var bidiOther = null;
    function getBidiPartAt(order, ch, sticky) {
        var found;
        bidiOther = null;
        for (var i = 0; i < order.length; ++i) {
            var cur = order[i];
            if (cur.from < ch && cur.to > ch) return i;
            cur.to == ch && (cur.from != cur.to && "before" == sticky ? found = i : bidiOther = i), 
            cur.from == ch && (cur.from != cur.to && "before" != sticky ? found = i : bidiOther = i);
        }
        return null != found ? found : bidiOther;
    }
    bidiRE = /[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac]/, isNeutral = /[stwN]/, 
    isStrong = /[LRr]/, countsAsLeft = /[Lb1n]/, countsAsNum = /[1n]/;
    var bidiRE, isNeutral, isStrong, countsAsLeft, countsAsNum, bidiOrdering = function(str, direction) {
        var outerType = "ltr" == direction ? "L" : "R";
        if (0 == str.length || "ltr" == direction && !bidiRE.test(str)) return !1;
        for (var code, len = str.length, types = [], i = 0; i < len; ++i) types.push((code = str.charCodeAt(i)) <= 247 ? "bbbbbbbbbtstwsbbbbbbbbbbbbbbssstwNN%%%NNNNNN,N,N1111111111NNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNbbbbbbsbbbbbbbbbbbbbbbbbbbbbbbbbb,N%%%%NNNNLNNNNN%%11NLNNN1LNNNNNLLLLLLLLLLLLLLLLLLLLLLLNLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLN".charAt(code) : 1424 <= code && code <= 1524 ? "R" : 1536 <= code && code <= 1785 ? "nnnnnnNNr%%r,rNNmmmmmmmmmmmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmmmmmmmmmmmmmmmnnnnnnnnnn%nnrrrmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmnNmmmmmmrrmmNmmmmrr1111111111".charAt(code - 1536) : 1774 <= code && code <= 2220 ? "r" : 8192 <= code && code <= 8203 ? "w" : 8204 == code ? "b" : "L");
        for (var i$1 = 0, prev = outerType; i$1 < len; ++i$1) {
            var type = types[i$1];
            "m" == type ? types[i$1] = prev : prev = type;
        }
        for (var i$2 = 0, cur = outerType; i$2 < len; ++i$2) {
            var type$1 = types[i$2];
            "1" == type$1 && "r" == cur ? types[i$2] = "n" : isStrong.test(type$1) && "r" == (cur = type$1) && (types[i$2] = "R");
        }
        for (var i$3 = 1, prev$1 = types[0]; i$3 < len - 1; ++i$3) {
            var type$2 = types[i$3];
            "+" == type$2 && "1" == prev$1 && "1" == types[i$3 + 1] ? types[i$3] = "1" : "," != type$2 || prev$1 != types[i$3 + 1] || "1" != prev$1 && "n" != prev$1 || (types[i$3] = prev$1), 
            prev$1 = type$2;
        }
        for (var i$4 = 0; i$4 < len; ++i$4) {
            var type$3 = types[i$4];
            if ("," == type$3) types[i$4] = "N"; else if ("%" == type$3) {
                for (var end = void 0, end = i$4 + 1; end < len && "%" == types[end]; ++end);
                for (var replace = i$4 && "!" == types[i$4 - 1] || end < len && "1" == types[end] ? "1" : "N", j = i$4; j < end; ++j) types[j] = replace;
                i$4 = end - 1;
            }
        }
        for (var i$5 = 0, cur$1 = outerType; i$5 < len; ++i$5) {
            var type$4 = types[i$5];
            "L" == cur$1 && "1" == type$4 ? types[i$5] = "L" : isStrong.test(type$4) && (cur$1 = type$4);
        }
        for (var i$6 = 0; i$6 < len; ++i$6) if (isNeutral.test(types[i$6])) {
            for (var end$1 = void 0, end$1 = i$6 + 1; end$1 < len && isNeutral.test(types[end$1]); ++end$1);
            for (var before = "L" == (i$6 ? types[i$6 - 1] : outerType), replace$1 = before == ("L" == (end$1 < len ? types[end$1] : outerType)) ? before ? "L" : "R" : outerType, j$1 = i$6; j$1 < end$1; ++j$1) types[j$1] = replace$1;
            i$6 = end$1 - 1;
        }
        for (var m, order = [], i$7 = 0; i$7 < len; ) if (countsAsLeft.test(types[i$7])) {
            var start = i$7;
            for (++i$7; i$7 < len && countsAsLeft.test(types[i$7]); ++i$7);
            order.push(new BidiSpan(0, start, i$7));
        } else {
            var pos = i$7, at = order.length, isRTL = "rtl" == direction ? 1 : 0;
            for (++i$7; i$7 < len && "L" != types[i$7]; ++i$7);
            for (var j$2 = pos; j$2 < i$7; ) if (countsAsNum.test(types[j$2])) {
                pos < j$2 && (order.splice(at, 0, new BidiSpan(1, pos, j$2)), at += isRTL);
                var nstart = j$2;
                for (++j$2; j$2 < i$7 && countsAsNum.test(types[j$2]); ++j$2);
                order.splice(at, 0, new BidiSpan(2, nstart, j$2)), at += isRTL, 
                pos = j$2;
            } else ++j$2;
            pos < i$7 && order.splice(at, 0, new BidiSpan(1, pos, i$7));
        }
        return "ltr" == direction && (1 == order[0].level && (m = str.match(/^\s+/)) && (order[0].from = m[0].length, 
        order.unshift(new BidiSpan(0, 0, m[0].length))), 1 == lst(order).level) && (m = str.match(/\s+$/)) && (lst(order).to -= m[0].length, 
        order.push(new BidiSpan(0, len - m[0].length, len))), "rtl" == direction ? order.reverse() : order;
    };
    function BidiSpan(level, from, to) {
        this.level = level, this.from = from, this.to = to;
    }
    function getOrder(line, direction) {
        var order = line.order;
        return order = null == order ? line.order = bidiOrdering(line.text, direction) : order;
    }
    var noHandlers = [], on = function(emitter, type, f) {
        emitter.addEventListener ? emitter.addEventListener(type, f, !1) : emitter.attachEvent ? emitter.attachEvent("on" + type, f) : (emitter = emitter._handlers || (emitter._handlers = {}))[type] = (emitter[type] || noHandlers).concat(f);
    };
    function getHandlers(emitter, type) {
        return emitter._handlers && emitter._handlers[type] || noHandlers;
    }
    function off(emitter, type, f) {
        var arr;
        emitter.removeEventListener ? emitter.removeEventListener(type, f, !1) : emitter.detachEvent ? emitter.detachEvent("on" + type, f) : (arr = (emitter = emitter._handlers) && emitter[type]) && -1 < (f = indexOf(arr, f)) && (emitter[type] = arr.slice(0, f).concat(arr.slice(f + 1)));
    }
    function signal(emitter, type) {
        var handlers = getHandlers(emitter, type);
        if (handlers.length) for (var args = Array.prototype.slice.call(arguments, 2), i = 0; i < handlers.length; ++i) handlers[i].apply(null, args);
    }
    function signalDOMEvent(cm, e, override) {
        return "string" == typeof e && (e = {
            type: e,
            preventDefault: function() {
                this.defaultPrevented = !0;
            }
        }), signal(cm, override || e.type, cm, e), e_defaultPrevented(e) || e.codemirrorIgnore;
    }
    function signalCursorActivity(cm) {
        var arr = cm._handlers && cm._handlers.cursorActivity;
        if (arr) for (var set = cm.curOp.cursorActivityHandlers || (cm.curOp.cursorActivityHandlers = []), i = 0; i < arr.length; ++i) -1 == indexOf(set, arr[i]) && set.push(arr[i]);
    }
    function hasHandler(emitter, type) {
        return 0 < getHandlers(emitter, type).length;
    }
    function eventMixin(ctor) {
        ctor.prototype.on = function(type, f) {
            on(this, type, f);
        }, ctor.prototype.off = function(type, f) {
            off(this, type, f);
        };
    }
    function e_preventDefault(e) {
        e.preventDefault ? e.preventDefault() : e.returnValue = !1;
    }
    function e_stopPropagation(e) {
        e.stopPropagation ? e.stopPropagation() : e.cancelBubble = !0;
    }
    function e_defaultPrevented(e) {
        return null != e.defaultPrevented ? e.defaultPrevented : 0 == e.returnValue;
    }
    function e_stop(e) {
        e_preventDefault(e), e_stopPropagation(e);
    }
    function e_target(e) {
        return e.target || e.srcElement;
    }
    function e_button(e) {
        var b = e.which;
        return null == b && (1 & e.button ? b = 1 : 2 & e.button ? b = 3 : 4 & e.button && (b = 2)), 
        b = mac && e.ctrlKey && 1 == b ? 3 : b;
    }
    var zwspSupported, badBidiRects, dragAndDrop = !(ie && ie_version < 9) && ("draggable" in (edge = elt("div")) || "dragDrop" in edge);
    var splitLinesAuto = 3 != "\n\nb".split(/\n/).length ? function(string) {
        for (var pos = 0, result = [], l = string.length; pos <= l; ) {
            var nl = string.indexOf("\n", pos), line = (-1 == nl && (nl = string.length), 
            string.slice(pos, "\r" == string.charAt(nl - 1) ? nl - 1 : nl)), rt = line.indexOf("\r");
            -1 != rt ? (result.push(line.slice(0, rt)), pos += rt + 1) : (result.push(line), 
            pos = nl + 1);
        }
        return result;
    } : function(string) {
        return string.split(/\r\n?|\n/);
    }, hasSelection = window.getSelection ? function(te) {
        try {
            return te.selectionStart != te.selectionEnd;
        } catch (e) {
            return !1;
        }
    } : function(te) {
        var range;
        try {
            range = te.ownerDocument.selection.createRange();
        } catch (e) {}
        return !(!range || range.parentElement() != te) && 0 != range.compareEndPoints("StartToEnd", range);
    }, hasCopyEvent = "oncopy" in (platform = elt("div")) || (platform.setAttribute("oncopy", "return;"), 
    "function" == typeof platform.oncopy), badZoomedRects = null;
    var modes = {}, mimeModes = {};
    function resolveMode(spec) {
        if ("string" == typeof spec && mimeModes.hasOwnProperty(spec)) spec = mimeModes[spec]; else if (spec && "string" == typeof spec.name && mimeModes.hasOwnProperty(spec.name)) {
            var found = mimeModes[spec.name];
            (spec = createObj(found = "string" == typeof found ? {
                name: found
            } : found, spec)).name = found.name;
        } else {
            if ("string" == typeof spec && /^[\w\-]+\/[\w\-]+\+xml$/.test(spec)) return resolveMode("application/xml");
            if ("string" == typeof spec && /^[\w\-]+\/[\w\-]+\+json$/.test(spec)) return resolveMode("application/json");
        }
        return "string" == typeof spec ? {
            name: spec
        } : spec || {
            name: "null"
        };
    }
    function getMode(options, spec) {
        spec = resolveMode(spec);
        var mfactory = modes[spec.name];
        if (!mfactory) return getMode(options, "text/plain");
        var modeObj = mfactory(options, spec);
        if (modeExtensions.hasOwnProperty(spec.name)) {
            var prop, exts = modeExtensions[spec.name];
            for (prop in exts) exts.hasOwnProperty(prop) && (modeObj.hasOwnProperty(prop) && (modeObj["_" + prop] = modeObj[prop]), 
            modeObj[prop] = exts[prop]);
        }
        if (modeObj.name = spec.name, spec.helperType && (modeObj.helperType = spec.helperType), 
        spec.modeProps) for (var prop$1 in spec.modeProps) modeObj[prop$1] = spec.modeProps[prop$1];
        return modeObj;
    }
    var modeExtensions = {};
    function extendMode(mode, properties) {
        copyObj(properties, modeExtensions.hasOwnProperty(mode) ? modeExtensions[mode] : modeExtensions[mode] = {});
    }
    function copyState(mode, state) {
        if (!0 === state) return state;
        if (mode.copyState) return mode.copyState(state);
        var n, nstate = {};
        for (n in state) {
            var val = state[n];
            val instanceof Array && (val = val.concat([])), nstate[n] = val;
        }
        return nstate;
    }
    function innerMode(mode, state) {
        for (var info; mode.innerMode && (info = mode.innerMode(state)) && info.mode != mode; ) state = info.state, 
        mode = info.mode;
        return info || {
            mode: mode,
            state: state
        };
    }
    function startState(mode, a1, a2) {
        return !mode.startState || mode.startState(a1, a2);
    }
    var StringStream = function(string, tabSize, lineOracle) {
        this.pos = this.start = 0, this.string = string, this.tabSize = tabSize || 8, 
        this.lastColumnPos = this.lastColumnValue = 0, this.lineStart = 0, this.lineOracle = lineOracle;
    };
    function getLine(doc, n) {
        if ((n -= doc.first) < 0 || n >= doc.size) throw new Error("There is no line " + (n + doc.first) + " in the document.");
        for (var chunk = doc; !chunk.lines; ) for (var i = 0; ;++i) {
            var child = chunk.children[i], sz = child.chunkSize();
            if (n < sz) {
                chunk = child;
                break;
            }
            n -= sz;
        }
        return chunk.lines[n];
    }
    function getBetween(doc, start, end) {
        var out = [], n = start.line;
        return doc.iter(start.line, end.line + 1, function(line) {
            line = line.text;
            n == end.line && (line = line.slice(0, end.ch)), n == start.line && (line = line.slice(start.ch)), 
            out.push(line), ++n;
        }), out;
    }
    function getLines(doc, from, to) {
        var out = [];
        return doc.iter(from, to, function(line) {
            out.push(line.text);
        }), out;
    }
    function updateLineHeight(line, height) {
        var diff = height - line.height;
        if (diff) for (var n = line; n; n = n.parent) n.height += diff;
    }
    function lineNo(line) {
        if (null == line.parent) return null;
        for (var cur = line.parent, no = indexOf(cur.lines, line), chunk = cur.parent; chunk; chunk = (cur = chunk).parent) for (var i = 0; chunk.children[i] != cur; ++i) no += chunk.children[i].chunkSize();
        return no + cur.first;
    }
    function lineAtHeight(chunk, h) {
        var n = chunk.first;
        outer: do {
            for (var i$1 = 0; i$1 < chunk.children.length; ++i$1) {
                var child = chunk.children[i$1], ch = child.height;
                if (h < ch) {
                    chunk = child;
                    continue outer;
                }
                h -= ch, n += child.chunkSize();
            }
            return n;
        } while (!chunk.lines);
        for (var i = 0; i < chunk.lines.length; ++i) {
            var lh = chunk.lines[i].height;
            if (h < lh) break;
            h -= lh;
        }
        return n + i;
    }
    function isLine(doc, l) {
        return l >= doc.first && l < doc.first + doc.size;
    }
    function lineNumberFor(options, i) {
        return String(options.lineNumberFormatter(i + options.firstLineNumber));
    }
    function Pos(line, ch, sticky) {
        if (void 0 === sticky && (sticky = null), !(this instanceof Pos)) return new Pos(line, ch, sticky);
        this.line = line, this.ch = ch, this.sticky = sticky;
    }
    function cmp(a, b) {
        return a.line - b.line || a.ch - b.ch;
    }
    function equalCursorPos(a, b) {
        return a.sticky == b.sticky && 0 == cmp(a, b);
    }
    function copyPos(x) {
        return Pos(x.line, x.ch);
    }
    function maxPos(a, b) {
        return cmp(a, b) < 0 ? b : a;
    }
    function minPos(a, b) {
        return cmp(a, b) < 0 ? a : b;
    }
    function clipLine(doc, n) {
        return Math.max(doc.first, Math.min(n, doc.first + doc.size - 1));
    }
    function clipPos(doc, pos) {
        var last;
        return pos.line < doc.first ? Pos(doc.first, 0) : (last = doc.first + doc.size - 1, 
        pos.line > last ? Pos(last, getLine(doc, last).text.length) : function(pos, linelen) {
            var ch = pos.ch;
            return null == ch || linelen < ch ? Pos(pos.line, linelen) : ch < 0 ? Pos(pos.line, 0) : pos;
        }(pos, getLine(doc, pos.line).text.length));
    }
    function clipPosArray(doc, array) {
        for (var out = [], i = 0; i < array.length; i++) out[i] = clipPos(doc, array[i]);
        return out;
    }
    StringStream.prototype.eol = function() {
        return this.pos >= this.string.length;
    }, StringStream.prototype.sol = function() {
        return this.pos == this.lineStart;
    }, StringStream.prototype.peek = function() {
        return this.string.charAt(this.pos) || void 0;
    }, StringStream.prototype.next = function() {
        if (this.pos < this.string.length) return this.string.charAt(this.pos++);
    }, StringStream.prototype.eat = function(match) {
        var ch = this.string.charAt(this.pos), match = "string" == typeof match ? ch == match : ch && (match.test ? match.test(ch) : match(ch));
        if (match) return ++this.pos, ch;
    }, StringStream.prototype.eatWhile = function(match) {
        for (var start = this.pos; this.eat(match); );
        return this.pos > start;
    }, StringStream.prototype.eatSpace = function() {
        for (var start = this.pos; /[\s\u00a0]/.test(this.string.charAt(this.pos)); ) ++this.pos;
        return this.pos > start;
    }, StringStream.prototype.skipToEnd = function() {
        this.pos = this.string.length;
    }, StringStream.prototype.skipTo = function(ch) {
        ch = this.string.indexOf(ch, this.pos);
        if (-1 < ch) return this.pos = ch, !0;
    }, StringStream.prototype.backUp = function(n) {
        this.pos -= n;
    }, StringStream.prototype.column = function() {
        return this.lastColumnPos < this.start && (this.lastColumnValue = countColumn(this.string, this.start, this.tabSize, this.lastColumnPos, this.lastColumnValue), 
        this.lastColumnPos = this.start), this.lastColumnValue - (this.lineStart ? countColumn(this.string, this.lineStart, this.tabSize) : 0);
    }, StringStream.prototype.indentation = function() {
        return countColumn(this.string, null, this.tabSize) - (this.lineStart ? countColumn(this.string, this.lineStart, this.tabSize) : 0);
    }, StringStream.prototype.match = function(pattern, consume, caseInsensitive) {
        var match;
        return "string" != typeof pattern ? (match = this.string.slice(this.pos).match(pattern)) && 0 < match.index ? null : (match && !1 !== consume && (this.pos += match[0].length), 
        match) : (match = function(str) {
            return caseInsensitive ? str.toLowerCase() : str;
        })(this.string.substr(this.pos, pattern.length)) == match(pattern) ? (!1 !== consume && (this.pos += pattern.length), 
        !0) : void 0;
    }, StringStream.prototype.current = function() {
        return this.string.slice(this.start, this.pos);
    }, StringStream.prototype.hideFirstChars = function(n, inner) {
        this.lineStart += n;
        try {
            return inner();
        } finally {
            this.lineStart -= n;
        }
    }, StringStream.prototype.lookAhead = function(n) {
        var oracle = this.lineOracle;
        return oracle && oracle.lookAhead(n);
    }, StringStream.prototype.baseToken = function() {
        var oracle = this.lineOracle;
        return oracle && oracle.baseToken(this.pos);
    };
    function SavedContext(state, lookAhead) {
        this.state = state, this.lookAhead = lookAhead;
    }
    var Context = function(doc, state, line, lookAhead) {
        this.state = state, this.doc = doc, this.line = line, this.maxLookAhead = lookAhead || 0, 
        this.baseTokens = null, this.baseTokenPos = 1;
    };
    function highlightLine(cm, line, context, forceToEnd) {
        for (var st = [ cm.state.modeGen ], lineClasses = {}, state = (runMode(cm, line.text, cm.doc.mode, context, function(end, style) {
            st.push(end, style);
        }, lineClasses, forceToEnd), context.state), o = 0; o < cm.state.overlays.length; ++o) !function(o) {
            context.baseTokens = st;
            var overlay = cm.state.overlays[o], i = 1, at = 0;
            context.state = !0, runMode(cm, line.text, overlay.mode, context, function(end, style) {
                for (var start = i; at < end; ) {
                    var i_end = st[i];
                    end < i_end && st.splice(i, 1, end, st[i + 1], i_end), i += 2, 
                    at = Math.min(end, i_end);
                }
                if (style) if (overlay.opaque) st.splice(start, i - start, end, "overlay " + style), 
                i = start + 2; else for (;start < i; start += 2) {
                    var cur = st[start + 1];
                    st[start + 1] = (cur ? cur + " " : "") + "overlay " + style;
                }
            }, lineClasses), context.state = state, context.baseTokens = null, context.baseTokenPos = 1;
        }(o);
        return {
            styles: st,
            classes: lineClasses.bgClass || lineClasses.textClass ? lineClasses : null
        };
    }
    function getLineStyles(cm, line, updateFrontier) {
        var context, resetState, result;
        return line.styles && line.styles[0] == cm.state.modeGen || (context = getContextBefore(cm, lineNo(line)), 
        resetState = line.text.length > cm.options.maxHighlightLength && copyState(cm.doc.mode, context.state), 
        result = highlightLine(cm, line, context), resetState && (context.state = resetState), 
        line.stateAfter = context.save(!resetState), line.styles = result.styles, 
        result.classes ? line.styleClasses = result.classes : line.styleClasses && (line.styleClasses = null), 
        updateFrontier === cm.doc.highlightFrontier && (cm.doc.modeFrontier = Math.max(cm.doc.modeFrontier, ++cm.doc.highlightFrontier))), 
        line.styles;
    }
    function getContextBefore(cm, n, precise) {
        var start, saved, context, doc = cm.doc, display = cm.display;
        return doc.mode.startState ? (saved = (start = function(cm, n, precise) {
            for (var minindent, minline, doc = cm.doc, lim = precise ? -1 : n - (cm.doc.mode.innerMode ? 1e3 : 100), search = n; lim < search; --search) {
                if (search <= doc.first) return doc.first;
                var line = getLine(doc, search - 1), after = line.stateAfter;
                if (after && (!precise || search + (after instanceof SavedContext ? after.lookAhead : 0) <= doc.modeFrontier)) return search;
                after = countColumn(line.text, null, cm.options.tabSize);
                (null == minline || after < minindent) && (minline = search - 1, 
                minindent = after);
            }
            return minline;
        }(cm, n, precise)) > doc.first && getLine(doc, start - 1).stateAfter, context = saved ? Context.fromSaved(doc, saved, start) : new Context(doc, startState(doc.mode), start), 
        doc.iter(start, n, function(line) {
            processLine(cm, line.text, context);
            var pos = context.line;
            line.stateAfter = pos == n - 1 || pos % 5 == 0 || pos >= display.viewFrom && pos < display.viewTo ? context.save() : null, 
            context.nextLine();
        }), precise && (doc.modeFrontier = context.line), context) : new Context(doc, !0, n);
    }
    function processLine(cm, text, context, startAt) {
        var mode = cm.doc.mode, stream = new StringStream(text, cm.options.tabSize, context);
        for (stream.start = stream.pos = startAt || 0, "" == text && callBlankLine(mode, context.state); !stream.eol(); ) readToken(mode, stream, context.state), 
        stream.start = stream.pos;
    }
    function callBlankLine(mode, state) {
        return mode.blankLine ? mode.blankLine(state) : mode.innerMode && (mode = innerMode(mode, state)).mode.blankLine ? mode.mode.blankLine(mode.state) : void 0;
    }
    function readToken(mode, stream, state, inner) {
        for (var i = 0; i < 10; i++) {
            inner && (inner[0] = innerMode(mode, state).mode);
            var style = mode.token(stream, state);
            if (stream.pos > stream.start) return style;
        }
        throw new Error("Mode " + mode.name + " failed to advance stream.");
    }
    Context.prototype.lookAhead = function(n) {
        var line = this.doc.getLine(this.line + n);
        return null != line && n > this.maxLookAhead && (this.maxLookAhead = n), 
        line;
    }, Context.prototype.baseToken = function(n) {
        if (!this.baseTokens) return null;
        for (;this.baseTokens[this.baseTokenPos] <= n; ) this.baseTokenPos += 2;
        var type = this.baseTokens[this.baseTokenPos + 1];
        return {
            type: type && type.replace(/( |^)overlay .*/, ""),
            size: this.baseTokens[this.baseTokenPos] - n
        };
    }, Context.prototype.nextLine = function() {
        this.line++, 0 < this.maxLookAhead && this.maxLookAhead--;
    }, Context.fromSaved = function(doc, saved, line) {
        return saved instanceof SavedContext ? new Context(doc, copyState(doc.mode, saved.state), line, saved.lookAhead) : new Context(doc, copyState(doc.mode, saved), line);
    }, Context.prototype.save = function(copy) {
        copy = !1 !== copy ? copyState(this.doc.mode, this.state) : this.state;
        return 0 < this.maxLookAhead ? new SavedContext(copy, this.maxLookAhead) : copy;
    };
    var Token = function(stream, type, state) {
        this.start = stream.start, this.end = stream.pos, this.string = stream.current(), 
        this.type = type || null, this.state = state;
    };
    function takeToken(cm, pos, precise, asArray) {
        var style, tokens, doc = cm.doc, mode = doc.mode, line = getLine(doc, (pos = clipPos(doc, pos)).line), context = getContextBefore(cm, pos.line, precise), stream = new StringStream(line.text, cm.options.tabSize, context);
        for (asArray && (tokens = []); (asArray || stream.pos < pos.ch) && !stream.eol(); ) stream.start = stream.pos, 
        style = readToken(mode, stream, context.state), asArray && tokens.push(new Token(stream, style, copyState(doc.mode, context.state)));
        return asArray ? tokens : new Token(stream, style, context.state);
    }
    function extractLineClasses(type, output) {
        if (type) for (;;) {
            var lineClass = type.match(/(?:^|\s+)line-(background-)?(\S+)/);
            if (!lineClass) break;
            type = type.slice(0, lineClass.index) + type.slice(lineClass.index + lineClass[0].length);
            var prop = lineClass[1] ? "bgClass" : "textClass";
            null == output[prop] ? output[prop] = lineClass[2] : new RegExp("(?:^|\\s)" + lineClass[2] + "(?:$|\\s)").test(output[prop]) || (output[prop] += " " + lineClass[2]);
        }
        return type;
    }
    function runMode(cm, text, mode, context, f, lineClasses, forceToEnd) {
        var flattenSpans = mode.flattenSpans, curStart = (null == flattenSpans && (flattenSpans = cm.options.flattenSpans), 
        0), curStyle = null, stream = new StringStream(text, cm.options.tabSize, context), inner = cm.options.addModeClass && [ null ];
        for ("" == text && extractLineClasses(callBlankLine(mode, context.state), lineClasses); !stream.eol(); ) {
            var mName, style = stream.pos > cm.options.maxHighlightLength ? (flattenSpans = !1, 
            forceToEnd && processLine(cm, text, context, stream.pos), stream.pos = text.length, 
            null) : extractLineClasses(readToken(mode, stream, context.state, inner), lineClasses);
            if (inner && (mName = inner[0].name) && (style = "m-" + (style ? mName + " " + style : mName)), 
            !flattenSpans || curStyle != style) {
                for (;curStart < stream.start; ) f(curStart = Math.min(stream.start, curStart + 5e3), curStyle);
                curStyle = style;
            }
            stream.start = stream.pos;
        }
        for (;curStart < stream.pos; ) {
            var pos = Math.min(stream.pos, curStart + 5e3);
            f(pos, curStyle), curStart = pos;
        }
    }
    var sawReadOnlySpans = !1, sawCollapsedSpans = !1;
    function MarkedSpan(marker, from, to) {
        this.marker = marker, this.from = from, this.to = to;
    }
    function getMarkedSpanFor(spans, marker) {
        if (spans) for (var i = 0; i < spans.length; ++i) {
            var span = spans[i];
            if (span.marker == marker) return span;
        }
    }
    function stretchSpansOverChange(doc, change) {
        if (change.full) return null;
        var oldFirst = isLine(doc, change.from.line) && getLine(doc, change.from.line).markedSpans, doc = isLine(doc, change.to.line) && getLine(doc, change.to.line).markedSpans;
        if (!oldFirst && !doc) return null;
        var startCh = change.from.ch, endCh = change.to.ch, isInsert = 0 == cmp(change.from, change.to), first = function(old, startCh, isInsert) {
            var nw;
            if (old) for (var i = 0; i < old.length; ++i) {
                var endsAfter, span = old[i], marker = span.marker;
                !(null == span.from || (marker.inclusiveLeft ? span.from <= startCh : span.from < startCh)) && (span.from != startCh || "bookmark" != marker.type || isInsert && span.marker.insertLeft) || (endsAfter = null == span.to || (marker.inclusiveRight ? span.to >= startCh : span.to > startCh), 
                (nw = nw || []).push(new MarkedSpan(marker, span.from, endsAfter ? null : span.to)));
            }
            return nw;
        }(oldFirst, startCh, isInsert), last = function(old, endCh, isInsert) {
            var nw;
            if (old) for (var i = 0; i < old.length; ++i) {
                var startsBefore, span = old[i], marker = span.marker;
                !(null == span.to || (marker.inclusiveRight ? span.to >= endCh : span.to > endCh)) && (span.from != endCh || "bookmark" != marker.type || isInsert && !span.marker.insertLeft) || (startsBefore = null == span.from || (marker.inclusiveLeft ? span.from <= endCh : span.from < endCh), 
                (nw = nw || []).push(new MarkedSpan(marker, startsBefore ? null : span.from - endCh, null == span.to ? null : span.to - endCh)));
            }
            return nw;
        }(doc, endCh, isInsert), sameLine = 1 == change.text.length, offset = lst(change.text).length + (sameLine ? startCh : 0);
        if (first) for (var i = 0; i < first.length; ++i) {
            var found, span = first[i];
            null == span.to && ((found = getMarkedSpanFor(last, span.marker)) ? sameLine && (span.to = null == found.to ? null : found.to + offset) : span.to = startCh);
        }
        if (last) for (var i$1 = 0; i$1 < last.length; ++i$1) {
            var span$1 = last[i$1];
            null != span$1.to && (span$1.to += offset), null == span$1.from ? getMarkedSpanFor(first, span$1.marker) || (span$1.from = offset, 
            sameLine && (first = first || []).push(span$1)) : (span$1.from += offset, 
            sameLine && (first = first || []).push(span$1));
        }
        first = first && clearEmptySpans(first), last && last != first && (last = clearEmptySpans(last));
        var newMarkers = [ first ];
        if (!sameLine) {
            var gapMarkers, gap = change.text.length - 2;
            if (0 < gap && first) for (var i$2 = 0; i$2 < first.length; ++i$2) null == first[i$2].to && (gapMarkers = gapMarkers || []).push(new MarkedSpan(first[i$2].marker, null, null));
            for (var i$3 = 0; i$3 < gap; ++i$3) newMarkers.push(gapMarkers);
            newMarkers.push(last);
        }
        return newMarkers;
    }
    function clearEmptySpans(spans) {
        for (var i = 0; i < spans.length; ++i) {
            var span = spans[i];
            null != span.from && span.from == span.to && !1 !== span.marker.clearWhenEmpty && spans.splice(i--, 1);
        }
        return spans.length ? spans : null;
    }
    function detachMarkedSpans(line) {
        var spans = line.markedSpans;
        if (spans) {
            for (var i = 0; i < spans.length; ++i) spans[i].marker.detachLine(line);
            line.markedSpans = null;
        }
    }
    function attachMarkedSpans(line, spans) {
        if (spans) {
            for (var i = 0; i < spans.length; ++i) spans[i].marker.attachLine(line);
            line.markedSpans = spans;
        }
    }
    function extraLeft(marker) {
        return marker.inclusiveLeft ? -1 : 0;
    }
    function extraRight(marker) {
        return marker.inclusiveRight ? 1 : 0;
    }
    function compareCollapsedMarkers(a, b) {
        var bPos, fromCmp, lenDiff = a.lines.length - b.lines.length;
        return 0 != lenDiff ? lenDiff : (lenDiff = a.find(), bPos = b.find(), (fromCmp = cmp(lenDiff.from, bPos.from) || extraLeft(a) - extraLeft(b)) ? -fromCmp : cmp(lenDiff.to, bPos.to) || extraRight(a) - extraRight(b) || b.id - a.id);
    }
    function collapsedSpanAtSide(line, start) {
        var found, sps = sawCollapsedSpans && line.markedSpans;
        if (sps) for (var sp, i = 0; i < sps.length; ++i) (sp = sps[i]).marker.collapsed && null == (start ? sp.from : sp.to) && (!found || compareCollapsedMarkers(found, sp.marker) < 0) && (found = sp.marker);
        return found;
    }
    function collapsedSpanAtStart(line) {
        return collapsedSpanAtSide(line, !0);
    }
    function collapsedSpanAtEnd(line) {
        return collapsedSpanAtSide(line, !1);
    }
    function conflictingCollapsedRange(doc, lineNo, from, to, marker) {
        var doc = getLine(doc, lineNo), sps = sawCollapsedSpans && doc.markedSpans;
        if (sps) for (var i = 0; i < sps.length; ++i) {
            var sp = sps[i];
            if (sp.marker.collapsed) {
                var found = sp.marker.find(0), fromCmp = cmp(found.from, from) || extraLeft(sp.marker) - extraLeft(marker), toCmp = cmp(found.to, to) || extraRight(sp.marker) - extraRight(marker);
                if (!(0 <= fromCmp && toCmp <= 0 || fromCmp <= 0 && 0 <= toCmp) && (fromCmp <= 0 && (sp.marker.inclusiveRight && marker.inclusiveLeft ? 0 <= cmp(found.to, from) : 0 < cmp(found.to, from)) || 0 <= fromCmp && (sp.marker.inclusiveRight && marker.inclusiveLeft ? cmp(found.from, to) <= 0 : cmp(found.from, to) < 0))) return 1;
            }
        }
    }
    function visualLine(line) {
        for (var merged; merged = collapsedSpanAtStart(line); ) line = merged.find(-1, !0).line;
        return line;
    }
    function visualLineNo(doc, lineN) {
        var doc = getLine(doc, lineN), vis = visualLine(doc);
        return doc == vis ? lineN : lineNo(vis);
    }
    function visualLineEndNo(doc, lineN) {
        if (lineN > doc.lastLine()) return lineN;
        var merged, line = getLine(doc, lineN);
        if (!lineIsHidden(doc, line)) return lineN;
        for (;merged = collapsedSpanAtEnd(line); ) line = merged.find(1, !0).line;
        return lineNo(line) + 1;
    }
    function lineIsHidden(doc, line) {
        var sps = sawCollapsedSpans && line.markedSpans;
        if (sps) for (var sp, i = 0; i < sps.length; ++i) if ((sp = sps[i]).marker.collapsed) {
            if (null == sp.from) return !0;
            if (!sp.marker.widgetNode && 0 == sp.from && sp.marker.inclusiveLeft && function lineIsHiddenInner(doc, line, span) {
                {
                    var end;
                    if (null == span.to) return end = span.marker.find(1, !0), lineIsHiddenInner(doc, end.line, getMarkedSpanFor(end.line.markedSpans, span.marker));
                }
                if (span.marker.inclusiveRight && span.to == line.text.length) return !0;
                for (var sp = void 0, i = 0; i < line.markedSpans.length; ++i) if ((sp = line.markedSpans[i]).marker.collapsed && !sp.marker.widgetNode && sp.from == span.to && (null == sp.to || sp.to != span.from) && (sp.marker.inclusiveLeft || span.marker.inclusiveRight) && lineIsHiddenInner(doc, line, sp)) return !0;
            }(doc, line, sp)) return !0;
        }
    }
    function heightAtLine(lineObj) {
        for (var h = 0, chunk = (lineObj = visualLine(lineObj)).parent, i = 0; i < chunk.lines.length; ++i) {
            var line = chunk.lines[i];
            if (line == lineObj) break;
            h += line.height;
        }
        for (var p = chunk.parent; p; p = (chunk = p).parent) for (var i$1 = 0; i$1 < p.children.length; ++i$1) {
            var cur = p.children[i$1];
            if (cur == chunk) break;
            h += cur.height;
        }
        return h;
    }
    function lineLength(line) {
        if (0 == line.height) return 0;
        for (var merged, len = line.text.length, cur = line; merged = collapsedSpanAtStart(cur); ) {
            var found = merged.find(0, !0), cur = found.from.line;
            len += found.from.ch - found.to.ch;
        }
        for (cur = line; merged = collapsedSpanAtEnd(cur); ) var found$1 = merged.find(0, !0), len = (len -= cur.text.length - found$1.from.ch) + ((cur = found$1.to.line).text.length - found$1.to.ch);
        return len;
    }
    function findMaxLine(cm) {
        var d = cm.display, cm = cm.doc;
        d.maxLine = getLine(cm, cm.first), d.maxLineLength = lineLength(d.maxLine), 
        d.maxLineChanged = !0, cm.iter(function(line) {
            var len = lineLength(line);
            len > d.maxLineLength && (d.maxLineLength = len, d.maxLine = line);
        });
    }
    var Line = function(text, markedSpans, estimateHeight) {
        this.text = text, attachMarkedSpans(this, markedSpans), this.height = estimateHeight ? estimateHeight(this) : 1;
    };
    Line.prototype.lineNo = function() {
        return lineNo(this);
    }, eventMixin(Line);
    var styleToClassCache = {}, styleToClassCacheWithMode = {};
    function interpretTokenStyle(style, options) {
        return !style || /^\s*$/.test(style) ? null : (options = options.addModeClass ? styleToClassCacheWithMode : styleToClassCache)[style] || (options[style] = style.replace(/\S+/g, "cm-$&"));
    }
    function buildLineContent(cm, lineView) {
        var content = eltP("span", null, null, webkit ? "padding-right: .1px" : null), builder = {
            pre: eltP("pre", [ content ], "CodeMirror-line"),
            content: content,
            col: 0,
            pos: 0,
            cm: cm,
            trailingSpace: !1,
            splitSpaces: cm.getOption("lineWrapping")
        };
        lineView.measure = {};
        for (var r0, txt, i = 0; i <= (lineView.rest ? lineView.rest.length : 0); i++) {
            var line = i ? lineView.rest[i - 1] : lineView.line, order = void 0, measure = (builder.pos = 0, 
            builder.addToken = buildToken, measure = cm.display.measure, txt = r0 = void 0, 
            (null != badBidiRects ? badBidiRects : (txt = removeChildrenAndAdd(measure, document.createTextNode("A\u062eA")), 
            r0 = range(txt, 0, 1).getBoundingClientRect(), txt = range(txt, 1, 2).getBoundingClientRect(), 
            removeChildren(measure), r0 && r0.left != r0.right && (badBidiRects = txt.right - r0.right < 3))) && (order = getOrder(line, cm.doc.direction)) && (builder.addToken = function(inner, order) {
                return function(builder, text, style, startStyle, endStyle, css, attributes) {
                    style = style ? style + " cm-force-border" : "cm-force-border";
                    for (var start = builder.pos, end = start + text.length; ;) {
                        for (var part = void 0, i = 0; i < order.length && !((part = order[i]).to > start && part.from <= start); i++);
                        if (part.to >= end) return inner(builder, text, style, startStyle, endStyle, css, attributes);
                        inner(builder, text.slice(0, part.to - start), style, startStyle, null, css, attributes), 
                        startStyle = null, text = text.slice(part.to - start), start = part.to;
                    }
                };
            }(builder.addToken, order)), builder.map = [], lineView != cm.display.externalMeasured && lineNo(line));
            !function(line, builder, styles) {
                var spans = line.markedSpans, allText = line.text, at = 0;
                if (spans) for (var style, css, spanStyle, spanEndStyle, spanStartStyle, collapsed, attributes, len = allText.length, pos = 0, i = 1, text = "", nextChange = 0; ;) {
                    if (nextChange == pos) {
                        spanStyle = spanEndStyle = spanStartStyle = css = "", collapsed = attributes = null, 
                        nextChange = 1 / 0;
                        for (var foundBookmarks = [], endStyles = void 0, j = 0; j < spans.length; ++j) {
                            var sp = spans[j], m = sp.marker;
                            if ("bookmark" == m.type && sp.from == pos && m.widgetNode) foundBookmarks.push(m); else if (sp.from <= pos && (null == sp.to || sp.to > pos || m.collapsed && sp.to == pos && sp.from == pos)) {
                                if (null != sp.to && sp.to != pos && nextChange > sp.to && (nextChange = sp.to, 
                                spanEndStyle = ""), m.className && (spanStyle += " " + m.className), 
                                m.css && (css = (css ? css + ";" : "") + m.css), 
                                m.startStyle && sp.from == pos && (spanStartStyle += " " + m.startStyle), 
                                m.endStyle && sp.to == nextChange && (endStyles = endStyles || []).push(m.endStyle, sp.to), 
                                m.title && ((attributes = attributes || {}).title = m.title), 
                                m.attributes) for (var attr in m.attributes) (attributes = attributes || {})[attr] = m.attributes[attr];
                                m.collapsed && (!collapsed || compareCollapsedMarkers(collapsed.marker, m) < 0) && (collapsed = sp);
                            } else sp.from > pos && nextChange > sp.from && (nextChange = sp.from);
                        }
                        if (endStyles) for (var j$1 = 0; j$1 < endStyles.length; j$1 += 2) endStyles[j$1 + 1] == nextChange && (spanEndStyle += " " + endStyles[j$1]);
                        if (!collapsed || collapsed.from == pos) for (var j$2 = 0; j$2 < foundBookmarks.length; ++j$2) buildCollapsedSpan(builder, 0, foundBookmarks[j$2]);
                        if (collapsed && (collapsed.from || 0) == pos) {
                            if (buildCollapsedSpan(builder, (null == collapsed.to ? len + 1 : collapsed.to) - pos, collapsed.marker, null == collapsed.from), 
                            null == collapsed.to) return;
                            collapsed.to == pos && (collapsed = !1);
                        }
                    }
                    if (len <= pos) break;
                    for (var upto = Math.min(len, nextChange); ;) {
                        if (text) {
                            var tokenText, end = pos + text.length;
                            if (collapsed || (tokenText = upto < end ? text.slice(0, upto - pos) : text, 
                            builder.addToken(builder, tokenText, style ? style + spanStyle : spanStyle, spanStartStyle, pos + tokenText.length == nextChange ? spanEndStyle : "", css, attributes)), 
                            upto <= end) {
                                text = text.slice(upto - pos), pos = upto;
                                break;
                            }
                            pos = end, spanStartStyle = "";
                        }
                        text = allText.slice(at, at = styles[i++]), style = interpretTokenStyle(styles[i++], builder.cm.options);
                    }
                } else for (var i$1 = 1; i$1 < styles.length; i$1 += 2) builder.addToken(builder, allText.slice(at, at = styles[i$1]), interpretTokenStyle(styles[i$1 + 1], builder.cm.options));
            }(line, builder, getLineStyles(cm, line, measure)), line.styleClasses && (line.styleClasses.bgClass && (builder.bgClass = joinClasses(line.styleClasses.bgClass, builder.bgClass || "")), 
            line.styleClasses.textClass) && (builder.textClass = joinClasses(line.styleClasses.textClass, builder.textClass || "")), 
            0 == builder.map.length && builder.map.push(0, 0, builder.content.appendChild(function(measure) {
                var test;
                return (measure = (zwspSupported = null == zwspSupported && (test = elt("span", "\u200b"), 
                removeChildrenAndAdd(measure, elt("span", [ test, document.createTextNode("x") ])), 
                0 != measure.firstChild.offsetHeight) ? test.offsetWidth <= 1 && 2 < test.offsetHeight && !(ie && ie_version < 8) : zwspSupported) ? elt("span", "\u200b") : elt("span", "\xa0", null, "display: inline-block; width: 1px; margin-right: -1px")).setAttribute("cm-text", ""), 
                measure;
            }(cm.display.measure))), 0 == i ? (lineView.measure.map = builder.map, 
            lineView.measure.cache = {}) : ((lineView.measure.maps || (lineView.measure.maps = [])).push(builder.map), 
            (lineView.measure.caches || (lineView.measure.caches = [])).push({}));
        }
        return webkit && (content = builder.content.lastChild, /\bcm-tab\b/.test(content.className) || content.querySelector && content.querySelector(".cm-tab")) && (builder.content.className = "cm-tab-wrap-hack"), 
        signal(cm, "renderLine", cm, lineView.line, builder.pre), builder.pre.className && (builder.textClass = joinClasses(builder.pre.className, builder.textClass || "")), 
        builder;
    }
    function defaultSpecialCharPlaceholder(ch) {
        var token = elt("span", "\u2022", "cm-invalidchar");
        return token.title = "\\u" + ch.charCodeAt(0).toString(16), token.setAttribute("aria-label", token.title), 
        token;
    }
    function buildToken(builder, text, style, startStyle, endStyle, css, attributes) {
        if (text) {
            var displayText = builder.splitSpaces ? function(text, trailingBefore) {
                if (1 < text.length && !/  /.test(text)) return text;
                for (var spaceBefore = trailingBefore, result = "", i = 0; i < text.length; i++) {
                    var ch = text.charAt(i);
                    " " != ch || !spaceBefore || i != text.length - 1 && 32 != text.charCodeAt(i + 1) || (ch = "\xa0"), 
                    result += ch, spaceBefore = " " == ch;
                }
                return result;
            }(text, builder.trailingSpace) : text, special = builder.cm.state.specialChars, mustWrap = !1;
            if (special.test(text)) for (var content = document.createDocumentFragment(), pos = 0; ;) {
                special.lastIndex = pos;
                var m = special.exec(text), skipped = m ? m.index - pos : text.length - pos;
                if (skipped && (txt = document.createTextNode(displayText.slice(pos, pos + skipped)), 
                ie && ie_version < 9 ? content.appendChild(elt("span", [ txt ])) : content.appendChild(txt), 
                builder.map.push(builder.pos, builder.pos + skipped, txt), builder.col += skipped, 
                builder.pos += skipped), !m) break;
                pos += 1 + skipped;
                var txt = void 0;
                "\t" == m[0] ? (skipped = (skipped = builder.cm.options.tabSize) - builder.col % skipped, 
                (txt = content.appendChild(elt("span", spaceStr(skipped), "cm-tab"))).setAttribute("role", "presentation"), 
                txt.setAttribute("cm-text", "\t"), builder.col += skipped) : ("\r" == m[0] || "\n" == m[0] ? (txt = content.appendChild(elt("span", "\r" == m[0] ? "\u240d" : "\u2424", "cm-invalidchar"))).setAttribute("cm-text", m[0]) : ((txt = builder.cm.options.specialCharPlaceholder(m[0])).setAttribute("cm-text", m[0]), 
                ie && ie_version < 9 ? content.appendChild(elt("span", [ txt ])) : content.appendChild(txt)), 
                builder.col += 1), builder.map.push(builder.pos, builder.pos + 1, txt), 
                builder.pos++;
            } else builder.col += text.length, content = document.createTextNode(displayText), 
            builder.map.push(builder.pos, builder.pos + text.length, content), ie && ie_version < 9 && (mustWrap = !0), 
            builder.pos += text.length;
            if (builder.trailingSpace = 32 == displayText.charCodeAt(text.length - 1), 
            style || startStyle || endStyle || mustWrap || css || attributes) {
                var mustWrap = style || "", token = (startStyle && (mustWrap += startStyle), 
                endStyle && (mustWrap += endStyle), elt("span", [ content ], mustWrap, css));
                if (attributes) for (var attr in attributes) attributes.hasOwnProperty(attr) && "style" != attr && "class" != attr && token.setAttribute(attr, attributes[attr]);
                return builder.content.appendChild(token);
            }
            builder.content.appendChild(content);
        }
    }
    function buildCollapsedSpan(builder, size, marker, ignoreWidget) {
        var widget = !ignoreWidget && marker.widgetNode;
        widget && builder.map.push(builder.pos, builder.pos + size, widget), !ignoreWidget && builder.cm.display.input.needsContentAttribute && (widget = widget || builder.content.appendChild(document.createElement("span"))).setAttribute("cm-marker", marker.id), 
        widget && (builder.cm.display.input.setUneditable(widget), builder.content.appendChild(widget)), 
        builder.pos += size, builder.trailingSpace = !1;
    }
    function LineView(doc, line, lineN) {
        this.line = line, this.rest = function(line) {
            for (var merged, lines; merged = collapsedSpanAtEnd(line); ) line = merged.find(1, !0).line, 
            (lines = lines || []).push(line);
            return lines;
        }(line), this.size = this.rest ? lineNo(lst(this.rest)) - lineN + 1 : 1, 
        this.node = this.text = null, this.hidden = lineIsHidden(doc, line);
    }
    function buildViewArray(cm, from, to) {
        for (var array = [], pos = from; pos < to; pos = nextPos) {
            var view = new LineView(cm.doc, getLine(cm.doc, pos), pos), nextPos = pos + view.size;
            array.push(view);
        }
        return array;
    }
    var operationGroup = null;
    function finishOperation(op, endCb) {
        op = op.ownsGroup;
        if (op) try {
            !function(group) {
                var callbacks = group.delayedCallbacks, i = 0;
                do {
                    for (;i < callbacks.length; i++) callbacks[i].call(null);
                    for (var j = 0; j < group.ops.length; j++) {
                        var op = group.ops[j];
                        if (op.cursorActivityHandlers) for (;op.cursorActivityCalled < op.cursorActivityHandlers.length; ) op.cursorActivityHandlers[op.cursorActivityCalled++].call(null, op.cm);
                    }
                } while (i < callbacks.length);
            }(op);
        } finally {
            operationGroup = null, endCb(op);
        }
    }
    var orphanDelayedCallbacks = null;
    function signalLater(emitter, type) {
        var arr = getHandlers(emitter, type);
        if (arr.length) for (var list, args = Array.prototype.slice.call(arguments, 2), i = (operationGroup ? list = operationGroup.delayedCallbacks : orphanDelayedCallbacks ? list = orphanDelayedCallbacks : (list = orphanDelayedCallbacks = [], 
        setTimeout(fireOrphanDelayed, 0)), 0); i < arr.length; ++i) !function(i) {
            list.push(function() {
                return arr[i].apply(null, args);
            });
        }(i);
    }
    function fireOrphanDelayed() {
        var delayed = orphanDelayedCallbacks;
        orphanDelayedCallbacks = null;
        for (var i = 0; i < delayed.length; ++i) delayed[i]();
    }
    function updateLineForChanges(cm, lineView, lineN, dims) {
        for (var j = 0; j < lineView.changes.length; j++) {
            var type = lineView.changes[j];
            "text" == type ? function(cm, lineView) {
                var cls = lineView.text.className, built = getLineContent(cm, lineView);
                lineView.text == lineView.node && (lineView.node = built.pre);
                lineView.text.parentNode.replaceChild(built.pre, lineView.text), 
                lineView.text = built.pre, built.bgClass != lineView.bgClass || built.textClass != lineView.textClass ? (lineView.bgClass = built.bgClass, 
                lineView.textClass = built.textClass, updateLineClasses(cm, lineView)) : cls && (lineView.text.className = cls);
            }(cm, lineView) : "gutter" == type ? updateLineGutter(cm, lineView, lineN, dims) : "class" == type ? updateLineClasses(cm, lineView) : "widget" == type && function(cm, lineView, dims) {
                lineView.alignable && (lineView.alignable = null);
                for (var isWidget = classTest("CodeMirror-linewidget"), node = lineView.node.firstChild, next = void 0; node; node = next) next = node.nextSibling, 
                isWidget.test(node.className) && lineView.node.removeChild(node);
                insertLineWidgets(cm, lineView, dims);
            }(cm, lineView, dims);
        }
        lineView.changes = null;
    }
    function ensureLineWrapped(lineView) {
        return lineView.node == lineView.text && (lineView.node = elt("div", null, null, "position: relative"), 
        lineView.text.parentNode && lineView.text.parentNode.replaceChild(lineView.node, lineView.text), 
        lineView.node.appendChild(lineView.text), ie) && ie_version < 8 && (lineView.node.style.zIndex = 2), 
        lineView.node;
    }
    function getLineContent(cm, lineView) {
        var ext = cm.display.externalMeasured;
        return ext && ext.line == lineView.line ? (cm.display.externalMeasured = null, 
        lineView.measure = ext.measure, ext.built) : buildLineContent(cm, lineView);
    }
    function updateLineClasses(cm, lineView) {
        !function(cm, lineView) {
            var wrap, cls = lineView.bgClass ? lineView.bgClass + " " + (lineView.line.bgClass || "") : lineView.line.bgClass;
            cls && (cls += " CodeMirror-linebackground"), lineView.background ? cls ? lineView.background.className = cls : (lineView.background.parentNode.removeChild(lineView.background), 
            lineView.background = null) : cls && (wrap = ensureLineWrapped(lineView), 
            lineView.background = wrap.insertBefore(elt("div", null, cls), wrap.firstChild), 
            cm.display.input.setUneditable(lineView.background));
        }(cm, lineView), lineView.line.wrapClass ? ensureLineWrapped(lineView).className = lineView.line.wrapClass : lineView.node != lineView.text && (lineView.node.className = "");
        cm = lineView.textClass ? lineView.textClass + " " + (lineView.line.textClass || "") : lineView.line.textClass;
        lineView.text.className = cm || "";
    }
    function updateLineGutter(cm, lineView, lineN, dims) {
        lineView.gutter && (lineView.node.removeChild(lineView.gutter), lineView.gutter = null), 
        lineView.gutterBackground && (lineView.node.removeChild(lineView.gutterBackground), 
        lineView.gutterBackground = null), lineView.line.gutterClass && (wrap = ensureLineWrapped(lineView), 
        lineView.gutterBackground = elt("div", null, "CodeMirror-gutter-background " + lineView.line.gutterClass, "left: " + (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) + "px; width: " + dims.gutterTotalWidth + "px"), 
        cm.display.input.setUneditable(lineView.gutterBackground), wrap.insertBefore(lineView.gutterBackground, lineView.text));
        var markers = lineView.line.gutterMarkers;
        if (cm.options.lineNumbers || markers) {
            var wrap = ensureLineWrapped(lineView), gutterWrap = lineView.gutter = elt("div", null, "CodeMirror-gutter-wrapper", "left: " + (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) + "px");
            if (gutterWrap.setAttribute("aria-hidden", "true"), cm.display.input.setUneditable(gutterWrap), 
            wrap.insertBefore(gutterWrap, lineView.text), lineView.line.gutterClass && (gutterWrap.className += " " + lineView.line.gutterClass), 
            !cm.options.lineNumbers || markers && markers["CodeMirror-linenumbers"] || (lineView.lineNumber = gutterWrap.appendChild(elt("div", lineNumberFor(cm.options, lineN), "CodeMirror-linenumber CodeMirror-gutter-elt", "left: " + dims.gutterLeft["CodeMirror-linenumbers"] + "px; width: " + cm.display.lineNumInnerWidth + "px"))), 
            markers) for (var k = 0; k < cm.display.gutterSpecs.length; ++k) {
                var id = cm.display.gutterSpecs[k].className, found = markers.hasOwnProperty(id) && markers[id];
                found && gutterWrap.appendChild(elt("div", [ found ], "CodeMirror-gutter-elt", "left: " + dims.gutterLeft[id] + "px; width: " + dims.gutterWidth[id] + "px"));
            }
        }
    }
    function insertLineWidgets(cm, lineView, dims) {
        if (insertLineWidgetsFor(cm, lineView.line, lineView, dims, !0), lineView.rest) for (var i = 0; i < lineView.rest.length; i++) insertLineWidgetsFor(cm, lineView.rest[i], lineView, dims, !1);
    }
    function insertLineWidgetsFor(cm, line, lineView, dims, allowAbove) {
        if (line.widgets) for (var wrap = ensureLineWrapped(lineView), i = 0, ws = line.widgets; i < ws.length; ++i) {
            var widget = ws[i], node = elt("div", [ widget.node ], "CodeMirror-linewidget" + (widget.className ? " " + widget.className : ""));
            widget.handleMouseEvents || node.setAttribute("cm-ignore-events", "true"), 
            !function(widget, node, lineView, dims) {
                widget.noHScroll && ((lineView.alignable || (lineView.alignable = [])).push(node), 
                lineView = dims.wrapperWidth, node.style.left = dims.fixedPos + "px", 
                widget.coverGutter || (lineView -= dims.gutterTotalWidth, node.style.paddingLeft = dims.gutterTotalWidth + "px"), 
                node.style.width = lineView + "px");
                widget.coverGutter && (node.style.zIndex = 5, node.style.position = "relative", 
                widget.noHScroll || (node.style.marginLeft = -dims.gutterTotalWidth + "px"));
            }(widget, node, lineView, dims), cm.display.input.setUneditable(node), 
            allowAbove && widget.above ? wrap.insertBefore(node, lineView.gutter || lineView.text) : wrap.appendChild(node), 
            signalLater(widget, "redraw");
        }
    }
    function widgetHeight(widget) {
        var cm, parentStyle;
        return null != widget.height ? widget.height : (cm = widget.doc.cm) ? (contains(document.body, widget.node) || (parentStyle = "position: relative;", 
        widget.coverGutter && (parentStyle += "margin-left: -" + cm.display.gutters.offsetWidth + "px;"), 
        widget.noHScroll && (parentStyle += "width: " + cm.display.wrapper.clientWidth + "px;"), 
        removeChildrenAndAdd(cm.display.measure, elt("div", [ widget.node ], null, parentStyle))), 
        widget.height = widget.node.parentNode.offsetHeight) : 0;
    }
    function eventInWidget(display, e) {
        for (var n = e_target(e); n != display.wrapper; n = n.parentNode) if (!n || 1 == n.nodeType && "true" == n.getAttribute("cm-ignore-events") || n.parentNode == display.sizer && n != display.mover) return 1;
    }
    function paddingTop(display) {
        return display.lineSpace.offsetTop;
    }
    function paddingVert(display) {
        return display.mover.offsetHeight - display.lineSpace.offsetHeight;
    }
    function paddingH(display) {
        var e;
        return display.cachedPaddingH || (e = removeChildrenAndAdd(display.measure, elt("pre", "x", "CodeMirror-line-like")), 
        e = window.getComputedStyle ? window.getComputedStyle(e) : e.currentStyle, 
        e = {
            left: parseInt(e.paddingLeft),
            right: parseInt(e.paddingRight)
        }, isNaN(e.left) || isNaN(e.right) || (display.cachedPaddingH = e), e);
    }
    function scrollGap(cm) {
        return scrollerGap - cm.display.nativeBarWidth;
    }
    function displayWidth(cm) {
        return cm.display.scroller.clientWidth - scrollGap(cm) - cm.display.barWidth;
    }
    function displayHeight(cm) {
        return cm.display.scroller.clientHeight - scrollGap(cm) - cm.display.barHeight;
    }
    function mapFromLineView(lineView, line, lineN) {
        if (lineView.line == line) return {
            map: lineView.measure.map,
            cache: lineView.measure.cache
        };
        if (lineView.rest) {
            for (var i = 0; i < lineView.rest.length; i++) if (lineView.rest[i] == line) return {
                map: lineView.measure.maps[i],
                cache: lineView.measure.caches[i]
            };
            for (var i$1 = 0; i$1 < lineView.rest.length; i$1++) if (lineNo(lineView.rest[i$1]) > lineN) return {
                map: lineView.measure.maps[i$1],
                cache: lineView.measure.caches[i$1],
                before: !0
            };
        }
    }
    function measureChar(cm, line, ch, bias) {
        return measureCharPrepared(cm, prepareMeasureForLine(cm, line), ch, bias);
    }
    function findViewForLine(cm, lineN) {
        return lineN >= cm.display.viewFrom && lineN < cm.display.viewTo ? cm.display.view[findViewIndex(cm, lineN)] : (cm = cm.display.externalMeasured) && lineN >= cm.lineN && lineN < cm.lineN + cm.size ? cm : void 0;
    }
    function prepareMeasureForLine(cm, line) {
        var lineN = lineNo(line), view = findViewForLine(cm, lineN), cm = (view && !view.text ? view = null : view && view.changes && (updateLineForChanges(cm, view, lineN, getDimensions(cm)), 
        cm.curOp.forceUpdate = !0), mapFromLineView(view = view || function(cm, line) {
            var lineN = lineNo(line = visualLine(line)), lineN = ((line = cm.display.externalMeasured = new LineView(cm.doc, line, lineN)).lineN = lineN, 
            line.built = buildLineContent(cm, line));
            return line.text = lineN.pre, removeChildrenAndAdd(cm.display.lineMeasure, lineN.pre), 
            line;
        }(cm, line), line, lineN));
        return {
            line: line,
            view: view,
            rect: null,
            map: cm.map,
            cache: cm.cache,
            before: cm.before,
            hasHeights: !1
        };
    }
    function measureCharPrepared(cm, prepared, ch, bias, varHeight) {
        var found, key = (ch = prepared.before ? -1 : ch) + (bias || "");
        return prepared.cache.hasOwnProperty(key) ? found = prepared.cache[key] : (prepared.rect || (prepared.rect = prepared.view.text.getBoundingClientRect()), 
        prepared.hasHeights || (function(cm, lineView, rect) {
            var wrapping = cm.options.lineWrapping, cm = wrapping && displayWidth(cm);
            if (!lineView.measure.heights || wrapping && lineView.measure.width != cm) {
                var heights = lineView.measure.heights = [];
                if (wrapping) {
                    lineView.measure.width = cm;
                    for (var rects = lineView.text.firstChild.getClientRects(), i = 0; i < rects.length - 1; i++) {
                        var cur = rects[i], next = rects[i + 1];
                        2 < Math.abs(cur.bottom - next.bottom) && heights.push((cur.bottom + next.top) / 2 - rect.top);
                    }
                }
                heights.push(rect.bottom - rect.top);
            }
        }(cm, prepared.view, prepared.rect), prepared.hasHeights = !0), (found = function(cm, prepared, ch, bias) {
            var rect, place = nodeAndOffsetInLineMap(prepared.map, ch, bias), node = place.node, start = place.start, end = place.end, collapse = place.collapse;
            if (3 == node.nodeType) {
                for (var i$1 = 0; i$1 < 4; i$1++) {
                    for (;start && isExtendingChar(prepared.line.text.charAt(place.coverStart + start)); ) --start;
                    for (;place.coverStart + end < place.coverEnd && isExtendingChar(prepared.line.text.charAt(place.coverStart + end)); ) ++end;
                    if ((rect = ie && ie_version < 9 && 0 == start && end == place.coverEnd - place.coverStart ? node.parentNode.getBoundingClientRect() : function(rects, bias) {
                        var rect = nullRect;
                        if ("left" == bias) for (var i = 0; i < rects.length && (rect = rects[i]).left == rect.right; i++); else for (var i$1 = rects.length - 1; 0 <= i$1 && (rect = rects[i$1]).left == rect.right; i$1--);
                        return rect;
                    }(range(node, start, end).getClientRects(), bias)).left || rect.right || 0 == start) break;
                    end = start, start -= 1, collapse = "right";
                }
                ie && ie_version < 11 && (rect = function(measure, rect) {
                    var scaleY;
                    return window.screen && null != screen.logicalXDPI && screen.logicalXDPI != screen.deviceXDPI && function(measure) {
                        var normal;
                        return null != badZoomedRects ? badZoomedRects : (normal = (measure = removeChildrenAndAdd(measure, elt("span", "x"))).getBoundingClientRect(), 
                        measure = range(measure, 0, 1).getBoundingClientRect(), 
                        badZoomedRects = 1 < Math.abs(normal.left - measure.left));
                    }(measure) ? (measure = screen.logicalXDPI / screen.deviceXDPI, 
                    scaleY = screen.logicalYDPI / screen.deviceYDPI, {
                        left: rect.left * measure,
                        right: rect.right * measure,
                        top: rect.top * scaleY,
                        bottom: rect.bottom * scaleY
                    }) : rect;
                }(cm.display.measure, rect));
            } else 0 < start && (collapse = bias = "right"), rect = cm.options.lineWrapping && 1 < (ch = node.getClientRects()).length ? ch["right" == bias ? ch.length - 1 : 0] : node.getBoundingClientRect();
            !(ie && ie_version < 9) || start || rect && (rect.left || rect.right) || (ch = node.parentNode.getClientRects()[0], 
            rect = ch ? {
                left: ch.left,
                right: ch.left + charWidth(cm.display),
                top: ch.top,
                bottom: ch.bottom
            } : nullRect);
            for (var ch = rect.top - prepared.rect.top, rbot = rect.bottom - prepared.rect.top, mid = (ch + rbot) / 2, heights = prepared.view.measure.heights, i = 0; i < heights.length - 1 && !(mid < heights[i]); i++);
            var top = i ? heights[i - 1] : 0, bot = heights[i], top = {
                left: ("right" == collapse ? rect.right : rect.left) - prepared.rect.left,
                right: ("left" == collapse ? rect.left : rect.right) - prepared.rect.left,
                top: top,
                bottom: bot
            };
            rect.left || rect.right || (top.bogus = !0);
            cm.options.singleCursorHeightPerLine || (top.rtop = ch, top.rbottom = rbot);
            return top;
        }(cm, prepared, ch, bias)).bogus || (prepared.cache[key] = found)), {
            left: found.left,
            right: found.right,
            top: varHeight ? found.rtop : found.top,
            bottom: varHeight ? found.rbottom : found.bottom
        };
    }
    var measureText, nullRect = {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0
    };
    function nodeAndOffsetInLineMap(map, ch, bias) {
        for (var node, start, end, collapse, mStart, mEnd, i = 0; i < map.length; i += 3) if (mStart = map[i], 
        mEnd = map[i + 1], ch < mStart ? (start = 0, end = 1, collapse = "left") : ch < mEnd ? end = (start = ch - mStart) + 1 : (i == map.length - 3 || ch == mEnd && map[i + 3] > ch) && (start = (end = mEnd - mStart) - 1, 
        mEnd <= ch) && (collapse = "right"), null != start) {
            if (node = map[i + 2], mStart == mEnd && bias == (node.insertLeft ? "left" : "right") && (collapse = bias), 
            "left" == bias && 0 == start) for (;i && map[i - 2] == map[i - 3] && map[i - 1].insertLeft; ) node = map[2 + (i -= 3)], 
            collapse = "left";
            if ("right" == bias && start == mEnd - mStart) for (;i < map.length - 3 && map[i + 3] == map[i + 4] && !map[i + 5].insertLeft; ) node = map[(i += 3) + 2], 
            collapse = "right";
            break;
        }
        return {
            node: node,
            start: start,
            end: end,
            collapse: collapse,
            coverStart: mStart,
            coverEnd: mEnd
        };
    }
    function clearLineMeasurementCacheFor(lineView) {
        if (lineView.measure && (lineView.measure.cache = {}, lineView.measure.heights = null, 
        lineView.rest)) for (var i = 0; i < lineView.rest.length; i++) lineView.measure.caches[i] = {};
    }
    function clearLineMeasurementCache(cm) {
        cm.display.externalMeasure = null, removeChildren(cm.display.lineMeasure);
        for (var i = 0; i < cm.display.view.length; i++) clearLineMeasurementCacheFor(cm.display.view[i]);
    }
    function clearCaches(cm) {
        clearLineMeasurementCache(cm), cm.display.cachedCharWidth = cm.display.cachedTextHeight = cm.display.cachedPaddingH = null, 
        cm.options.lineWrapping || (cm.display.maxLineChanged = !0), cm.display.lineNumChars = null;
    }
    function pageScrollX() {
        return chrome && android ? -(document.body.getBoundingClientRect().left - parseInt(getComputedStyle(document.body).marginLeft)) : window.pageXOffset || (document.documentElement || document.body).scrollLeft;
    }
    function pageScrollY() {
        return chrome && android ? -(document.body.getBoundingClientRect().top - parseInt(getComputedStyle(document.body).marginTop)) : window.pageYOffset || (document.documentElement || document.body).scrollTop;
    }
    function widgetTopHeight(lineObj) {
        var widgets = visualLine(lineObj).widgets, height = 0;
        if (widgets) for (var i = 0; i < widgets.length; ++i) widgets[i].above && (height += widgetHeight(widgets[i]));
        return height;
    }
    function intoCoordSystem(cm, lineObj, rect, context, includeWidgets) {
        return includeWidgets || (includeWidgets = widgetTopHeight(lineObj), rect.top += includeWidgets, 
        rect.bottom += includeWidgets), "line" != context && (context = context || "local", 
        includeWidgets = heightAtLine(lineObj), "local" == context ? includeWidgets += paddingTop(cm.display) : includeWidgets -= cm.display.viewOffset, 
        "page" != context && "window" != context || (includeWidgets += (lineObj = cm.display.lineSpace.getBoundingClientRect()).top + ("window" == context ? 0 : pageScrollY()), 
        cm = lineObj.left + ("window" == context ? 0 : pageScrollX()), rect.left += cm, 
        rect.right += cm), rect.top += includeWidgets, rect.bottom += includeWidgets), 
        rect;
    }
    function fromCoordSystem(cm, coords, context) {
        var left;
        return "div" == context ? coords : (left = coords.left, coords = coords.top, 
        "page" == context ? (left -= pageScrollX(), coords -= pageScrollY()) : "local" != context && context || (left += (context = cm.display.sizer.getBoundingClientRect()).left, 
        coords += context.top), {
            left: left - (context = cm.display.lineSpace.getBoundingClientRect()).left,
            top: coords - context.top
        });
    }
    function charCoords(cm, pos, context, lineObj, bias) {
        return intoCoordSystem(cm, lineObj = lineObj || getLine(cm.doc, pos.line), measureChar(cm, lineObj, pos.ch, bias), context);
    }
    function cursorCoords(cm, pos, context, lineObj, preparedMeasure, varHeight) {
        function get(ch, right) {
            ch = measureCharPrepared(cm, preparedMeasure, ch, right ? "right" : "left", varHeight);
            return right ? ch.left = ch.right : ch.right = ch.left, intoCoordSystem(cm, lineObj, ch, context);
        }
        lineObj = lineObj || getLine(cm.doc, pos.line), preparedMeasure = preparedMeasure || prepareMeasureForLine(cm, lineObj);
        var other, partPos, order = getOrder(lineObj, cm.doc.direction), ch = pos.ch, pos = pos.sticky;
        return ch >= lineObj.text.length ? (ch = lineObj.text.length, pos = "before") : ch <= 0 && (ch = 0, 
        pos = "after"), order ? (partPos = getBidiPartAt(order, ch, pos), other = bidiOther, 
        partPos = getBidi(ch, partPos, "before" == pos), null != other && (partPos.other = getBidi(ch, other, "before" != pos)), 
        partPos) : get("before" == pos ? ch - 1 : ch, "before" == pos);
        function getBidi(ch, partPos, invert) {
            return get(invert ? ch - 1 : ch, 1 == order[partPos].level != invert);
        }
    }
    function estimateCoords(cm, pos) {
        var left = 0, pos = (pos = clipPos(cm.doc, pos), cm.options.lineWrapping || (left = charWidth(cm.display) * pos.ch), 
        getLine(cm.doc, pos.line)), cm = heightAtLine(pos) + paddingTop(cm.display);
        return {
            left: left,
            right: left,
            top: cm,
            bottom: cm + pos.height
        };
    }
    function PosWithInfo(line, ch, sticky, outside, xRel) {
        line = Pos(line, ch, sticky);
        return line.xRel = xRel, outside && (line.outside = outside), line;
    }
    function coordsChar(cm, x, y) {
        var doc = cm.doc;
        if ((y += cm.display.viewOffset) < 0) return PosWithInfo(doc.first, 0, null, -1, -1);
        var lineN = lineAtHeight(doc, y), last = doc.first + doc.size - 1;
        if (last < lineN) return PosWithInfo(doc.first + doc.size - 1, getLine(doc, last).text.length, null, 1, 1);
        x < 0 && (x = 0);
        for (var lineObj = getLine(doc, lineN); ;) {
            var found = function(cm, lineObj, lineNo, x, y) {
                y -= heightAtLine(lineObj);
                var preparedMeasure = prepareMeasureForLine(cm, lineObj), widgetHeight = widgetTopHeight(lineObj), begin = 0, end = lineObj.text.length, ltr = !0, order = getOrder(lineObj, cm.doc.direction);
                order && (order = (cm.options.lineWrapping ? coordsBidiPartWrapped : coordsBidiPart)(cm, lineObj, lineNo, preparedMeasure, order, x, y), 
                ltr = 1 != order.level, begin = ltr ? order.from : order.to - 1, 
                end = ltr ? order.to : order.from - 1);
                var chAround = null, boxAround = null, order = findFirst(function(ch) {
                    var box = measureCharPrepared(cm, preparedMeasure, ch);
                    return box.top += widgetHeight, box.bottom += widgetHeight, 
                    boxIsAfter(box, x, y, !1) && (box.top <= y && box.left <= x && (chAround = ch, 
                    boxAround = box), 1);
                }, begin, end), outside = !1;
                {
                    var atLeft, atStart;
                    boxAround ? (atLeft = x - boxAround.left < boxAround.right - x, 
                    order = chAround + ((atStart = atLeft == ltr) ? 0 : 1), atStart = atStart ? "after" : "before", 
                    atLeft = atLeft ? boxAround.left : boxAround.right) : (ltr || order != end && order != begin || order++, 
                    atStart = 0 == order || order != lineObj.text.length && measureCharPrepared(cm, preparedMeasure, order - (ltr ? 1 : 0)).bottom + widgetHeight <= y == ltr ? "after" : "before", 
                    end = cursorCoords(cm, Pos(lineNo, order, atStart), "line", lineObj, preparedMeasure), 
                    atLeft = end.left, outside = y < end.top ? -1 : y >= end.bottom ? 1 : 0);
                }
                return order = skipExtendingChars(lineObj.text, order, 1), PosWithInfo(lineNo, order, atStart, outside, x - atLeft);
            }(cm, lineObj, lineN, x, y), collapsed = function(line, ch) {
                var found, sps = sawCollapsedSpans && line.markedSpans;
                if (sps) for (var i = 0; i < sps.length; ++i) {
                    var sp = sps[i];
                    sp.marker.collapsed && (null == sp.from || sp.from < ch) && (null == sp.to || sp.to > ch) && (!found || compareCollapsedMarkers(found, sp.marker) < 0) && (found = sp.marker);
                }
                return found;
            }(lineObj, found.ch + (0 < found.xRel || 0 < found.outside ? 1 : 0));
            if (!collapsed) return found;
            found = collapsed.find(1);
            if (found.line == lineN) return found;
            lineObj = getLine(doc, lineN = found.line);
        }
    }
    function wrappedLineExtent(cm, lineObj, preparedMeasure, y) {
        y -= widgetTopHeight(lineObj);
        var lineObj = lineObj.text.length, begin = findFirst(function(ch) {
            return measureCharPrepared(cm, preparedMeasure, ch - 1).bottom <= y;
        }, lineObj, 0);
        return {
            begin: begin,
            end: findFirst(function(ch) {
                return measureCharPrepared(cm, preparedMeasure, ch).top > y;
            }, begin, lineObj)
        };
    }
    function wrappedLineExtentChar(cm, lineObj, preparedMeasure, target) {
        return wrappedLineExtent(cm, lineObj, preparedMeasure = preparedMeasure || prepareMeasureForLine(cm, lineObj), intoCoordSystem(cm, lineObj, measureCharPrepared(cm, preparedMeasure, target), "line").top);
    }
    function boxIsAfter(box, x, y, left) {
        return !(box.bottom <= y) && (box.top > y || (left ? box.left : box.right) > x);
    }
    function coordsBidiPart(cm, lineObj, lineNo, preparedMeasure, order, x, y) {
        var ltr, index = findFirst(function(i) {
            var i = order[i], ltr = 1 != i.level;
            return boxIsAfter(cursorCoords(cm, Pos(lineNo, ltr ? i.to : i.from, ltr ? "before" : "after"), "line", lineObj, preparedMeasure), x, y, !0);
        }, 0, order.length - 1), part = order[index];
        return part = 0 < index && (ltr = 1 != part.level, boxIsAfter(ltr = cursorCoords(cm, Pos(lineNo, ltr ? part.from : part.to, ltr ? "after" : "before"), "line", lineObj, preparedMeasure), x, y, !0)) && ltr.top > y ? order[index - 1] : part;
    }
    function coordsBidiPartWrapped(cm, lineObj, _lineNo, preparedMeasure, order, x, y) {
        for (var y = wrappedLineExtent(cm, lineObj, preparedMeasure, y), begin = y.begin, end = y.end, part = (/\s/.test(lineObj.text.charAt(end - 1)) && end--, 
        null), closestDist = null, i = 0; i < order.length; i++) {
            var endX, p = order[i];
            p.from >= end || p.to <= begin || (endX = (endX = measureCharPrepared(cm, preparedMeasure, 1 != p.level ? Math.min(end, p.to) - 1 : Math.max(begin, p.from)).right) < x ? x - endX + 1e9 : endX - x, 
            (!part || endX < closestDist) && (part = p, closestDist = endX));
        }
        return part = (part = (part = part || order[order.length - 1]).from < begin ? {
            from: begin,
            to: part.to,
            level: part.level
        } : part).to > end ? {
            from: part.from,
            to: end,
            level: part.level
        } : part;
    }
    function textHeight(display) {
        if (null != display.cachedTextHeight) return display.cachedTextHeight;
        if (null == measureText) {
            measureText = elt("pre", null, "CodeMirror-line-like");
            for (var i = 0; i < 49; ++i) measureText.appendChild(document.createTextNode("x")), 
            measureText.appendChild(elt("br"));
            measureText.appendChild(document.createTextNode("x"));
        }
        removeChildrenAndAdd(display.measure, measureText);
        var height = measureText.offsetHeight / 50;
        return 3 < height && (display.cachedTextHeight = height), removeChildren(display.measure), 
        height || 1;
    }
    function charWidth(display) {
        var pre, anchor;
        return null != display.cachedCharWidth ? display.cachedCharWidth : (anchor = elt("span", "xxxxxxxxxx"), 
        pre = elt("pre", [ anchor ], "CodeMirror-line-like"), removeChildrenAndAdd(display.measure, pre), 
        2 < (anchor = ((pre = anchor.getBoundingClientRect()).right - pre.left) / 10) && (display.cachedCharWidth = anchor), 
        anchor || 10);
    }
    function getDimensions(cm) {
        for (var d = cm.display, left = {}, width = {}, gutterLeft = d.gutters.clientLeft, n = d.gutters.firstChild, i = 0; n; n = n.nextSibling, 
        ++i) {
            var id = cm.display.gutterSpecs[i].className;
            left[id] = n.offsetLeft + n.clientLeft + gutterLeft, width[id] = n.clientWidth;
        }
        return {
            fixedPos: compensateForHScroll(d),
            gutterTotalWidth: d.gutters.offsetWidth,
            gutterLeft: left,
            gutterWidth: width,
            wrapperWidth: d.wrapper.clientWidth
        };
    }
    function compensateForHScroll(display) {
        return display.scroller.getBoundingClientRect().left - display.sizer.getBoundingClientRect().left;
    }
    function estimateHeight(cm) {
        var th = textHeight(cm.display), wrapping = cm.options.lineWrapping, perLine = wrapping && Math.max(5, cm.display.scroller.clientWidth / charWidth(cm.display) - 3);
        return function(line) {
            if (lineIsHidden(cm.doc, line)) return 0;
            var widgetsHeight = 0;
            if (line.widgets) for (var i = 0; i < line.widgets.length; i++) line.widgets[i].height && (widgetsHeight += line.widgets[i].height);
            return wrapping ? widgetsHeight + (Math.ceil(line.text.length / perLine) || 1) * th : widgetsHeight + th;
        };
    }
    function estimateLineHeights(cm) {
        var doc = cm.doc, est = estimateHeight(cm);
        doc.iter(function(line) {
            var estHeight = est(line);
            estHeight != line.height && updateLineHeight(line, estHeight);
        });
    }
    function posFromMouse(cm, e, liberal, forRect) {
        var display = cm.display;
        if (!liberal && "true" == e_target(e).getAttribute("cm-not-content")) return null;
        var x, y, liberal = display.lineSpace.getBoundingClientRect();
        try {
            x = e.clientX - liberal.left, y = e.clientY - liberal.top;
        } catch (e$1) {
            return null;
        }
        display = coordsChar(cm, x, y);
        return forRect && 0 < display.xRel && (e = getLine(cm.doc, display.line).text).length == display.ch && (liberal = countColumn(e, e.length, cm.options.tabSize) - e.length, 
        display = Pos(display.line, Math.max(0, Math.round((x - paddingH(cm.display).left) / charWidth(cm.display)) - liberal))), 
        display;
    }
    function findViewIndex(cm, n) {
        if (n >= cm.display.viewTo) return null;
        if ((n -= cm.display.viewFrom) < 0) return null;
        for (var view = cm.display.view, i = 0; i < view.length; i++) if ((n -= view[i].size) < 0) return i;
    }
    function regChange(cm, from, to, lendiff) {
        null == from && (from = cm.doc.first), null == to && (to = cm.doc.first + cm.doc.size);
        var cutBot, display = cm.display, cut = ((lendiff = lendiff || 0) && to < display.viewTo && (null == display.updateLineNumbers || display.updateLineNumbers > from) && (display.updateLineNumbers = from), 
        cm.curOp.viewChanged = !0, from >= display.viewTo ? sawCollapsedSpans && visualLineNo(cm.doc, from) < display.viewTo && resetView(cm) : to <= display.viewFrom ? sawCollapsedSpans && visualLineEndNo(cm.doc, to + lendiff) > display.viewFrom ? resetView(cm) : (display.viewFrom += lendiff, 
        display.viewTo += lendiff) : from <= display.viewFrom && to >= display.viewTo ? resetView(cm) : from <= display.viewFrom ? (cut = viewCuttingPoint(cm, to, to + lendiff, 1)) ? (display.view = display.view.slice(cut.index), 
        display.viewFrom = cut.lineN, display.viewTo += lendiff) : resetView(cm) : to >= display.viewTo ? (cut = viewCuttingPoint(cm, from, from, -1)) ? (display.view = display.view.slice(0, cut.index), 
        display.viewTo = cut.lineN) : resetView(cm) : (cut = viewCuttingPoint(cm, from, from, -1), 
        cutBot = viewCuttingPoint(cm, to, to + lendiff, 1), cut && cutBot ? (display.view = display.view.slice(0, cut.index).concat(buildViewArray(cm, cut.lineN, cutBot.lineN)).concat(display.view.slice(cutBot.index)), 
        display.viewTo += lendiff) : resetView(cm)), display.externalMeasured);
        cut && (to < cut.lineN ? cut.lineN += lendiff : from < cut.lineN + cut.size && (display.externalMeasured = null));
    }
    function regLineChange(cm, line, type) {
        cm.curOp.viewChanged = !0;
        var display = cm.display, ext = cm.display.externalMeasured;
        ext && line >= ext.lineN && line < ext.lineN + ext.size && (display.externalMeasured = null), 
        line < display.viewFrom || line >= display.viewTo || null != (ext = display.view[findViewIndex(cm, line)]).node && -1 == indexOf(display = ext.changes || (ext.changes = []), type) && display.push(type);
    }
    function resetView(cm) {
        cm.display.viewFrom = cm.display.viewTo = cm.doc.first, cm.display.view = [], 
        cm.display.viewOffset = 0;
    }
    function viewCuttingPoint(cm, oldN, newN, dir) {
        var diff, index = findViewIndex(cm, oldN), view = cm.display.view;
        if (sawCollapsedSpans && newN != cm.doc.first + cm.doc.size) {
            for (var n = cm.display.viewFrom, i = 0; i < index; i++) n += view[i].size;
            if (n != oldN) {
                if (0 < dir) {
                    if (index == view.length - 1) return null;
                    diff = n + view[index].size - oldN, index++;
                } else diff = n - oldN;
                oldN += diff, newN += diff;
            }
            for (;visualLineNo(cm.doc, newN) != newN; ) {
                if (index == (dir < 0 ? 0 : view.length - 1)) return null;
                newN += dir * view[index - (dir < 0 ? 1 : 0)].size, index += dir;
            }
        }
        return {
            index: index,
            lineN: newN
        };
    }
    function countDirtyView(cm) {
        for (var view = cm.display.view, dirty = 0, i = 0; i < view.length; i++) {
            var lineView = view[i];
            lineView.hidden || lineView.node && !lineView.changes || ++dirty;
        }
        return dirty;
    }
    function updateSelection(cm) {
        cm.display.input.showSelection(cm.display.input.prepareSelection());
    }
    function prepareSelection(cm, primary) {
        void 0 === primary && (primary = !0);
        var doc = cm.doc, result = {}, curFragment = result.cursors = document.createDocumentFragment(), selFragment = result.selection = document.createDocumentFragment(), customCursor = cm.options.$customCursor;
        customCursor && (primary = !0);
        for (var range, collapsed, head, i = 0; i < doc.sel.ranges.length; i++) !primary && i == doc.sel.primIndex || ((range = doc.sel.ranges[i]).from().line >= cm.display.viewTo || range.to().line < cm.display.viewFrom || (collapsed = range.empty(), 
        customCursor ? (head = customCursor(cm, range)) && drawSelectionCursor(cm, head, curFragment) : (collapsed || cm.options.showCursorWhenSelecting) && drawSelectionCursor(cm, range.head, curFragment), 
        collapsed)) || function(cm, range, output) {
            var display = cm.display, doc = cm.doc, fragment = document.createDocumentFragment(), padding = paddingH(cm.display), leftSide = padding.left, rightSide = Math.max(display.sizerWidth, displayWidth(cm) - display.sizer.offsetLeft) - padding.right, docLTR = "ltr" == doc.direction;
            function add(left, top, width, bottom) {
                top < 0 && (top = 0), top = Math.round(top), bottom = Math.round(bottom), 
                fragment.appendChild(elt("div", null, "CodeMirror-selected", "position: absolute; left: " + left + "px;\n                             top: " + top + "px; width: " + (null == width ? rightSide - left : width) + "px;\n                             height: " + (bottom - top) + "px"));
            }
            function drawForLine(line, fromArg, toArg) {
                var start, end, lineObj = getLine(doc, line), lineLen = lineObj.text.length;
                function coords(ch, bias) {
                    return charCoords(cm, Pos(line, ch), "div", lineObj, bias);
                }
                function wrapX(pos, dir, side) {
                    pos = wrappedLineExtentChar(cm, lineObj, null, pos), dir = "ltr" == dir == ("after" == side) ? "left" : "right";
                    return coords("after" == side ? pos.begin : pos.end - (/\s/.test(lineObj.text.charAt(pos.end - 1)) ? 2 : 1), dir)[dir];
                }
                var order = getOrder(lineObj, doc.direction);
                return function(order, from, to, f) {
                    if (!order) return f(from, to, "ltr", 0);
                    for (var found = !1, i = 0; i < order.length; ++i) {
                        var part = order[i];
                        (part.from < to && part.to > from || from == to && part.to == from) && (f(Math.max(part.from, from), Math.min(part.to, to), 1 == part.level ? "rtl" : "ltr", i), 
                        found = !0);
                    }
                    found || f(from, to, "ltr");
                }(order, fromArg || 0, null == toArg ? lineLen : toArg, function(from, to, dir, i) {
                    var left, topLeft, topRight, botLeft, right, ltr = "ltr" == dir, fromPos = coords(from, ltr ? "left" : "right"), toPos = coords(to - 1, ltr ? "right" : "left"), openStart = null == fromArg && 0 == from, openEnd = null == toArg && to == lineLen, first = 0 == i, i = !order || i == order.length - 1;
                    toPos.top - fromPos.top <= 3 ? (left = (docLTR ? openStart : openEnd) && first ? leftSide : (ltr ? fromPos : toPos).left, 
                    right = (docLTR ? openEnd : openStart) && i ? rightSide : (ltr ? toPos : fromPos).right, 
                    add(left, fromPos.top, right - left, fromPos.bottom)) : (right = ltr ? (topLeft = docLTR && openStart && first ? leftSide : fromPos.left, 
                    topRight = docLTR ? rightSide : wrapX(from, dir, "before"), 
                    botLeft = docLTR ? leftSide : wrapX(to, dir, "after"), docLTR && openEnd && i ? rightSide : toPos.right) : (topLeft = docLTR ? wrapX(from, dir, "before") : leftSide, 
                    topRight = !docLTR && openStart && first ? rightSide : fromPos.right, 
                    botLeft = !docLTR && openEnd && i ? leftSide : toPos.left, docLTR ? wrapX(to, dir, "after") : rightSide), 
                    add(topLeft, fromPos.top, topRight - topLeft, fromPos.bottom), 
                    fromPos.bottom < toPos.top && add(leftSide, fromPos.bottom, null, toPos.top), 
                    add(botLeft, toPos.top, right - botLeft, toPos.bottom)), (!start || cmpCoords(fromPos, start) < 0) && (start = fromPos), 
                    cmpCoords(toPos, start) < 0 && (start = toPos), (!end || cmpCoords(fromPos, end) < 0) && (end = fromPos), 
                    cmpCoords(toPos, end) < 0 && (end = toPos);
                }), {
                    start: start,
                    end: end
                };
            }
            display = range.from(), padding = range.to();
            {
                var toLine;
                display.line == padding.line ? drawForLine(display.line, display.ch, padding.ch) : (range = getLine(doc, display.line), 
                toLine = getLine(doc, padding.line), toLine = visualLine(range) == visualLine(toLine), 
                display = drawForLine(display.line, display.ch, toLine ? range.text.length + 1 : null).end, 
                range = drawForLine(padding.line, toLine ? 0 : null, padding.ch).start, 
                toLine && (display.top < range.top - 2 ? (add(display.right, display.top, null, display.bottom), 
                add(leftSide, range.top, range.left, range.bottom)) : add(display.right, display.top, range.left - display.right, display.bottom)), 
                display.bottom < range.top && add(leftSide, display.bottom, null, range.top));
            }
            output.appendChild(fragment);
        }(cm, range, selFragment);
        return result;
    }
    function drawSelectionCursor(cm, head, output) {
        var pos = cursorCoords(cm, head, "div", null, null, !cm.options.singleCursorHeightPerLine), cursor = output.appendChild(elt("div", "\xa0", "CodeMirror-cursor"));
        cursor.style.left = pos.left + "px", cursor.style.top = pos.top + "px", 
        cursor.style.height = Math.max(0, pos.bottom - pos.top) * cm.options.cursorHeight + "px", 
        /\bcm-fat-cursor\b/.test(cm.getWrapperElement().className) && (head = (head = charCoords(cm, head, "div", null, null)).right - head.left, 
        cursor.style.width = (0 < head ? head : cm.defaultCharWidth()) + "px"), 
        pos.other && ((cursor = output.appendChild(elt("div", "\xa0", "CodeMirror-cursor CodeMirror-secondarycursor"))).style.display = "", 
        cursor.style.left = pos.other.left + "px", cursor.style.top = pos.other.top + "px", 
        cursor.style.height = .85 * (pos.other.bottom - pos.other.top) + "px");
    }
    function cmpCoords(a, b) {
        return a.top - b.top || a.left - b.left;
    }
    function restartBlink(cm) {
        var display, on;
        cm.state.focused && (display = cm.display, clearInterval(display.blinker), 
        on = !0, display.cursorDiv.style.visibility = "", 0 < cm.options.cursorBlinkRate ? display.blinker = setInterval(function() {
            cm.hasFocus() || onBlur(cm), display.cursorDiv.style.visibility = (on = !on) ? "" : "hidden";
        }, cm.options.cursorBlinkRate) : cm.options.cursorBlinkRate < 0 && (display.cursorDiv.style.visibility = "hidden"));
    }
    function ensureFocus(cm) {
        cm.hasFocus() || (cm.display.input.focus(), cm.state.focused) || onFocus(cm);
    }
    function delayBlurEvent(cm) {
        cm.state.delayingBlurEvent = !0, setTimeout(function() {
            cm.state.delayingBlurEvent && (cm.state.delayingBlurEvent = !1, cm.state.focused) && onBlur(cm);
        }, 100);
    }
    function onFocus(cm, e) {
        cm.state.delayingBlurEvent && !cm.state.draggingText && (cm.state.delayingBlurEvent = !1), 
        "nocursor" != cm.options.readOnly && (cm.state.focused || (signal(cm, "focus", cm, e), 
        cm.state.focused = !0, addClass(cm.display.wrapper, "CodeMirror-focused"), 
        cm.curOp || cm.display.selForContextMenu == cm.doc.sel || (cm.display.input.reset(), 
        webkit && setTimeout(function() {
            return cm.display.input.reset(!0);
        }, 20)), cm.display.input.receivedFocus()), restartBlink(cm));
    }
    function onBlur(cm, e) {
        cm.state.delayingBlurEvent || (cm.state.focused && (signal(cm, "blur", cm, e), 
        cm.state.focused = !1, rmClass(cm.display.wrapper, "CodeMirror-focused")), 
        clearInterval(cm.display.blinker), setTimeout(function() {
            cm.state.focused || (cm.display.shift = !1);
        }, 150));
    }
    function updateHeightsInViewport(cm) {
        for (var display = cm.display, prevBottom = display.lineDiv.offsetTop, viewTop = Math.max(0, display.scroller.getBoundingClientRect().top), oldHeight = display.lineDiv.getBoundingClientRect().top, mustScroll = 0, i = 0; i < display.view.length; i++) {
            var cur = display.view[i], wrapping = cm.options.lineWrapping, height = void 0, width = 0;
            if (!cur.hidden) {
                oldHeight += cur.line.height, ie && ie_version < 8 ? (height = (bot = cur.node.offsetTop + cur.node.offsetHeight) - prevBottom, 
                prevBottom = bot) : (height = (bot = cur.node.getBoundingClientRect()).bottom - bot.top, 
                !wrapping && cur.text.firstChild && (width = cur.text.firstChild.getBoundingClientRect().right - bot.left - 1));
                var bot, wrapping = cur.line.height - height;
                if ((.005 < wrapping || wrapping < -.005) && (oldHeight < viewTop && (mustScroll -= wrapping), 
                updateLineHeight(cur.line, height), updateWidgetHeight(cur.line), 
                cur.rest)) for (var j = 0; j < cur.rest.length; j++) updateWidgetHeight(cur.rest[j]);
                width > cm.display.sizerWidth && (wrapping = Math.ceil(width / charWidth(cm.display))) > cm.display.maxLineLength && (cm.display.maxLineLength = wrapping, 
                cm.display.maxLine = cur.line, cm.display.maxLineChanged = !0);
            }
        }
        2 < Math.abs(mustScroll) && (display.scroller.scrollTop += mustScroll);
    }
    function updateWidgetHeight(line) {
        if (line.widgets) for (var i = 0; i < line.widgets.length; ++i) {
            var w = line.widgets[i], parent = w.node.parentNode;
            parent && (w.height = parent.offsetHeight);
        }
    }
    function visibleLines(display, doc, viewport) {
        var ensureFrom, top = viewport && null != viewport.top ? Math.max(0, viewport.top) : display.scroller.scrollTop, top = Math.floor(top - paddingTop(display)), bottom = viewport && null != viewport.bottom ? viewport.bottom : top + display.wrapper.clientHeight, top = lineAtHeight(doc, top), bottom = lineAtHeight(doc, bottom);
        return viewport && viewport.ensure && (ensureFrom = viewport.ensure.from.line, 
        viewport = viewport.ensure.to.line, ensureFrom < top ? bottom = lineAtHeight(doc, heightAtLine(getLine(doc, top = ensureFrom)) + display.wrapper.clientHeight) : Math.min(viewport, doc.lastLine()) >= bottom && (top = lineAtHeight(doc, heightAtLine(getLine(doc, viewport)) - display.wrapper.clientHeight), 
        bottom = viewport)), {
            from: top,
            to: Math.max(bottom, top + 1)
        };
    }
    function calculateScrollPos(cm, rect) {
        var display = cm.display, snapMargin = textHeight(cm.display), screentop = (rect.top < 0 && (rect.top = 0), 
        (cm.curOp && null != cm.curOp.scrollTop ? cm.curOp : display.scroller).scrollTop), screen = displayHeight(cm), result = {}, docBottom = (rect.bottom - rect.top > screen && (rect.bottom = rect.top + screen), 
        cm.doc.height + paddingVert(display)), atTop = rect.top < snapMargin, snapMargin = rect.bottom > docBottom - snapMargin, snapMargin = (rect.top < screentop ? result.scrollTop = atTop ? 0 : rect.top : rect.bottom > screentop + screen && (atTop = Math.min(rect.top, (snapMargin ? docBottom : rect.bottom) - screen)) != screentop && (result.scrollTop = atTop), 
        cm.options.fixedGutter ? 0 : display.gutters.offsetWidth), docBottom = cm.curOp && null != cm.curOp.scrollLeft ? cm.curOp.scrollLeft : display.scroller.scrollLeft - snapMargin, screen = displayWidth(cm) - display.gutters.offsetWidth, screentop = rect.right - rect.left > screen;
        return screentop && (rect.right = rect.left + screen), rect.left < 10 ? result.scrollLeft = 0 : rect.left < docBottom ? result.scrollLeft = Math.max(0, rect.left + snapMargin - (screentop ? 0 : 10)) : rect.right > screen + docBottom - 3 && (result.scrollLeft = rect.right + (screentop ? 0 : 10) - screen), 
        result;
    }
    function addToScrollTop(cm, top) {
        null != top && (resolveScrollToPos(cm), cm.curOp.scrollTop = (null == cm.curOp.scrollTop ? cm.doc : cm.curOp).scrollTop + top);
    }
    function ensureCursorVisible(cm) {
        resolveScrollToPos(cm);
        var cur = cm.getCursor();
        cm.curOp.scrollToPos = {
            from: cur,
            to: cur,
            margin: cm.options.cursorScrollMargin
        };
    }
    function scrollToCoords(cm, x, y) {
        null == x && null == y || resolveScrollToPos(cm), null != x && (cm.curOp.scrollLeft = x), 
        null != y && (cm.curOp.scrollTop = y);
    }
    function resolveScrollToPos(cm) {
        var range = cm.curOp.scrollToPos;
        range && (cm.curOp.scrollToPos = null, scrollToCoordsRange(cm, estimateCoords(cm, range.from), estimateCoords(cm, range.to), range.margin));
    }
    function scrollToCoordsRange(cm, from, to, margin) {
        from = calculateScrollPos(cm, {
            left: Math.min(from.left, to.left),
            top: Math.min(from.top, to.top) - margin,
            right: Math.max(from.right, to.right),
            bottom: Math.max(from.bottom, to.bottom) + margin
        });
        scrollToCoords(cm, from.scrollLeft, from.scrollTop);
    }
    function updateScrollTop(cm, val) {
        Math.abs(cm.doc.scrollTop - val) < 2 || (gecko || updateDisplaySimple(cm, {
            top: val
        }), setScrollTop(cm, val, !0), gecko && updateDisplaySimple(cm), startWorker(cm, 100));
    }
    function setScrollTop(cm, val, forceScroll) {
        val = Math.max(0, Math.min(cm.display.scroller.scrollHeight - cm.display.scroller.clientHeight, val)), 
        cm.display.scroller.scrollTop == val && !forceScroll || (cm.doc.scrollTop = val, 
        cm.display.scrollbars.setScrollTop(val), cm.display.scroller.scrollTop == val) || (cm.display.scroller.scrollTop = val);
    }
    function setScrollLeft(cm, val, isScroller, forceScroll) {
        val = Math.max(0, Math.min(val, cm.display.scroller.scrollWidth - cm.display.scroller.clientWidth)), 
        (isScroller ? val == cm.doc.scrollLeft : Math.abs(cm.doc.scrollLeft - val) < 2) && !forceScroll || (cm.doc.scrollLeft = val, 
        alignHorizontally(cm), cm.display.scroller.scrollLeft != val && (cm.display.scroller.scrollLeft = val), 
        cm.display.scrollbars.setScrollLeft(val));
    }
    function measureForScrollbars(cm) {
        var d = cm.display, gutterW = d.gutters.offsetWidth, docH = Math.round(cm.doc.height + paddingVert(cm.display));
        return {
            clientHeight: d.scroller.clientHeight,
            viewHeight: d.wrapper.clientHeight,
            scrollWidth: d.scroller.scrollWidth,
            clientWidth: d.scroller.clientWidth,
            viewWidth: d.wrapper.clientWidth,
            barLeft: cm.options.fixedGutter ? gutterW : 0,
            docHeight: docH,
            scrollHeight: docH + scrollGap(cm) + d.barHeight,
            nativeBarWidth: d.nativeBarWidth,
            gutterWidth: gutterW
        };
    }
    function NativeScrollbars(place, scroll, cm) {
        this.cm = cm;
        var vert = this.vert = elt("div", [ elt("div", null, null, "min-width: 1px") ], "CodeMirror-vscrollbar"), horiz = this.horiz = elt("div", [ elt("div", null, null, "height: 100%; min-height: 1px") ], "CodeMirror-hscrollbar");
        vert.tabIndex = horiz.tabIndex = -1, place(vert), place(horiz), on(vert, "scroll", function() {
            vert.clientHeight && scroll(vert.scrollTop, "vertical");
        }), on(horiz, "scroll", function() {
            horiz.clientWidth && scroll(horiz.scrollLeft, "horizontal");
        }), this.checkedZeroWidth = !1, ie && ie_version < 8 && (this.horiz.style.minHeight = this.vert.style.minWidth = "18px");
    }
    function NullScrollbars() {}
    NativeScrollbars.prototype.update = function(measure) {
        var totalHeight, needsH = measure.scrollWidth > measure.clientWidth + 1, needsV = measure.scrollHeight > measure.clientHeight + 1, sWidth = measure.nativeBarWidth;
        return needsV ? (this.vert.style.display = "block", this.vert.style.bottom = needsH ? sWidth + "px" : "0", 
        totalHeight = measure.viewHeight - (needsH ? sWidth : 0), this.vert.firstChild.style.height = Math.max(0, measure.scrollHeight - measure.clientHeight + totalHeight) + "px") : (this.vert.scrollTop = 0, 
        this.vert.style.display = "", this.vert.firstChild.style.height = "0"), 
        needsH ? (this.horiz.style.display = "block", this.horiz.style.right = needsV ? sWidth + "px" : "0", 
        this.horiz.style.left = measure.barLeft + "px", totalHeight = measure.viewWidth - measure.barLeft - (needsV ? sWidth : 0), 
        this.horiz.firstChild.style.width = Math.max(0, measure.scrollWidth - measure.clientWidth + totalHeight) + "px") : (this.horiz.style.display = "", 
        this.horiz.firstChild.style.width = "0"), !this.checkedZeroWidth && 0 < measure.clientHeight && (0 == sWidth && this.zeroWidthHack(), 
        this.checkedZeroWidth = !0), {
            right: needsV ? sWidth : 0,
            bottom: needsH ? sWidth : 0
        };
    }, NativeScrollbars.prototype.setScrollLeft = function(pos) {
        this.horiz.scrollLeft != pos && (this.horiz.scrollLeft = pos), this.disableHoriz && this.enableZeroWidthBar(this.horiz, this.disableHoriz, "horiz");
    }, NativeScrollbars.prototype.setScrollTop = function(pos) {
        this.vert.scrollTop != pos && (this.vert.scrollTop = pos), this.disableVert && this.enableZeroWidthBar(this.vert, this.disableVert, "vert");
    }, NativeScrollbars.prototype.zeroWidthHack = function() {
        this.horiz.style.height = this.vert.style.width = mac && !mac_geMountainLion ? "12px" : "18px", 
        this.horiz.style.visibility = this.vert.style.visibility = "hidden", this.disableHoriz = new Delayed(), 
        this.disableVert = new Delayed();
    }, NativeScrollbars.prototype.enableZeroWidthBar = function(bar, delay, type) {
        bar.style.visibility = "", delay.set(1e3, function maybeDisable() {
            var box = bar.getBoundingClientRect();
            ("vert" == type ? document.elementFromPoint(box.right - 1, (box.top + box.bottom) / 2) : document.elementFromPoint((box.right + box.left) / 2, box.bottom - 1)) != bar ? bar.style.visibility = "hidden" : delay.set(1e3, maybeDisable);
        });
    }, NativeScrollbars.prototype.clear = function() {
        var parent = this.horiz.parentNode;
        parent.removeChild(this.horiz), parent.removeChild(this.vert);
    };
    function updateScrollbars(cm, measure) {
        measure = measure || measureForScrollbars(cm);
        var startWidth = cm.display.barWidth, startHeight = cm.display.barHeight;
        updateScrollbarsInner(cm, measure);
        for (var i = 0; i < 4 && startWidth != cm.display.barWidth || startHeight != cm.display.barHeight; i++) startWidth != cm.display.barWidth && cm.options.lineWrapping && updateHeightsInViewport(cm), 
        updateScrollbarsInner(cm, measureForScrollbars(cm)), startWidth = cm.display.barWidth, 
        startHeight = cm.display.barHeight;
    }
    function updateScrollbarsInner(cm, measure) {
        var d = cm.display, sizes = d.scrollbars.update(measure);
        d.sizer.style.paddingRight = (d.barWidth = sizes.right) + "px", d.sizer.style.paddingBottom = (d.barHeight = sizes.bottom) + "px", 
        d.heightForcer.style.borderBottom = sizes.bottom + "px solid transparent", 
        sizes.right && sizes.bottom ? (d.scrollbarFiller.style.display = "block", 
        d.scrollbarFiller.style.height = sizes.bottom + "px", d.scrollbarFiller.style.width = sizes.right + "px") : d.scrollbarFiller.style.display = "", 
        sizes.bottom && cm.options.coverGutterNextToScrollbar && cm.options.fixedGutter ? (d.gutterFiller.style.display = "block", 
        d.gutterFiller.style.height = sizes.bottom + "px", d.gutterFiller.style.width = measure.gutterWidth + "px") : d.gutterFiller.style.display = "";
    }
    NullScrollbars.prototype.update = function() {
        return {
            bottom: 0,
            right: 0
        };
    }, NullScrollbars.prototype.setScrollLeft = function() {}, NullScrollbars.prototype.setScrollTop = function() {}, 
    NullScrollbars.prototype.clear = function() {};
    var scrollbarModel = {
        native: NativeScrollbars,
        null: NullScrollbars
    };
    function initScrollbars(cm) {
        cm.display.scrollbars && (cm.display.scrollbars.clear(), cm.display.scrollbars.addClass) && rmClass(cm.display.wrapper, cm.display.scrollbars.addClass), 
        cm.display.scrollbars = new scrollbarModel[cm.options.scrollbarStyle](function(node) {
            cm.display.wrapper.insertBefore(node, cm.display.scrollbarFiller), on(node, "mousedown", function() {
                cm.state.focused && setTimeout(function() {
                    return cm.display.input.focus();
                }, 0);
            }), node.setAttribute("cm-not-content", "true");
        }, function(pos, axis) {
            ("horizontal" == axis ? setScrollLeft : updateScrollTop)(cm, pos);
        }, cm), cm.display.scrollbars.addClass && addClass(cm.display.wrapper, cm.display.scrollbars.addClass);
    }
    var nextOpId = 0;
    function startOperation(cm) {
        cm.curOp = {
            cm: cm,
            viewChanged: !1,
            startHeight: cm.doc.height,
            forceUpdate: !1,
            updateInput: 0,
            typing: !1,
            changeObjs: null,
            cursorActivityHandlers: null,
            cursorActivityCalled: 0,
            selectionChanged: !1,
            updateMaxLine: !1,
            scrollLeft: null,
            scrollTop: null,
            scrollToPos: null,
            focus: !1,
            id: ++nextOpId,
            markArrays: null
        }, cm = cm.curOp, operationGroup ? operationGroup.ops.push(cm) : cm.ownsGroup = operationGroup = {
            ops: [ cm ],
            delayedCallbacks: []
        };
    }
    function endOperation(cm) {
        cm = cm.curOp;
        cm && finishOperation(cm, function(group) {
            for (var i = 0; i < group.ops.length; i++) group.ops[i].cm.curOp = null;
            !function(group) {
                for (var ops = group.ops, i = 0; i < ops.length; i++) !function(op) {
                    var cm = op.cm, display = cm.display;
                    (function(cm) {
                        var display = cm.display;
                        !display.scrollbarsClipped && display.scroller.offsetWidth && (display.nativeBarWidth = display.scroller.offsetWidth - display.scroller.clientWidth, 
                        display.heightForcer.style.height = scrollGap(cm) + "px", 
                        display.sizer.style.marginBottom = -display.nativeBarWidth + "px", 
                        display.sizer.style.borderRightWidth = scrollGap(cm) + "px", 
                        display.scrollbarsClipped = !0);
                    })(cm), op.updateMaxLine && findMaxLine(cm);
                    op.mustUpdate = op.viewChanged || op.forceUpdate || null != op.scrollTop || op.scrollToPos && (op.scrollToPos.from.line < display.viewFrom || op.scrollToPos.to.line >= display.viewTo) || display.maxLineChanged && cm.options.lineWrapping, 
                    op.update = op.mustUpdate && new DisplayUpdate(cm, op.mustUpdate && {
                        top: op.scrollTop,
                        ensure: op.scrollToPos
                    }, op.forceUpdate);
                }(ops[i]);
                for (var i$1 = 0; i$1 < ops.length; i$1++) !function(op) {
                    op.updatedDisplay = op.mustUpdate && updateDisplayIfNeeded(op.cm, op.update);
                }(ops[i$1]);
                for (var i$2 = 0; i$2 < ops.length; i$2++) !function(op) {
                    var cm = op.cm, display = cm.display;
                    op.updatedDisplay && updateHeightsInViewport(cm);
                    op.barMeasure = measureForScrollbars(cm), display.maxLineChanged && !cm.options.lineWrapping && (op.adjustWidthTo = measureChar(cm, display.maxLine, display.maxLine.text.length).left + 3, 
                    cm.display.sizerWidth = op.adjustWidthTo, op.barMeasure.scrollWidth = Math.max(display.scroller.clientWidth, display.sizer.offsetLeft + op.adjustWidthTo + scrollGap(cm) + cm.display.barWidth), 
                    op.maxScrollLeft = Math.max(0, display.sizer.offsetLeft + op.adjustWidthTo - displayWidth(cm)));
                    (op.updatedDisplay || op.selectionChanged) && (op.preparedSelection = display.input.prepareSelection());
                }(ops[i$2]);
                for (var i$3 = 0; i$3 < ops.length; i$3++) !function(op) {
                    var cm = op.cm;
                    null != op.adjustWidthTo && (cm.display.sizer.style.minWidth = op.adjustWidthTo + "px", 
                    op.maxScrollLeft < cm.doc.scrollLeft && setScrollLeft(cm, Math.min(cm.display.scroller.scrollLeft, op.maxScrollLeft), !0), 
                    cm.display.maxLineChanged = !1);
                    var takeFocus = op.focus && op.focus == activeElt();
                    op.preparedSelection && cm.display.input.showSelection(op.preparedSelection, takeFocus);
                    !op.updatedDisplay && op.startHeight == cm.doc.height || updateScrollbars(cm, op.barMeasure);
                    op.updatedDisplay && setDocumentHeight(cm, op.barMeasure);
                    op.selectionChanged && restartBlink(cm);
                    cm.state.focused && op.updateInput && cm.display.input.reset(op.typing);
                    takeFocus && ensureFocus(op.cm);
                }(ops[i$3]);
                for (var i$4 = 0; i$4 < ops.length; i$4++) !function(op) {
                    var cm = op.cm, display = cm.display, doc = cm.doc;
                    op.updatedDisplay && postUpdateDisplay(cm, op.update);
                    null == display.wheelStartX || null == op.scrollTop && null == op.scrollLeft && !op.scrollToPos || (display.wheelStartX = display.wheelStartY = null);
                    null != op.scrollTop && setScrollTop(cm, op.scrollTop, op.forceScroll);
                    null != op.scrollLeft && setScrollLeft(cm, op.scrollLeft, !0, !0);
                    {
                        var rect;
                        op.scrollToPos && (rect = function(cm, pos, end, margin) {
                            null == margin && (margin = 0), cm.options.lineWrapping || pos != end || (end = "before" == pos.sticky ? Pos(pos.line, pos.ch + 1, "before") : pos, 
                            pos = pos.ch ? Pos(pos.line, "before" == pos.sticky ? pos.ch - 1 : pos.ch, "after") : pos);
                            for (var limit = 0; limit < 5; limit++) {
                                var rect, changed = !1, coords = cursorCoords(cm, pos), endCoords = end && end != pos ? cursorCoords(cm, end) : coords, coords = calculateScrollPos(cm, rect = {
                                    left: Math.min(coords.left, endCoords.left),
                                    top: Math.min(coords.top, endCoords.top) - margin,
                                    right: Math.max(coords.left, endCoords.left),
                                    bottom: Math.max(coords.bottom, endCoords.bottom) + margin
                                }), endCoords = cm.doc.scrollTop, startLeft = cm.doc.scrollLeft;
                                if (null != coords.scrollTop && (updateScrollTop(cm, coords.scrollTop), 
                                1 < Math.abs(cm.doc.scrollTop - endCoords)) && (changed = !0), 
                                !(changed = null != coords.scrollLeft && (setScrollLeft(cm, coords.scrollLeft), 
                                1 < Math.abs(cm.doc.scrollLeft - startLeft)) ? !0 : changed)) break;
                            }
                            return rect;
                        }(cm, clipPos(doc, op.scrollToPos.from), clipPos(doc, op.scrollToPos.to), op.scrollToPos.margin), 
                        function(cm, rect) {
                            var display, doScroll, box;
                            signalDOMEvent(cm, "scrollCursorIntoView") || (box = (display = cm.display).sizer.getBoundingClientRect(), 
                            doScroll = null, rect.top + box.top < 0 ? doScroll = !0 : rect.bottom + box.top > (window.innerHeight || document.documentElement.clientHeight) && (doScroll = !1), 
                            null == doScroll) || phantom || (box = elt("div", "\u200b", null, "position: absolute;\n                         top: " + (rect.top - display.viewOffset - paddingTop(cm.display)) + "px;\n                         height: " + (rect.bottom - rect.top + scrollGap(cm) + display.barHeight) + "px;\n                         left: " + rect.left + "px; width: " + Math.max(2, rect.right - rect.left) + "px;"), 
                            cm.display.lineSpace.appendChild(box), box.scrollIntoView(doScroll), 
                            cm.display.lineSpace.removeChild(box));
                        }(cm, rect));
                    }
                    var hidden = op.maybeHiddenMarkers, unhidden = op.maybeUnhiddenMarkers;
                    if (hidden) for (var i = 0; i < hidden.length; ++i) hidden[i].lines.length || signal(hidden[i], "hide");
                    if (unhidden) for (var i$1 = 0; i$1 < unhidden.length; ++i$1) unhidden[i$1].lines.length && signal(unhidden[i$1], "unhide");
                    display.wrapper.offsetHeight && (doc.scrollTop = cm.display.scroller.scrollTop);
                    op.changeObjs && signal(cm, "changes", cm, op.changeObjs);
                    op.update && op.update.finish();
                }(ops[i$4]);
            }(group);
        });
    }
    function runInOp(cm, f) {
        if (cm.curOp) return f();
        startOperation(cm);
        try {
            return f();
        } finally {
            endOperation(cm);
        }
    }
    function operation(cm, f) {
        return function() {
            if (cm.curOp) return f.apply(cm, arguments);
            startOperation(cm);
            try {
                return f.apply(cm, arguments);
            } finally {
                endOperation(cm);
            }
        };
    }
    function methodOp(f) {
        return function() {
            if (this.curOp) return f.apply(this, arguments);
            startOperation(this);
            try {
                return f.apply(this, arguments);
            } finally {
                endOperation(this);
            }
        };
    }
    function docMethodOp(f) {
        return function() {
            var cm = this.cm;
            if (!cm || cm.curOp) return f.apply(this, arguments);
            startOperation(cm);
            try {
                return f.apply(this, arguments);
            } finally {
                endOperation(cm);
            }
        };
    }
    function startWorker(cm, time) {
        cm.doc.highlightFrontier < cm.display.viewTo && cm.state.highlight.set(time, bind(highlightWorker, cm));
    }
    function highlightWorker(cm) {
        var end, context, changedLines, doc = cm.doc;
        doc.highlightFrontier >= cm.display.viewTo || (end = +new Date() + cm.options.workTime, 
        context = getContextBefore(cm, doc.highlightFrontier), changedLines = [], 
        doc.iter(context.line, Math.min(doc.first + doc.size, cm.display.viewTo + 500), function(line) {
            if (context.line >= cm.display.viewFrom) {
                for (var oldStyles = line.styles, resetState = line.text.length > cm.options.maxHighlightLength ? copyState(doc.mode, context.state) : null, highlighted = highlightLine(cm, line, context, !0), resetState = (resetState && (context.state = resetState), 
                line.styles = highlighted.styles, line.styleClasses), highlighted = highlighted.classes, ischange = (highlighted ? line.styleClasses = highlighted : resetState && (line.styleClasses = null), 
                !oldStyles || oldStyles.length != line.styles.length || resetState != highlighted && (!resetState || !highlighted || resetState.bgClass != highlighted.bgClass || resetState.textClass != highlighted.textClass)), i = 0; !ischange && i < oldStyles.length; ++i) ischange = oldStyles[i] != line.styles[i];
                ischange && changedLines.push(context.line), line.stateAfter = context.save();
            } else line.text.length <= cm.options.maxHighlightLength && processLine(cm, line.text, context), 
            line.stateAfter = context.line % 5 == 0 ? context.save() : null;
            if (context.nextLine(), +new Date() > end) return startWorker(cm, cm.options.workDelay), 
            !0;
        }), doc.highlightFrontier = context.line, doc.modeFrontier = Math.max(doc.modeFrontier, context.line), 
        changedLines.length && runInOp(cm, function() {
            for (var i = 0; i < changedLines.length; i++) regLineChange(cm, changedLines[i], "text");
        }));
    }
    var DisplayUpdate = function(cm, viewport, force) {
        var display = cm.display;
        this.viewport = viewport, this.visible = visibleLines(display, cm.doc, viewport), 
        this.editorIsHidden = !display.wrapper.offsetWidth, this.wrapperHeight = display.wrapper.clientHeight, 
        this.wrapperWidth = display.wrapper.clientWidth, this.oldDisplayWidth = displayWidth(cm), 
        this.force = force, this.dims = getDimensions(cm), this.events = [];
    };
    function updateDisplayIfNeeded(cm, update) {
        var display = cm.display, doc = cm.doc;
        if (update.editorIsHidden) return resetView(cm), !1;
        if (!update.force && update.visible.from >= display.viewFrom && update.visible.to <= display.viewTo && (null == display.updateLineNumbers || display.updateLineNumbers >= display.viewTo) && display.renderedView == display.view && 0 == countDirtyView(cm)) return !1;
        maybeUpdateLineNumberWidth(cm) && (resetView(cm), update.dims = getDimensions(cm));
        var end = doc.first + doc.size, from = Math.max(update.visible.from - cm.options.viewportMargin, doc.first), to = Math.min(end, update.visible.to + cm.options.viewportMargin), doc = (display.viewFrom < from && from - display.viewFrom < 20 && (from = Math.max(doc.first, display.viewFrom)), 
        display.viewTo > to && display.viewTo - to < 20 && (to = Math.min(end, display.viewTo)), 
        sawCollapsedSpans && (from = visualLineNo(cm.doc, from), to = visualLineEndNo(cm.doc, to)), 
        from != display.viewFrom || to != display.viewTo || display.lastWrapHeight != update.wrapperHeight || display.lastWrapWidth != update.wrapperWidth), end = (!function(cm, from, to) {
            var display = cm.display;
            0 == display.view.length || from >= display.viewTo || to <= display.viewFrom ? (display.view = buildViewArray(cm, from, to), 
            display.viewFrom = from) : (display.viewFrom > from ? display.view = buildViewArray(cm, from, display.viewFrom).concat(display.view) : display.viewFrom < from && (display.view = display.view.slice(findViewIndex(cm, from))), 
            display.viewFrom = from, display.viewTo < to ? display.view = display.view.concat(buildViewArray(cm, display.viewTo, to)) : display.viewTo > to && (display.view = display.view.slice(0, findViewIndex(cm, to)))), 
            display.viewTo = to;
        }(cm, from, to), display.viewOffset = heightAtLine(getLine(cm.doc, display.viewFrom)), 
        cm.display.mover.style.top = display.viewOffset + "px", countDirtyView(cm));
        return !(!doc && 0 == end && !update.force && display.renderedView == display.view && (null == display.updateLineNumbers || display.updateLineNumbers >= display.viewTo) || (from = function(cm) {
            var active, sel;
            return !cm.hasFocus() && (active = activeElt()) && contains(cm.display.lineDiv, active) ? (active = {
                activeElt: active
            }, window.getSelection && (sel = window.getSelection()).anchorNode && sel.extend && contains(cm.display.lineDiv, sel.anchorNode) && (active.anchorNode = sel.anchorNode, 
            active.anchorOffset = sel.anchorOffset, active.focusNode = sel.focusNode, 
            active.focusOffset = sel.focusOffset), active) : null;
        }(cm), 4 < end && (display.lineDiv.style.display = "none"), function(cm, updateNumbersFrom, dims) {
            var display = cm.display, lineNumbers = cm.options.lineNumbers, container = display.lineDiv, cur = container.firstChild;
            function rm(node) {
                var next = node.nextSibling;
                return webkit && mac && cm.display.currentWheelTarget == node ? node.style.display = "none" : node.parentNode.removeChild(node), 
                next;
            }
            for (var view = display.view, lineN = display.viewFrom, i = 0; i < view.length; i++) {
                var lineView = view[i];
                if (!lineView.hidden) if (lineView.node && lineView.node.parentNode == container) {
                    for (;cur != lineView.node; ) cur = rm(cur);
                    var updateNumber = lineNumbers && null != updateNumbersFrom && updateNumbersFrom <= lineN && lineView.lineNumber;
                    lineView.changes && (-1 < indexOf(lineView.changes, "gutter") && (updateNumber = !1), 
                    updateLineForChanges(cm, lineView, lineN, dims)), updateNumber && (removeChildren(lineView.lineNumber), 
                    lineView.lineNumber.appendChild(document.createTextNode(lineNumberFor(cm.options, lineN)))), 
                    cur = lineView.node.nextSibling;
                } else {
                    updateNumber = function(cm, lineView, lineN, dims) {
                        var built = getLineContent(cm, lineView);
                        return lineView.text = lineView.node = built.pre, built.bgClass && (lineView.bgClass = built.bgClass), 
                        built.textClass && (lineView.textClass = built.textClass), 
                        updateLineClasses(cm, lineView), updateLineGutter(cm, lineView, lineN, dims), 
                        insertLineWidgets(cm, lineView, dims), lineView.node;
                    }(cm, lineView, lineN, dims);
                    container.insertBefore(updateNumber, cur);
                }
                lineN += lineView.size;
            }
            for (;cur; ) cur = rm(cur);
        }(cm, display.updateLineNumbers, update.dims), 4 < end && (display.lineDiv.style.display = ""), 
        display.renderedView = display.view, (to = from) && to.activeElt && to.activeElt != activeElt() && (to.activeElt.focus(), 
        !/^(INPUT|TEXTAREA)$/.test(to.activeElt.nodeName)) && to.anchorNode && contains(document.body, to.anchorNode) && contains(document.body, to.focusNode) && (end = window.getSelection(), 
        (from = document.createRange()).setEnd(to.anchorNode, to.anchorOffset), 
        from.collapse(!1), end.removeAllRanges(), end.addRange(from), end.extend(to.focusNode, to.focusOffset)), 
        removeChildren(display.cursorDiv), removeChildren(display.selectionDiv), 
        display.gutters.style.height = display.sizer.style.minHeight = 0, doc && (display.lastWrapHeight = update.wrapperHeight, 
        display.lastWrapWidth = update.wrapperWidth, startWorker(cm, 400)), display.updateLineNumbers = null));
    }
    function postUpdateDisplay(cm, update) {
        for (var viewport = update.viewport, first = !0; ;first = !1) {
            if (first && cm.options.lineWrapping && update.oldDisplayWidth != displayWidth(cm)) first && (update.visible = visibleLines(cm.display, cm.doc, viewport)); else if (viewport && null != viewport.top && (viewport = {
                top: Math.min(cm.doc.height + paddingVert(cm.display) - displayHeight(cm), viewport.top)
            }), update.visible = visibleLines(cm.display, cm.doc, viewport), update.visible.from >= cm.display.viewFrom && update.visible.to <= cm.display.viewTo) break;
            if (!updateDisplayIfNeeded(cm, update)) break;
            updateHeightsInViewport(cm);
            var barMeasure = measureForScrollbars(cm);
            updateSelection(cm), updateScrollbars(cm, barMeasure), setDocumentHeight(cm, barMeasure), 
            update.force = !1;
        }
        update.signal(cm, "update", cm), cm.display.viewFrom == cm.display.reportedViewFrom && cm.display.viewTo == cm.display.reportedViewTo || (update.signal(cm, "viewportChange", cm, cm.display.viewFrom, cm.display.viewTo), 
        cm.display.reportedViewFrom = cm.display.viewFrom, cm.display.reportedViewTo = cm.display.viewTo);
    }
    function updateDisplaySimple(cm, viewport) {
        var barMeasure, viewport = new DisplayUpdate(cm, viewport);
        updateDisplayIfNeeded(cm, viewport) && (updateHeightsInViewport(cm), postUpdateDisplay(cm, viewport), 
        barMeasure = measureForScrollbars(cm), updateSelection(cm), updateScrollbars(cm, barMeasure), 
        setDocumentHeight(cm, barMeasure), viewport.finish());
    }
    function updateGutterSpace(display) {
        var width = display.gutters.offsetWidth;
        display.sizer.style.marginLeft = width + "px", signalLater(display, "gutterChanged", display);
    }
    function setDocumentHeight(cm, measure) {
        cm.display.sizer.style.minHeight = measure.docHeight + "px", cm.display.heightForcer.style.top = measure.docHeight + "px", 
        cm.display.gutters.style.height = measure.docHeight + cm.display.barHeight + scrollGap(cm) + "px";
    }
    function alignHorizontally(cm) {
        var display = cm.display, view = display.view;
        if (display.alignWidgets || display.gutters.firstChild && cm.options.fixedGutter) {
            for (var comp = compensateForHScroll(display) - display.scroller.scrollLeft + cm.doc.scrollLeft, gutterW = display.gutters.offsetWidth, left = comp + "px", i = 0; i < view.length; i++) if (!view[i].hidden) {
                cm.options.fixedGutter && (view[i].gutter && (view[i].gutter.style.left = left), 
                view[i].gutterBackground) && (view[i].gutterBackground.style.left = left);
                var align = view[i].alignable;
                if (align) for (var j = 0; j < align.length; j++) align[j].style.left = left;
            }
            cm.options.fixedGutter && (display.gutters.style.left = comp + gutterW + "px");
        }
    }
    function maybeUpdateLineNumberWidth(cm) {
        var doc, display, innerW, test;
        if (cm.options.lineNumbers) return doc = cm.doc, doc = lineNumberFor(cm.options, doc.first + doc.size - 1), 
        display = cm.display, doc.length != display.lineNumChars ? (innerW = (test = display.measure.appendChild(elt("div", [ elt("div", doc) ], "CodeMirror-linenumber CodeMirror-gutter-elt"))).firstChild.offsetWidth, 
        test = test.offsetWidth - innerW, display.lineGutter.style.width = "", display.lineNumInnerWidth = Math.max(innerW, display.lineGutter.offsetWidth - test) + 1, 
        display.lineNumWidth = display.lineNumInnerWidth + test, display.lineNumChars = display.lineNumInnerWidth ? doc.length : -1, 
        display.lineGutter.style.width = display.lineNumWidth + "px", updateGutterSpace(cm.display), 
        1) : void 0;
    }
    function getGutters(gutters, lineNumbers) {
        for (var result = [], sawLineNumbers = !1, i = 0; i < gutters.length; i++) {
            var name = gutters[i], style = null;
            if ("string" != typeof name && (style = name.style, name = name.className), 
            "CodeMirror-linenumbers" == name) {
                if (!lineNumbers) continue;
                sawLineNumbers = !0;
            }
            result.push({
                className: name,
                style: style
            });
        }
        return lineNumbers && !sawLineNumbers && result.push({
            className: "CodeMirror-linenumbers",
            style: null
        }), result;
    }
    function renderGutters(display) {
        var gutters = display.gutters, specs = display.gutterSpecs;
        removeChildren(gutters), display.lineGutter = null;
        for (var i = 0; i < specs.length; ++i) {
            var ref = specs[i], className = ref.className, ref = ref.style, gElt = gutters.appendChild(elt("div", null, "CodeMirror-gutter " + className));
            ref && (gElt.style.cssText = ref), "CodeMirror-linenumbers" == className && ((display.lineGutter = gElt).style.width = (display.lineNumWidth || 1) + "px");
        }
        gutters.style.display = specs.length ? "" : "none", updateGutterSpace(display);
    }
    function updateGutters(cm) {
        renderGutters(cm.display), regChange(cm), alignHorizontally(cm);
    }
    function Display(place, doc, input, options) {
        var d = this, lines = (this.input = input, d.scrollbarFiller = elt("div", null, "CodeMirror-scrollbar-filler"), 
        d.scrollbarFiller.setAttribute("cm-not-content", "true"), d.gutterFiller = elt("div", null, "CodeMirror-gutter-filler"), 
        d.gutterFiller.setAttribute("cm-not-content", "true"), d.lineDiv = eltP("div", null, "CodeMirror-code"), 
        d.selectionDiv = elt("div", null, null, "position: relative; z-index: 1"), 
        d.cursorDiv = elt("div", null, "CodeMirror-cursors"), d.measure = elt("div", null, "CodeMirror-measure"), 
        d.lineMeasure = elt("div", null, "CodeMirror-measure"), d.lineSpace = eltP("div", [ d.measure, d.lineMeasure, d.selectionDiv, d.cursorDiv, d.lineDiv ], null, "position: relative; outline: none"), 
        eltP("div", [ d.lineSpace ], "CodeMirror-lines"));
        d.mover = elt("div", [ lines ], null, "position: relative"), d.sizer = elt("div", [ d.mover ], "CodeMirror-sizer"), 
        d.sizerWidth = null, d.heightForcer = elt("div", null, null, "position: absolute; height: " + scrollerGap + "px; width: 1px;"), 
        d.gutters = elt("div", null, "CodeMirror-gutters"), d.lineGutter = null, 
        d.scroller = elt("div", [ d.sizer, d.heightForcer, d.gutters ], "CodeMirror-scroll"), 
        d.scroller.setAttribute("tabIndex", "-1"), d.wrapper = elt("div", [ d.scrollbarFiller, d.gutterFiller, d.scroller ], "CodeMirror"), 
        d.wrapper.setAttribute("translate", "no"), ie && ie_version < 8 && (d.gutters.style.zIndex = -1, 
        d.scroller.style.paddingRight = 0), webkit || gecko && mobile || (d.scroller.draggable = !0), 
        place && (place.appendChild ? place.appendChild(d.wrapper) : place(d.wrapper)), 
        d.viewFrom = d.viewTo = doc.first, d.reportedViewFrom = d.reportedViewTo = doc.first, 
        d.view = [], d.renderedView = null, d.externalMeasured = null, d.viewOffset = 0, 
        d.lastWrapHeight = d.lastWrapWidth = 0, d.updateLineNumbers = null, d.nativeBarWidth = d.barHeight = d.barWidth = 0, 
        d.scrollbarsClipped = !1, d.lineNumWidth = d.lineNumInnerWidth = d.lineNumChars = null, 
        d.alignWidgets = !1, d.cachedCharWidth = d.cachedTextHeight = d.cachedPaddingH = null, 
        d.maxLine = null, d.maxLineLength = 0, d.maxLineChanged = !1, d.wheelDX = d.wheelDY = d.wheelStartX = d.wheelStartY = null, 
        d.shift = !1, d.selForContextMenu = null, d.activeTouch = null, d.gutterSpecs = getGutters(options.gutters, options.lineNumbers), 
        renderGutters(d), input.init(d);
    }
    DisplayUpdate.prototype.signal = function(emitter, type) {
        hasHandler(emitter, type) && this.events.push(arguments);
    }, DisplayUpdate.prototype.finish = function() {
        for (var i = 0; i < this.events.length; i++) signal.apply(null, this.events[i]);
    };
    var wheelSamples = 0, wheelPixelsPerUnit = null;
    function wheelEventDelta(e) {
        var dx = e.wheelDeltaX, dy = e.wheelDeltaY;
        return null == dx && e.detail && e.axis == e.HORIZONTAL_AXIS && (dx = e.detail), 
        null == dy && e.detail && e.axis == e.VERTICAL_AXIS ? dy = e.detail : null == dy && (dy = e.wheelDelta), 
        {
            x: dx,
            y: dy
        };
    }
    function wheelEventPixels(e) {
        e = wheelEventDelta(e);
        return e.x *= wheelPixelsPerUnit, e.y *= wheelPixelsPerUnit, e;
    }
    function onScrollWheel(cm, e) {
        chrome && 102 <= chrome_version && (null == cm.display.chromeScrollHack ? cm.display.sizer.style.pointerEvents = "none" : clearTimeout(cm.display.chromeScrollHack), 
        cm.display.chromeScrollHack = setTimeout(function() {
            cm.display.chromeScrollHack = null, cm.display.sizer.style.pointerEvents = "";
        }, 100));
        var pixels, bot, delta = wheelEventDelta(e), dx = delta.x, delta = delta.y, pixelsPerUnit = wheelPixelsPerUnit, display = (0 === e.deltaMode && (dx = e.deltaX, 
        delta = e.deltaY, pixelsPerUnit = 1), cm.display), scroll = display.scroller, canScrollX = scroll.scrollWidth > scroll.clientWidth, canScrollY = scroll.scrollHeight > scroll.clientHeight;
        if (dx && canScrollX || delta && canScrollY) {
            if (delta && mac && webkit) outer: for (var cur = e.target, view = display.view; cur != scroll; cur = cur.parentNode) for (var i = 0; i < view.length; i++) if (view[i].node == cur) {
                cm.display.currentWheelTarget = cur;
                break outer;
            }
            !dx || gecko || presto || null == pixelsPerUnit ? (delta && null != pixelsPerUnit && (bot = (canScrollX = cm.doc.scrollTop) + display.wrapper.clientHeight, 
            (pixels = delta * pixelsPerUnit) < 0 ? canScrollX = Math.max(0, canScrollX + pixels - 50) : bot = Math.min(cm.doc.height, bot + pixels + 50), 
            updateDisplaySimple(cm, {
                top: canScrollX,
                bottom: bot
            })), wheelSamples < 20 && 0 !== e.deltaMode && (null == display.wheelStartX ? (display.wheelStartX = scroll.scrollLeft, 
            display.wheelStartY = scroll.scrollTop, display.wheelDX = dx, display.wheelDY = delta, 
            setTimeout(function() {
                var movedX, movedY;
                null != display.wheelStartX && (movedX = scroll.scrollLeft - display.wheelStartX, 
                movedY = (movedY = scroll.scrollTop - display.wheelStartY) && display.wheelDY && movedY / display.wheelDY || movedX && display.wheelDX && movedX / display.wheelDX, 
                display.wheelStartX = display.wheelStartY = null, movedY) && (wheelPixelsPerUnit = (wheelPixelsPerUnit * wheelSamples + movedY) / (wheelSamples + 1), 
                ++wheelSamples);
            }, 200)) : (display.wheelDX += dx, display.wheelDY += delta))) : (delta && canScrollY && updateScrollTop(cm, Math.max(0, scroll.scrollTop + delta * pixelsPerUnit)), 
            setScrollLeft(cm, Math.max(0, scroll.scrollLeft + dx * pixelsPerUnit)), 
            delta && !canScrollY || e_preventDefault(e), display.wheelStartX = null);
        }
    }
    ie ? wheelPixelsPerUnit = -.53 : gecko ? wheelPixelsPerUnit = 15 : chrome ? wheelPixelsPerUnit = -.7 : safari && (wheelPixelsPerUnit = -1 / 3);
    var Selection = function(ranges, primIndex) {
        this.ranges = ranges, this.primIndex = primIndex;
    }, Range = (Selection.prototype.primary = function() {
        return this.ranges[this.primIndex];
    }, Selection.prototype.equals = function(other) {
        if (other != this) {
            if (other.primIndex != this.primIndex || other.ranges.length != this.ranges.length) return !1;
            for (var i = 0; i < this.ranges.length; i++) {
                var here = this.ranges[i], there = other.ranges[i];
                if (!equalCursorPos(here.anchor, there.anchor) || !equalCursorPos(here.head, there.head)) return !1;
            }
        }
        return !0;
    }, Selection.prototype.deepCopy = function() {
        for (var out = [], i = 0; i < this.ranges.length; i++) out[i] = new Range(copyPos(this.ranges[i].anchor), copyPos(this.ranges[i].head));
        return new Selection(out, this.primIndex);
    }, Selection.prototype.somethingSelected = function() {
        for (var i = 0; i < this.ranges.length; i++) if (!this.ranges[i].empty()) return !0;
        return !1;
    }, Selection.prototype.contains = function(pos, end) {
        end = end || pos;
        for (var i = 0; i < this.ranges.length; i++) {
            var range = this.ranges[i];
            if (0 <= cmp(end, range.from()) && cmp(pos, range.to()) <= 0) return i;
        }
        return -1;
    }, function(anchor, head) {
        this.anchor = anchor, this.head = head;
    });
    function normalizeSelection(cm, ranges, primIndex) {
        var mayTouch = cm && cm.options.selectionsMayTouch, cm = ranges[primIndex];
        ranges.sort(function(a, b) {
            return cmp(a.from(), b.from());
        }), primIndex = indexOf(ranges, cm);
        for (var i = 1; i < ranges.length; i++) {
            var to, cur = ranges[i], prev = ranges[i - 1], diff = cmp(prev.to(), cur.from());
            (mayTouch && !cur.empty() ? 0 < diff : 0 <= diff) && (diff = minPos(prev.from(), cur.from()), 
            to = maxPos(prev.to(), cur.to()), cur = prev.empty() ? cur.from() == cur.head : prev.from() == prev.head, 
            i <= primIndex && --primIndex, ranges.splice(--i, 2, new Range(cur ? to : diff, cur ? diff : to)));
        }
        return new Selection(ranges, primIndex);
    }
    function simpleSelection(anchor, head) {
        return new Selection([ new Range(anchor, head || anchor) ], 0);
    }
    function changeEnd(change) {
        return change.text ? Pos(change.from.line + change.text.length - 1, lst(change.text).length + (1 == change.text.length ? change.from.ch : 0)) : change.to;
    }
    function adjustForChange(pos, change) {
        var line, ch;
        return cmp(pos, change.from) < 0 ? pos : cmp(pos, change.to) <= 0 ? changeEnd(change) : (line = pos.line + change.text.length - (change.to.line - change.from.line) - 1, 
        ch = pos.ch, pos.line == change.to.line && (ch += changeEnd(change).ch - change.to.ch), 
        Pos(line, ch));
    }
    function computeSelAfterChange(doc, change) {
        for (var out = [], i = 0; i < doc.sel.ranges.length; i++) {
            var range = doc.sel.ranges[i];
            out.push(new Range(adjustForChange(range.anchor, change), adjustForChange(range.head, change)));
        }
        return normalizeSelection(doc.cm, out, doc.sel.primIndex);
    }
    function offsetPos(pos, old, nw) {
        return pos.line == old.line ? Pos(nw.line, pos.ch - old.ch + nw.ch) : Pos(nw.line + (pos.line - old.line), pos.ch);
    }
    function loadMode(cm) {
        cm.doc.mode = getMode(cm.options, cm.doc.modeOption), resetModeState(cm);
    }
    function resetModeState(cm) {
        cm.doc.iter(function(line) {
            line.stateAfter && (line.stateAfter = null), line.styles && (line.styles = null);
        }), cm.doc.modeFrontier = cm.doc.highlightFrontier = cm.doc.first, startWorker(cm, 100), 
        cm.state.modeGen++, cm.curOp && regChange(cm);
    }
    function isWholeLineUpdate(doc, change) {
        return 0 == change.from.ch && 0 == change.to.ch && "" == lst(change.text) && (!doc.cm || doc.cm.options.wholeLineUpdateBefore);
    }
    function updateDoc(doc, change, markedSpans, estimateHeight) {
        function spansFor(n) {
            return markedSpans ? markedSpans[n] : null;
        }
        function update(line, text, spans) {
            !function(line, text, markedSpans, estimateHeight) {
                line.text = text, line.stateAfter && (line.stateAfter = null), line.styles && (line.styles = null), 
                null != line.order && (line.order = null), detachMarkedSpans(line), 
                attachMarkedSpans(line, markedSpans), (text = estimateHeight ? estimateHeight(line) : 1) != line.height && updateLineHeight(line, text);
            }(line, text, spans, estimateHeight), signalLater(line, "change", line, change);
        }
        function linesFor(start, end) {
            for (var result = [], i = start; i < end; ++i) result.push(new Line(text[i], spansFor(i), estimateHeight));
            return result;
        }
        var added, from = change.from, to = change.to, text = change.text, firstLine = getLine(doc, from.line), lastLine = getLine(doc, to.line), lastText = lst(text), lastSpans = spansFor(text.length - 1), nlines = to.line - from.line;
        change.full ? (doc.insert(0, linesFor(0, text.length)), doc.remove(text.length, doc.size - text.length)) : isWholeLineUpdate(doc, change) ? (added = linesFor(0, text.length - 1), 
        update(lastLine, lastLine.text, lastSpans), nlines && doc.remove(from.line, nlines), 
        added.length && doc.insert(from.line, added)) : firstLine == lastLine ? 1 == text.length ? update(firstLine, firstLine.text.slice(0, from.ch) + lastText + firstLine.text.slice(to.ch), lastSpans) : ((added = linesFor(1, text.length - 1)).push(new Line(lastText + firstLine.text.slice(to.ch), lastSpans, estimateHeight)), 
        update(firstLine, firstLine.text.slice(0, from.ch) + text[0], spansFor(0)), 
        doc.insert(from.line + 1, added)) : 1 == text.length ? (update(firstLine, firstLine.text.slice(0, from.ch) + text[0] + lastLine.text.slice(to.ch), spansFor(0)), 
        doc.remove(from.line + 1, nlines)) : (update(firstLine, firstLine.text.slice(0, from.ch) + text[0], spansFor(0)), 
        update(lastLine, lastText + lastLine.text.slice(to.ch), lastSpans), added = linesFor(1, text.length - 1), 
        1 < nlines && doc.remove(from.line + 1, nlines - 1), doc.insert(from.line + 1, added)), 
        signalLater(doc, "change", doc, change);
    }
    function linkedDocs(doc, f, sharedHistOnly) {
        !function propagate(doc, skip, sharedHist) {
            if (doc.linked) for (var i = 0; i < doc.linked.length; ++i) {
                var shared, rel = doc.linked[i];
                rel.doc != skip && (shared = sharedHist && rel.sharedHist, !sharedHistOnly || shared) && (f(rel.doc, shared), 
                propagate(rel.doc, doc, shared));
            }
        }(doc, null, !0);
    }
    function attachDoc(cm, doc) {
        if (doc.cm) throw new Error("This document is already in use.");
        cm.doc = doc, estimateLineHeights(doc.cm = cm), loadMode(cm), setDirectionClass(cm), 
        cm.options.direction = doc.direction, cm.options.lineWrapping || findMaxLine(cm), 
        cm.options.mode = doc.modeOption, regChange(cm);
    }
    function setDirectionClass(cm) {
        ("rtl" == cm.doc.direction ? addClass : rmClass)(cm.display.lineDiv, "CodeMirror-rtl");
    }
    function History(prev) {
        this.done = [], this.undone = [], this.undoDepth = prev ? prev.undoDepth : 1 / 0, 
        this.lastModTime = this.lastSelTime = 0, this.lastOp = this.lastSelOp = null, 
        this.lastOrigin = this.lastSelOrigin = null, this.generation = this.maxGeneration = prev ? prev.maxGeneration : 1;
    }
    function historyChangeFromChange(doc, change) {
        var histChange = {
            from: copyPos(change.from),
            to: changeEnd(change),
            text: getBetween(doc, change.from, change.to)
        };
        return attachLocalSpans(doc, histChange, change.from.line, change.to.line + 1), 
        linkedDocs(doc, function(doc) {
            return attachLocalSpans(doc, histChange, change.from.line, change.to.line + 1);
        }, !0), histChange;
    }
    function clearSelectionEvents(array) {
        for (;array.length; ) {
            if (!lst(array).ranges) break;
            array.pop();
        }
    }
    function addChangeToHistory(doc, change, selAfter, opId) {
        var cur, last, hist = doc.history, time = (hist.undone.length = 0, +new Date());
        if ((hist.lastOp == opId || hist.lastOrigin == change.origin && change.origin && ("+" == change.origin.charAt(0) && hist.lastModTime > time - (doc.cm ? doc.cm.options.historyEventDelay : 500) || "*" == change.origin.charAt(0))) && (cur = function(hist, force) {
            return force ? (clearSelectionEvents(hist.done), lst(hist.done)) : hist.done.length && !lst(hist.done).ranges ? lst(hist.done) : 1 < hist.done.length && !hist.done[hist.done.length - 2].ranges ? (hist.done.pop(), 
            lst(hist.done)) : void 0;
        }(hist, hist.lastOp == opId))) last = lst(cur.changes), 0 == cmp(change.from, change.to) && 0 == cmp(change.from, last.to) ? last.to = changeEnd(change) : cur.changes.push(historyChangeFromChange(doc, change)); else {
            var before = lst(hist.done);
            for (before && before.ranges || pushSelectionToHistory(doc.sel, hist.done), 
            cur = {
                changes: [ historyChangeFromChange(doc, change) ],
                generation: hist.generation
            }, hist.done.push(cur); hist.done.length > hist.undoDepth; ) hist.done.shift(), 
            hist.done[0].ranges || hist.done.shift();
        }
        hist.done.push(selAfter), hist.generation = ++hist.maxGeneration, hist.lastModTime = hist.lastSelTime = time, 
        hist.lastOp = hist.lastSelOp = opId, hist.lastOrigin = hist.lastSelOrigin = change.origin, 
        last || signal(doc, "historyAdded");
    }
    function addSelectionToHistory(doc, sel, opId, options) {
        var hist = doc.history, origin = options && options.origin;
        opId == hist.lastSelOp || origin && hist.lastSelOrigin == origin && (hist.lastModTime == hist.lastSelTime && hist.lastOrigin == origin || function(doc, origin, prev, sel) {
            return "*" == (origin = origin.charAt(0)) || "+" == origin && prev.ranges.length == sel.ranges.length && prev.somethingSelected() == sel.somethingSelected() && new Date() - doc.history.lastSelTime <= (doc.cm ? doc.cm.options.historyEventDelay : 500);
        }(doc, origin, lst(hist.done), sel)) ? hist.done[hist.done.length - 1] = sel : pushSelectionToHistory(sel, hist.done), 
        hist.lastSelTime = +new Date(), hist.lastSelOrigin = origin, hist.lastSelOp = opId, 
        options && !1 !== options.clearRedo && clearSelectionEvents(hist.undone);
    }
    function pushSelectionToHistory(sel, dest) {
        var top = lst(dest);
        top && top.ranges && top.equals(sel) || dest.push(sel);
    }
    function attachLocalSpans(doc, change, from, to) {
        var existing = change["spans_" + doc.id], n = 0;
        doc.iter(Math.max(doc.first, from), Math.min(doc.first + doc.size, to), function(line) {
            line.markedSpans && ((existing = existing || (change["spans_" + doc.id] = {}))[n] = line.markedSpans), 
            ++n;
        });
    }
    function getOldSpans(doc, change) {
        var found = change["spans_" + doc.id];
        if (!found) return null;
        for (var nw = [], i = 0; i < change.text.length; ++i) nw.push(function(spans) {
            if (!spans) return null;
            for (var out, i = 0; i < spans.length; ++i) spans[i].marker.explicitlyCleared ? out = out || spans.slice(0, i) : out && out.push(spans[i]);
            return out ? out.length ? out : null : spans;
        }(found[i]));
        return nw;
    }
    function mergeOldSpans(doc, change) {
        var old = getOldSpans(doc, change), stretched = stretchSpansOverChange(doc, change);
        if (!old) return stretched;
        if (stretched) for (var i = 0; i < old.length; ++i) {
            var oldCur = old[i], stretchCur = stretched[i];
            if (oldCur && stretchCur) spans: for (var j = 0; j < stretchCur.length; ++j) {
                for (var span = stretchCur[j], k = 0; k < oldCur.length; ++k) if (oldCur[k].marker == span.marker) continue spans;
                oldCur.push(span);
            } else stretchCur && (old[i] = stretchCur);
        }
        return old;
    }
    function copyHistoryArray(events, newGroup, instantiateSel) {
        for (var copy = [], i = 0; i < events.length; ++i) {
            var event = events[i];
            if (event.ranges) copy.push(instantiateSel ? Selection.prototype.deepCopy.call(event) : event); else {
                var changes = event.changes, newChanges = [];
                copy.push({
                    changes: newChanges
                });
                for (var j = 0; j < changes.length; ++j) {
                    var m, change = changes[j];
                    if (newChanges.push({
                        from: change.from,
                        to: change.to,
                        text: change.text
                    }), newGroup) for (var prop in change) (m = prop.match(/^spans_(\d+)$/)) && -1 < indexOf(newGroup, Number(m[1])) && (lst(newChanges)[prop] = change[prop], 
                    delete change[prop]);
                }
            }
        }
        return copy;
    }
    function extendRange(range, head, other, extend) {
        return extend ? (extend = range.anchor, other && ((range = cmp(head, extend) < 0) != cmp(other, extend) < 0 ? (extend = head, 
        head = other) : range != cmp(head, other) < 0 && (head = other)), new Range(extend, head)) : new Range(other || head, head);
    }
    function extendSelection(doc, head, other, options, extend) {
        null == extend && (extend = doc.cm && (doc.cm.display.shift || doc.extend)), 
        setSelection(doc, new Selection([ extendRange(doc.sel.primary(), head, other, extend) ], 0), options);
    }
    function extendSelections(doc, heads, options) {
        for (var out = [], extend = doc.cm && (doc.cm.display.shift || doc.extend), i = 0; i < doc.sel.ranges.length; i++) out[i] = extendRange(doc.sel.ranges[i], heads[i], null, extend);
        setSelection(doc, normalizeSelection(doc.cm, out, doc.sel.primIndex), options);
    }
    function replaceOneSelection(doc, i, range, options) {
        var ranges = doc.sel.ranges.slice(0);
        ranges[i] = range, setSelection(doc, normalizeSelection(doc.cm, ranges, doc.sel.primIndex), options);
    }
    function setSimpleSelection(doc, anchor, head, options) {
        setSelection(doc, simpleSelection(anchor, head), options);
    }
    function setSelectionReplaceHistory(doc, sel, options) {
        var done = doc.history.done, last = lst(done);
        last && last.ranges ? setSelectionNoUndo(doc, done[done.length - 1] = sel, options) : setSelection(doc, sel, options);
    }
    function setSelection(doc, sel, options) {
        setSelectionNoUndo(doc, sel, options), addSelectionToHistory(doc, doc.sel, doc.cm ? doc.cm.curOp.id : NaN, options);
    }
    function setSelectionNoUndo(doc, sel, options) {
        (hasHandler(doc, "beforeSelectionChange") || doc.cm && hasHandler(doc.cm, "beforeSelectionChange")) && (sel = function(doc, sel, options) {
            return options = {
                ranges: sel.ranges,
                update: function(ranges) {
                    this.ranges = [];
                    for (var i = 0; i < ranges.length; i++) this.ranges[i] = new Range(clipPos(doc, ranges[i].anchor), clipPos(doc, ranges[i].head));
                },
                origin: options && options.origin
            }, signal(doc, "beforeSelectionChange", doc, options), doc.cm && signal(doc.cm, "beforeSelectionChange", doc.cm, options), 
            options.ranges != sel.ranges ? normalizeSelection(doc.cm, options.ranges, options.ranges.length - 1) : sel;
        }(doc, sel, options));
        var bias = options && options.bias || (cmp(sel.primary().head, doc.sel.primary().head) < 0 ? -1 : 1);
        setSelectionInner(doc, skipAtomicInSelection(doc, sel, bias, !0)), options && !1 === options.scroll || !doc.cm || "nocursor" == doc.cm.getOption("readOnly") || ensureCursorVisible(doc.cm);
    }
    function setSelectionInner(doc, sel) {
        sel.equals(doc.sel) || (doc.sel = sel, doc.cm && (doc.cm.curOp.updateInput = 1, 
        doc.cm.curOp.selectionChanged = !0, signalCursorActivity(doc.cm)), signalLater(doc, "cursorActivity", doc));
    }
    function reCheckSelection(doc) {
        setSelectionInner(doc, skipAtomicInSelection(doc, doc.sel, null, !1));
    }
    function skipAtomicInSelection(doc, sel, bias, mayClear) {
        for (var out, i = 0; i < sel.ranges.length; i++) {
            var range = sel.ranges[i], old = sel.ranges.length == doc.sel.ranges.length && doc.sel.ranges[i], newAnchor = skipAtomic(doc, range.anchor, old && old.anchor, bias, mayClear), old = range.head == range.anchor ? newAnchor : skipAtomic(doc, range.head, old && old.head, bias, mayClear);
            !out && newAnchor == range.anchor && old == range.head || ((out = out || sel.ranges.slice(0, i))[i] = new Range(newAnchor, old));
        }
        return out ? normalizeSelection(doc.cm, out, sel.primIndex) : sel;
    }
    function skipAtomicInner(doc, pos, oldPos, dir, mayClear) {
        var line = getLine(doc, pos.line);
        if (line.markedSpans) for (var i = 0; i < line.markedSpans.length; ++i) {
            var sp = line.markedSpans[i], m = sp.marker, preventCursorLeft = "selectLeft" in m ? !m.selectLeft : m.inclusiveLeft, preventCursorRight = "selectRight" in m ? !m.selectRight : m.inclusiveRight;
            if ((null == sp.from || (preventCursorLeft ? sp.from <= pos.ch : sp.from < pos.ch)) && (null == sp.to || (preventCursorRight ? sp.to >= pos.ch : sp.to > pos.ch))) {
                if (mayClear && (signal(m, "beforeCursorEnter"), m.explicitlyCleared)) {
                    if (line.markedSpans) {
                        --i;
                        continue;
                    }
                    break;
                }
                if (m.atomic) {
                    if (oldPos) {
                        var sp = m.find(dir < 0 ? 1 : -1), diff = void 0;
                        if ((sp = (dir < 0 ? preventCursorRight : preventCursorLeft) ? movePos(doc, sp, -dir, sp && sp.line == pos.line ? line : null) : sp) && sp.line == pos.line && (diff = cmp(sp, oldPos)) && (dir < 0 ? diff < 0 : 0 < diff)) return skipAtomicInner(doc, sp, pos, dir, mayClear);
                    }
                    diff = m.find(dir < 0 ? -1 : 1);
                    return (diff = (dir < 0 ? preventCursorLeft : preventCursorRight) ? movePos(doc, diff, dir, diff.line == pos.line ? line : null) : diff) ? skipAtomicInner(doc, diff, pos, dir, mayClear) : null;
                }
            }
        }
        return pos;
    }
    function skipAtomic(doc, pos, oldPos, bias, mayClear) {
        bias = bias || 1, mayClear = skipAtomicInner(doc, pos, oldPos, bias, mayClear) || !mayClear && skipAtomicInner(doc, pos, oldPos, bias, !0) || skipAtomicInner(doc, pos, oldPos, -bias, mayClear) || !mayClear && skipAtomicInner(doc, pos, oldPos, -bias, !0);
        return mayClear || (doc.cantEdit = !0, Pos(doc.first, 0));
    }
    function movePos(doc, pos, dir, line) {
        return dir < 0 && 0 == pos.ch ? pos.line > doc.first ? clipPos(doc, Pos(pos.line - 1)) : null : 0 < dir && pos.ch == (line || getLine(doc, pos.line)).text.length ? pos.line < doc.first + doc.size - 1 ? Pos(pos.line + 1, 0) : null : new Pos(pos.line, pos.ch + dir);
    }
    function selectAll(cm) {
        cm.setSelection(Pos(cm.firstLine(), 0), Pos(cm.lastLine()), sel_dontScroll);
    }
    function filterChange(doc, change, update) {
        var obj = {
            canceled: !1,
            from: change.from,
            to: change.to,
            text: change.text,
            origin: change.origin,
            cancel: function() {
                return obj.canceled = !0;
            }
        };
        return update && (obj.update = function(from, to, text, origin) {
            from && (obj.from = clipPos(doc, from)), to && (obj.to = clipPos(doc, to)), 
            text && (obj.text = text), void 0 !== origin && (obj.origin = origin);
        }), signal(doc, "beforeChange", doc, obj), doc.cm && signal(doc.cm, "beforeChange", doc.cm, obj), 
        obj.canceled ? (doc.cm && (doc.cm.curOp.updateInput = 2), null) : {
            from: obj.from,
            to: obj.to,
            text: obj.text,
            origin: obj.origin
        };
    }
    function makeChange(doc, change, ignoreReadOnly) {
        if (doc.cm) {
            if (!doc.cm.curOp) return operation(doc.cm, makeChange)(doc, change, ignoreReadOnly);
            if (doc.cm.state.suppressEdits) return;
        }
        if (!(hasHandler(doc, "beforeChange") || doc.cm && hasHandler(doc.cm, "beforeChange")) || (change = filterChange(doc, change, !0))) {
            var split = sawReadOnlySpans && !ignoreReadOnly && function(doc, from, to) {
                var markers = null;
                if (doc.iter(from.line, to.line + 1, function(line) {
                    if (line.markedSpans) for (var i = 0; i < line.markedSpans.length; ++i) {
                        var mark = line.markedSpans[i].marker;
                        !mark.readOnly || markers && -1 != indexOf(markers, mark) || (markers = markers || []).push(mark);
                    }
                }), !markers) return null;
                for (var parts = [ {
                    from: from,
                    to: to
                } ], i = 0; i < markers.length; ++i) for (var mk = markers[i], m = mk.find(0), j = 0; j < parts.length; ++j) {
                    var newParts, dfrom, dto, p = parts[j];
                    cmp(p.to, m.from) < 0 || 0 < cmp(p.from, m.to) || (newParts = [ j, 1 ], 
                    dfrom = cmp(p.from, m.from), dto = cmp(p.to, m.to), (dfrom < 0 || !mk.inclusiveLeft && !dfrom) && newParts.push({
                        from: p.from,
                        to: m.from
                    }), (0 < dto || !mk.inclusiveRight && !dto) && newParts.push({
                        from: m.to,
                        to: p.to
                    }), parts.splice.apply(parts, newParts), j += newParts.length - 3);
                }
                return parts;
            }(doc, change.from, change.to);
            if (split) for (var i = split.length - 1; 0 <= i; --i) makeChangeInner(doc, {
                from: split[i].from,
                to: split[i].to,
                text: i ? [ "" ] : change.text,
                origin: change.origin
            }); else makeChangeInner(doc, change);
        }
    }
    function makeChangeInner(doc, change) {
        var selAfter, rebased;
        1 == change.text.length && "" == change.text[0] && 0 == cmp(change.from, change.to) || (selAfter = computeSelAfterChange(doc, change), 
        addChangeToHistory(doc, change, selAfter, doc.cm ? doc.cm.curOp.id : NaN), 
        makeChangeSingleDoc(doc, change, selAfter, stretchSpansOverChange(doc, change)), 
        rebased = [], linkedDocs(doc, function(doc, sharedHist) {
            sharedHist || -1 != indexOf(rebased, doc.history) || (rebaseHist(doc.history, change), 
            rebased.push(doc.history)), makeChangeSingleDoc(doc, change, null, stretchSpansOverChange(doc, change));
        }));
    }
    function makeChangeFromHistory(doc, type, allowSelectionOnly) {
        var suppress = doc.cm && doc.cm.state.suppressEdits;
        if (!suppress || allowSelectionOnly) {
            for (var event, hist = doc.history, selAfter = doc.sel, source = "undo" == type ? hist.done : hist.undone, dest = "undo" == type ? hist.undone : hist.done, i = 0; i < source.length && (event = source[i], 
            allowSelectionOnly ? !event.ranges || event.equals(doc.sel) : event.ranges); i++);
            if (i != source.length) {
                for (hist.lastOrigin = hist.lastSelOrigin = null; ;) {
                    if (!(event = source.pop()).ranges) {
                        if (suppress) return void source.push(event);
                        break;
                    }
                    if (pushSelectionToHistory(event, dest), allowSelectionOnly && !event.equals(doc.sel)) return void setSelection(doc, event, {
                        clearRedo: !1
                    });
                    selAfter = event;
                }
                for (var antiChanges = [], filter = (pushSelectionToHistory(selAfter, dest), 
                dest.push({
                    changes: antiChanges,
                    generation: hist.generation
                }), hist.generation = event.generation || ++hist.maxGeneration, 
                hasHandler(doc, "beforeChange") || doc.cm && hasHandler(doc.cm, "beforeChange")), i$1 = event.changes.length - 1; 0 <= i$1; --i$1) {
                    var returned = function(i) {
                        var change = event.changes[i];
                        if (change.origin = type, filter && !filterChange(doc, change, !1)) return source.length = 0, 
                        {};
                        antiChanges.push(historyChangeFromChange(doc, change));
                        var after = i ? computeSelAfterChange(doc, change) : lst(source), rebased = (makeChangeSingleDoc(doc, change, after, mergeOldSpans(doc, change)), 
                        !i && doc.cm && doc.cm.scrollIntoView({
                            from: change.from,
                            to: changeEnd(change)
                        }), []);
                        linkedDocs(doc, function(doc, sharedHist) {
                            sharedHist || -1 != indexOf(rebased, doc.history) || (rebaseHist(doc.history, change), 
                            rebased.push(doc.history)), makeChangeSingleDoc(doc, change, null, mergeOldSpans(doc, change));
                        });
                    }(i$1);
                    if (returned) return returned.v;
                }
            }
        }
    }
    function shiftDoc(doc, distance) {
        if (0 != distance && (doc.first += distance, doc.sel = new Selection(map(doc.sel.ranges, function(range) {
            return new Range(Pos(range.anchor.line + distance, range.anchor.ch), Pos(range.head.line + distance, range.head.ch));
        }), doc.sel.primIndex), doc.cm)) {
            regChange(doc.cm, doc.first, doc.first - distance, distance);
            for (var d = doc.cm.display, l = d.viewFrom; l < d.viewTo; l++) regLineChange(doc.cm, l, "gutter");
        }
    }
    function makeChangeSingleDoc(doc, change, selAfter, spans) {
        if (doc.cm && !doc.cm.curOp) return operation(doc.cm, makeChangeSingleDoc)(doc, change, selAfter, spans);
        var shift;
        change.to.line < doc.first ? shiftDoc(doc, change.text.length - 1 - (change.to.line - change.from.line)) : change.from.line > doc.lastLine() || (change.from.line < doc.first && (shiftDoc(doc, shift = change.text.length - 1 - (doc.first - change.from.line)), 
        change = {
            from: Pos(doc.first, 0),
            to: Pos(change.to.line + shift, change.to.ch),
            text: [ lst(change.text) ],
            origin: change.origin
        }), shift = doc.lastLine(), (change = change.to.line > shift ? {
            from: change.from,
            to: Pos(shift, getLine(doc, shift).text.length),
            text: [ change.text[0] ],
            origin: change.origin
        } : change).removed = getBetween(doc, change.from, change.to), selAfter = selAfter || computeSelAfterChange(doc, change), 
        doc.cm ? function(cm, change, spans) {
            var doc = cm.doc, display = cm.display, from = change.from, to = change.to, recomputeMaxLength = !1, checkWidthStart = from.line;
            cm.options.lineWrapping || (checkWidthStart = lineNo(visualLine(getLine(doc, from.line))), 
            doc.iter(checkWidthStart, to.line + 1, function(line) {
                if (line == display.maxLine) return recomputeMaxLength = !0;
            }));
            -1 < doc.sel.contains(change.from, change.to) && signalCursorActivity(cm);
            updateDoc(doc, change, spans, estimateHeight(cm)), cm.options.lineWrapping || (doc.iter(checkWidthStart, from.line + change.text.length, function(line) {
                var len = lineLength(line);
                len > display.maxLineLength && (display.maxLine = line, display.maxLineLength = len, 
                display.maxLineChanged = !0, recomputeMaxLength = !1);
            }), recomputeMaxLength && (cm.curOp.updateMaxLine = !0));
            (function(doc, n) {
                if (doc.modeFrontier = Math.min(doc.modeFrontier, n), !(doc.highlightFrontier < n - 10)) {
                    for (var start = doc.first, line = n - 1; start < line; line--) {
                        var saved = getLine(doc, line).stateAfter;
                        if (saved && (!(saved instanceof SavedContext) || line + saved.lookAhead < n)) {
                            start = line + 1;
                            break;
                        }
                    }
                    doc.highlightFrontier = Math.min(doc.highlightFrontier, start);
                }
            })(doc, from.line), startWorker(cm, 400);
            spans = change.text.length - (to.line - from.line) - 1;
            change.full ? regChange(cm) : from.line != to.line || 1 != change.text.length || isWholeLineUpdate(cm.doc, change) ? regChange(cm, from.line, to.line + 1, spans) : regLineChange(cm, from.line, "text");
            checkWidthStart = hasHandler(cm, "changes"), doc = hasHandler(cm, "change");
            (doc || checkWidthStart) && (spans = {
                from: from,
                to: to,
                text: change.text,
                removed: change.removed,
                origin: change.origin
            }, doc && signalLater(cm, "change", cm, spans), checkWidthStart) && (cm.curOp.changeObjs || (cm.curOp.changeObjs = [])).push(spans);
            cm.display.selForContextMenu = null;
        }(doc.cm, change, spans) : updateDoc(doc, change, spans), setSelectionNoUndo(doc, selAfter, sel_dontScroll), 
        doc.cantEdit && skipAtomic(doc, Pos(doc.firstLine(), 0)) && (doc.cantEdit = !1));
    }
    function replaceRange(doc, code, from, to, origin) {
        var assign;
        cmp(to = to || from, from) < 0 && (from = (assign = [ to, from ])[0], to = assign[1]), 
        "string" == typeof code && (code = doc.splitLines(code)), makeChange(doc, {
            from: from,
            to: to,
            text: code,
            origin: origin
        });
    }
    function rebaseHistSelSingle(pos, from, to, diff) {
        to < pos.line ? pos.line += diff : from < pos.line && (pos.line = from, 
        pos.ch = 0);
    }
    function rebaseHistArray(array, from, to, diff) {
        for (var i = 0; i < array.length; ++i) {
            var sub = array[i], ok = !0;
            if (sub.ranges) {
                sub.copied || ((sub = array[i] = sub.deepCopy()).copied = !0);
                for (var j = 0; j < sub.ranges.length; j++) rebaseHistSelSingle(sub.ranges[j].anchor, from, to, diff), 
                rebaseHistSelSingle(sub.ranges[j].head, from, to, diff);
            } else {
                for (var j$1 = 0; j$1 < sub.changes.length; ++j$1) {
                    var cur = sub.changes[j$1];
                    if (to < cur.from.line) cur.from = Pos(cur.from.line + diff, cur.from.ch), 
                    cur.to = Pos(cur.to.line + diff, cur.to.ch); else if (from <= cur.to.line) {
                        ok = !1;
                        break;
                    }
                }
                ok || (array.splice(0, i + 1), i = 0);
            }
        }
    }
    function rebaseHist(hist, change) {
        var from = change.from.line, to = change.to.line, change = change.text.length - (to - from) - 1;
        rebaseHistArray(hist.done, from, to, change), rebaseHistArray(hist.undone, from, to, change);
    }
    function changeLine(doc, handle, changeType, op) {
        var no = handle, line = handle;
        return "number" == typeof handle ? line = getLine(doc, clipLine(doc, handle)) : no = lineNo(handle), 
        null == no ? null : (op(line, no) && doc.cm && regLineChange(doc.cm, no, changeType), 
        line);
    }
    function LeafChunk(lines) {
        this.lines = lines, this.parent = null;
        for (var height = 0, i = 0; i < lines.length; ++i) lines[i].parent = this, 
        height += lines[i].height;
        this.height = height;
    }
    function BranchChunk(children) {
        this.children = children;
        for (var size = 0, height = 0, i = 0; i < children.length; ++i) {
            var ch = children[i];
            size += ch.chunkSize(), height += ch.height, ch.parent = this;
        }
        this.size = size, this.height = height, this.parent = null;
    }
    Range.prototype.from = function() {
        return minPos(this.anchor, this.head);
    }, Range.prototype.to = function() {
        return maxPos(this.anchor, this.head);
    }, Range.prototype.empty = function() {
        return this.head.line == this.anchor.line && this.head.ch == this.anchor.ch;
    }, LeafChunk.prototype = {
        chunkSize: function() {
            return this.lines.length;
        },
        removeInner: function(at, n) {
            for (var i = at, e = at + n; i < e; ++i) {
                var line = this.lines[i];
                this.height -= line.height, !function(line) {
                    line.parent = null, detachMarkedSpans(line);
                }(line), signalLater(line, "delete");
            }
            this.lines.splice(at, n);
        },
        collapse: function(lines) {
            lines.push.apply(lines, this.lines);
        },
        insertInner: function(at, lines, height) {
            this.height += height, this.lines = this.lines.slice(0, at).concat(lines).concat(this.lines.slice(at));
            for (var i = 0; i < lines.length; ++i) lines[i].parent = this;
        },
        iterN: function(at, n, op) {
            for (var e = at + n; at < e; ++at) if (op(this.lines[at])) return !0;
        }
    }, BranchChunk.prototype = {
        chunkSize: function() {
            return this.size;
        },
        removeInner: function(at, n) {
            this.size -= n;
            for (var lines, i = 0; i < this.children.length; ++i) {
                var child = this.children[i], sz = child.chunkSize();
                if (at < sz) {
                    var rm = Math.min(n, sz - at), oldHeight = child.height;
                    if (child.removeInner(at, rm), this.height -= oldHeight - child.height, 
                    sz == rm && (this.children.splice(i--, 1), child.parent = null), 
                    0 == (n -= rm)) break;
                    at = 0;
                } else at -= sz;
            }
            this.size - n < 25 && (1 < this.children.length || !(this.children[0] instanceof LeafChunk)) && (this.collapse(lines = []), 
            this.children = [ new LeafChunk(lines) ], this.children[0].parent = this);
        },
        collapse: function(lines) {
            for (var i = 0; i < this.children.length; ++i) this.children[i].collapse(lines);
        },
        insertInner: function(at, lines, height) {
            this.size += lines.length, this.height += height;
            for (var i = 0; i < this.children.length; ++i) {
                var child = this.children[i], sz = child.chunkSize();
                if (at <= sz) {
                    if (child.insertInner(at, lines, height), child.lines && 50 < child.lines.length) {
                        for (var remaining = child.lines.length % 25 + 25, pos = remaining; pos < child.lines.length; ) {
                            var leaf = new LeafChunk(child.lines.slice(pos, pos += 25));
                            child.height -= leaf.height, this.children.splice(++i, 0, leaf), 
                            leaf.parent = this;
                        }
                        child.lines = child.lines.slice(0, remaining), this.maybeSpill();
                    }
                    break;
                }
                at -= sz;
            }
        },
        maybeSpill: function() {
            if (!(this.children.length <= 10)) {
                var me = this;
                do {
                    var myIndex, sibling = new BranchChunk(me.children.splice(me.children.length - 5, 5));
                } while (me.parent ? (me.size -= sibling.size, me.height -= sibling.height, 
                myIndex = indexOf(me.parent.children, me), me.parent.children.splice(myIndex + 1, 0, sibling)) : (((myIndex = new BranchChunk(me.children)).parent = me).children = [ myIndex, sibling ], 
                me = myIndex), sibling.parent = me.parent, 10 < me.children.length);
                me.parent.maybeSpill();
            }
        },
        iterN: function(at, n, op) {
            for (var i = 0; i < this.children.length; ++i) {
                var child = this.children[i], sz = child.chunkSize();
                if (at < sz) {
                    var used = Math.min(n, sz - at);
                    if (child.iterN(at, used, op)) return !0;
                    if (0 == (n -= used)) break;
                    at = 0;
                } else at -= sz;
            }
        }
    };
    function LineWidget(doc, node, options) {
        if (options) for (var opt in options) options.hasOwnProperty(opt) && (this[opt] = options[opt]);
        this.doc = doc, this.node = node;
    }
    function adjustScrollWhenAboveVisible(cm, line, diff) {
        heightAtLine(line) < (cm.curOp && cm.curOp.scrollTop || cm.doc.scrollTop) && addToScrollTop(cm, diff);
    }
    LineWidget.prototype.clear = function() {
        var cm = this.doc.cm, ws = this.line.widgets, line = this.line, no = lineNo(line);
        if (null != no && ws) {
            for (var i = 0; i < ws.length; ++i) ws[i] == this && ws.splice(i--, 1);
            ws.length || (line.widgets = null);
            var height = widgetHeight(this);
            updateLineHeight(line, Math.max(0, line.height - height)), cm && (runInOp(cm, function() {
                adjustScrollWhenAboveVisible(cm, line, -height), regLineChange(cm, no, "widget");
            }), signalLater(cm, "lineWidgetCleared", cm, this, no));
        }
    }, LineWidget.prototype.changed = function() {
        var this$1$1 = this, oldH = this.height, cm = this.doc.cm, line = this.line, diff = (this.height = null, 
        widgetHeight(this) - oldH);
        diff && (lineIsHidden(this.doc, line) || updateLineHeight(line, line.height + diff), 
        cm) && runInOp(cm, function() {
            cm.curOp.forceUpdate = !0, adjustScrollWhenAboveVisible(cm, line, diff), 
            signalLater(cm, "lineWidgetChanged", cm, this$1$1, lineNo(line));
        });
    }, eventMixin(LineWidget);
    function TextMarker(doc, type) {
        this.lines = [], this.type = type, this.doc = doc, this.id = ++nextMarkerId;
    }
    var nextMarkerId = 0;
    function markText(doc, from, to, options, type) {
        if (options && options.shared) return function(doc, from, to, options, type) {
            (options = copyObj(options)).shared = !1;
            var markers = [ markText(doc, from, to, options, type) ], primary = markers[0], widget = options.widgetNode;
            return linkedDocs(doc, function(doc) {
                widget && (options.widgetNode = widget.cloneNode(!0)), markers.push(markText(doc, clipPos(doc, from), clipPos(doc, to), options, type));
                for (var i = 0; i < doc.linked.length; ++i) if (doc.linked[i].isParent) return;
                primary = lst(markers);
            }), new SharedTextMarker(markers, primary);
        }(doc, from, to, options, type);
        if (doc.cm && !doc.cm.curOp) return operation(doc.cm, markText)(doc, from, to, options, type);
        var marker = new TextMarker(doc, type), type = cmp(from, to);
        if (options && copyObj(options, marker, !1), !(0 < type || 0 == type && !1 !== marker.clearWhenEmpty)) {
            if (marker.replacedWith && (marker.collapsed = !0, marker.widgetNode = eltP("span", [ marker.replacedWith ], "CodeMirror-widget"), 
            options.handleMouseEvents || marker.widgetNode.setAttribute("cm-ignore-events", "true"), 
            options.insertLeft) && (marker.widgetNode.insertLeft = !0), marker.collapsed) {
                if (conflictingCollapsedRange(doc, from.line, from, to, marker) || from.line != to.line && conflictingCollapsedRange(doc, to.line, from, to, marker)) throw new Error("Inserting collapsed marker partially overlapping an existing one");
                sawCollapsedSpans = !0;
            }
            marker.addToHistory && addChangeToHistory(doc, {
                from: from,
                to: to,
                origin: "markText"
            }, doc.sel, NaN);
            var updateMaxLine, curLine = from.line, cm = doc.cm;
            if (doc.iter(curLine, to.line + 1, function(line) {
                cm && marker.collapsed && !cm.options.lineWrapping && visualLine(line) == cm.display.maxLine && (updateMaxLine = !0), 
                marker.collapsed && curLine != from.line && updateLineHeight(line, 0), 
                function(line, span, op) {
                    (op = op && window.WeakSet && (op.markedSpans || (op.markedSpans = new WeakSet()))) && line.markedSpans && op.has(line.markedSpans) ? line.markedSpans.push(span) : (line.markedSpans = line.markedSpans ? line.markedSpans.concat([ span ]) : [ span ], 
                    op && op.add(line.markedSpans)), span.marker.attachLine(line);
                }(line, new MarkedSpan(marker, curLine == from.line ? from.ch : null, curLine == to.line ? to.ch : null), doc.cm && doc.cm.curOp), 
                ++curLine;
            }), marker.collapsed && doc.iter(from.line, to.line + 1, function(line) {
                lineIsHidden(doc, line) && updateLineHeight(line, 0);
            }), marker.clearOnEnter && on(marker, "beforeCursorEnter", function() {
                return marker.clear();
            }), marker.readOnly && (sawReadOnlySpans = !0, doc.history.done.length || doc.history.undone.length) && doc.clearHistory(), 
            marker.collapsed && (marker.id = ++nextMarkerId, marker.atomic = !0), 
            cm) {
                if (updateMaxLine && (cm.curOp.updateMaxLine = !0), marker.collapsed) regChange(cm, from.line, to.line + 1); else if (marker.className || marker.startStyle || marker.endStyle || marker.css || marker.attributes || marker.title) for (var i = from.line; i <= to.line; i++) regLineChange(cm, i, "text");
                marker.atomic && reCheckSelection(cm.doc), signalLater(cm, "markerAdded", cm, marker);
            }
        }
        return marker;
    }
    TextMarker.prototype.clear = function() {
        if (!this.explicitlyCleared) {
            for (var found, cm = this.doc.cm, withOp = cm && !cm.curOp, min = (withOp && startOperation(cm), 
            hasHandler(this, "clear") && (found = this.find()) && signalLater(this, "clear", found.from, found.to), 
            null), max = null, i = 0; i < this.lines.length; ++i) {
                var line = this.lines[i], span = getMarkedSpanFor(line.markedSpans, this);
                cm && !this.collapsed ? regLineChange(cm, lineNo(line), "text") : cm && (null != span.to && (max = lineNo(line)), 
                null != span.from) && (min = lineNo(line)), line.markedSpans = function(spans, span) {
                    for (var r, i = 0; i < spans.length; ++i) spans[i] != span && (r = r || []).push(spans[i]);
                    return r;
                }(line.markedSpans, span), null == span.from && this.collapsed && !lineIsHidden(this.doc, line) && cm && updateLineHeight(line, textHeight(cm.display));
            }
            if (cm && this.collapsed && !cm.options.lineWrapping) for (var i$1 = 0; i$1 < this.lines.length; ++i$1) {
                var visual = visualLine(this.lines[i$1]), len = lineLength(visual);
                len > cm.display.maxLineLength && (cm.display.maxLine = visual, 
                cm.display.maxLineLength = len, cm.display.maxLineChanged = !0);
            }
            null != min && cm && this.collapsed && regChange(cm, min, max + 1), 
            this.lines.length = 0, this.explicitlyCleared = !0, this.atomic && this.doc.cantEdit && (this.doc.cantEdit = !1, 
            cm) && reCheckSelection(cm.doc), cm && signalLater(cm, "markerCleared", cm, this, min, max), 
            withOp && endOperation(cm), this.parent && this.parent.clear();
        }
    }, TextMarker.prototype.find = function(side, lineObj) {
        var from, to;
        null == side && "bookmark" == this.type && (side = 1);
        for (var i = 0; i < this.lines.length; ++i) {
            var line = this.lines[i], span = getMarkedSpanFor(line.markedSpans, this);
            if (null != span.from && (from = Pos(lineObj ? line : lineNo(line), span.from), 
            -1 == side)) return from;
            if (null != span.to && (to = Pos(lineObj ? line : lineNo(line), span.to), 
            1 == side)) return to;
        }
        return from && {
            from: from,
            to: to
        };
    }, TextMarker.prototype.changed = function() {
        var this$1$1 = this, pos = this.find(-1, !0), widget = this, cm = this.doc.cm;
        pos && cm && runInOp(cm, function() {
            var line = pos.line, lineN = lineNo(pos.line), lineN = findViewForLine(cm, lineN);
            lineN && (clearLineMeasurementCacheFor(lineN), cm.curOp.selectionChanged = cm.curOp.forceUpdate = !0), 
            cm.curOp.updateMaxLine = !0, !lineIsHidden(widget.doc, line) && null != widget.height && (lineN = widget.height, 
            widget.height = null, lineN = widgetHeight(widget) - lineN) && updateLineHeight(line, line.height + lineN), 
            signalLater(cm, "markerChanged", cm, this$1$1);
        });
    }, TextMarker.prototype.attachLine = function(line) {
        var op;
        this.lines.length || !this.doc.cm || (op = this.doc.cm.curOp).maybeHiddenMarkers && -1 != indexOf(op.maybeHiddenMarkers, this) || (op.maybeUnhiddenMarkers || (op.maybeUnhiddenMarkers = [])).push(this), 
        this.lines.push(line);
    }, TextMarker.prototype.detachLine = function(line) {
        this.lines.splice(indexOf(this.lines, line), 1), !this.lines.length && this.doc.cm && ((line = this.doc.cm.curOp).maybeHiddenMarkers || (line.maybeHiddenMarkers = [])).push(this);
    }, eventMixin(TextMarker);
    var SharedTextMarker = function(markers, primary) {
        this.markers = markers, this.primary = primary;
        for (var i = 0; i < markers.length; ++i) markers[i].parent = this;
    };
    function findSharedMarkers(doc) {
        return doc.findMarks(Pos(doc.first, 0), doc.clipPos(Pos(doc.lastLine())), function(m) {
            return m.parent;
        });
    }
    function detachSharedMarkers(markers) {
        for (var i = 0; i < markers.length; i++) !function(i) {
            var marker = markers[i], linked = [ marker.primary.doc ];
            linkedDocs(marker.primary.doc, function(d) {
                return linked.push(d);
            });
            for (var j = 0; j < marker.markers.length; j++) {
                var subMarker = marker.markers[j];
                -1 == indexOf(linked, subMarker.doc) && (subMarker.parent = null, 
                marker.markers.splice(j--, 1));
            }
        }(i);
    }
    SharedTextMarker.prototype.clear = function() {
        if (!this.explicitlyCleared) {
            this.explicitlyCleared = !0;
            for (var i = 0; i < this.markers.length; ++i) this.markers[i].clear();
            signalLater(this, "clear");
        }
    }, SharedTextMarker.prototype.find = function(side, lineObj) {
        return this.primary.find(side, lineObj);
    }, eventMixin(SharedTextMarker);
    function Doc(text, mode, firstLine, lineSep, direction) {
        if (!(this instanceof Doc)) return new Doc(text, mode, firstLine, lineSep, direction);
        null == firstLine && (firstLine = 0), BranchChunk.call(this, [ new LeafChunk([ new Line("", null) ]) ]), 
        this.first = firstLine, this.scrollTop = this.scrollLeft = 0, this.cantEdit = !1, 
        this.cleanGeneration = 1, firstLine = Pos(this.modeFrontier = this.highlightFrontier = firstLine, 0), 
        this.sel = simpleSelection(firstLine), this.history = new History(null), 
        this.id = ++nextDocId, this.modeOption = mode, this.lineSep = lineSep, this.direction = "rtl" == direction ? "rtl" : "ltr", 
        this.extend = !1, "string" == typeof text && (text = this.splitLines(text)), 
        updateDoc(this, {
            from: firstLine,
            to: firstLine,
            text: text
        }), setSelection(this, simpleSelection(firstLine), sel_dontScroll);
    }
    var nextDocId = 0, lastDrop = ((Doc.prototype = createObj(BranchChunk.prototype, {
        constructor: Doc,
        iter: function(from, to, op) {
            op ? this.iterN(from - this.first, to - from, op) : this.iterN(this.first, this.first + this.size, from);
        },
        insert: function(at, lines) {
            for (var height = 0, i = 0; i < lines.length; ++i) height += lines[i].height;
            this.insertInner(at - this.first, lines, height);
        },
        remove: function(at, n) {
            this.removeInner(at - this.first, n);
        },
        getValue: function(lineSep) {
            var lines = getLines(this, this.first, this.first + this.size);
            return !1 === lineSep ? lines : lines.join(lineSep || this.lineSeparator());
        },
        setValue: docMethodOp(function(code) {
            var top = Pos(this.first, 0), last = this.first + this.size - 1;
            makeChange(this, {
                from: top,
                to: Pos(last, getLine(this, last).text.length),
                text: this.splitLines(code),
                origin: "setValue",
                full: !0
            }, !0), this.cm && scrollToCoords(this.cm, 0, 0), setSelection(this, simpleSelection(top), sel_dontScroll);
        }),
        replaceRange: function(code, from, to, origin) {
            replaceRange(this, code, from = clipPos(this, from), to = to ? clipPos(this, to) : from, origin);
        },
        getRange: function(from, to, lineSep) {
            from = getBetween(this, clipPos(this, from), clipPos(this, to));
            return !1 === lineSep ? from : "" === lineSep ? from.join("") : from.join(lineSep || this.lineSeparator());
        },
        getLine: function(line) {
            line = this.getLineHandle(line);
            return line && line.text;
        },
        getLineHandle: function(line) {
            if (isLine(this, line)) return getLine(this, line);
        },
        getLineNumber: lineNo,
        getLineHandleVisualStart: function(line) {
            return visualLine(line = "number" == typeof line ? getLine(this, line) : line);
        },
        lineCount: function() {
            return this.size;
        },
        firstLine: function() {
            return this.first;
        },
        lastLine: function() {
            return this.first + this.size - 1;
        },
        clipPos: function(pos) {
            return clipPos(this, pos);
        },
        getCursor: function(start) {
            var range = this.sel.primary(), start = null == start || "head" == start ? range.head : "anchor" == start ? range.anchor : "end" == start || "to" == start || !1 === start ? range.to() : range.from();
            return start;
        },
        listSelections: function() {
            return this.sel.ranges;
        },
        somethingSelected: function() {
            return this.sel.somethingSelected();
        },
        setCursor: docMethodOp(function(line, ch, options) {
            setSimpleSelection(this, clipPos(this, "number" == typeof line ? Pos(line, ch || 0) : line), null, options);
        }),
        setSelection: docMethodOp(function(anchor, head, options) {
            setSimpleSelection(this, clipPos(this, anchor), clipPos(this, head || anchor), options);
        }),
        extendSelection: docMethodOp(function(head, other, options) {
            extendSelection(this, clipPos(this, head), other && clipPos(this, other), options);
        }),
        extendSelections: docMethodOp(function(heads, options) {
            extendSelections(this, clipPosArray(this, heads), options);
        }),
        extendSelectionsBy: docMethodOp(function(f, options) {
            extendSelections(this, clipPosArray(this, map(this.sel.ranges, f)), options);
        }),
        setSelections: docMethodOp(function(ranges, primary, options) {
            if (ranges.length) {
                for (var out = [], i = 0; i < ranges.length; i++) out[i] = new Range(clipPos(this, ranges[i].anchor), clipPos(this, ranges[i].head || ranges[i].anchor));
                null == primary && (primary = Math.min(ranges.length - 1, this.sel.primIndex)), 
                setSelection(this, normalizeSelection(this.cm, out, primary), options);
            }
        }),
        addSelection: docMethodOp(function(anchor, head, options) {
            var ranges = this.sel.ranges.slice(0);
            ranges.push(new Range(clipPos(this, anchor), clipPos(this, head || anchor))), 
            setSelection(this, normalizeSelection(this.cm, ranges, ranges.length - 1), options);
        }),
        getSelection: function(lineSep) {
            for (var ranges = this.sel.ranges, i = 0; i < ranges.length; i++) var sel = getBetween(this, ranges[i].from(), ranges[i].to()), lines = lines ? lines.concat(sel) : sel;
            return !1 === lineSep ? lines : lines.join(lineSep || this.lineSeparator());
        },
        getSelections: function(lineSep) {
            for (var parts = [], ranges = this.sel.ranges, i = 0; i < ranges.length; i++) {
                var sel = getBetween(this, ranges[i].from(), ranges[i].to());
                !1 !== lineSep && (sel = sel.join(lineSep || this.lineSeparator())), 
                parts[i] = sel;
            }
            return parts;
        },
        replaceSelection: function(code, collapse, origin) {
            for (var dup = [], i = 0; i < this.sel.ranges.length; i++) dup[i] = code;
            this.replaceSelections(dup, collapse, origin || "+input");
        },
        replaceSelections: docMethodOp(function(code, collapse, origin) {
            for (var changes = [], sel = this.sel, i = 0; i < sel.ranges.length; i++) {
                var range = sel.ranges[i];
                changes[i] = {
                    from: range.from(),
                    to: range.to(),
                    text: this.splitLines(code[i]),
                    origin: origin
                };
            }
            for (var collapse = collapse && "end" != collapse && function(doc, changes, hint) {
                for (var out = [], newPrev = oldPrev = Pos(doc.first, 0), i = 0; i < changes.length; i++) {
                    var change = changes[i], from = offsetPos(change.from, oldPrev, newPrev), to = offsetPos(changeEnd(change), oldPrev, newPrev), oldPrev = change.to, newPrev = to;
                    "around" == hint ? (change = cmp((change = doc.sel.ranges[i]).head, change.anchor) < 0, 
                    out[i] = new Range(change ? to : from, change ? from : to)) : out[i] = new Range(from, from);
                }
                return new Selection(out, doc.sel.primIndex);
            }(this, changes, collapse), i$1 = changes.length - 1; 0 <= i$1; i$1--) makeChange(this, changes[i$1]);
            collapse ? setSelectionReplaceHistory(this, collapse) : this.cm && ensureCursorVisible(this.cm);
        }),
        undo: docMethodOp(function() {
            makeChangeFromHistory(this, "undo");
        }),
        redo: docMethodOp(function() {
            makeChangeFromHistory(this, "redo");
        }),
        undoSelection: docMethodOp(function() {
            makeChangeFromHistory(this, "undo", !0);
        }),
        redoSelection: docMethodOp(function() {
            makeChangeFromHistory(this, "redo", !0);
        }),
        setExtending: function(val) {
            this.extend = val;
        },
        getExtending: function() {
            return this.extend;
        },
        historySize: function() {
            for (var hist = this.history, done = 0, undone = 0, i = 0; i < hist.done.length; i++) hist.done[i].ranges || ++done;
            for (var i$1 = 0; i$1 < hist.undone.length; i$1++) hist.undone[i$1].ranges || ++undone;
            return {
                undo: done,
                redo: undone
            };
        },
        clearHistory: function() {
            var this$1$1 = this;
            this.history = new History(this.history), linkedDocs(this, function(doc) {
                return doc.history = this$1$1.history;
            }, !0);
        },
        markClean: function() {
            this.cleanGeneration = this.changeGeneration(!0);
        },
        changeGeneration: function(forceSplit) {
            return forceSplit && (this.history.lastOp = this.history.lastSelOp = this.history.lastOrigin = null), 
            this.history.generation;
        },
        isClean: function(gen) {
            return this.history.generation == (gen || this.cleanGeneration);
        },
        getHistory: function() {
            return {
                done: copyHistoryArray(this.history.done),
                undone: copyHistoryArray(this.history.undone)
            };
        },
        setHistory: function(histData) {
            var hist = this.history = new History(this.history);
            hist.done = copyHistoryArray(histData.done.slice(0), null, !0), hist.undone = copyHistoryArray(histData.undone.slice(0), null, !0);
        },
        setGutterMarker: docMethodOp(function(line, gutterID, value) {
            return changeLine(this, line, "gutter", function(line) {
                var markers = line.gutterMarkers || (line.gutterMarkers = {});
                return !(markers[gutterID] = value) && isEmpty(markers) && (line.gutterMarkers = null), 
                1;
            });
        }),
        clearGutter: docMethodOp(function(gutterID) {
            var this$1$1 = this;
            this.iter(function(line) {
                line.gutterMarkers && line.gutterMarkers[gutterID] && changeLine(this$1$1, line, "gutter", function() {
                    return line.gutterMarkers[gutterID] = null, isEmpty(line.gutterMarkers) && (line.gutterMarkers = null), 
                    1;
                });
            });
        }),
        lineInfo: function(line) {
            var n;
            if ("number" == typeof line) {
                if (!isLine(this, line)) return null;
                if (n = line, !(line = getLine(this, line))) return null;
            } else if (null == (n = lineNo(line))) return null;
            return {
                line: n,
                handle: line,
                text: line.text,
                gutterMarkers: line.gutterMarkers,
                textClass: line.textClass,
                bgClass: line.bgClass,
                wrapClass: line.wrapClass,
                widgets: line.widgets
            };
        },
        addLineClass: docMethodOp(function(handle, where, cls) {
            return changeLine(this, handle, "gutter" == where ? "gutter" : "class", function(line) {
                var prop = "text" == where ? "textClass" : "background" == where ? "bgClass" : "gutter" == where ? "gutterClass" : "wrapClass";
                if (line[prop]) {
                    if (classTest(cls).test(line[prop])) return;
                    line[prop] += " " + cls;
                } else line[prop] = cls;
                return 1;
            });
        }),
        removeLineClass: docMethodOp(function(handle, where, cls) {
            return changeLine(this, handle, "gutter" == where ? "gutter" : "class", function(line) {
                var prop = "text" == where ? "textClass" : "background" == where ? "bgClass" : "gutter" == where ? "gutterClass" : "wrapClass", cur = line[prop];
                if (cur) {
                    if (null == cls) line[prop] = null; else {
                        var found = cur.match(classTest(cls));
                        if (!found) return;
                        var end = found.index + found[0].length;
                        line[prop] = cur.slice(0, found.index) + (found.index && end != cur.length ? " " : "") + cur.slice(end) || null;
                    }
                    return 1;
                }
            });
        }),
        addLineWidget: docMethodOp(function(handle, node, options) {
            return function(doc, handle, node, options) {
                var widget = new LineWidget(doc, node, options), cm = doc.cm;
                return cm && widget.noHScroll && (cm.display.alignWidgets = !0), 
                changeLine(doc, handle, "widget", function(line) {
                    var widgets = line.widgets || (line.widgets = []);
                    return null == widget.insertAt ? widgets.push(widget) : widgets.splice(Math.min(widgets.length, Math.max(0, widget.insertAt)), 0, widget), 
                    widget.line = line, cm && !lineIsHidden(doc, line) && (widgets = heightAtLine(line) < doc.scrollTop, 
                    updateLineHeight(line, line.height + widgetHeight(widget)), 
                    widgets && addToScrollTop(cm, widget.height), cm.curOp.forceUpdate = !0), 
                    1;
                }), cm && signalLater(cm, "lineWidgetAdded", cm, widget, "number" == typeof handle ? handle : lineNo(handle)), 
                widget;
            }(this, handle, node, options);
        }),
        removeLineWidget: function(widget) {
            widget.clear();
        },
        markText: function(from, to, options) {
            return markText(this, clipPos(this, from), clipPos(this, to), options, options && options.type || "range");
        },
        setBookmark: function(pos, options) {
            options = {
                replacedWith: options && (null == options.nodeType ? options.widget : options),
                insertLeft: options && options.insertLeft,
                clearWhenEmpty: !1,
                shared: options && options.shared,
                handleMouseEvents: options && options.handleMouseEvents
            };
            return markText(this, pos = clipPos(this, pos), pos, options, "bookmark");
        },
        findMarksAt: function(pos) {
            var markers = [], spans = getLine(this, (pos = clipPos(this, pos)).line).markedSpans;
            if (spans) for (var i = 0; i < spans.length; ++i) {
                var span = spans[i];
                (null == span.from || span.from <= pos.ch) && (null == span.to || span.to >= pos.ch) && markers.push(span.marker.parent || span.marker);
            }
            return markers;
        },
        findMarks: function(from, to, filter) {
            from = clipPos(this, from), to = clipPos(this, to);
            var found = [], lineNo = from.line;
            return this.iter(from.line, to.line + 1, function(line) {
                var spans = line.markedSpans;
                if (spans) for (var i = 0; i < spans.length; i++) {
                    var span = spans[i];
                    null != span.to && lineNo == from.line && from.ch >= span.to || null == span.from && lineNo != from.line || null != span.from && lineNo == to.line && span.from >= to.ch || filter && !filter(span.marker) || found.push(span.marker.parent || span.marker);
                }
                ++lineNo;
            }), found;
        },
        getAllMarks: function() {
            var markers = [];
            return this.iter(function(line) {
                var sps = line.markedSpans;
                if (sps) for (var i = 0; i < sps.length; ++i) null != sps[i].from && markers.push(sps[i].marker);
            }), markers;
        },
        posFromIndex: function(off) {
            var ch, lineNo = this.first, sepSize = this.lineSeparator().length;
            return this.iter(function(line) {
                line = line.text.length + sepSize;
                if (off < line) return ch = off, !0;
                off -= line, ++lineNo;
            }), clipPos(this, Pos(lineNo, ch));
        },
        indexFromPos: function(coords) {
            var sepSize, index = (coords = clipPos(this, coords)).ch;
            return coords.line < this.first || coords.ch < 0 ? 0 : (sepSize = this.lineSeparator().length, 
            this.iter(this.first, coords.line, function(line) {
                index += line.text.length + sepSize;
            }), index);
        },
        copy: function(copyHistory) {
            var doc = new Doc(getLines(this, this.first, this.first + this.size), this.modeOption, this.first, this.lineSep, this.direction);
            return doc.scrollTop = this.scrollTop, doc.scrollLeft = this.scrollLeft, 
            doc.sel = this.sel, doc.extend = !1, copyHistory && (doc.history.undoDepth = this.history.undoDepth, 
            doc.setHistory(this.getHistory())), doc;
        },
        linkedDoc: function(options) {
            for (var from = this.first, to = this.first + this.size, to = (null != (options = options || {}).from && options.from > from && (from = options.from), 
            null != options.to && options.to < to && (to = options.to), new Doc(getLines(this, from, to), options.mode || this.modeOption, from, this.lineSep, this.direction)), doc = (options.sharedHist && (to.history = this.history), 
            (this.linked || (this.linked = [])).push({
                doc: to,
                sharedHist: options.sharedHist
            }), to.linked = [ {
                doc: this,
                isParent: !0,
                sharedHist: options.sharedHist
            } ], to), markers = findSharedMarkers(this), i = 0; i < markers.length; i++) {
                var marker = markers[i], pos = marker.find(), mFrom = doc.clipPos(pos.from), pos = doc.clipPos(pos.to);
                cmp(mFrom, pos) && (mFrom = markText(doc, mFrom, pos, marker.primary, marker.primary.type), 
                marker.markers.push(mFrom), mFrom.parent = marker);
            }
            return to;
        },
        unlinkDoc: function(other) {
            if (other instanceof CodeMirror && (other = other.doc), this.linked) for (var i = 0; i < this.linked.length; ++i) {
                var link = this.linked[i];
                if (link.doc == other) {
                    this.linked.splice(i, 1), other.unlinkDoc(this), detachSharedMarkers(findSharedMarkers(this));
                    break;
                }
            }
            var splitIds;
            other.history == this.history && (splitIds = [ other.id ], linkedDocs(other, function(doc) {
                return splitIds.push(doc.id);
            }, !0), other.history = new History(null), other.history.done = copyHistoryArray(this.history.done, splitIds), 
            other.history.undone = copyHistoryArray(this.history.undone, splitIds));
        },
        iterLinkedDocs: function(f) {
            linkedDocs(this, f);
        },
        getMode: function() {
            return this.mode;
        },
        getEditor: function() {
            return this.cm;
        },
        splitLines: function(str) {
            return this.lineSep ? str.split(this.lineSep) : splitLinesAuto(str);
        },
        lineSeparator: function() {
            return this.lineSep || "\n";
        },
        setDirection: docMethodOp(function(dir) {
            var cm;
            (dir = "rtl" != dir ? "ltr" : dir) != this.direction && (this.direction = dir, 
            this.iter(function(line) {
                return line.order = null;
            }), this.cm) && runInOp(cm = this.cm, function() {
                setDirectionClass(cm), regChange(cm);
            });
        })
    })).eachLine = Doc.prototype.iter, 0);
    function onDrop(e) {
        var cm = this;
        if (clearDragCursor(cm), !signalDOMEvent(cm, e) && !eventInWidget(cm.display, e)) {
            e_preventDefault(e), ie && (lastDrop = +new Date());
            var pos = posFromMouse(cm, e, !0), files = e.dataTransfer.files;
            if (pos && !cm.isReadOnly()) if (files && files.length && window.FileReader && window.File) for (var n = files.length, text = Array(n), read = 0, markAsReadAndPasteIfAllFilesAreRead = function() {
                ++read == n && operation(cm, function() {
                    var change = {
                        from: pos = clipPos(cm.doc, pos),
                        to: pos,
                        text: cm.doc.splitLines(text.filter(function(t) {
                            return null != t;
                        }).join(cm.doc.lineSeparator())),
                        origin: "paste"
                    };
                    makeChange(cm.doc, change), setSelectionReplaceHistory(cm.doc, simpleSelection(clipPos(cm.doc, pos), clipPos(cm.doc, changeEnd(change))));
                })();
            }, i = 0; i < files.length; i++) !function(file, i) {
                var reader;
                cm.options.allowDropFileTypes && -1 == indexOf(cm.options.allowDropFileTypes, file.type) ? markAsReadAndPasteIfAllFilesAreRead() : ((reader = new FileReader()).onerror = function() {
                    return markAsReadAndPasteIfAllFilesAreRead();
                }, reader.onload = function() {
                    var content = reader.result;
                    /[\x00-\x08\x0e-\x1f]{2}/.test(content) || (text[i] = content), 
                    markAsReadAndPasteIfAllFilesAreRead();
                }, reader.readAsText(file));
            }(files[i], i); else if (cm.state.draggingText && -1 < cm.doc.sel.contains(pos)) cm.state.draggingText(e), 
            setTimeout(function() {
                return cm.display.input.focus();
            }, 20); else try {
                var selected, text$1 = e.dataTransfer.getData("Text");
                if (text$1) {
                    if (cm.state.draggingText && !cm.state.draggingText.copy && (selected = cm.listSelections()), 
                    setSelectionNoUndo(cm.doc, simpleSelection(pos, pos)), selected) for (var i$1 = 0; i$1 < selected.length; ++i$1) replaceRange(cm.doc, "", selected[i$1].anchor, selected[i$1].head, "drag");
                    cm.replaceSelection(text$1, "around", "paste"), cm.display.input.focus();
                }
            } catch (e$1) {}
        }
    }
    function clearDragCursor(cm) {
        cm.display.dragCursor && (cm.display.lineSpace.removeChild(cm.display.dragCursor), 
        cm.display.dragCursor = null);
    }
    function forEachCodeMirror(f) {
        if (document.getElementsByClassName) {
            for (var byClass = document.getElementsByClassName("CodeMirror"), editors = [], i = 0; i < byClass.length; i++) {
                var cm = byClass[i].CodeMirror;
                cm && editors.push(cm);
            }
            editors.length && editors[0].operation(function() {
                for (var i = 0; i < editors.length; i++) f(editors[i]);
            });
        }
    }
    var globalsRegistered = !1;
    function ensureGlobalHandlers() {
        var resizeTimer;
        globalsRegistered || (on(window, "resize", function() {
            null == resizeTimer && (resizeTimer = setTimeout(function() {
                resizeTimer = null, forEachCodeMirror(onResize);
            }, 100));
        }), on(window, "blur", function() {
            return forEachCodeMirror(onBlur);
        }), globalsRegistered = !0);
    }
    function onResize(cm) {
        var d = cm.display;
        d.cachedCharWidth = d.cachedTextHeight = d.cachedPaddingH = null, d.scrollbarsClipped = !1, 
        cm.setSize();
    }
    for (var keyNames = {
        3: "Pause",
        8: "Backspace",
        9: "Tab",
        13: "Enter",
        16: "Shift",
        17: "Ctrl",
        18: "Alt",
        19: "Pause",
        20: "CapsLock",
        27: "Esc",
        32: "Space",
        33: "PageUp",
        34: "PageDown",
        35: "End",
        36: "Home",
        37: "Left",
        38: "Up",
        39: "Right",
        40: "Down",
        44: "PrintScrn",
        45: "Insert",
        46: "Delete",
        59: ";",
        61: "=",
        91: "Mod",
        92: "Mod",
        93: "Mod",
        106: "*",
        107: "=",
        109: "-",
        110: ".",
        111: "/",
        145: "ScrollLock",
        173: "-",
        186: ";",
        187: "=",
        188: ",",
        189: "-",
        190: ".",
        191: "/",
        192: "`",
        219: "[",
        220: "\\",
        221: "]",
        222: "'",
        224: "Mod",
        63232: "Up",
        63233: "Down",
        63234: "Left",
        63235: "Right",
        63272: "Delete",
        63273: "Home",
        63275: "End",
        63276: "PageUp",
        63277: "PageDown",
        63302: "Insert"
    }, i = 0; i < 10; i++) keyNames[i + 48] = keyNames[i + 96] = String(i);
    for (var i$1 = 65; i$1 <= 90; i$1++) keyNames[i$1] = String.fromCharCode(i$1);
    for (var i$2 = 1; i$2 <= 12; i$2++) keyNames[i$2 + 111] = keyNames[i$2 + 63235] = "F" + i$2;
    var keyMap = {};
    function normalizeKeyName(name) {
        var alt, ctrl, shift, cmd, parts = name.split(/-(?!$)/);
        name = parts[parts.length - 1];
        for (var i = 0; i < parts.length - 1; i++) {
            var mod = parts[i];
            if (/^(cmd|meta|m)$/i.test(mod)) cmd = !0; else if (/^a(lt)?$/i.test(mod)) alt = !0; else if (/^(c|ctrl|control)$/i.test(mod)) ctrl = !0; else {
                if (!/^s(hift)?$/i.test(mod)) throw new Error("Unrecognized modifier name: " + mod);
                shift = !0;
            }
        }
        return alt && (name = "Alt-" + name), ctrl && (name = "Ctrl-" + name), cmd && (name = "Cmd-" + name), 
        name = shift ? "Shift-" + name : name;
    }
    function normalizeKeyMap(keymap) {
        var keyname, prop, copy = {};
        for (keyname in keymap) if (keymap.hasOwnProperty(keyname)) {
            var value = keymap[keyname];
            if (!/^(name|fallthrough|(de|at)tach)$/.test(keyname)) {
                if ("..." != value) for (var keys = map(keyname.split(" "), normalizeKeyName), i = 0; i < keys.length; i++) {
                    var val = void 0, name = void 0, val = i == keys.length - 1 ? (name = keys.join(" "), 
                    value) : (name = keys.slice(0, i + 1).join(" "), "..."), prev = copy[name];
                    if (prev) {
                        if (prev != val) throw new Error("Inconsistent bindings for " + name);
                    } else copy[name] = val;
                }
                delete keymap[keyname];
            }
        }
        for (prop in copy) keymap[prop] = copy[prop];
        return keymap;
    }
    function lookupKey(key, map, handle, context) {
        var found = (map = getKeyMap(map)).call ? map.call(key, context) : map[key];
        if (!1 === found) return "nothing";
        if ("..." === found) return "multi";
        if (null != found && handle(found)) return "handled";
        if (map.fallthrough) {
            if ("[object Array]" != Object.prototype.toString.call(map.fallthrough)) return lookupKey(key, map.fallthrough, handle, context);
            for (var i = 0; i < map.fallthrough.length; i++) {
                var result = lookupKey(key, map.fallthrough[i], handle, context);
                if (result) return result;
            }
        }
    }
    function isModifierKey(value) {
        value = "string" == typeof value ? value : keyNames[value.keyCode];
        return "Ctrl" == value || "Alt" == value || "Shift" == value || "Mod" == value;
    }
    function addModifierNames(name, event, noShift) {
        var base = name;
        return event.altKey && "Alt" != base && (name = "Alt-" + name), (flipCtrlCmd ? event.metaKey : event.ctrlKey) && "Ctrl" != base && (name = "Ctrl-" + name), 
        (flipCtrlCmd ? event.ctrlKey : event.metaKey) && "Mod" != base && (name = "Cmd-" + name), 
        name = !noShift && event.shiftKey && "Shift" != base ? "Shift-" + name : name;
    }
    function keyName(event, noShift) {
        var name;
        return !(presto && 34 == event.keyCode && event.char || null == (name = keyNames[event.keyCode]) || event.altGraphKey) && addModifierNames(name = 3 == event.keyCode && event.code ? event.code : name, event, noShift);
    }
    function getKeyMap(val) {
        return "string" == typeof val ? keyMap[val] : val;
    }
    function deleteNearSelection(cm, compute) {
        for (var ranges = cm.doc.sel.ranges, kill = [], i = 0; i < ranges.length; i++) {
            for (var toKill = compute(ranges[i]); kill.length && cmp(toKill.from, lst(kill).to) <= 0; ) {
                var replaced = kill.pop();
                if (cmp(replaced.from, toKill.from) < 0) {
                    toKill.from = replaced.from;
                    break;
                }
            }
            kill.push(toKill);
        }
        runInOp(cm, function() {
            for (var i = kill.length - 1; 0 <= i; i--) replaceRange(cm.doc, "", kill[i].from, kill[i].to, "+delete");
            ensureCursorVisible(cm);
        });
    }
    function moveCharLogically(line, ch, dir) {
        ch = skipExtendingChars(line.text, ch + dir, dir);
        return ch < 0 || ch > line.text.length ? null : ch;
    }
    function moveLogically(line, start, dir) {
        line = moveCharLogically(line, start.ch, dir);
        return null == line ? null : new Pos(start.line, line, dir < 0 ? "after" : "before");
    }
    function endOfLine(visually, cm, lineObj, lineNo, dir) {
        if (visually) {
            "rtl" == cm.doc.direction && (dir = -dir);
            var sticky, prep, ch, targetTop, visually = getOrder(lineObj, cm.doc.direction);
            if (visually) return sticky = dir < 0 == (1 == (visually = dir < 0 ? lst(visually) : visually[0]).level) ? "after" : "before", 
            0 < visually.level || "rtl" == cm.doc.direction ? (prep = prepareMeasureForLine(cm, lineObj), 
            ch = dir < 0 ? lineObj.text.length - 1 : 0, targetTop = measureCharPrepared(cm, prep, ch).top, 
            ch = findFirst(function(ch) {
                return measureCharPrepared(cm, prep, ch).top == targetTop;
            }, dir < 0 == (1 == visually.level) ? visually.from : visually.to - 1, ch), 
            "before" == sticky && (ch = moveCharLogically(lineObj, ch, 1))) : ch = dir < 0 ? visually.to : visually.from, 
            new Pos(lineNo, ch, sticky);
        }
        return new Pos(lineNo, dir < 0 ? lineObj.text.length : 0, dir < 0 ? "before" : "after");
    }
    function moveVisually(cm, line, start, dir) {
        var bidi = getOrder(line, cm.doc.direction);
        if (!bidi) return moveLogically(line, start, dir);
        start.ch >= line.text.length ? (start.ch = line.text.length, start.sticky = "before") : start.ch <= 0 && (start.ch = 0, 
        start.sticky = "after");
        var partPos = getBidiPartAt(bidi, start.ch, start.sticky), part = bidi[partPos];
        if ("ltr" == cm.doc.direction && part.level % 2 == 0 && (0 < dir ? part.to > start.ch : part.from < start.ch)) return moveLogically(line, start, dir);
        function mv(pos, dir) {
            return moveCharLogically(line, pos instanceof Pos ? pos.ch : pos, dir);
        }
        function getWrappedLineExtent(ch) {
            return cm.options.lineWrapping ? (prep = prep || prepareMeasureForLine(cm, line), 
            wrappedLineExtentChar(cm, line, prep, ch)) : {
                begin: 0,
                end: line.text.length
            };
        }
        var prep, wrappedLineExtent = getWrappedLineExtent("before" == start.sticky ? mv(start, -1) : start.ch);
        if ("rtl" == cm.doc.direction || 1 == part.level) {
            var moveInStorageOrder = 1 == part.level == dir < 0, ch = mv(start, moveInStorageOrder ? 1 : -1);
            if (null != ch && (moveInStorageOrder ? ch <= part.to && ch <= wrappedLineExtent.end : ch >= part.from && ch >= wrappedLineExtent.begin)) return new Pos(start.line, ch, moveInStorageOrder ? "before" : "after");
        }
        function searchInVisualLine(partPos, dir, wrappedLineExtent) {
            for (var getRes = function(ch, moveInStorageOrder) {
                return moveInStorageOrder ? new Pos(start.line, mv(ch, 1), "before") : new Pos(start.line, ch, "after");
            }; 0 <= partPos && partPos < bidi.length; partPos += dir) {
                var part = bidi[partPos], moveInStorageOrder = 0 < dir == (1 != part.level), ch = moveInStorageOrder ? wrappedLineExtent.begin : mv(wrappedLineExtent.end, -1);
                if (part.from <= ch && ch < part.to) return getRes(ch, moveInStorageOrder);
                if (ch = moveInStorageOrder ? part.from : mv(part.to, -1), wrappedLineExtent.begin <= ch && ch < wrappedLineExtent.end) return getRes(ch, moveInStorageOrder);
            }
        }
        part = searchInVisualLine(partPos + dir, dir, wrappedLineExtent);
        return part || (null == (ch = 0 < dir ? wrappedLineExtent.end : mv(wrappedLineExtent.begin, -1)) || 0 < dir && ch == line.text.length || !(part = searchInVisualLine(0 < dir ? 0 : bidi.length - 1, dir, getWrappedLineExtent(ch))) ? null : part);
    }
    keyMap.basic = {
        Left: "goCharLeft",
        Right: "goCharRight",
        Up: "goLineUp",
        Down: "goLineDown",
        End: "goLineEnd",
        Home: "goLineStartSmart",
        PageUp: "goPageUp",
        PageDown: "goPageDown",
        Delete: "delCharAfter",
        Backspace: "delCharBefore",
        "Shift-Backspace": "delCharBefore",
        Tab: "defaultTab",
        "Shift-Tab": "indentAuto",
        Enter: "newlineAndIndent",
        Insert: "toggleOverwrite",
        Esc: "singleSelection"
    }, keyMap.pcDefault = {
        "Ctrl-A": "selectAll",
        "Ctrl-D": "deleteLine",
        "Ctrl-Z": "undo",
        "Shift-Ctrl-Z": "redo",
        "Ctrl-Y": "redo",
        "Ctrl-Home": "goDocStart",
        "Ctrl-End": "goDocEnd",
        "Ctrl-Up": "goLineUp",
        "Ctrl-Down": "goLineDown",
        "Ctrl-Left": "goGroupLeft",
        "Ctrl-Right": "goGroupRight",
        "Alt-Left": "goLineStart",
        "Alt-Right": "goLineEnd",
        "Ctrl-Backspace": "delGroupBefore",
        "Ctrl-Delete": "delGroupAfter",
        "Ctrl-S": "save",
        "Ctrl-F": "find",
        "Ctrl-G": "findNext",
        "Shift-Ctrl-G": "findPrev",
        "Shift-Ctrl-F": "replace",
        "Shift-Ctrl-R": "replaceAll",
        "Ctrl-[": "indentLess",
        "Ctrl-]": "indentMore",
        "Ctrl-U": "undoSelection",
        "Shift-Ctrl-U": "redoSelection",
        "Alt-U": "redoSelection",
        fallthrough: "basic"
    }, keyMap.emacsy = {
        "Ctrl-F": "goCharRight",
        "Ctrl-B": "goCharLeft",
        "Ctrl-P": "goLineUp",
        "Ctrl-N": "goLineDown",
        "Ctrl-A": "goLineStart",
        "Ctrl-E": "goLineEnd",
        "Ctrl-V": "goPageDown",
        "Shift-Ctrl-V": "goPageUp",
        "Ctrl-D": "delCharAfter",
        "Ctrl-H": "delCharBefore",
        "Alt-Backspace": "delWordBefore",
        "Ctrl-K": "killLine",
        "Ctrl-T": "transposeChars",
        "Ctrl-O": "openLine"
    }, keyMap.macDefault = {
        "Cmd-A": "selectAll",
        "Cmd-D": "deleteLine",
        "Cmd-Z": "undo",
        "Shift-Cmd-Z": "redo",
        "Cmd-Y": "redo",
        "Cmd-Home": "goDocStart",
        "Cmd-Up": "goDocStart",
        "Cmd-End": "goDocEnd",
        "Cmd-Down": "goDocEnd",
        "Alt-Left": "goGroupLeft",
        "Alt-Right": "goGroupRight",
        "Cmd-Left": "goLineLeft",
        "Cmd-Right": "goLineRight",
        "Alt-Backspace": "delGroupBefore",
        "Ctrl-Alt-Backspace": "delGroupAfter",
        "Alt-Delete": "delGroupAfter",
        "Cmd-S": "save",
        "Cmd-F": "find",
        "Cmd-G": "findNext",
        "Shift-Cmd-G": "findPrev",
        "Cmd-Alt-F": "replace",
        "Shift-Cmd-Alt-F": "replaceAll",
        "Cmd-[": "indentLess",
        "Cmd-]": "indentMore",
        "Cmd-Backspace": "delWrappedLineLeft",
        "Cmd-Delete": "delWrappedLineRight",
        "Cmd-U": "undoSelection",
        "Shift-Cmd-U": "redoSelection",
        "Ctrl-Up": "goDocStart",
        "Ctrl-Down": "goDocEnd",
        fallthrough: [ "basic", "emacsy" ]
    }, keyMap.default = mac ? keyMap.macDefault : keyMap.pcDefault;
    var commands = {
        selectAll: selectAll,
        singleSelection: function(cm) {
            return cm.setSelection(cm.getCursor("anchor"), cm.getCursor("head"), sel_dontScroll);
        },
        killLine: function(cm) {
            return deleteNearSelection(cm, function(range) {
                var len;
                return range.empty() ? (len = getLine(cm.doc, range.head.line).text.length, 
                range.head.ch == len && range.head.line < cm.lastLine() ? {
                    from: range.head,
                    to: Pos(range.head.line + 1, 0)
                } : {
                    from: range.head,
                    to: Pos(range.head.line, len)
                }) : {
                    from: range.from(),
                    to: range.to()
                };
            });
        },
        deleteLine: function(cm) {
            return deleteNearSelection(cm, function(range) {
                return {
                    from: Pos(range.from().line, 0),
                    to: clipPos(cm.doc, Pos(range.to().line + 1, 0))
                };
            });
        },
        delLineLeft: function(cm) {
            return deleteNearSelection(cm, function(range) {
                return {
                    from: Pos(range.from().line, 0),
                    to: range.from()
                };
            });
        },
        delWrappedLineLeft: function(cm) {
            return deleteNearSelection(cm, function(range) {
                var top = cm.charCoords(range.head, "div").top + 5;
                return {
                    from: cm.coordsChar({
                        left: 0,
                        top: top
                    }, "div"),
                    to: range.from()
                };
            });
        },
        delWrappedLineRight: function(cm) {
            return deleteNearSelection(cm, function(range) {
                var top = cm.charCoords(range.head, "div").top + 5, top = cm.coordsChar({
                    left: cm.display.lineDiv.offsetWidth + 100,
                    top: top
                }, "div");
                return {
                    from: range.from(),
                    to: top
                };
            });
        },
        undo: function(cm) {
            return cm.undo();
        },
        redo: function(cm) {
            return cm.redo();
        },
        undoSelection: function(cm) {
            return cm.undoSelection();
        },
        redoSelection: function(cm) {
            return cm.redoSelection();
        },
        goDocStart: function(cm) {
            return cm.extendSelection(Pos(cm.firstLine(), 0));
        },
        goDocEnd: function(cm) {
            return cm.extendSelection(Pos(cm.lastLine()));
        },
        goLineStart: function(cm) {
            return cm.extendSelectionsBy(function(range) {
                return lineStart(cm, range.head.line);
            }, {
                origin: "+move",
                bias: 1
            });
        },
        goLineStartSmart: function(cm) {
            return cm.extendSelectionsBy(function(range) {
                return lineStartSmart(cm, range.head);
            }, {
                origin: "+move",
                bias: 1
            });
        },
        goLineEnd: function(cm) {
            return cm.extendSelectionsBy(function(range) {
                return function(cm, lineN) {
                    var line = getLine(cm.doc, lineN), visual = function(line) {
                        for (var merged; merged = collapsedSpanAtEnd(line); ) line = merged.find(1, !0).line;
                        return line;
                    }(line);
                    visual != line && (lineN = lineNo(visual));
                    return endOfLine(!0, cm, line, lineN, -1);
                }(cm, range.head.line);
            }, {
                origin: "+move",
                bias: -1
            });
        },
        goLineRight: function(cm) {
            return cm.extendSelectionsBy(function(range) {
                range = cm.cursorCoords(range.head, "div").top + 5;
                return cm.coordsChar({
                    left: cm.display.lineDiv.offsetWidth + 100,
                    top: range
                }, "div");
            }, sel_move);
        },
        goLineLeft: function(cm) {
            return cm.extendSelectionsBy(function(range) {
                range = cm.cursorCoords(range.head, "div").top + 5;
                return cm.coordsChar({
                    left: 0,
                    top: range
                }, "div");
            }, sel_move);
        },
        goLineLeftSmart: function(cm) {
            return cm.extendSelectionsBy(function(range) {
                var top = cm.cursorCoords(range.head, "div").top + 5, top = cm.coordsChar({
                    left: 0,
                    top: top
                }, "div");
                return top.ch < cm.getLine(top.line).search(/\S/) ? lineStartSmart(cm, range.head) : top;
            }, sel_move);
        },
        goLineUp: function(cm) {
            return cm.moveV(-1, "line");
        },
        goLineDown: function(cm) {
            return cm.moveV(1, "line");
        },
        goPageUp: function(cm) {
            return cm.moveV(-1, "page");
        },
        goPageDown: function(cm) {
            return cm.moveV(1, "page");
        },
        goCharLeft: function(cm) {
            return cm.moveH(-1, "char");
        },
        goCharRight: function(cm) {
            return cm.moveH(1, "char");
        },
        goColumnLeft: function(cm) {
            return cm.moveH(-1, "column");
        },
        goColumnRight: function(cm) {
            return cm.moveH(1, "column");
        },
        goWordLeft: function(cm) {
            return cm.moveH(-1, "word");
        },
        goGroupRight: function(cm) {
            return cm.moveH(1, "group");
        },
        goGroupLeft: function(cm) {
            return cm.moveH(-1, "group");
        },
        goWordRight: function(cm) {
            return cm.moveH(1, "word");
        },
        delCharBefore: function(cm) {
            return cm.deleteH(-1, "codepoint");
        },
        delCharAfter: function(cm) {
            return cm.deleteH(1, "char");
        },
        delWordBefore: function(cm) {
            return cm.deleteH(-1, "word");
        },
        delWordAfter: function(cm) {
            return cm.deleteH(1, "word");
        },
        delGroupBefore: function(cm) {
            return cm.deleteH(-1, "group");
        },
        delGroupAfter: function(cm) {
            return cm.deleteH(1, "group");
        },
        indentAuto: function(cm) {
            return cm.indentSelection("smart");
        },
        indentMore: function(cm) {
            return cm.indentSelection("add");
        },
        indentLess: function(cm) {
            return cm.indentSelection("subtract");
        },
        insertTab: function(cm) {
            return cm.replaceSelection("\t");
        },
        insertSoftTab: function(cm) {
            for (var spaces = [], ranges = cm.listSelections(), tabSize = cm.options.tabSize, i = 0; i < ranges.length; i++) {
                var pos = ranges[i].from(), pos = countColumn(cm.getLine(pos.line), pos.ch, tabSize);
                spaces.push(spaceStr(tabSize - pos % tabSize));
            }
            cm.replaceSelections(spaces);
        },
        defaultTab: function(cm) {
            cm.somethingSelected() ? cm.indentSelection("add") : cm.execCommand("insertTab");
        },
        transposeChars: function(cm) {
            return runInOp(cm, function() {
                for (var cur, line, prev, ranges = cm.listSelections(), newSel = [], i = 0; i < ranges.length; i++) ranges[i].empty() && (cur = ranges[i].head, 
                (line = getLine(cm.doc, cur.line).text) && (0 < (cur = cur.ch == line.length ? new Pos(cur.line, cur.ch - 1) : cur).ch ? (cur = new Pos(cur.line, cur.ch + 1), 
                cm.replaceRange(line.charAt(cur.ch - 1) + line.charAt(cur.ch - 2), Pos(cur.line, cur.ch - 2), cur, "+transpose")) : cur.line > cm.doc.first && (prev = getLine(cm.doc, cur.line - 1).text) && (cur = new Pos(cur.line, 1), 
                cm.replaceRange(line.charAt(0) + cm.doc.lineSeparator() + prev.charAt(prev.length - 1), Pos(cur.line - 1, prev.length - 1), cur, "+transpose"))), 
                newSel.push(new Range(cur, cur)));
                cm.setSelections(newSel);
            });
        },
        newlineAndIndent: function(cm) {
            return runInOp(cm, function() {
                for (var i = (sels = cm.listSelections()).length - 1; 0 <= i; i--) cm.replaceRange(cm.doc.lineSeparator(), sels[i].anchor, sels[i].head, "+input");
                for (var sels = cm.listSelections(), i$1 = 0; i$1 < sels.length; i$1++) cm.indentLine(sels[i$1].from().line, null, !0);
                ensureCursorVisible(cm);
            });
        },
        openLine: function(cm) {
            return cm.replaceSelection("\n", "start");
        },
        toggleOverwrite: function(cm) {
            return cm.toggleOverwrite();
        }
    };
    function lineStart(cm, lineN) {
        var line = getLine(cm.doc, lineN), visual = visualLine(line);
        return endOfLine(!0, cm, visual, lineN = visual != line ? lineNo(visual) : lineN, 1);
    }
    function lineStartSmart(cm, pos) {
        var start = lineStart(cm, pos.line), line = getLine(cm.doc, start.line), cm = getOrder(line, cm.doc.direction);
        return cm && 0 != cm[0].level ? start : (cm = Math.max(start.ch, line.text.search(/\S/)), 
        line = pos.line == start.line && pos.ch <= cm && pos.ch, Pos(start.line, line ? 0 : cm, start.sticky));
    }
    function doHandleBinding(cm, bound, dropShift) {
        if ("string" == typeof bound && !(bound = commands[bound])) return !1;
        cm.display.input.ensurePolled();
        var prevShift = cm.display.shift, done = !1;
        try {
            cm.isReadOnly() && (cm.state.suppressEdits = !0), dropShift && (cm.display.shift = !1), 
            done = bound(cm) != Pass;
        } finally {
            cm.display.shift = prevShift, cm.state.suppressEdits = !1;
        }
        return done;
    }
    var stopSeq = new Delayed();
    function dispatchKey(cm, name, e, handle) {
        var seq = cm.state.keySeq;
        if (seq) {
            if (isModifierKey(name)) return "handled";
            if (/\'$/.test(name) ? cm.state.keySeq = null : stopSeq.set(50, function() {
                cm.state.keySeq == seq && (cm.state.keySeq = null, cm.display.input.reset());
            }), dispatchKeyInner(cm, seq + " " + name, e, handle)) return !0;
        }
        return dispatchKeyInner(cm, name, e, handle);
    }
    function dispatchKeyInner(cm, name, e, handle) {
        handle = function(cm, name, handle) {
            for (var i = 0; i < cm.state.keyMaps.length; i++) {
                var result = lookupKey(name, cm.state.keyMaps[i], handle, cm);
                if (result) return result;
            }
            return cm.options.extraKeys && lookupKey(name, cm.options.extraKeys, handle, cm) || lookupKey(name, cm.options.keyMap, handle, cm);
        }(cm, name, handle);
        return "multi" == handle && (cm.state.keySeq = name), "handled" == handle && signalLater(cm, "keyHandled", cm, name, e), 
        "handled" != handle && "multi" != handle || (e_preventDefault(e), restartBlink(cm)), 
        !!handle;
    }
    function handleKeyBinding(cm, e) {
        var name = keyName(e, !0);
        return !!name && (e.shiftKey && !cm.state.keySeq ? dispatchKey(cm, "Shift-" + name, e, function(b) {
            return doHandleBinding(cm, b, !0);
        }) || dispatchKey(cm, name, e, function(b) {
            if ("string" == typeof b ? /^go[A-Z]/.test(b) : b.motion) return doHandleBinding(cm, b);
        }) : dispatchKey(cm, name, e, function(b) {
            return doHandleBinding(cm, b);
        }));
    }
    var lastStoppedKey = null;
    function onKeyDown(e) {
        var code, handled, cm = this;
        e.target && e.target != cm.display.input.getField() || (cm.curOp.focus = activeElt(), 
        signalDOMEvent(cm, e)) || (ie && ie_version < 11 && 27 == e.keyCode && (e.returnValue = !1), 
        code = e.keyCode, cm.display.shift = 16 == code || e.shiftKey, handled = handleKeyBinding(cm, e), 
        presto && (lastStoppedKey = handled ? code : null, !handled) && 88 == code && !hasCopyEvent && (mac ? e.metaKey : e.ctrlKey) && cm.replaceSelection("", null, "cut"), 
        gecko && !mac && !handled && 46 == code && e.shiftKey && !e.ctrlKey && document.execCommand && document.execCommand("cut"), 
        18 != code) || /\bCodeMirror-crosshair\b/.test(cm.display.lineDiv.className) || !function(cm) {
            var lineDiv = cm.display.lineDiv;
            function up(e) {
                18 != e.keyCode && e.altKey || (rmClass(lineDiv, "CodeMirror-crosshair"), 
                off(document, "keyup", up), off(document, "mouseover", up));
            }
            addClass(lineDiv, "CodeMirror-crosshair"), on(document, "keyup", up), 
            on(document, "mouseover", up);
        }(cm);
    }
    function onKeyUp(e) {
        16 == e.keyCode && (this.doc.sel.shift = !1), signalDOMEvent(this, e);
    }
    function onKeyPress(e) {
        var charCode, keyCode, cm = this;
        e.target && e.target != cm.display.input.getField() || eventInWidget(cm.display, e) || signalDOMEvent(cm, e) || e.ctrlKey && !e.altKey || mac && e.metaKey || (keyCode = e.keyCode, 
        charCode = e.charCode, presto && keyCode == lastStoppedKey ? (lastStoppedKey = null, 
        e_preventDefault(e)) : presto && (!e.which || e.which < 10) && handleKeyBinding(cm, e) || "\b" == (keyCode = String.fromCharCode(null == charCode ? keyCode : charCode)) || function(cm, e, ch) {
            return dispatchKey(cm, "'" + ch + "'", e, function(b) {
                return doHandleBinding(cm, b, !0);
            });
        }(cm, e, keyCode) || cm.display.input.onKeyPress(e));
    }
    function PastClick(time, pos, button) {
        this.time = time, this.pos = pos, this.button = button;
    }
    var lastClick, lastDoubleClick;
    function onMouseDown(e) {
        var pos, button, repeat, cm = this, display = cm.display;
        signalDOMEvent(cm, e) || display.activeTouch && display.input.supportsTouch() || (display.input.ensurePolled(), 
        display.shift = e.shiftKey, eventInWidget(display, e) ? webkit || (display.scroller.draggable = !1, 
        setTimeout(function() {
            return display.scroller.draggable = !0;
        }, 100)) : clickInGutter(cm, e) || (pos = posFromMouse(cm, e), button = e_button(e), 
        repeat = pos ? function(pos, button) {
            var now = +new Date();
            return lastDoubleClick && lastDoubleClick.compare(now, pos, button) ? (lastClick = lastDoubleClick = null, 
            "triple") : lastClick && lastClick.compare(now, pos, button) ? (lastDoubleClick = new PastClick(now, pos, button), 
            lastClick = null, "double") : (lastClick = new PastClick(now, pos, button), 
            lastDoubleClick = null, "single");
        }(pos, button) : "single", window.focus(), 1 == button && cm.state.selectingText && cm.state.selectingText(e), 
        pos && function(cm, button, pos, repeat, event) {
            var name = "Click";
            "double" == repeat ? name = "Double" + name : "triple" == repeat && (name = "Triple" + name);
            return dispatchKey(cm, addModifierNames(name = (1 == button ? "Left" : 2 == button ? "Middle" : "Right") + name, event), event, function(bound) {
                if (!(bound = "string" == typeof bound ? commands[bound] : bound)) return !1;
                var done = !1;
                try {
                    cm.isReadOnly() && (cm.state.suppressEdits = !0), done = bound(cm, pos) != Pass;
                } finally {
                    cm.state.suppressEdits = !1;
                }
                return done;
            });
        }(cm, button, pos, repeat, e)) || (1 == button ? pos ? function(cm, pos, repeat, event) {
            ie ? setTimeout(bind(ensureFocus, cm), 0) : cm.curOp.focus = activeElt();
            var behavior = function(cm, repeat, event) {
                var option = cm.getOption("configureMouse"), option = option ? option(cm, repeat, event) : {};
                {
                    var rect;
                    null == option.unit && (rect = chromeOS ? event.shiftKey && event.metaKey : event.altKey, 
                    option.unit = rect ? "rectangle" : "single" == repeat ? "char" : "double" == repeat ? "word" : "line");
                }
                null != option.extend && !cm.doc.extend || (option.extend = cm.doc.extend || event.shiftKey);
                null == option.addNew && (option.addNew = mac ? event.metaKey : event.ctrlKey);
                null == option.moveOnDrag && (option.moveOnDrag = !(mac ? event.altKey : event.ctrlKey));
                return option;
            }(cm, repeat, event), sel = cm.doc.sel;
            (cm.options.dragDrop && dragAndDrop && !cm.isReadOnly() && "single" == repeat && -1 < (repeat = sel.contains(pos)) && (cmp((repeat = sel.ranges[repeat]).from(), pos) < 0 || 0 < pos.xRel) && (0 < cmp(repeat.to(), pos) || pos.xRel < 0) ? function(cm, event, pos, behavior) {
                var display = cm.display, moved = !1, dragEnd = operation(cm, function(e) {
                    webkit && (display.scroller.draggable = !1), cm.state.draggingText = !1, 
                    cm.state.delayingBlurEvent && (cm.hasFocus() ? cm.state.delayingBlurEvent = !1 : delayBlurEvent(cm)), 
                    off(display.wrapper.ownerDocument, "mouseup", dragEnd), off(display.wrapper.ownerDocument, "mousemove", mouseMove), 
                    off(display.scroller, "dragstart", dragStart), off(display.scroller, "drop", dragEnd), 
                    moved || (e_preventDefault(e), behavior.addNew || extendSelection(cm.doc, pos, null, null, behavior.extend), 
                    webkit && !safari || ie && 9 == ie_version ? setTimeout(function() {
                        display.wrapper.ownerDocument.body.focus({
                            preventScroll: !0
                        }), display.input.focus();
                    }, 20) : display.input.focus());
                }), mouseMove = function(e2) {
                    moved = moved || 10 <= Math.abs(event.clientX - e2.clientX) + Math.abs(event.clientY - e2.clientY);
                }, dragStart = function() {
                    return moved = !0;
                };
                webkit && (display.scroller.draggable = !0);
                (cm.state.draggingText = dragEnd).copy = !behavior.moveOnDrag, on(display.wrapper.ownerDocument, "mouseup", dragEnd), 
                on(display.wrapper.ownerDocument, "mousemove", mouseMove), on(display.scroller, "dragstart", dragStart), 
                on(display.scroller, "drop", dragEnd), cm.state.delayingBlurEvent = !0, 
                setTimeout(function() {
                    return display.input.focus();
                }, 20), display.scroller.dragDrop && display.scroller.dragDrop();
            } : function(cm, event, start, behavior) {
                ie && delayBlurEvent(cm);
                var display = cm.display, doc = cm.doc;
                e_preventDefault(event);
                var ourRange, ourIndex, startSel = doc.sel, ranges = startSel.ranges;
                behavior.addNew && !behavior.extend ? (ourIndex = doc.sel.contains(start), 
                ourRange = -1 < ourIndex ? ranges[ourIndex] : new Range(start, start)) : (ourRange = doc.sel.primary(), 
                ourIndex = doc.sel.primIndex);
                "rectangle" == behavior.unit ? (behavior.addNew || (ourRange = new Range(start, start)), 
                start = posFromMouse(cm, event, !0, !0), ourIndex = -1) : (event = rangeForUnit(cm, start, behavior.unit), 
                ourRange = behavior.extend ? extendRange(ourRange, event.anchor, event.head, behavior.extend) : event);
                behavior.addNew ? -1 == ourIndex ? (ourIndex = ranges.length, setSelection(doc, normalizeSelection(cm, ranges.concat([ ourRange ]), ourIndex), {
                    scroll: !1,
                    origin: "*mouse"
                })) : 1 < ranges.length && ranges[ourIndex].empty() && "char" == behavior.unit && !behavior.extend ? (setSelection(doc, normalizeSelection(cm, ranges.slice(0, ourIndex).concat(ranges.slice(ourIndex + 1)), 0), {
                    scroll: !1,
                    origin: "*mouse"
                }), startSel = doc.sel) : replaceOneSelection(doc, ourIndex, ourRange, sel_mouse) : (setSelection(doc, new Selection([ ourRange ], ourIndex = 0), sel_mouse), 
                startSel = doc.sel);
                var lastPos = start;
                function extendTo(pos) {
                    if (0 != cmp(lastPos, pos)) if (lastPos = pos, "rectangle" == behavior.unit) {
                        for (var ranges = [], tabSize = cm.options.tabSize, startCol = countColumn(getLine(doc, start.line).text, start.ch, tabSize), posCol = countColumn(getLine(doc, pos.line).text, pos.ch, tabSize), left = Math.min(startCol, posCol), right = Math.max(startCol, posCol), line = Math.min(start.line, pos.line), end = Math.min(cm.lastLine(), Math.max(start.line, pos.line)); line <= end; line++) {
                            var text = getLine(doc, line).text, leftPos = findColumn(text, left, tabSize);
                            left == right ? ranges.push(new Range(Pos(line, leftPos), Pos(line, leftPos))) : text.length > leftPos && ranges.push(new Range(Pos(line, leftPos), Pos(line, findColumn(text, right, tabSize))));
                        }
                        ranges.length || ranges.push(new Range(start, start)), setSelection(doc, normalizeSelection(cm, startSel.ranges.slice(0, ourIndex).concat(ranges), ourIndex), {
                            origin: "*mouse",
                            scroll: !1
                        }), cm.scrollIntoView(pos);
                    } else {
                        var head, startCol = ourRange, posCol = rangeForUnit(cm, pos, behavior.unit), pos = startCol.anchor, pos = 0 < cmp(posCol.anchor, pos) ? (head = posCol.head, 
                        minPos(startCol.from(), posCol.anchor)) : (head = posCol.anchor, 
                        maxPos(startCol.to(), posCol.head)), startCol = startSel.ranges.slice(0);
                        startCol[ourIndex] = function(cm, range) {
                            var anchor = range.anchor, head = range.head, anchorLine = getLine(cm.doc, anchor.line);
                            if (0 == cmp(anchor, head) && anchor.sticky == head.sticky) return range;
                            anchorLine = getOrder(anchorLine);
                            if (!anchorLine) return range;
                            var index = getBidiPartAt(anchorLine, anchor.ch, anchor.sticky), part = anchorLine[index];
                            if (part.from != anchor.ch && part.to != anchor.ch) return range;
                            var boundary = index + (part.from == anchor.ch == (1 != part.level) ? 0 : 1);
                            if (0 == boundary || boundary == anchorLine.length) return range;
                            part = head.line != anchor.line ? 0 < (head.line - anchor.line) * ("ltr" == cm.doc.direction ? 1 : -1) : (cm = getBidiPartAt(anchorLine, head.ch, head.sticky), 
                            index = cm - index || (head.ch - anchor.ch) * (1 == part.level ? -1 : 1), 
                            cm == boundary - 1 || cm == boundary ? index < 0 : 0 < index);
                            cm = anchorLine[boundary + (part ? -1 : 0)], index = part == (1 == cm.level), 
                            anchorLine = index ? cm.from : cm.to, boundary = index ? "after" : "before";
                            return anchor.ch == anchorLine && anchor.sticky == boundary ? range : new Range(new Pos(anchor.line, anchorLine, boundary), head);
                        }(cm, new Range(clipPos(doc, pos), head)), setSelection(doc, normalizeSelection(cm, startCol, ourIndex), sel_mouse);
                    }
                }
                var editorSize = display.wrapper.getBoundingClientRect(), counter = 0;
                function done(e) {
                    cm.state.selectingText = !1, counter = 1 / 0, e && (e_preventDefault(e), 
                    display.input.focus()), off(display.wrapper.ownerDocument, "mousemove", move), 
                    off(display.wrapper.ownerDocument, "mouseup", up), doc.history.lastSelOrigin = null;
                }
                var move = operation(cm, function(e) {
                    (0 !== e.buttons && e_button(e) ? function extend(e) {
                        var visible, outside, curCount = ++counter, cur = posFromMouse(cm, e, !0, "rectangle" == behavior.unit);
                        cur && (0 != cmp(cur, lastPos) ? (cm.curOp.focus = activeElt(), 
                        extendTo(cur), visible = visibleLines(display, doc), (cur.line >= visible.to || cur.line < visible.from) && setTimeout(operation(cm, function() {
                            counter == curCount && extend(e);
                        }), 150)) : (outside = e.clientY < editorSize.top ? -20 : e.clientY > editorSize.bottom ? 20 : 0) && setTimeout(operation(cm, function() {
                            counter == curCount && (display.scroller.scrollTop += outside, 
                            extend(e));
                        }), 50));
                    } : done)(e);
                }), up = operation(cm, done);
                cm.state.selectingText = up, on(display.wrapper.ownerDocument, "mousemove", move), 
                on(display.wrapper.ownerDocument, "mouseup", up);
            })(cm, event, pos, behavior);
        }(cm, pos, repeat, e) : e_target(e) == display.scroller && e_preventDefault(e) : 2 == button ? (pos && extendSelection(cm.doc, pos), 
        setTimeout(function() {
            return display.input.focus();
        }, 20)) : 3 == button && (captureRightClick ? cm.display.input.onContextMenu(e) : delayBlurEvent(cm))));
    }
    function rangeForUnit(cm, pos, unit) {
        return "char" == unit ? new Range(pos, pos) : "word" == unit ? cm.findWordAt(pos) : "line" == unit ? new Range(Pos(pos.line, 0), clipPos(cm.doc, Pos(pos.line + 1, 0))) : (unit = unit(cm, pos), 
        new Range(unit.from, unit.to));
    }
    function gutterEvent(cm, e, type, prevent) {
        var mX, mY;
        if (e.touches) mX = e.touches[0].clientX, mY = e.touches[0].clientY; else try {
            mX = e.clientX, mY = e.clientY;
        } catch (e$1) {
            return !1;
        }
        if (mX >= Math.floor(cm.display.gutters.getBoundingClientRect().right)) return !1;
        prevent && e_preventDefault(e);
        var display = cm.display, prevent = display.lineDiv.getBoundingClientRect();
        if (mY > prevent.bottom || !hasHandler(cm, type)) return e_defaultPrevented(e);
        mY -= prevent.top - display.viewOffset;
        for (var i = 0; i < cm.display.gutterSpecs.length; ++i) {
            var g = display.gutters.childNodes[i];
            if (g && g.getBoundingClientRect().right >= mX) return signal(cm, type, cm, lineAtHeight(cm.doc, mY), cm.display.gutterSpecs[i].className, e), 
            e_defaultPrevented(e);
        }
    }
    function clickInGutter(cm, e) {
        return gutterEvent(cm, e, "gutterClick", !0);
    }
    function onContextMenu(cm, e) {
        eventInWidget(cm.display, e) || function(cm, e) {
            return hasHandler(cm, "gutterContextMenu") && gutterEvent(cm, e, "gutterContextMenu", !1);
        }(cm, e) || signalDOMEvent(cm, e, "contextmenu") || captureRightClick || cm.display.input.onContextMenu(e);
    }
    function themeChanged(cm) {
        cm.display.wrapper.className = cm.display.wrapper.className.replace(/\s*cm-s-\S+/g, "") + cm.options.theme.replace(/(^|\s)\s*/g, " cm-s-"), 
        clearCaches(cm);
    }
    PastClick.prototype.compare = function(time, pos, button) {
        return this.time + 400 > time && 0 == cmp(pos, this.pos) && button == this.button;
    };
    var Init = {
        toString: function() {
            return "CodeMirror.Init";
        }
    }, defaults = {}, optionHandlers = {};
    function dragDropChanged(cm, value, old) {
        !value != !(old && old != Init) && (old = cm.display.dragFunctions, (value = value ? on : off)(cm.display.scroller, "dragstart", old.start), 
        value(cm.display.scroller, "dragenter", old.enter), value(cm.display.scroller, "dragover", old.over), 
        value(cm.display.scroller, "dragleave", old.leave), value(cm.display.scroller, "drop", old.drop));
    }
    function wrappingChanged(cm) {
        cm.options.lineWrapping ? (addClass(cm.display.wrapper, "CodeMirror-wrap"), 
        cm.display.sizer.style.minWidth = "", cm.display.sizerWidth = null) : (rmClass(cm.display.wrapper, "CodeMirror-wrap"), 
        findMaxLine(cm)), estimateLineHeights(cm), regChange(cm), clearCaches(cm), 
        setTimeout(function() {
            return updateScrollbars(cm);
        }, 100);
    }
    function CodeMirror(place, options) {
        var this$1$1 = this;
        if (!(this instanceof CodeMirror)) return new CodeMirror(place, options);
        this.options = options = options ? copyObj(options) : {}, copyObj(defaults, options, !1);
        var opt, doc = options.value, input = ("string" == typeof doc ? doc = new Doc(doc, options.mode, null, options.lineSeparator, options.direction) : options.mode && (doc.modeOption = options.mode), 
        this.doc = doc, new CodeMirror.inputStyles[options.inputStyle](this)), place = this.display = new Display(place, doc, input, options), cm = (themeChanged(place.wrapper.CodeMirror = this), 
        options.lineWrapping && (this.display.wrapper.className += " CodeMirror-wrap"), 
        initScrollbars(this), this.state = {
            keyMaps: [],
            overlays: [],
            modeGen: 0,
            overwrite: !1,
            delayingBlurEvent: !1,
            focused: !1,
            suppressEdits: !1,
            pasteIncoming: -1,
            cutIncoming: -1,
            selectingText: !1,
            draggingText: !1,
            highlight: new Delayed(),
            keySeq: null,
            specialChars: null
        }, options.autofocus && !mobile && place.input.focus(), ie && ie_version < 11 && setTimeout(function() {
            return this$1$1.display.input.reset(!0);
        }, 20), this), d = cm.display;
        on(d.scroller, "mousedown", operation(cm, onMouseDown)), on(d.scroller, "dblclick", ie && ie_version < 11 ? operation(cm, function(e) {
            var pos;
            signalDOMEvent(cm, e) || !(pos = posFromMouse(cm, e)) || clickInGutter(cm, e) || eventInWidget(cm.display, e) || (e_preventDefault(e), 
            e = cm.findWordAt(pos), extendSelection(cm.doc, e.anchor, e.head));
        }) : function(e) {
            return signalDOMEvent(cm, e) || e_preventDefault(e);
        }), on(d.scroller, "contextmenu", function(e) {
            return onContextMenu(cm, e);
        }), on(d.input.getField(), "contextmenu", function(e) {
            d.scroller.contains(e.target) || onContextMenu(cm, e);
        });
        var touchFinished, prevTouch = {
            end: 0
        };
        function finishTouch() {
            d.activeTouch && (touchFinished = setTimeout(function() {
                return d.activeTouch = null;
            }, 1e3), (prevTouch = d.activeTouch).end = +new Date());
        }
        function farAway(touch, other) {
            var dx;
            return null == other.left || 400 < (dx = other.left - touch.left) * dx + (dx = other.top - touch.top) * dx;
        }
        on(d.scroller, "touchstart", function(e) {
            var now;
            signalDOMEvent(cm, e) || function(e) {
                if (1 == e.touches.length) return (e = e.touches[0]).radiusX <= 1 && e.radiusY <= 1;
            }(e) || clickInGutter(cm, e) || (d.input.ensurePolled(), clearTimeout(touchFinished), 
            now = +new Date(), d.activeTouch = {
                start: now,
                moved: !1,
                prev: now - prevTouch.end <= 300 ? prevTouch : null
            }, 1 == e.touches.length && (d.activeTouch.left = e.touches[0].pageX, 
            d.activeTouch.top = e.touches[0].pageY));
        }), on(d.scroller, "touchmove", function() {
            d.activeTouch && (d.activeTouch.moved = !0);
        }), on(d.scroller, "touchend", function(e) {
            var pos, touch = d.activeTouch;
            touch && !eventInWidget(d, e) && null != touch.left && !touch.moved && new Date() - touch.start < 300 && (pos = cm.coordsChar(d.activeTouch, "page"), 
            touch = !touch.prev || farAway(touch, touch.prev) ? new Range(pos, pos) : !touch.prev.prev || farAway(touch, touch.prev.prev) ? cm.findWordAt(pos) : new Range(Pos(pos.line, 0), clipPos(cm.doc, Pos(pos.line + 1, 0))), 
            cm.setSelection(touch.anchor, touch.head), cm.focus(), e_preventDefault(e)), 
            finishTouch();
        }), on(d.scroller, "touchcancel", finishTouch), on(d.scroller, "scroll", function() {
            d.scroller.clientHeight && (updateScrollTop(cm, d.scroller.scrollTop), 
            setScrollLeft(cm, d.scroller.scrollLeft, !0), signal(cm, "scroll", cm));
        }), on(d.scroller, "mousewheel", function(e) {
            return onScrollWheel(cm, e);
        }), on(d.scroller, "DOMMouseScroll", function(e) {
            return onScrollWheel(cm, e);
        }), on(d.wrapper, "scroll", function() {
            return d.wrapper.scrollTop = d.wrapper.scrollLeft = 0;
        }), d.dragFunctions = {
            enter: function(e) {
                signalDOMEvent(cm, e) || e_stop(e);
            },
            over: function(e) {
                signalDOMEvent(cm, e) || (!function(cm, e) {
                    (e = posFromMouse(cm, e)) && (drawSelectionCursor(cm, e, e = document.createDocumentFragment()), 
                    cm.display.dragCursor || (cm.display.dragCursor = elt("div", null, "CodeMirror-cursors CodeMirror-dragcursors"), 
                    cm.display.lineSpace.insertBefore(cm.display.dragCursor, cm.display.cursorDiv)), 
                    removeChildrenAndAdd(cm.display.dragCursor, e));
                }(cm, e), e_stop(e));
            },
            start: function(e) {
                return function(cm, e) {
                    var img;
                    ie && (!cm.state.draggingText || +new Date() - lastDrop < 100) ? e_stop(e) : signalDOMEvent(cm, e) || eventInWidget(cm.display, e) || (e.dataTransfer.setData("Text", cm.getSelection()), 
                    e.dataTransfer.effectAllowed = "copyMove", e.dataTransfer.setDragImage && !safari && ((img = elt("img", null, null, "position: fixed; left: 0; top: 0;")).src = "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==", 
                    presto && (img.width = img.height = 1, cm.display.wrapper.appendChild(img), 
                    img._top = img.offsetTop), e.dataTransfer.setDragImage(img, 0, 0), 
                    presto) && img.parentNode.removeChild(img));
                }(cm, e);
            },
            drop: operation(cm, onDrop),
            leave: function(e) {
                signalDOMEvent(cm, e) || clearDragCursor(cm);
            }
        };
        input = d.input.getField();
        for (opt in on(input, "keyup", function(e) {
            return onKeyUp.call(cm, e);
        }), on(input, "keydown", operation(cm, onKeyDown)), on(input, "keypress", operation(cm, onKeyPress)), 
        on(input, "focus", function(e) {
            return onFocus(cm, e);
        }), on(input, "blur", function(e) {
            return onBlur(cm, e);
        }), ensureGlobalHandlers(), startOperation(this), this.curOp.forceUpdate = !0, 
        attachDoc(this, doc), options.autofocus && !mobile || this.hasFocus() ? setTimeout(function() {
            this$1$1.hasFocus() && !this$1$1.state.focused && onFocus(this$1$1);
        }, 20) : onBlur(this), optionHandlers) optionHandlers.hasOwnProperty(opt) && optionHandlers[opt](this, options[opt], Init);
        maybeUpdateLineNumberWidth(this), options.finishInit && options.finishInit(this);
        for (var i = 0; i < initHooks.length; ++i) initHooks[i](this);
        endOperation(this), webkit && options.lineWrapping && "optimizelegibility" == getComputedStyle(place.lineDiv).textRendering && (place.lineDiv.style.textRendering = "auto");
    }
    CodeMirror.defaults = defaults, CodeMirror.optionHandlers = optionHandlers;
    var initHooks = [];
    function indentLine(cm, n, how, aggressive) {
        var state, doc = cm.doc, tabSize = ("smart" == (how = null == how ? "add" : how) && (doc.mode.indent ? state = getContextBefore(cm, n).state : how = "prev"), 
        cm.options.tabSize), line = getLine(doc, n), curSpace = countColumn(line.text, null, tabSize), curSpaceString = (line.stateAfter && (line.stateAfter = null), 
        line.text.match(/^\s*/)[0]);
        if (aggressive || /\S/.test(line.text)) {
            if ("smart" == how && ((indentation = doc.mode.indent(state, line.text.slice(curSpaceString.length), line.text)) == Pass || 150 < indentation)) {
                if (!aggressive) return;
                how = "prev";
            }
        } else indentation = 0, how = "not";
        "prev" == how ? indentation = n > doc.first ? countColumn(getLine(doc, n - 1).text, null, tabSize) : 0 : "add" == how ? indentation = curSpace + cm.options.indentUnit : "subtract" == how ? indentation = curSpace - cm.options.indentUnit : "number" == typeof how && (indentation = curSpace + how);
        var indentation = Math.max(0, indentation), indentString = "", pos = 0;
        if (cm.options.indentWithTabs) for (var i = Math.floor(indentation / tabSize); i; --i) pos += tabSize, 
        indentString += "\t";
        if (pos < indentation && (indentString += spaceStr(indentation - pos)), 
        indentString != curSpaceString) return replaceRange(doc, indentString, Pos(n, 0), Pos(n, curSpaceString.length), "+input"), 
        !(line.stateAfter = null);
        for (var i$1 = 0; i$1 < doc.sel.ranges.length; i$1++) {
            var range = doc.sel.ranges[i$1];
            if (range.head.line == n && range.head.ch < curSpaceString.length) {
                range = Pos(n, curSpaceString.length);
                replaceOneSelection(doc, i$1, new Range(range, range));
                break;
            }
        }
    }
    CodeMirror.defineInitHook = function(f) {
        return initHooks.push(f);
    };
    var lastCopied = null;
    function setLastCopied(newLastCopied) {
        lastCopied = newLastCopied;
    }
    function applyTextInput(cm, inserted, deleted, sel, origin) {
        var doc = cm.doc, recent = (cm.display.shift = !1, sel = sel || doc.sel, 
        +new Date() - 200), paste = "paste" == origin || cm.state.pasteIncoming > recent, textLines = splitLinesAuto(inserted), multiPaste = null;
        if (paste && 1 < sel.ranges.length) if (lastCopied && lastCopied.text.join("\n") == inserted) {
            if (sel.ranges.length % lastCopied.text.length == 0) for (var multiPaste = [], i = 0; i < lastCopied.text.length; i++) multiPaste.push(doc.splitLines(lastCopied.text[i]));
        } else textLines.length == sel.ranges.length && cm.options.pasteLinesPerSelection && (multiPaste = map(textLines, function(l) {
            return [ l ];
        }));
        for (var updateInput = cm.curOp.updateInput, i$1 = sel.ranges.length - 1; 0 <= i$1; i$1--) {
            var range = sel.ranges[i$1], from = range.from(), to = range.to(), range = (range.empty() && (deleted && 0 < deleted ? from = Pos(from.line, from.ch - deleted) : cm.state.overwrite && !paste ? to = Pos(to.line, Math.min(getLine(doc, to.line).text.length, to.ch + lst(textLines).length)) : paste && lastCopied && lastCopied.lineWise && lastCopied.text.join("\n") == textLines.join("\n") && (from = to = Pos(from.line, 0))), 
            {
                from: from,
                to: to,
                text: multiPaste ? multiPaste[i$1 % multiPaste.length] : textLines,
                origin: origin || (paste ? "paste" : cm.state.cutIncoming > recent ? "cut" : "+input")
            });
            makeChange(cm.doc, range), signalLater(cm, "inputRead", cm, range);
        }
        inserted && !paste && triggerElectric(cm, inserted), ensureCursorVisible(cm), 
        cm.curOp.updateInput < 2 && (cm.curOp.updateInput = updateInput), cm.curOp.typing = !0, 
        cm.state.pasteIncoming = cm.state.cutIncoming = -1;
    }
    function handlePaste(e, cm) {
        var pasted = e.clipboardData && e.clipboardData.getData("Text");
        return pasted && (e.preventDefault(), cm.isReadOnly() || cm.options.disableInput || !cm.hasFocus() || runInOp(cm, function() {
            return applyTextInput(cm, pasted, 0, null, "paste");
        }), 1);
    }
    function triggerElectric(cm, inserted) {
        if (cm.options.electricChars && cm.options.smartIndent) for (var sel = cm.doc.sel, i = sel.ranges.length - 1; 0 <= i; i--) {
            var range = sel.ranges[i];
            if (!(100 < range.head.ch || i && sel.ranges[i - 1].head.line == range.head.line)) {
                var mode = cm.getModeAt(range.head), indented = !1;
                if (mode.electricChars) {
                    for (var j = 0; j < mode.electricChars.length; j++) if (-1 < inserted.indexOf(mode.electricChars.charAt(j))) {
                        indented = indentLine(cm, range.head.line, "smart");
                        break;
                    }
                } else mode.electricInput && mode.electricInput.test(getLine(cm.doc, range.head.line).text.slice(0, range.head.ch)) && (indented = indentLine(cm, range.head.line, "smart"));
                indented && signalLater(cm, "electricInput", cm, range.head.line);
            }
        }
    }
    function copyableRanges(cm) {
        for (var text = [], ranges = [], i = 0; i < cm.doc.sel.ranges.length; i++) {
            var line = cm.doc.sel.ranges[i].head.line, line = {
                anchor: Pos(line, 0),
                head: Pos(line + 1, 0)
            };
            ranges.push(line), text.push(cm.getRange(line.anchor, line.head));
        }
        return {
            text: text,
            ranges: ranges
        };
    }
    function disableBrowserMagic(field, spellcheck, autocorrect, autocapitalize) {
        field.setAttribute("autocorrect", autocorrect ? "" : "off"), field.setAttribute("autocapitalize", autocapitalize ? "" : "off"), 
        field.setAttribute("spellcheck", !!spellcheck);
    }
    function hiddenTextarea() {
        var te = elt("textarea", null, null, "position: absolute; bottom: -1em; padding: 0; width: 1px; height: 1em; min-height: 1em; outline: none"), div = elt("div", [ te ], null, "overflow: hidden; position: relative; width: 3px; height: 0px;");
        return webkit ? te.style.width = "1000px" : te.setAttribute("wrap", "off"), 
        ios && (te.style.border = "1px solid black"), disableBrowserMagic(te), div;
    }
    function findPosH(doc, pos, dir, unit, visually) {
        var oldPos = pos, origDir = dir, lineObj = getLine(doc, pos.line), lineDir = visually && "rtl" == doc.direction ? -dir : dir;
        function moveOnce(boundToLine) {
            var ch;
            if (null == (ch = "codepoint" == unit ? (ch = lineObj.text.charCodeAt(pos.ch + (0 < dir ? 0 : -1)), 
            isNaN(ch) ? null : (ch = 0 < dir ? 55296 <= ch && ch < 56320 : 56320 <= ch && ch < 57343, 
            new Pos(pos.line, Math.max(0, Math.min(lineObj.text.length, pos.ch + dir * (ch ? 2 : 1))), -dir))) : visually ? moveVisually(doc.cm, lineObj, pos, dir) : moveLogically(lineObj, pos, dir))) {
                if (boundToLine || (boundToLine = pos.line + lineDir) < doc.first || boundToLine >= doc.first + doc.size || (pos = new Pos(boundToLine, pos.ch, pos.sticky), 
                !(lineObj = getLine(doc, boundToLine)))) return;
                pos = endOfLine(visually, doc.cm, lineObj, pos.line, lineDir);
            } else pos = ch;
            return 1;
        }
        if ("char" == unit || "codepoint" == unit) moveOnce(); else if ("column" == unit) moveOnce(!0); else if ("word" == unit || "group" == unit) for (var sawType = null, group = "group" == unit, helper = doc.cm && doc.cm.getHelper(pos, "wordChars"), first = !0; !(dir < 0) || moveOnce(!first); first = !1) {
            var cur = lineObj.text.charAt(pos.ch) || "\n", cur = isWordChar(cur, helper) ? "w" : group && "\n" == cur ? "n" : !group || /\s/.test(cur) ? null : "p";
            if (group && !first && (cur = cur || "s"), sawType && sawType != cur) {
                dir < 0 && (dir = 1, moveOnce(), pos.sticky = "after");
                break;
            }
            if (cur && (sawType = cur), 0 < dir && !moveOnce(!first)) break;
        }
        origDir = skipAtomic(doc, pos, oldPos, origDir, !0);
        return equalCursorPos(oldPos, origDir) && (origDir.hitSide = !0), origDir;
    }
    function findPosV(cm, pos, dir, unit) {
        var pageSize, y, target, doc = cm.doc, x = pos.left;
        for ("page" == unit ? (pageSize = Math.min(cm.display.wrapper.clientHeight, window.innerHeight || document.documentElement.clientHeight), 
        pageSize = Math.max(pageSize - .5 * textHeight(cm.display), 3), y = (0 < dir ? pos.bottom : pos.top) + dir * pageSize) : "line" == unit && (y = 0 < dir ? pos.bottom + 3 : pos.top - 3); (target = coordsChar(cm, x, y)).outside; ) {
            if (dir < 0 ? y <= 0 : y >= doc.height) {
                target.hitSide = !0;
                break;
            }
            y += 5 * dir;
        }
        return target;
    }
    function ContentEditableInput(cm) {
        this.cm = cm, this.lastAnchorNode = this.lastAnchorOffset = this.lastFocusNode = this.lastFocusOffset = null, 
        this.polling = new Delayed(), this.composing = null, this.gracePeriod = !1, 
        this.readDOMTimeout = null;
    }
    function posToDOM(cm, pos) {
        var info, side, view = findViewForLine(cm, pos.line);
        return !view || view.hidden ? null : (info = mapFromLineView(view, view = getLine(cm.doc, pos.line), pos.line), 
        side = "left", (view = getOrder(view, cm.doc.direction)) && (side = getBidiPartAt(view, pos.ch) % 2 ? "right" : "left"), 
        (cm = nodeAndOffsetInLineMap(info.map, pos.ch, side)).offset = "right" == cm.collapse ? cm.end : cm.start, 
        cm);
    }
    function badPos(pos, bad) {
        return bad && (pos.bad = !0), pos;
    }
    function domToPos(cm, node, offset) {
        var lineNode;
        if (node == cm.display.lineDiv) {
            if (!(lineNode = cm.display.lineDiv.childNodes[offset])) return badPos(cm.clipPos(Pos(cm.display.viewTo - 1)), !0);
            node = null, offset = 0;
        } else for (lineNode = node; ;lineNode = lineNode.parentNode) {
            if (!lineNode || lineNode == cm.display.lineDiv) return null;
            if (lineNode.parentNode && lineNode.parentNode == cm.display.lineDiv) break;
        }
        for (var i = 0; i < cm.display.view.length; i++) {
            var lineView = cm.display.view[i];
            if (lineView.node == lineNode) return function(lineView, node, offset) {
                var wrapper = lineView.text.firstChild, bad = !1;
                if (!node || !contains(wrapper, node)) return badPos(Pos(lineNo(lineView.line), 0), !0);
                if (node == wrapper) if (bad = !0, node = wrapper.childNodes[offset], 
                offset = 0, !node) return badPos(Pos(lineNo(line = lineView.rest ? lst(lineView.rest) : lineView.line), line.text.length), bad);
                var line = 3 == node.nodeType ? node : null, topNode = node;
                line || 1 != node.childNodes.length || 3 != node.firstChild.nodeType || (line = node.firstChild, 
                offset = offset && line.nodeValue.length);
                for (;topNode.parentNode != wrapper; ) topNode = topNode.parentNode;
                var measure = lineView.measure, maps = measure.maps;
                function find(textNode, topNode, offset) {
                    for (var i = -1; i < (maps ? maps.length : 0); i++) for (var map = i < 0 ? measure.map : maps[i], j = 0; j < map.length; j += 3) {
                        var line, ch, curNode = map[j + 2];
                        if (curNode == textNode || curNode == topNode) return line = lineNo(i < 0 ? lineView.line : lineView.rest[i]), 
                        ch = map[j] + offset, Pos(line, ch = offset < 0 || curNode != textNode ? map[j + (offset ? 1 : 0)] : ch);
                    }
                }
                var found = find(line, topNode, offset);
                if (found) return badPos(found, bad);
                for (var after = topNode.nextSibling, dist = line ? line.nodeValue.length - offset : 0; after; after = after.nextSibling) {
                    if (found = find(after, after.firstChild, 0)) return badPos(Pos(found.line, found.ch - dist), bad);
                    dist += after.textContent.length;
                }
                for (var before = topNode.previousSibling, dist$1 = offset; before; before = before.previousSibling) {
                    if (found = find(before, before.firstChild, -1)) return badPos(Pos(found.line, found.ch + dist$1), bad);
                    dist$1 += before.textContent.length;
                }
            }(lineView, node, offset);
        }
    }
    ContentEditableInput.prototype.init = function(display) {
        var this$1$1 = this, input = this, cm = input.cm, div = input.div = display.lineDiv;
        function belongsToInput(e) {
            for (var t = e.target; t; t = t.parentNode) {
                if (t == div) return 1;
                if (/\bCodeMirror-(?:line)?widget\b/.test(t.className)) break;
            }
        }
        function onCopyCut(e) {
            if (belongsToInput(e) && !signalDOMEvent(cm, e)) {
                if (cm.somethingSelected()) setLastCopied({
                    lineWise: !1,
                    text: cm.getSelections()
                }), "cut" == e.type && cm.replaceSelection("", null, "cut"); else {
                    if (!cm.options.lineWiseCopyCut) return;
                    var ranges = copyableRanges(cm);
                    setLastCopied({
                        lineWise: !0,
                        text: ranges.text
                    }), "cut" == e.type && cm.operation(function() {
                        cm.setSelections(ranges.ranges, 0, sel_dontScroll), cm.replaceSelection("", null, "cut");
                    });
                }
                if (e.clipboardData) {
                    e.clipboardData.clearData();
                    var content = lastCopied.text.join("\n");
                    if (e.clipboardData.setData("Text", content), e.clipboardData.getData("Text") == content) return void e.preventDefault();
                }
                var kludge = hiddenTextarea(), content = kludge.firstChild, hadFocus = (cm.display.lineSpace.insertBefore(kludge, cm.display.lineSpace.firstChild), 
                content.value = lastCopied.text.join("\n"), activeElt());
                selectInput(content), setTimeout(function() {
                    cm.display.lineSpace.removeChild(kludge), hadFocus.focus(), 
                    hadFocus == div && input.showPrimarySelection();
                }, 50);
            }
        }
        div.contentEditable = !0, disableBrowserMagic(div, cm.options.spellcheck, cm.options.autocorrect, cm.options.autocapitalize), 
        on(div, "paste", function(e) {
            !belongsToInput(e) || signalDOMEvent(cm, e) || handlePaste(e, cm) || ie_version <= 11 && setTimeout(operation(cm, function() {
                return this$1$1.updateFromDOM();
            }), 20);
        }), on(div, "compositionstart", function(e) {
            this$1$1.composing = {
                data: e.data,
                done: !1
            };
        }), on(div, "compositionupdate", function(e) {
            this$1$1.composing || (this$1$1.composing = {
                data: e.data,
                done: !1
            });
        }), on(div, "compositionend", function(e) {
            this$1$1.composing && (e.data != this$1$1.composing.data && this$1$1.readFromDOMSoon(), 
            this$1$1.composing.done = !0);
        }), on(div, "touchstart", function() {
            return input.forceCompositionEnd();
        }), on(div, "input", function() {
            this$1$1.composing || this$1$1.readFromDOMSoon();
        }), on(div, "copy", onCopyCut), on(div, "cut", onCopyCut);
    }, ContentEditableInput.prototype.screenReaderLabelChanged = function(label) {
        label ? this.div.setAttribute("aria-label", label) : this.div.removeAttribute("aria-label");
    }, ContentEditableInput.prototype.prepareSelection = function() {
        var result = prepareSelection(this.cm, !1);
        return result.focus = activeElt() == this.div, result;
    }, ContentEditableInput.prototype.showSelection = function(info, takeFocus) {
        info && this.cm.display.view.length && ((info.focus || takeFocus) && this.showPrimarySelection(), 
        this.showMultipleSelections(info));
    }, ContentEditableInput.prototype.getSelection = function() {
        return this.cm.display.wrapper.ownerDocument.getSelection();
    }, ContentEditableInput.prototype.showPrimarySelection = function() {
        var sel = this.getSelection(), cm = this.cm, prim = cm.doc.sel.primary(), from = prim.from(), prim = prim.to();
        if (cm.display.viewTo == cm.display.viewFrom || from.line >= cm.display.viewTo || prim.line < cm.display.viewFrom) sel.removeAllRanges(); else {
            var curAnchor = domToPos(cm, sel.anchorNode, sel.anchorOffset), curFocus = domToPos(cm, sel.focusNode, sel.focusOffset);
            if (!curAnchor || curAnchor.bad || !curFocus || curFocus.bad || 0 != cmp(minPos(curAnchor, curFocus), from) || 0 != cmp(maxPos(curAnchor, curFocus), prim)) {
                var curAnchor = cm.display.view, curFocus = from.line >= cm.display.viewFrom && posToDOM(cm, from) || {
                    node: curAnchor[0].measure.map[2],
                    offset: 0
                }, from = prim.line < cm.display.viewTo && posToDOM(cm, prim);
                if (from || (from = {
                    node: (curAnchor = (prim = curAnchor[curAnchor.length - 1].measure).maps ? prim.maps[prim.maps.length - 1] : prim.map)[curAnchor.length - 1],
                    offset: curAnchor[curAnchor.length - 2] - curAnchor[curAnchor.length - 3]
                }), curFocus && from) {
                    var rng, prim = sel.rangeCount && sel.getRangeAt(0);
                    try {
                        rng = range(curFocus.node, curFocus.offset, from.offset, from.node);
                    } catch (e) {}
                    rng && (!gecko && cm.state.focused && (sel.collapse(curFocus.node, curFocus.offset), 
                    rng.collapsed) || (sel.removeAllRanges(), sel.addRange(rng)), 
                    prim && null == sel.anchorNode ? sel.addRange(prim) : gecko && this.startGracePeriod()), 
                    this.rememberSelection();
                } else sel.removeAllRanges();
            }
        }
    }, ContentEditableInput.prototype.startGracePeriod = function() {
        var this$1$1 = this;
        clearTimeout(this.gracePeriod), this.gracePeriod = setTimeout(function() {
            this$1$1.gracePeriod = !1, this$1$1.selectionChanged() && this$1$1.cm.operation(function() {
                return this$1$1.cm.curOp.selectionChanged = !0;
            });
        }, 20);
    }, ContentEditableInput.prototype.showMultipleSelections = function(info) {
        removeChildrenAndAdd(this.cm.display.cursorDiv, info.cursors), removeChildrenAndAdd(this.cm.display.selectionDiv, info.selection);
    }, ContentEditableInput.prototype.rememberSelection = function() {
        var sel = this.getSelection();
        this.lastAnchorNode = sel.anchorNode, this.lastAnchorOffset = sel.anchorOffset, 
        this.lastFocusNode = sel.focusNode, this.lastFocusOffset = sel.focusOffset;
    }, ContentEditableInput.prototype.selectionInEditor = function() {
        var sel = this.getSelection();
        return !!sel.rangeCount && (sel = sel.getRangeAt(0).commonAncestorContainer, 
        contains(this.div, sel));
    }, ContentEditableInput.prototype.focus = function() {
        "nocursor" != this.cm.options.readOnly && (this.selectionInEditor() && activeElt() == this.div || this.showSelection(this.prepareSelection(), !0), 
        this.div.focus());
    }, ContentEditableInput.prototype.blur = function() {
        this.div.blur();
    }, ContentEditableInput.prototype.getField = function() {
        return this.div;
    }, ContentEditableInput.prototype.supportsTouch = function() {
        return !0;
    }, ContentEditableInput.prototype.receivedFocus = function() {
        var this$1$1 = this, input = this;
        this.selectionInEditor() ? setTimeout(function() {
            return this$1$1.pollSelection();
        }, 20) : runInOp(this.cm, function() {
            return input.cm.curOp.selectionChanged = !0;
        }), this.polling.set(this.cm.options.pollInterval, function poll() {
            input.cm.state.focused && (input.pollSelection(), input.polling.set(input.cm.options.pollInterval, poll));
        });
    }, ContentEditableInput.prototype.selectionChanged = function() {
        var sel = this.getSelection();
        return sel.anchorNode != this.lastAnchorNode || sel.anchorOffset != this.lastAnchorOffset || sel.focusNode != this.lastFocusNode || sel.focusOffset != this.lastFocusOffset;
    }, ContentEditableInput.prototype.pollSelection = function() {
        var sel, cm, anchor, head;
        null == this.readDOMTimeout && !this.gracePeriod && this.selectionChanged() && (sel = this.getSelection(), 
        cm = this.cm, android && chrome && this.cm.display.gutterSpecs.length && function(node) {
            for (var scan = node; scan; scan = scan.parentNode) if (/CodeMirror-gutter-wrapper/.test(scan.className)) return 1;
            return;
        }(sel.anchorNode) ? (this.cm.triggerOnKeyDown({
            type: "keydown",
            keyCode: 8,
            preventDefault: Math.abs
        }), this.blur(), this.focus()) : this.composing || (this.rememberSelection(), 
        anchor = domToPos(cm, sel.anchorNode, sel.anchorOffset), head = domToPos(cm, sel.focusNode, sel.focusOffset), 
        anchor && head && runInOp(cm, function() {
            setSelection(cm.doc, simpleSelection(anchor, head), sel_dontScroll), 
            (anchor.bad || head.bad) && (cm.curOp.selectionChanged = !0);
        })));
    }, ContentEditableInput.prototype.pollContent = function() {
        null != this.readDOMTimeout && (clearTimeout(this.readDOMTimeout), this.readDOMTimeout = null);
        var fromLine, cm = this.cm, display = cm.display, sel = cm.doc.sel.primary(), from = sel.from(), sel = sel.to();
        if (0 == from.ch && from.line > cm.firstLine() && (from = Pos(from.line - 1, getLine(cm.doc, from.line - 1).length)), 
        sel.ch == getLine(cm.doc, sel.line).text.length && sel.line < cm.lastLine() && (sel = Pos(sel.line + 1, 0)), 
        from.line < display.viewFrom || sel.line > display.viewTo - 1) return !1;
        var toLine, fromIndex = from.line == display.viewFrom || 0 == (fromIndex = findViewIndex(cm, from.line)) ? (fromLine = lineNo(display.view[0].line), 
        display.view[0].node) : (fromLine = lineNo(display.view[fromIndex].line), 
        display.view[fromIndex - 1].node.nextSibling), sel = findViewIndex(cm, sel.line), display = sel == display.view.length - 1 ? (toLine = display.viewTo - 1, 
        display.lineDiv.lastChild) : (toLine = lineNo(display.view[sel + 1].line) - 1, 
        display.view[sel + 1].node.previousSibling);
        if (!fromIndex) return !1;
        for (var newText = cm.doc.splitLines(function(cm, from, to, fromLine, toLine) {
            var text = "", closing = !1, lineSep = cm.doc.lineSeparator(), extraLinebreak = !1;
            function close() {
                closing && (text += lineSep, extraLinebreak && (text += lineSep), 
                closing = extraLinebreak = !1);
            }
            function addText(str) {
                str && (close(), text += str);
            }
            for (;!function walk(node) {
                if (1 == node.nodeType) {
                    var cmText = node.getAttribute("cm-text");
                    if (cmText) addText(cmText); else if (cmText = node.getAttribute("cm-marker")) (cmText = cm.findMarks(Pos(fromLine, 0), Pos(toLine + 1, 0), (id = +cmText, 
                    function(marker) {
                        return marker.id == id;
                    }))).length && (cmText = cmText[0].find(0)) && addText(getBetween(cm.doc, cmText.from, cmText.to).join(lineSep)); else if ("false" != node.getAttribute("contenteditable") && (cmText = /^(pre|div|p|li|table|br)$/i.test(node.nodeName), 
                    /^br$/i.test(node.nodeName) || 0 != node.textContent.length)) {
                        cmText && close();
                        for (var i = 0; i < node.childNodes.length; i++) walk(node.childNodes[i]);
                        /^(pre|p)$/i.test(node.nodeName) && (extraLinebreak = !0), 
                        cmText && (closing = !0);
                    }
                } else 3 == node.nodeType && addText(node.nodeValue.replace(/\u200b/g, "").replace(/\u00a0/g, " "));
                var id;
            }(from), from != to; ) from = from.nextSibling, extraLinebreak = !1;
            return text;
        }(cm, fromIndex, display, fromLine, toLine)), oldText = getBetween(cm.doc, Pos(fromLine, 0), Pos(toLine, getLine(cm.doc, toLine).text.length)); 1 < newText.length && 1 < oldText.length; ) if (lst(newText) == lst(oldText)) newText.pop(), 
        oldText.pop(), toLine--; else {
            if (newText[0] != oldText[0]) break;
            newText.shift(), oldText.shift(), fromLine++;
        }
        for (var cutFront = 0, cutEnd = 0, newTop = newText[0], oldTop = oldText[0], maxCutFront = Math.min(newTop.length, oldTop.length); cutFront < maxCutFront && newTop.charCodeAt(cutFront) == oldTop.charCodeAt(cutFront); ) ++cutFront;
        for (var newBot = lst(newText), oldBot = lst(oldText), maxCutEnd = Math.min(newBot.length - (1 == newText.length ? cutFront : 0), oldBot.length - (1 == oldText.length ? cutFront : 0)); cutEnd < maxCutEnd && newBot.charCodeAt(newBot.length - cutEnd - 1) == oldBot.charCodeAt(oldBot.length - cutEnd - 1); ) ++cutEnd;
        if (1 == newText.length && 1 == oldText.length && fromLine == from.line) for (;cutFront && cutFront > from.ch && newBot.charCodeAt(newBot.length - cutEnd - 1) == oldBot.charCodeAt(oldBot.length - cutEnd - 1); ) cutFront--, 
        cutEnd++;
        newText[newText.length - 1] = newBot.slice(0, newBot.length - cutEnd).replace(/^\u200b+/, ""), 
        newText[0] = newText[0].slice(cutFront).replace(/\u200b+$/, "");
        sel = Pos(fromLine, cutFront), fromIndex = Pos(toLine, oldText.length ? lst(oldText).length - cutEnd : 0);
        return 1 < newText.length || newText[0] || cmp(sel, fromIndex) ? (replaceRange(cm.doc, newText, sel, fromIndex, "+input"), 
        !0) : void 0;
    }, ContentEditableInput.prototype.ensurePolled = function() {
        this.forceCompositionEnd();
    }, ContentEditableInput.prototype.reset = function() {
        this.forceCompositionEnd();
    }, ContentEditableInput.prototype.forceCompositionEnd = function() {
        this.composing && (clearTimeout(this.readDOMTimeout), this.composing = null, 
        this.updateFromDOM(), this.div.blur(), this.div.focus());
    }, ContentEditableInput.prototype.readFromDOMSoon = function() {
        var this$1$1 = this;
        null == this.readDOMTimeout && (this.readDOMTimeout = setTimeout(function() {
            if (this$1$1.readDOMTimeout = null, this$1$1.composing) {
                if (!this$1$1.composing.done) return;
                this$1$1.composing = null;
            }
            this$1$1.updateFromDOM();
        }, 80));
    }, ContentEditableInput.prototype.updateFromDOM = function() {
        var this$1$1 = this;
        !this.cm.isReadOnly() && this.pollContent() || runInOp(this.cm, function() {
            return regChange(this$1$1.cm);
        });
    }, ContentEditableInput.prototype.setUneditable = function(node) {
        node.contentEditable = "false";
    }, ContentEditableInput.prototype.onKeyPress = function(e) {
        0 == e.charCode || this.composing || (e.preventDefault(), this.cm.isReadOnly()) || operation(this.cm, applyTextInput)(this.cm, String.fromCharCode(null == e.charCode ? e.keyCode : e.charCode), 0);
    }, ContentEditableInput.prototype.readOnlyChanged = function(val) {
        this.div.contentEditable = String("nocursor" != val);
    }, ContentEditableInput.prototype.onContextMenu = function() {}, ContentEditableInput.prototype.resetPosition = function() {}, 
    ContentEditableInput.prototype.needsContentAttribute = !0;
    function TextareaInput(cm) {
        this.cm = cm, this.prevInput = "", this.pollingFast = !1, this.polling = new Delayed(), 
        this.hasSelection = !1, this.composing = null;
    }
    TextareaInput.prototype.init = function(display) {
        var this$1$1 = this, input = this, cm = this.cm, te = (this.createField(display), 
        this.textarea);
        function prepareCopyCut(e) {
            if (!signalDOMEvent(cm, e)) {
                if (cm.somethingSelected()) setLastCopied({
                    lineWise: !1,
                    text: cm.getSelections()
                }); else {
                    if (!cm.options.lineWiseCopyCut) return;
                    var ranges = copyableRanges(cm);
                    setLastCopied({
                        lineWise: !0,
                        text: ranges.text
                    }), "cut" == e.type ? cm.setSelections(ranges.ranges, null, sel_dontScroll) : (input.prevInput = "", 
                    te.value = ranges.text.join("\n"), selectInput(te));
                }
                "cut" == e.type && (cm.state.cutIncoming = +new Date());
            }
        }
        display.wrapper.insertBefore(this.wrapper, display.wrapper.firstChild), 
        ios && (te.style.width = "0px"), on(te, "input", function() {
            ie && 9 <= ie_version && this$1$1.hasSelection && (this$1$1.hasSelection = null), 
            input.poll();
        }), on(te, "paste", function(e) {
            signalDOMEvent(cm, e) || handlePaste(e, cm) || (cm.state.pasteIncoming = +new Date(), 
            input.fastPoll());
        }), on(te, "cut", prepareCopyCut), on(te, "copy", prepareCopyCut), on(display.scroller, "paste", function(e) {
            var event;
            eventInWidget(display, e) || signalDOMEvent(cm, e) || (te.dispatchEvent ? ((event = new Event("paste")).clipboardData = e.clipboardData, 
            te.dispatchEvent(event)) : (cm.state.pasteIncoming = +new Date(), input.focus()));
        }), on(display.lineSpace, "selectstart", function(e) {
            eventInWidget(display, e) || e_preventDefault(e);
        }), on(te, "compositionstart", function() {
            var start = cm.getCursor("from");
            input.composing && input.composing.range.clear(), input.composing = {
                start: start,
                range: cm.markText(start, cm.getCursor("to"), {
                    className: "CodeMirror-composing"
                })
            };
        }), on(te, "compositionend", function() {
            input.composing && (input.poll(), input.composing.range.clear(), input.composing = null);
        });
    }, TextareaInput.prototype.createField = function(_display) {
        this.wrapper = hiddenTextarea(), this.textarea = this.wrapper.firstChild;
    }, TextareaInput.prototype.screenReaderLabelChanged = function(label) {
        label ? this.textarea.setAttribute("aria-label", label) : this.textarea.removeAttribute("aria-label");
    }, TextareaInput.prototype.prepareSelection = function() {
        var lineOff, cm = this.cm, display = cm.display, doc = cm.doc, result = prepareSelection(cm);
        return cm.options.moveInputWithCursor && (cm = cursorCoords(cm, doc.sel.primary().head, "div"), 
        doc = display.wrapper.getBoundingClientRect(), lineOff = display.lineDiv.getBoundingClientRect(), 
        result.teTop = Math.max(0, Math.min(display.wrapper.clientHeight - 10, cm.top + lineOff.top - doc.top)), 
        result.teLeft = Math.max(0, Math.min(display.wrapper.clientWidth - 10, cm.left + lineOff.left - doc.left))), 
        result;
    }, TextareaInput.prototype.showSelection = function(drawn) {
        var display = this.cm.display;
        removeChildrenAndAdd(display.cursorDiv, drawn.cursors), removeChildrenAndAdd(display.selectionDiv, drawn.selection), 
        null != drawn.teTop && (this.wrapper.style.top = drawn.teTop + "px", this.wrapper.style.left = drawn.teLeft + "px");
    }, TextareaInput.prototype.reset = function(typing) {
        var cm, content;
        this.contextMenuPending || this.composing || ((cm = this.cm).somethingSelected() ? (this.prevInput = "", 
        content = cm.getSelection(), this.textarea.value = content, cm.state.focused && selectInput(this.textarea), 
        ie && 9 <= ie_version && (this.hasSelection = content)) : typing || (this.prevInput = this.textarea.value = "", 
        ie && 9 <= ie_version && (this.hasSelection = null)));
    }, TextareaInput.prototype.getField = function() {
        return this.textarea;
    }, TextareaInput.prototype.supportsTouch = function() {
        return !1;
    }, TextareaInput.prototype.focus = function() {
        if ("nocursor" != this.cm.options.readOnly && (!mobile || activeElt() != this.textarea)) try {
            this.textarea.focus();
        } catch (e) {}
    }, TextareaInput.prototype.blur = function() {
        this.textarea.blur();
    }, TextareaInput.prototype.resetPosition = function() {
        this.wrapper.style.top = this.wrapper.style.left = 0;
    }, TextareaInput.prototype.receivedFocus = function() {
        this.slowPoll();
    }, TextareaInput.prototype.slowPoll = function() {
        var this$1$1 = this;
        this.pollingFast || this.polling.set(this.cm.options.pollInterval, function() {
            this$1$1.poll(), this$1$1.cm.state.focused && this$1$1.slowPoll();
        });
    }, TextareaInput.prototype.fastPoll = function() {
        var missed = !1, input = this;
        input.pollingFast = !0, input.polling.set(20, function p() {
            input.poll() || missed ? (input.pollingFast = !1, input.slowPoll()) : (missed = !0, 
            input.polling.set(60, p));
        });
    }, TextareaInput.prototype.poll = function() {
        var this$1$1 = this, cm = this.cm, input = this.textarea, prevInput = this.prevInput;
        if (this.contextMenuPending || !cm.state.focused || hasSelection(input) && !prevInput && !this.composing || cm.isReadOnly() || cm.options.disableInput || cm.state.keySeq) return !1;
        var text = input.value;
        if (text == prevInput && !cm.somethingSelected()) return !1;
        if (ie && 9 <= ie_version && this.hasSelection === text || mac && /[\uf700-\uf7ff]/.test(text)) return cm.display.input.reset(), 
        !1;
        if (cm.doc.sel == cm.display.selForContextMenu) {
            var first = text.charCodeAt(0);
            if (8203 == first && (prevInput = prevInput || "\u200b"), 8666 == first) return this.reset(), 
            this.cm.execCommand("undo");
        }
        for (var same = 0, l = Math.min(prevInput.length, text.length); same < l && prevInput.charCodeAt(same) == text.charCodeAt(same); ) ++same;
        return runInOp(cm, function() {
            applyTextInput(cm, text.slice(same), prevInput.length - same, null, this$1$1.composing ? "*compose" : null), 
            1e3 < text.length || -1 < text.indexOf("\n") ? input.value = this$1$1.prevInput = "" : this$1$1.prevInput = text, 
            this$1$1.composing && (this$1$1.composing.range.clear(), this$1$1.composing.range = cm.markText(this$1$1.composing.start, cm.getCursor("to"), {
                className: "CodeMirror-composing"
            }));
        }), !0;
    }, TextareaInput.prototype.ensurePolled = function() {
        this.pollingFast && this.poll() && (this.pollingFast = !1);
    }, TextareaInput.prototype.onKeyPress = function() {
        ie && 9 <= ie_version && (this.hasSelection = null), this.fastPoll();
    }, TextareaInput.prototype.onContextMenu = function(e) {
        var oldCSS, oldWrapperCSS, oldScrollY, mouseup, input = this, cm = input.cm, display = cm.display, te = input.textarea, pos = (input.contextMenuPending && input.contextMenuPending(), 
        posFromMouse(cm, e)), scrollPos = display.scroller.scrollTop;
        function prepareSelectAllHack() {
            var selected, extval;
            null != te.selectionStart && (extval = "\u200b" + ((selected = cm.somethingSelected()) ? te.value : ""), 
            te.value = "\u21da", te.value = extval, input.prevInput = selected ? "" : "\u200b", 
            te.selectionStart = 1, te.selectionEnd = extval.length, display.selForContextMenu = cm.doc.sel);
        }
        function rehide() {
            var i, poll;
            input.contextMenuPending == rehide && (input.contextMenuPending = !1, 
            input.wrapper.style.cssText = oldWrapperCSS, te.style.cssText = oldCSS, 
            ie && ie_version < 9 && display.scrollbars.setScrollTop(display.scroller.scrollTop = scrollPos), 
            null != te.selectionStart) && ((!ie || ie_version < 9) && prepareSelectAllHack(), 
            i = 0, poll = function() {
                display.selForContextMenu == cm.doc.sel && 0 == te.selectionStart && 0 < te.selectionEnd && "\u200b" == input.prevInput ? operation(cm, selectAll)(cm) : i++ < 10 ? display.detectingSelectAll = setTimeout(poll, 500) : (display.selForContextMenu = null, 
                display.input.reset());
            }, display.detectingSelectAll = setTimeout(poll, 200));
        }
        pos && !presto && (cm.options.resetSelectionOnContextMenu && -1 == cm.doc.sel.contains(pos) && operation(cm, setSelection)(cm.doc, simpleSelection(pos), sel_dontScroll), 
        oldCSS = te.style.cssText, oldWrapperCSS = input.wrapper.style.cssText, 
        pos = input.wrapper.offsetParent.getBoundingClientRect(), input.wrapper.style.cssText = "position: static", 
        te.style.cssText = "position: absolute; width: 30px; height: 30px;\n      top: " + (e.clientY - pos.top - 5) + "px; left: " + (e.clientX - pos.left - 5) + "px;\n      z-index: 1000; background: " + (ie ? "rgba(255, 255, 255, .05)" : "transparent") + ";\n      outline: none; border-width: 0; outline: none; overflow: hidden; opacity: .05; filter: alpha(opacity=5);", 
        webkit && (oldScrollY = window.scrollY), display.input.focus(), webkit && window.scrollTo(null, oldScrollY), 
        display.input.reset(), cm.somethingSelected() || (te.value = input.prevInput = " "), 
        input.contextMenuPending = rehide, display.selForContextMenu = cm.doc.sel, 
        clearTimeout(display.detectingSelectAll), ie && 9 <= ie_version && prepareSelectAllHack(), 
        captureRightClick ? (e_stop(e), mouseup = function() {
            off(window, "mouseup", mouseup), setTimeout(rehide, 20);
        }, on(window, "mouseup", mouseup)) : setTimeout(rehide, 50));
    }, TextareaInput.prototype.readOnlyChanged = function(val) {
        val || this.reset(), this.textarea.disabled = "nocursor" == val, this.textarea.readOnly = !!val;
    }, TextareaInput.prototype.setUneditable = function() {}, TextareaInput.prototype.needsContentAttribute = !1, 
    function(CodeMirror) {
        var optionHandlers = CodeMirror.optionHandlers;
        function option(name, deflt, handle, notOnInit) {
            CodeMirror.defaults[name] = deflt, handle && (optionHandlers[name] = notOnInit ? function(cm, val, old) {
                old != Init && handle(cm, val, old);
            } : handle);
        }
        CodeMirror.defineOption = option, CodeMirror.Init = Init, option("value", "", function(cm, val) {
            return cm.setValue(val);
        }, !0), option("mode", null, function(cm, val) {
            cm.doc.modeOption = val, loadMode(cm);
        }, !0), option("indentUnit", 2, loadMode, !0), option("indentWithTabs", !1), 
        option("smartIndent", !0), option("tabSize", 4, function(cm) {
            resetModeState(cm), clearCaches(cm), regChange(cm);
        }, !0), option("lineSeparator", null, function(cm, val) {
            if (cm.doc.lineSep = val) {
                var newBreaks = [], lineNo = cm.doc.first;
                cm.doc.iter(function(line) {
                    for (var pos = 0; ;) {
                        var found = line.text.indexOf(val, pos);
                        if (-1 == found) break;
                        pos = found + val.length, newBreaks.push(Pos(lineNo, found));
                    }
                    lineNo++;
                });
                for (var i = newBreaks.length - 1; 0 <= i; i--) replaceRange(cm.doc, val, newBreaks[i], Pos(newBreaks[i].line, newBreaks[i].ch + val.length));
            }
        }), option("specialChars", /[\u0000-\u001f\u007f-\u009f\u00ad\u061c\u200b\u200e\u200f\u2028\u2029\ufeff\ufff9-\ufffc]/g, function(cm, val, old) {
            cm.state.specialChars = new RegExp(val.source + (val.test("\t") ? "" : "|\t"), "g"), 
            old != Init && cm.refresh();
        }), option("specialCharPlaceholder", defaultSpecialCharPlaceholder, function(cm) {
            return cm.refresh();
        }, !0), option("electricChars", !0), option("inputStyle", mobile ? "contenteditable" : "textarea", function() {
            throw new Error("inputStyle can not (yet) be changed in a running editor");
        }, !0), option("spellcheck", !1, function(cm, val) {
            return cm.getInputField().spellcheck = val;
        }, !0), option("autocorrect", !1, function(cm, val) {
            return cm.getInputField().autocorrect = val;
        }, !0), option("autocapitalize", !1, function(cm, val) {
            return cm.getInputField().autocapitalize = val;
        }, !0), option("rtlMoveVisually", !windows), option("wholeLineUpdateBefore", !0), 
        option("theme", "default", function(cm) {
            themeChanged(cm), updateGutters(cm);
        }, !0), option("keyMap", "default", function(cm, val, old) {
            val = getKeyMap(val), old = old != Init && getKeyMap(old);
            old && old.detach && old.detach(cm, val), val.attach && val.attach(cm, old || null);
        }), option("extraKeys", null), option("configureMouse", null), option("lineWrapping", !1, wrappingChanged, !0), 
        option("gutters", [], function(cm, val) {
            cm.display.gutterSpecs = getGutters(val, cm.options.lineNumbers), updateGutters(cm);
        }, !0), option("fixedGutter", !0, function(cm, val) {
            cm.display.gutters.style.left = val ? compensateForHScroll(cm.display) + "px" : "0", 
            cm.refresh();
        }, !0), option("coverGutterNextToScrollbar", !1, function(cm) {
            return updateScrollbars(cm);
        }, !0), option("scrollbarStyle", "native", function(cm) {
            initScrollbars(cm), updateScrollbars(cm), cm.display.scrollbars.setScrollTop(cm.doc.scrollTop), 
            cm.display.scrollbars.setScrollLeft(cm.doc.scrollLeft);
        }, !0), option("lineNumbers", !1, function(cm, val) {
            cm.display.gutterSpecs = getGutters(cm.options.gutters, val), updateGutters(cm);
        }, !0), option("firstLineNumber", 1, updateGutters, !0), option("lineNumberFormatter", function(integer) {
            return integer;
        }, updateGutters, !0), option("showCursorWhenSelecting", !1, updateSelection, !0), 
        option("resetSelectionOnContextMenu", !0), option("lineWiseCopyCut", !0), 
        option("pasteLinesPerSelection", !0), option("selectionsMayTouch", !1), 
        option("readOnly", !1, function(cm, val) {
            "nocursor" == val && (onBlur(cm), cm.display.input.blur()), cm.display.input.readOnlyChanged(val);
        }), option("screenReaderLabel", null, function(cm, val) {
            cm.display.input.screenReaderLabelChanged(val = "" === val ? null : val);
        }), option("disableInput", !1, function(cm, val) {
            val || cm.display.input.reset();
        }, !0), option("dragDrop", !0, dragDropChanged), option("allowDropFileTypes", null), 
        option("cursorBlinkRate", 530), option("cursorScrollMargin", 0), option("cursorHeight", 1, updateSelection, !0), 
        option("singleCursorHeightPerLine", !0, updateSelection, !0), option("workTime", 100), 
        option("workDelay", 100), option("flattenSpans", !0, resetModeState, !0), 
        option("addModeClass", !1, resetModeState, !0), option("pollInterval", 100), 
        option("undoDepth", 200, function(cm, val) {
            return cm.doc.history.undoDepth = val;
        }), option("historyEventDelay", 1250), option("viewportMargin", 10, function(cm) {
            return cm.refresh();
        }, !0), option("maxHighlightLength", 1e4, resetModeState, !0), option("moveInputWithCursor", !0, function(cm, val) {
            val || cm.display.input.resetPosition();
        }), option("tabindex", null, function(cm, val) {
            return cm.display.input.getField().tabIndex = val || "";
        }), option("autofocus", null), option("direction", "ltr", function(cm, val) {
            return cm.doc.setDirection(val);
        }, !0), option("phrases", null);
    }(CodeMirror), function(CodeMirror) {
        var optionHandlers = CodeMirror.optionHandlers, helpers = CodeMirror.helpers = {};
        CodeMirror.prototype = {
            constructor: CodeMirror,
            focus: function() {
                window.focus(), this.display.input.focus();
            },
            setOption: function(option, value) {
                var options = this.options, old = options[option];
                options[option] == value && "mode" != option || (options[option] = value, 
                optionHandlers.hasOwnProperty(option) && operation(this, optionHandlers[option])(this, value, old), 
                signal(this, "optionChange", this, option));
            },
            getOption: function(option) {
                return this.options[option];
            },
            getDoc: function() {
                return this.doc;
            },
            addKeyMap: function(map, bottom) {
                this.state.keyMaps[bottom ? "push" : "unshift"](getKeyMap(map));
            },
            removeKeyMap: function(map) {
                for (var maps = this.state.keyMaps, i = 0; i < maps.length; ++i) if (maps[i] == map || maps[i].name == map) return maps.splice(i, 1), 
                !0;
            },
            addOverlay: methodOp(function(spec, options) {
                var mode = spec.token ? spec : CodeMirror.getMode(this.options, spec);
                if (mode.startState) throw new Error("Overlays may not be stateful.");
                for (var array = this.state.overlays, mode = {
                    mode: mode,
                    modeSpec: spec,
                    opaque: options && options.opaque,
                    priority: options && options.priority || 0
                }, score = function(overlay) {
                    return overlay.priority;
                }, pos = 0, priority = score(mode); pos < array.length && score(array[pos]) <= priority; ) pos++;
                array.splice(pos, 0, mode), this.state.modeGen++, regChange(this);
            }),
            removeOverlay: methodOp(function(spec) {
                for (var overlays = this.state.overlays, i = 0; i < overlays.length; ++i) {
                    var cur = overlays[i].modeSpec;
                    if (cur == spec || "string" == typeof spec && cur.name == spec) return overlays.splice(i, 1), 
                    this.state.modeGen++, void regChange(this);
                }
            }),
            indentLine: methodOp(function(n, dir, aggressive) {
                "string" != typeof dir && "number" != typeof dir && (dir = null == dir ? this.options.smartIndent ? "smart" : "prev" : dir ? "add" : "subtract"), 
                isLine(this.doc, n) && indentLine(this, n, dir, aggressive);
            }),
            indentSelection: methodOp(function(how) {
                for (var ranges = this.doc.sel.ranges, end = -1, i = 0; i < ranges.length; i++) {
                    var range = ranges[i];
                    if (range.empty()) range.head.line > end && (indentLine(this, range.head.line, how, !0), 
                    end = range.head.line, i == this.doc.sel.primIndex) && ensureCursorVisible(this); else {
                        for (var from = range.from(), range = range.to(), start = Math.max(end, from.line), end = Math.min(this.lastLine(), range.line - (range.ch ? 0 : 1)) + 1, j = start; j < end; ++j) indentLine(this, j, how);
                        range = this.doc.sel.ranges;
                        0 == from.ch && ranges.length == range.length && 0 < range[i].from().ch && replaceOneSelection(this.doc, i, new Range(from, range[i].to()), sel_dontScroll);
                    }
                }
            }),
            getTokenAt: function(pos, precise) {
                return takeToken(this, pos, precise);
            },
            getLineTokens: function(line, precise) {
                return takeToken(this, Pos(line), precise, !0);
            },
            getTokenTypeAt: function(pos) {
                pos = clipPos(this.doc, pos);
                var type, styles = getLineStyles(this, getLine(this.doc, pos.line)), before = 0, after = (styles.length - 1) / 2, ch = pos.ch;
                if (0 == ch) type = styles[2]; else for (;;) {
                    var mid = before + after >> 1;
                    if ((mid ? styles[2 * mid - 1] : 0) >= ch) after = mid; else {
                        if (!(styles[2 * mid + 1] < ch)) {
                            type = styles[2 * mid + 2];
                            break;
                        }
                        before = 1 + mid;
                    }
                }
                pos = type ? type.indexOf("overlay ") : -1;
                return pos < 0 ? type : 0 == pos ? null : type.slice(0, pos - 1);
            },
            getModeAt: function(pos) {
                var mode = this.doc.mode;
                return mode.innerMode ? CodeMirror.innerMode(mode, this.getTokenAt(pos).state).mode : mode;
            },
            getHelper: function(pos, type) {
                return this.getHelpers(pos, type)[0];
            },
            getHelpers: function(pos, type) {
                var found = [];
                if (helpers.hasOwnProperty(type)) {
                    var help = helpers[type], mode = this.getModeAt(pos);
                    if ("string" == typeof mode[type]) help[mode[type]] && found.push(help[mode[type]]); else if (mode[type]) for (var i = 0; i < mode[type].length; i++) {
                        var val = help[mode[type][i]];
                        val && found.push(val);
                    } else mode.helperType && help[mode.helperType] ? found.push(help[mode.helperType]) : help[mode.name] && found.push(help[mode.name]);
                    for (var i$1 = 0; i$1 < help._global.length; i$1++) {
                        var cur = help._global[i$1];
                        cur.pred(mode, this) && -1 == indexOf(found, cur.val) && found.push(cur.val);
                    }
                }
                return found;
            },
            getStateAfter: function(line, precise) {
                var doc = this.doc;
                return getContextBefore(this, (line = clipLine(doc, null == line ? doc.first + doc.size - 1 : line)) + 1, precise).state;
            },
            cursorCoords: function(start, mode) {
                var range = this.doc.sel.primary(), start = null == start ? range.head : "object" == typeof start ? clipPos(this.doc, start) : start ? range.from() : range.to();
                return cursorCoords(this, start, mode || "page");
            },
            charCoords: function(pos, mode) {
                return charCoords(this, clipPos(this.doc, pos), mode || "page");
            },
            coordsChar: function(coords, mode) {
                return coordsChar(this, (coords = fromCoordSystem(this, coords, mode || "page")).left, coords.top);
            },
            lineAtHeight: function(height, mode) {
                return height = fromCoordSystem(this, {
                    top: height,
                    left: 0
                }, mode || "page").top, lineAtHeight(this.doc, height + this.display.viewOffset);
            },
            heightAtLine: function(line, mode, includeWidgets) {
                var end = !1, last = "number" == typeof line ? (last = this.doc.first + this.doc.size - 1, 
                line < this.doc.first ? line = this.doc.first : last < line && (line = last, 
                end = !0), getLine(this.doc, line)) : line;
                return intoCoordSystem(this, last, {
                    top: 0,
                    left: 0
                }, mode || "page", includeWidgets || end).top + (end ? this.doc.height - heightAtLine(last) : 0);
            },
            defaultTextHeight: function() {
                return textHeight(this.display);
            },
            defaultCharWidth: function() {
                return charWidth(this.display);
            },
            getViewport: function() {
                return {
                    from: this.display.viewFrom,
                    to: this.display.viewTo
                };
            },
            addWidget: function(pos, node, scroll, vert, horiz) {
                var hspace, vspace, display = this.display, top = (pos = cursorCoords(this, clipPos(this.doc, pos))).bottom, left = pos.left;
                node.style.position = "absolute", node.setAttribute("cm-ignore-events", "true"), 
                this.display.input.setUneditable(node), display.sizer.appendChild(node), 
                "over" == vert ? top = pos.top : "above" != vert && "near" != vert || (vspace = Math.max(display.wrapper.clientHeight, this.doc.height), 
                hspace = Math.max(display.sizer.clientWidth, display.lineSpace.clientWidth), 
                ("above" == vert || pos.bottom + node.offsetHeight > vspace) && pos.top > node.offsetHeight ? top = pos.top - node.offsetHeight : pos.bottom + node.offsetHeight <= vspace && (top = pos.bottom), 
                left + node.offsetWidth > hspace && (left = hspace - node.offsetWidth)), 
                node.style.top = top + "px", node.style.left = node.style.right = "", 
                "right" == horiz ? (left = display.sizer.clientWidth - node.offsetWidth, 
                node.style.right = "0px") : ("left" == horiz ? left = 0 : "middle" == horiz && (left = (display.sizer.clientWidth - node.offsetWidth) / 2), 
                node.style.left = left + "px"), scroll && (vert = this, vspace = {
                    left: left,
                    top: top,
                    right: left + node.offsetWidth,
                    bottom: top + node.offsetHeight
                }, null != (vspace = calculateScrollPos(vert, vspace)).scrollTop && updateScrollTop(vert, vspace.scrollTop), 
                null != vspace.scrollLeft) && setScrollLeft(vert, vspace.scrollLeft);
            },
            triggerOnKeyDown: methodOp(onKeyDown),
            triggerOnKeyPress: methodOp(onKeyPress),
            triggerOnKeyUp: onKeyUp,
            triggerOnMouseDown: methodOp(onMouseDown),
            execCommand: function(cmd) {
                if (commands.hasOwnProperty(cmd)) return commands[cmd].call(null, this);
            },
            triggerElectric: methodOp(function(text) {
                triggerElectric(this, text);
            }),
            findPosH: function(from, amount, unit, visually) {
                for (var dir = 1, cur = (amount < 0 && (dir = -1, amount = -amount), 
                clipPos(this.doc, from)), i = 0; i < amount && !(cur = findPosH(this.doc, cur, dir, unit, visually)).hitSide; ++i);
                return cur;
            },
            moveH: methodOp(function(dir, unit) {
                var this$1$1 = this;
                this.extendSelectionsBy(function(range) {
                    return this$1$1.display.shift || this$1$1.doc.extend || range.empty() ? findPosH(this$1$1.doc, range.head, dir, unit, this$1$1.options.rtlMoveVisually) : dir < 0 ? range.from() : range.to();
                }, sel_move);
            }),
            deleteH: methodOp(function(dir, unit) {
                var sel = this.doc.sel, doc = this.doc;
                sel.somethingSelected() ? doc.replaceSelection("", null, "+delete") : deleteNearSelection(this, function(range) {
                    var other = findPosH(doc, range.head, dir, unit, !1);
                    return dir < 0 ? {
                        from: other,
                        to: range.head
                    } : {
                        from: range.head,
                        to: other
                    };
                });
            }),
            findPosV: function(from, amount, unit, goalColumn) {
                for (var dir = 1, x = goalColumn, cur = (amount < 0 && (dir = -1, 
                amount = -amount), clipPos(this.doc, from)), i = 0; i < amount; ++i) {
                    var coords = cursorCoords(this, cur, "div");
                    if (null == x ? x = coords.left : coords.left = x, (cur = findPosV(this, coords, dir, unit)).hitSide) break;
                }
                return cur;
            },
            moveV: methodOp(function(dir, unit) {
                var this$1$1 = this, doc = this.doc, goals = [], collapse = !this.display.shift && !doc.extend && doc.sel.somethingSelected();
                if (doc.extendSelectionsBy(function(range) {
                    var headPos, pos;
                    return collapse ? dir < 0 ? range.from() : range.to() : (headPos = cursorCoords(this$1$1, range.head, "div"), 
                    null != range.goalColumn && (headPos.left = range.goalColumn), 
                    goals.push(headPos.left), pos = findPosV(this$1$1, headPos, dir, unit), 
                    "page" == unit && range == doc.sel.primary() && addToScrollTop(this$1$1, charCoords(this$1$1, pos, "div").top - headPos.top), 
                    pos);
                }, sel_move), goals.length) for (var i = 0; i < doc.sel.ranges.length; i++) doc.sel.ranges[i].goalColumn = goals[i];
            }),
            findWordAt: function(pos) {
                var line = getLine(this.doc, pos.line).text, start = pos.ch, end = pos.ch;
                if (line) {
                    for (var helper = this.getHelper(pos, "wordChars"), startChar = ("before" != pos.sticky && end != line.length || !start ? ++end : --start, 
                    line.charAt(start)), check = isWordChar(startChar, helper) ? function(ch) {
                        return isWordChar(ch, helper);
                    } : /\s/.test(startChar) ? function(ch) {
                        return /\s/.test(ch);
                    } : function(ch) {
                        return !/\s/.test(ch) && !isWordChar(ch);
                    }; 0 < start && check(line.charAt(start - 1)); ) --start;
                    for (;end < line.length && check(line.charAt(end)); ) ++end;
                }
                return new Range(Pos(pos.line, start), Pos(pos.line, end));
            },
            toggleOverwrite: function(value) {
                null != value && value == this.state.overwrite || (((this.state.overwrite = !this.state.overwrite) ? addClass : rmClass)(this.display.cursorDiv, "CodeMirror-overwrite"), 
                signal(this, "overwriteToggle", this, this.state.overwrite));
            },
            hasFocus: function() {
                return this.display.input.getField() == activeElt();
            },
            isReadOnly: function() {
                return !(!this.options.readOnly && !this.doc.cantEdit);
            },
            scrollTo: methodOp(function(x, y) {
                scrollToCoords(this, x, y);
            }),
            getScrollInfo: function() {
                var scroller = this.display.scroller;
                return {
                    left: scroller.scrollLeft,
                    top: scroller.scrollTop,
                    height: scroller.scrollHeight - scrollGap(this) - this.display.barHeight,
                    width: scroller.scrollWidth - scrollGap(this) - this.display.barWidth,
                    clientHeight: displayHeight(this),
                    clientWidth: displayWidth(this)
                };
            },
            scrollIntoView: methodOp(function(range, margin) {
                null == range ? (range = {
                    from: this.doc.sel.primary().head,
                    to: null
                }, null == margin && (margin = this.options.cursorScrollMargin)) : "number" == typeof range ? range = {
                    from: Pos(range, 0),
                    to: null
                } : null == range.from && (range = {
                    from: range,
                    to: null
                }), range.to || (range.to = range.from), range.margin = margin || 0, 
                null != range.from.line ? function(cm, range) {
                    resolveScrollToPos(cm), cm.curOp.scrollToPos = range;
                }(this, range) : scrollToCoordsRange(this, range.from, range.to, range.margin);
            }),
            setSize: methodOp(function(width, height) {
                function interpret(val) {
                    return "number" == typeof val || /^\d+$/.test(String(val)) ? val + "px" : val;
                }
                var this$1$1 = this, lineNo = (null != width && (this.display.wrapper.style.width = interpret(width)), 
                null != height && (this.display.wrapper.style.height = interpret(height)), 
                this.options.lineWrapping && clearLineMeasurementCache(this), this.display.viewFrom);
                this.doc.iter(lineNo, this.display.viewTo, function(line) {
                    if (line.widgets) for (var i = 0; i < line.widgets.length; i++) if (line.widgets[i].noHScroll) {
                        regLineChange(this$1$1, lineNo, "widget");
                        break;
                    }
                    ++lineNo;
                }), this.curOp.forceUpdate = !0, signal(this, "refresh", this);
            }),
            operation: function(f) {
                return runInOp(this, f);
            },
            startOperation: function() {
                return startOperation(this);
            },
            endOperation: function() {
                return endOperation(this);
            },
            refresh: methodOp(function() {
                var oldHeight = this.display.cachedTextHeight;
                regChange(this), this.curOp.forceUpdate = !0, clearCaches(this), 
                scrollToCoords(this, this.doc.scrollLeft, this.doc.scrollTop), updateGutterSpace(this.display), 
                (null == oldHeight || .5 < Math.abs(oldHeight - textHeight(this.display)) || this.options.lineWrapping) && estimateLineHeights(this), 
                signal(this, "refresh", this);
            }),
            swapDoc: methodOp(function(doc) {
                var old = this.doc;
                return old.cm = null, this.state.selectingText && this.state.selectingText(), 
                attachDoc(this, doc), clearCaches(this), this.display.input.reset(), 
                scrollToCoords(this, doc.scrollLeft, doc.scrollTop), this.curOp.forceScroll = !0, 
                signalLater(this, "swapDoc", this, old), old;
            }),
            phrase: function(phraseText) {
                var phrases = this.options.phrases;
                return phrases && Object.prototype.hasOwnProperty.call(phrases, phraseText) ? phrases[phraseText] : phraseText;
            },
            getInputField: function() {
                return this.display.input.getField();
            },
            getWrapperElement: function() {
                return this.display.wrapper;
            },
            getScrollerElement: function() {
                return this.display.scroller;
            },
            getGutterElement: function() {
                return this.display.gutters;
            }
        }, eventMixin(CodeMirror), CodeMirror.registerHelper = function(type, name, value) {
            helpers.hasOwnProperty(type) || (helpers[type] = CodeMirror[type] = {
                _global: []
            }), helpers[type][name] = value;
        }, CodeMirror.registerGlobalHelper = function(type, name, predicate, value) {
            CodeMirror.registerHelper(type, name, value), helpers[type]._global.push({
                pred: predicate,
                val: value
            });
        };
    }(CodeMirror);
    var prop, dontDelegate = "iter insert remove copy getEditor constructor".split(" ");
    for (prop in Doc.prototype) Doc.prototype.hasOwnProperty(prop) && indexOf(dontDelegate, prop) < 0 && (CodeMirror.prototype[prop] = function(method) {
        return function() {
            return method.apply(this.doc, arguments);
        };
    }(Doc.prototype[prop]));
    return eventMixin(Doc), CodeMirror.inputStyles = {
        textarea: TextareaInput,
        contenteditable: ContentEditableInput
    }, CodeMirror.defineMode = function(name) {
        CodeMirror.defaults.mode || "null" == name || (CodeMirror.defaults.mode = name), 
        function(name, mode) {
            2 < arguments.length && (mode.dependencies = Array.prototype.slice.call(arguments, 2)), 
            modes[name] = mode;
        }.apply(this, arguments);
    }, CodeMirror.defineMIME = function(mime, spec) {
        mimeModes[mime] = spec;
    }, CodeMirror.defineMode("null", function() {
        return {
            token: function(stream) {
                return stream.skipToEnd();
            }
        };
    }), CodeMirror.defineMIME("text/plain", "null"), CodeMirror.defineExtension = function(name, func) {
        CodeMirror.prototype[name] = func;
    }, CodeMirror.defineDocExtension = function(name, func) {
        Doc.prototype[name] = func;
    }, CodeMirror.fromTextArea = function(textarea, options) {
        var hasFocus;
        function save() {
            textarea.value = cm.getValue();
        }
        if ((options = options ? copyObj(options) : {}).value = textarea.value, 
        !options.tabindex && textarea.tabIndex && (options.tabindex = textarea.tabIndex), 
        !options.placeholder && textarea.placeholder && (options.placeholder = textarea.placeholder), 
        null == options.autofocus && (hasFocus = activeElt(), options.autofocus = hasFocus == textarea || null != textarea.getAttribute("autofocus") && hasFocus == document.body), 
        textarea.form && (on(textarea.form, "submit", save), !options.leaveSubmitMethodAlone)) {
            var form = textarea.form, realSubmit = form.submit;
            try {
                var wrappedSubmit = form.submit = function() {
                    save(), form.submit = realSubmit, form.submit(), form.submit = wrappedSubmit;
                };
            } catch (e) {}
        }
        options.finishInit = function(cm) {
            cm.save = save, cm.getTextArea = function() {
                return textarea;
            }, cm.toTextArea = function() {
                cm.toTextArea = isNaN, save(), textarea.parentNode.removeChild(cm.getWrapperElement()), 
                textarea.style.display = "", textarea.form && (off(textarea.form, "submit", save), 
                options.leaveSubmitMethodAlone || "function" != typeof textarea.form.submit || (textarea.form.submit = realSubmit));
            };
        }, textarea.style.display = "none";
        var cm = CodeMirror(function(node) {
            return textarea.parentNode.insertBefore(node, textarea.nextSibling);
        }, options);
        return cm;
    }, function(CodeMirror) {
        CodeMirror.off = off, CodeMirror.on = on, CodeMirror.wheelEventPixels = wheelEventPixels, 
        CodeMirror.Doc = Doc, CodeMirror.splitLines = splitLinesAuto, CodeMirror.countColumn = countColumn, 
        CodeMirror.findColumn = findColumn, CodeMirror.isWordChar = isWordCharBasic, 
        CodeMirror.Pass = Pass, CodeMirror.signal = signal, CodeMirror.Line = Line, 
        CodeMirror.changeEnd = changeEnd, CodeMirror.scrollbarModel = scrollbarModel, 
        CodeMirror.Pos = Pos, CodeMirror.cmpPos = cmp, CodeMirror.modes = modes, 
        CodeMirror.mimeModes = mimeModes, CodeMirror.resolveMode = resolveMode, 
        CodeMirror.getMode = getMode, CodeMirror.modeExtensions = modeExtensions, 
        CodeMirror.extendMode = extendMode, CodeMirror.copyState = copyState, CodeMirror.startState = startState, 
        CodeMirror.innerMode = innerMode, CodeMirror.commands = commands, CodeMirror.keyMap = keyMap, 
        CodeMirror.keyName = keyName, CodeMirror.isModifierKey = isModifierKey, 
        CodeMirror.lookupKey = lookupKey, CodeMirror.normalizeKeyMap = normalizeKeyMap, 
        CodeMirror.StringStream = StringStream, CodeMirror.SharedTextMarker = SharedTextMarker, 
        CodeMirror.TextMarker = TextMarker, CodeMirror.LineWidget = LineWidget, 
        CodeMirror.e_preventDefault = e_preventDefault, CodeMirror.e_stopPropagation = e_stopPropagation, 
        CodeMirror.e_stop = e_stop, CodeMirror.addClass = addClass, CodeMirror.contains = contains, 
        CodeMirror.rmClass = rmClass, CodeMirror.keyNames = keyNames;
    }(CodeMirror), CodeMirror.version = "5.65.5", CodeMirror;
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    var defaults = {
        pairs: "()[]{}''\"\"",
        closeBefore: ")]}'\":;>",
        triples: "",
        explode: "[]{}"
    }, Pos = CodeMirror.Pos;
    function getOption(conf, name) {
        return "pairs" == name && "string" == typeof conf ? conf : ("object" == typeof conf && null != conf[name] ? conf : defaults)[name];
    }
    CodeMirror.defineOption("autoCloseBrackets", !1, function(cm, val, old) {
        old && old != CodeMirror.Init && (cm.removeKeyMap(keyMap), cm.state.closeBrackets = null), 
        val && (ensureBound(getOption(val, "pairs")), cm.state.closeBrackets = val, 
        cm.addKeyMap(keyMap));
    });
    var keyMap = {
        Backspace: function(cm) {
            var conf = getConfig(cm);
            if (!conf || cm.getOption("disableInput")) return CodeMirror.Pass;
            for (var pairs = getOption(conf, "pairs"), ranges = cm.listSelections(), i = 0; i < ranges.length; i++) {
                if (!ranges[i].empty()) return CodeMirror.Pass;
                var around = charsAround(cm, ranges[i].head);
                if (!around || pairs.indexOf(around) % 2 != 0) return CodeMirror.Pass;
            }
            for (i = ranges.length - 1; 0 <= i; i--) {
                var cur = ranges[i].head;
                cm.replaceRange("", Pos(cur.line, cur.ch - 1), Pos(cur.line, cur.ch + 1), "+delete");
            }
        },
        Enter: function(cm) {
            var conf = getConfig(cm), explode = conf && getOption(conf, "explode");
            if (!explode || cm.getOption("disableInput")) return CodeMirror.Pass;
            for (var ranges = cm.listSelections(), i = 0; i < ranges.length; i++) {
                if (!ranges[i].empty()) return CodeMirror.Pass;
                var around = charsAround(cm, ranges[i].head);
                if (!around || explode.indexOf(around) % 2 != 0) return CodeMirror.Pass;
            }
            cm.operation(function() {
                var linesep = cm.lineSeparator() || "\n";
                cm.replaceSelection(linesep + linesep, null), moveSel(cm, -1), ranges = cm.listSelections();
                for (var i = 0; i < ranges.length; i++) {
                    var line = ranges[i].head.line;
                    cm.indentLine(line, null, !0), cm.indentLine(line + 1, null, !0);
                }
            });
        }
    };
    function ensureBound(chars) {
        for (var i = 0; i < chars.length; i++) {
            var ch = chars.charAt(i), key = "'" + ch + "'";
            keyMap[key] || (keyMap[key] = function(ch) {
                return function(cm) {
                    return function(cm, ch) {
                        var conf = getConfig(cm);
                        if (!conf || cm.getOption("disableInput")) return CodeMirror.Pass;
                        var pairs = getOption(conf, "pairs"), pos = pairs.indexOf(ch);
                        if (-1 == pos) return CodeMirror.Pass;
                        for (var type, closeBefore = getOption(conf, "closeBefore"), triples = getOption(conf, "triples"), identical = pairs.charAt(pos + 1) == ch, ranges = cm.listSelections(), opening = pos % 2 == 0, i = 0; i < ranges.length; i++) {
                            var curType, range = ranges[i], cur = range.head, next = cm.getRange(cur, Pos(cur.line, cur.ch + 1));
                            if (opening && !range.empty()) curType = "surround"; else if (!identical && opening || next != ch) if (identical && 1 < cur.ch && 0 <= triples.indexOf(ch) && cm.getRange(Pos(cur.line, cur.ch - 2), cur) == ch + ch) {
                                if (2 < cur.ch && /\bstring/.test(cm.getTokenTypeAt(Pos(cur.line, cur.ch - 2)))) return CodeMirror.Pass;
                                curType = "addFour";
                            } else {
                                if (identical) {
                                    range = 0 == cur.ch ? " " : cm.getRange(Pos(cur.line, cur.ch - 1), cur);
                                    if (CodeMirror.isWordChar(next) || range == ch || CodeMirror.isWordChar(range)) return CodeMirror.Pass;
                                } else if (!opening || !(0 === next.length || /\s/.test(next) || -1 < closeBefore.indexOf(next))) return CodeMirror.Pass;
                                curType = "both";
                            } else curType = identical && function(cm, pos) {
                                var token = cm.getTokenAt(Pos(pos.line, pos.ch + 1));
                                return /\bstring/.test(token.type) && token.start == pos.ch && (0 == pos.ch || !/\bstring/.test(cm.getTokenTypeAt(pos)));
                            }(cm, cur) ? "both" : 0 <= triples.indexOf(ch) && cm.getRange(cur, Pos(cur.line, cur.ch + 3)) == ch + ch + ch ? "skipThree" : "skip";
                            if (type) {
                                if (type != curType) return CodeMirror.Pass;
                            } else type = curType;
                        }
                        var left = pos % 2 ? pairs.charAt(pos - 1) : ch, right = pos % 2 ? ch : pairs.charAt(pos + 1);
                        cm.operation(function() {
                            if ("skip" == type) moveSel(cm, 1); else if ("skipThree" == type) moveSel(cm, 3); else if ("surround" == type) {
                                for (var sels = cm.getSelections(), i = 0; i < sels.length; i++) sels[i] = left + sels[i] + right;
                                cm.replaceSelections(sels, "around");
                                for (sels = cm.listSelections().slice(), i = 0; i < sels.length; i++) sels[i] = (sel = sels[i], 
                                inverted = void 0, inverted = 0 < CodeMirror.cmpPos(sel.anchor, sel.head), 
                                {
                                    anchor: new Pos(sel.anchor.line, sel.anchor.ch + (inverted ? -1 : 1)),
                                    head: new Pos(sel.head.line, sel.head.ch + (inverted ? 1 : -1))
                                });
                                cm.setSelections(sels);
                            } else "both" == type ? (cm.replaceSelection(left + right, null), 
                            cm.triggerElectric(left + right), moveSel(cm, -1)) : "addFour" == type && (cm.replaceSelection(left + left + left + left, "before"), 
                            moveSel(cm, 1));
                            var sel, inverted;
                        });
                    }(cm, ch);
                };
            }(ch));
        }
    }
    function getConfig(cm) {
        var deflt = cm.state.closeBrackets;
        return deflt && !deflt.override && cm.getModeAt(cm.getCursor()).closeBrackets || deflt;
    }
    function moveSel(cm, dir) {
        for (var newRanges = [], ranges = cm.listSelections(), primary = 0, i = 0; i < ranges.length; i++) {
            var range = ranges[i], range = (range.head == cm.getCursor() && (primary = i), 
            range.head.ch || 0 < dir ? {
                line: range.head.line,
                ch: range.head.ch + dir
            } : {
                line: range.head.line - 1
            });
            newRanges.push({
                anchor: range,
                head: range
            });
        }
        cm.setSelections(newRanges, primary);
    }
    function charsAround(cm, pos) {
        cm = cm.getRange(Pos(pos.line, pos.ch - 1), Pos(pos.line, pos.ch + 1));
        return 2 == cm.length ? cm : null;
    }
    ensureBound(defaults.pairs + "`");
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror"), require("../fold/xml-fold")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror", "../fold/xml-fold" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    CodeMirror.defineOption("autoCloseTags", !1, function(cm, val, old) {
        old != CodeMirror.Init && old && cm.removeKeyMap("autoCloseTags"), val && (old = {
            name: "autoCloseTags"
        }, "object" == typeof val && !1 === val.whenClosing || (old["'/'"] = function(cm) {
            return cm.getOption("disableInput") ? CodeMirror.Pass : autoCloseCurrent(cm, !0);
        }), "object" == typeof val && !1 === val.whenOpening || (old["'>'"] = function(cm) {
            if (cm.getOption("disableInput")) return CodeMirror.Pass;
            for (var ranges = cm.listSelections(), replacements = [], opt = cm.getOption("autoCloseTags"), i = 0; i < ranges.length; i++) {
                if (!ranges[i].empty()) return CodeMirror.Pass;
                var pos = ranges[i].head, tok = cm.getTokenAt(pos), inner = CodeMirror.innerMode(cm.getMode(), tok.state), state = inner.state, tagInfo = inner.mode.xmlCurrentTag && inner.mode.xmlCurrentTag(state), tagName = tagInfo && tagInfo.name;
                if (!tagName) return CodeMirror.Pass;
                var html = "html" == inner.mode.configuration, dontCloseTags = "object" == typeof opt && opt.dontCloseTags || html && htmlDontClose, html = "object" == typeof opt && opt.indentTags || html && htmlIndent, lowerTagName = (tagName = tok.end > pos.ch ? tagName.slice(0, tagName.length - tok.end + pos.ch) : tagName).toLowerCase();
                if (!tagName || "string" == tok.type && (tok.end != pos.ch || !/[\"\']/.test(tok.string.charAt(tok.string.length - 1)) || 1 == tok.string.length) || "tag" == tok.type && tagInfo.close || tok.string.indexOf("/") == pos.ch - tok.start - 1 || dontCloseTags && -1 < indexOf(dontCloseTags, lowerTagName) || closingTagExists(cm, inner.mode.xmlCurrentContext && inner.mode.xmlCurrentContext(state) || [], tagName, pos, !0)) return CodeMirror.Pass;
                tagInfo = "object" == typeof opt && opt.emptyTags;
                tagInfo && -1 < indexOf(tagInfo, tagName) ? replacements[i] = {
                    text: "/>",
                    newPos: CodeMirror.Pos(pos.line, pos.ch + 2)
                } : (tok = html && -1 < indexOf(html, lowerTagName), replacements[i] = {
                    indent: tok,
                    text: ">" + (tok ? "\n\n" : "") + "</" + tagName + ">",
                    newPos: tok ? CodeMirror.Pos(pos.line + 1, 0) : CodeMirror.Pos(pos.line, pos.ch + 1)
                });
            }
            for (var dontIndentOnAutoClose = "object" == typeof opt && opt.dontIndentOnAutoClose, i = ranges.length - 1; 0 <= i; i--) {
                var info = replacements[i], sel = (cm.replaceRange(info.text, ranges[i].head, ranges[i].anchor, "+insert"), 
                cm.listSelections().slice(0));
                sel[i] = {
                    head: info.newPos,
                    anchor: info.newPos
                }, cm.setSelections(sel), !dontIndentOnAutoClose && info.indent && (cm.indentLine(info.newPos.line, null, !0), 
                cm.indentLine(info.newPos.line + 1, null, !0));
            }
        }), cm.addKeyMap(old));
    });
    var htmlDontClose = [ "area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr" ], htmlIndent = [ "applet", "blockquote", "body", "button", "div", "dl", "fieldset", "form", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "html", "iframe", "layer", "legend", "object", "ol", "p", "select", "table", "ul" ];
    function autoCloseCurrent(cm, typingSlash) {
        for (var ranges = cm.listSelections(), replacements = [], head = typingSlash ? "/" : "</", opt = cm.getOption("autoCloseTags"), opt = "object" == typeof opt && opt.dontIndentOnSlash, i = 0; i < ranges.length; i++) {
            if (!ranges[i].empty()) return CodeMirror.Pass;
            var pos = ranges[i].head, tok = cm.getTokenAt(pos), inner = CodeMirror.innerMode(cm.getMode(), tok.state), state = inner.state;
            if (typingSlash && ("string" == tok.type || "<" != tok.string.charAt(0) || tok.start != pos.ch - 1)) return CodeMirror.Pass;
            var replacement, mixed = "xml" != inner.mode.name && "htmlmixed" == cm.getMode().name;
            if (mixed && "javascript" == inner.mode.name) replacement = head + "script"; else if (mixed && "css" == inner.mode.name) replacement = head + "style"; else {
                mixed = inner.mode.xmlCurrentContext && inner.mode.xmlCurrentContext(state), 
                inner = mixed.length ? mixed[mixed.length - 1] : "";
                if (!mixed || mixed.length && closingTagExists(cm, mixed, inner, pos)) return CodeMirror.Pass;
                replacement = head + inner;
            }
            ">" != cm.getLine(pos.line).charAt(tok.end) && (replacement += ">"), 
            replacements[i] = replacement;
        }
        if (cm.replaceSelections(replacements), ranges = cm.listSelections(), !opt) for (i = 0; i < ranges.length; i++) (i == ranges.length - 1 || ranges[i].head.line < ranges[i + 1].head.line) && cm.indentLine(ranges[i].head.line);
    }
    function indexOf(collection, elt) {
        if (collection.indexOf) return collection.indexOf(elt);
        for (var i = 0, e = collection.length; i < e; ++i) if (collection[i] == elt) return i;
        return -1;
    }
    function closingTagExists(cm, context, tagName, pos, newTag) {
        if (CodeMirror.scanForClosingTag) {
            var end = Math.min(cm.lastLine() + 1, pos.line + 500), nextClose = CodeMirror.scanForClosingTag(cm, pos, null, end);
            if (nextClose && nextClose.tag == tagName) {
                for (var onCx = newTag ? 1 : 0, i = context.length - 1; 0 <= i && context[i] == tagName; i--) ++onCx;
                pos = nextClose.to;
                for (i = 1; i < onCx; i++) {
                    var next = CodeMirror.scanForClosingTag(cm, pos, null, end);
                    if (!next || next.tag != tagName) return;
                    pos = next.to;
                }
                return 1;
            }
        }
    }
    CodeMirror.commands.closeTag = function(cm) {
        return autoCloseCurrent(cm);
    };
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    var ie_lt8 = /MSIE \d/.test(navigator.userAgent) && (null == document.documentMode || document.documentMode < 8), Pos = CodeMirror.Pos, matching = {
        "(": ")>",
        ")": "(<",
        "[": "]>",
        "]": "[<",
        "{": "}>",
        "}": "{<",
        "<": ">>",
        ">": "<<"
    };
    function bracketRegex(config) {
        return config && config.bracketRegex || /[(){}[\]]/;
    }
    function findMatchingBracket(cm, where, config) {
        var line = cm.getLineHandle(where.line), pos = where.ch - 1, afterCursor = config && config.afterCursor, re = (null == afterCursor && (afterCursor = /(^| )cm-fat-cursor($| )/.test(cm.getWrapperElement().className)), 
        bracketRegex(config)), afterCursor = !afterCursor && 0 <= pos && re.test(line.text.charAt(pos)) && matching[line.text.charAt(pos)] || re.test(line.text.charAt(pos + 1)) && matching[line.text.charAt(++pos)];
        return !afterCursor || (re = ">" == afterCursor.charAt(1) ? 1 : -1, config && config.strict && 0 < re != (pos == where.ch)) || (line = cm.getTokenTypeAt(Pos(where.line, pos + 1)), 
        null == (cm = scanForBracket(cm, Pos(where.line, pos + (0 < re ? 1 : 0)), re, line, config))) ? null : {
            from: Pos(where.line, pos),
            to: cm && cm.pos,
            match: cm && cm.ch == afterCursor.charAt(0),
            forward: 0 < re
        };
    }
    function scanForBracket(cm, where, dir, style, config) {
        for (var maxScanLen = config && config.maxScanLineLength || 1e4, maxScanLines = config && config.maxScanLines || 1e3, stack = [], re = bracketRegex(config), lineEnd = 0 < dir ? Math.min(where.line + maxScanLines, cm.lastLine() + 1) : Math.max(cm.firstLine() - 1, where.line - maxScanLines), lineNo = where.line; lineNo != lineEnd; lineNo += dir) {
            var line = cm.getLine(lineNo);
            if (line) {
                var pos = 0 < dir ? 0 : line.length - 1, end = 0 < dir ? line.length : -1;
                if (!(line.length > maxScanLen)) for (lineNo == where.line && (pos = where.ch - (dir < 0 ? 1 : 0)); pos != end; pos += dir) {
                    var ch = line.charAt(pos);
                    if (re.test(ch) && (void 0 === style || (cm.getTokenTypeAt(Pos(lineNo, pos + 1)) || "") == (style || ""))) {
                        var match = matching[ch];
                        if (match && ">" == match.charAt(1) == 0 < dir) stack.push(ch); else {
                            if (!stack.length) return {
                                pos: Pos(lineNo, pos),
                                ch: ch
                            };
                            stack.pop();
                        }
                    }
                }
            }
        }
        return lineNo - dir != (0 < dir ? cm.lastLine() : cm.firstLine()) && null;
    }
    function matchBrackets(cm, autoclear, config) {
        for (var maxHighlightLen = cm.state.matchBrackets.maxHighlightLineLength || 1e3, highlightNonMatching = config && config.highlightNonMatching, marks = [], ranges = cm.listSelections(), i = 0; i < ranges.length; i++) {
            var style, match = ranges[i].empty() && findMatchingBracket(cm, ranges[i].head, config);
            match && (match.match || !1 !== highlightNonMatching) && cm.getLine(match.from.line).length <= maxHighlightLen && (style = match.match ? "CodeMirror-matchingbracket" : "CodeMirror-nonmatchingbracket", 
            marks.push(cm.markText(match.from, Pos(match.from.line, match.from.ch + 1), {
                className: style
            })), match.to) && cm.getLine(match.to.line).length <= maxHighlightLen && marks.push(cm.markText(match.to, Pos(match.to.line, match.to.ch + 1), {
                className: style
            }));
        }
        if (marks.length) {
            ie_lt8 && cm.state.focused && cm.focus();
            function clear() {
                cm.operation(function() {
                    for (var i = 0; i < marks.length; i++) marks[i].clear();
                });
            }
            if (!autoclear) return clear;
            setTimeout(clear, 800);
        }
    }
    function doMatchBrackets(cm) {
        cm.operation(function() {
            cm.state.matchBrackets.currentlyHighlighted && (cm.state.matchBrackets.currentlyHighlighted(), 
            cm.state.matchBrackets.currentlyHighlighted = null), cm.state.matchBrackets.currentlyHighlighted = matchBrackets(cm, !1, cm.state.matchBrackets);
        });
    }
    function clearHighlighted(cm) {
        cm.state.matchBrackets && cm.state.matchBrackets.currentlyHighlighted && (cm.state.matchBrackets.currentlyHighlighted(), 
        cm.state.matchBrackets.currentlyHighlighted = null);
    }
    CodeMirror.defineOption("matchBrackets", !1, function(cm, val, old) {
        old && old != CodeMirror.Init && (cm.off("cursorActivity", doMatchBrackets), 
        cm.off("focus", doMatchBrackets), cm.off("blur", clearHighlighted), clearHighlighted(cm)), 
        val && (cm.state.matchBrackets = "object" == typeof val ? val : {}, cm.on("cursorActivity", doMatchBrackets), 
        cm.on("focus", doMatchBrackets), cm.on("blur", clearHighlighted));
    }), CodeMirror.defineExtension("matchBrackets", function() {
        matchBrackets(this, !0);
    }), CodeMirror.defineExtension("findMatchingBracket", function(pos, config, oldConfig) {
        return findMatchingBracket(this, pos, config = !oldConfig && "boolean" != typeof config ? config : oldConfig ? (oldConfig.strict = config, 
        oldConfig) : config ? {
            strict: !0
        } : null);
    }), CodeMirror.defineExtension("scanForBracket", function(pos, dir, style, config) {
        return scanForBracket(this, pos, dir, style, config);
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    var WRAP_CLASS = "CodeMirror-activeline", BACK_CLASS = "CodeMirror-activeline-background", GUTT_CLASS = "CodeMirror-activeline-gutter";
    function clearActiveLines(cm) {
        for (var i = 0; i < cm.state.activeLines.length; i++) cm.removeLineClass(cm.state.activeLines[i], "wrap", WRAP_CLASS), 
        cm.removeLineClass(cm.state.activeLines[i], "background", BACK_CLASS), cm.removeLineClass(cm.state.activeLines[i], "gutter", GUTT_CLASS);
    }
    function updateActiveLines(cm, ranges) {
        for (var active = [], i = 0; i < ranges.length; i++) {
            var range = ranges[i], option = cm.getOption("styleActiveLine");
            ("object" == typeof option && option.nonEmpty ? range.anchor.line == range.head.line : range.empty()) && (option = cm.getLineHandleVisualStart(range.head.line), 
            active[active.length - 1] != option) && active.push(option);
        }
        !function(a, b) {
            if (a.length == b.length) {
                for (var i = 0; i < a.length; i++) if (a[i] != b[i]) return;
                return 1;
            }
        }(cm.state.activeLines, active) && cm.operation(function() {
            clearActiveLines(cm);
            for (var i = 0; i < active.length; i++) cm.addLineClass(active[i], "wrap", WRAP_CLASS), 
            cm.addLineClass(active[i], "background", BACK_CLASS), cm.addLineClass(active[i], "gutter", GUTT_CLASS);
            cm.state.activeLines = active;
        });
    }
    function selectionChange(cm, sel) {
        updateActiveLines(cm, sel.ranges);
    }
    CodeMirror.defineOption("styleActiveLine", !1, function(cm, val, old) {
        old = old != CodeMirror.Init && old;
        val != old && (old && (cm.off("beforeSelectionChange", selectionChange), 
        clearActiveLines(cm), delete cm.state.activeLines), val) && (cm.state.activeLines = [], 
        updateActiveLines(cm, cm.listSelections()), cm.on("beforeSelectionChange", selectionChange));
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    function onCursorActivity(cm) {
        cm.state.markedSelection && cm.operation(function() {
            !function(cm) {
                if (!cm.somethingSelected()) return clear(cm);
                if (1 < cm.listSelections().length) return reset(cm);
                var from = cm.getCursor("start"), to = cm.getCursor("end"), array = cm.state.markedSelection;
                if (!array.length) return coverRange(cm, from, to);
                var coverStart = array[0].find(), coverEnd = array[array.length - 1].find();
                if (!coverStart || !coverEnd || to.line - from.line <= CHUNK_SIZE || 0 <= cmp(from, coverEnd.to) || cmp(to, coverStart.from) <= 0) return reset(cm);
                for (;0 < cmp(from, coverStart.from); ) array.shift().clear(), coverStart = array[0].find();
                cmp(from, coverStart.from) < 0 && (coverStart.to.line - from.line < CHUNK_SIZE ? (array.shift().clear(), 
                coverRange(cm, from, coverStart.to, 0)) : coverRange(cm, from, coverStart.from, 0));
                for (;cmp(to, coverEnd.to) < 0; ) array.pop().clear(), coverEnd = array[array.length - 1].find();
                0 < cmp(to, coverEnd.to) && (to.line - coverEnd.from.line < CHUNK_SIZE ? (array.pop().clear(), 
                coverRange(cm, coverEnd.from, to)) : coverRange(cm, coverEnd.to, to));
            }(cm);
        });
    }
    function onChange(cm) {
        cm.state.markedSelection && cm.state.markedSelection.length && cm.operation(function() {
            clear(cm);
        });
    }
    CodeMirror.defineOption("styleSelectedText", !1, function(cm, val, old) {
        old = old && old != CodeMirror.Init;
        val && !old ? (cm.state.markedSelection = [], cm.state.markedSelectionStyle = "string" == typeof val ? val : "CodeMirror-selectedtext", 
        reset(cm), cm.on("cursorActivity", onCursorActivity), cm.on("change", onChange)) : !val && old && (cm.off("cursorActivity", onCursorActivity), 
        cm.off("change", onChange), clear(cm), cm.state.markedSelection = cm.state.markedSelectionStyle = null);
    });
    var CHUNK_SIZE = 8, Pos = CodeMirror.Pos, cmp = CodeMirror.cmpPos;
    function coverRange(cm, from, to, addAt) {
        if (0 != cmp(from, to)) for (var array = cm.state.markedSelection, cls = cm.state.markedSelectionStyle, line = from.line; ;) {
            var start = line == from.line ? from : Pos(line, 0), endLine = line + CHUNK_SIZE, atEnd = endLine >= to.line, end = atEnd ? to : Pos(endLine, 0), start = cm.markText(start, end, {
                className: cls
            });
            if (null == addAt ? array.push(start) : array.splice(addAt++, 0, start), 
            atEnd) break;
            line = endLine;
        }
    }
    function clear(cm) {
        for (var array = cm.state.markedSelection, i = 0; i < array.length; ++i) array[i].clear();
        array.length = 0;
    }
    function reset(cm) {
        clear(cm);
        for (var ranges = cm.listSelections(), i = 0; i < ranges.length; i++) coverRange(cm, ranges[i].from(), ranges[i].to());
    }
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror"), require("./matchesonscrollbar")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror", "./matchesonscrollbar" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    var defaults = {
        style: "matchhighlight",
        minChars: 2,
        delay: 100,
        wordsOnly: !1,
        annotateScrollbar: !1,
        showToken: !1,
        trim: !0
    };
    function State(options) {
        for (var name in this.options = {}, defaults) this.options[name] = (options && options.hasOwnProperty(name) ? options : defaults)[name];
        this.overlay = this.timeout = null, this.matchesonscroll = null, this.active = !1;
    }
    function cursorActivity(cm) {
        var state = cm.state.matchHighlighter;
        (state.active || cm.hasFocus()) && scheduleHighlight(cm, state);
    }
    function onFocus(cm) {
        var state = cm.state.matchHighlighter;
        state.active || (state.active = !0, scheduleHighlight(cm, state));
    }
    function scheduleHighlight(cm, state) {
        clearTimeout(state.timeout), state.timeout = setTimeout(function() {
            highlightMatches(cm);
        }, state.options.delay);
    }
    function addOverlay(cm, query, hasBoundary, style) {
        var state = cm.state.matchHighlighter;
        cm.addOverlay(state.overlay = function(query, hasBoundary, style) {
            return {
                token: function(stream) {
                    if (stream.match(query) && (!hasBoundary || function(stream, re) {
                        return !(stream.start && re.test(stream.string.charAt(stream.start - 1)) || stream.pos != stream.string.length && re.test(stream.string.charAt(stream.pos)));
                    }(stream, hasBoundary))) return style;
                    stream.next(), stream.skipTo(query.charAt(0)) || stream.skipToEnd();
                }
            };
        }(query, hasBoundary, style)), state.options.annotateScrollbar && cm.showMatchesOnScrollbar && (style = hasBoundary ? new RegExp((/\w/.test(query.charAt(0)) ? "\\b" : "") + query.replace(/[\\\[.+*?(){|^$]/g, "\\$&") + (/\w/.test(query.charAt(query.length - 1)) ? "\\b" : "")) : query, 
        state.matchesonscroll = cm.showMatchesOnScrollbar(style, !1, {
            className: "CodeMirror-selection-highlight-scrollbar"
        }));
    }
    function removeOverlay(cm) {
        var state = cm.state.matchHighlighter;
        state.overlay && (cm.removeOverlay(state.overlay), state.overlay = null, 
        state.matchesonscroll) && (state.matchesonscroll.clear(), state.matchesonscroll = null);
    }
    function highlightMatches(cm) {
        cm.operation(function() {
            var state = cm.state.matchHighlighter;
            if (removeOverlay(cm), !cm.somethingSelected() && state.options.showToken) {
                for (var re = !0 === state.options.showToken ? /[\w$]/ : state.options.showToken, cur = cm.getCursor(), line = cm.getLine(cur.line), start = cur.ch, end = start; start && re.test(line.charAt(start - 1)); ) --start;
                for (;end < line.length && re.test(line.charAt(end)); ) ++end;
                start < end && addOverlay(cm, line.slice(start, end), re, state.options.style);
            } else {
                var cur = cm.getCursor("from"), to = cm.getCursor("to");
                cur.line != to.line || state.options.wordsOnly && !function(cm, from, to) {
                    if (null !== cm.getRange(from, to).match(/^\w+$/)) {
                        if (0 < from.ch) {
                            var pos = {
                                line: from.line,
                                ch: from.ch - 1
                            };
                            if (null === cm.getRange(pos, from).match(/\W/)) return;
                        }
                        if (to.ch < cm.getLine(from.line).length) {
                            pos = {
                                line: to.line,
                                ch: to.ch + 1
                            };
                            if (null === cm.getRange(to, pos).match(/\W/)) return;
                        }
                        return 1;
                    }
                }(cm, cur, to) || (cur = cm.getRange(cur, to), (cur = state.options.trim ? cur.replace(/^\s+|\s+$/g, "") : cur).length >= state.options.minChars && addOverlay(cm, cur, !1, state.options.style));
            }
        });
    }
    CodeMirror.defineOption("highlightSelectionMatches", !1, function(cm, val, old) {
        old && old != CodeMirror.Init && (removeOverlay(cm), clearTimeout(cm.state.matchHighlighter.timeout), 
        cm.state.matchHighlighter = null, cm.off("cursorActivity", cursorActivity), 
        cm.off("focus", onFocus)), val && (old = cm.state.matchHighlighter = new State(val), 
        cm.hasFocus() ? (old.active = !0, highlightMatches(cm)) : cm.on("focus", onFocus), 
        cm.on("cursorActivity", cursorActivity));
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror"), require("./searchcursor"), require("../dialog/dialog")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror", "./searchcursor", "../dialog/dialog" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    function SearchState() {
        this.posFrom = this.posTo = this.lastQuery = this.query = null, this.overlay = null;
    }
    function getSearchState(cm) {
        return cm.state.search || (cm.state.search = new SearchState());
    }
    function queryCaseInsensitive(query) {
        return "string" == typeof query && query == query.toLowerCase();
    }
    function getSearchCursor(cm, query, pos) {
        return cm.getSearchCursor(query, pos, {
            caseFold: queryCaseInsensitive(query),
            multiline: !0
        });
    }
    function dialog(cm, text, shortText, deflt, f) {
        cm.openDialog ? cm.openDialog(text, f, {
            value: deflt,
            selectValueOnOpen: !0,
            bottom: cm.options.search.bottom
        }) : f(prompt(shortText, deflt));
    }
    function parseString(string) {
        return string.replace(/\\([nrt\\])/g, function(match, ch) {
            return "n" == ch ? "\n" : "r" == ch ? "\r" : "t" == ch ? "\t" : "\\" == ch ? "\\" : match;
        });
    }
    function parseQuery(query) {
        var isRE = query.match(/^\/(.*)\/([a-z]*)$/);
        if (isRE) try {
            query = new RegExp(isRE[1], -1 == isRE[2].indexOf("i") ? "" : "i");
        } catch (e) {} else query = parseString(query);
        return query = ("string" == typeof query ? "" == query : query.test("")) ? /x^/ : query;
    }
    function startSearch(cm, state, query) {
        state.queryText = query, state.query = parseQuery(query), cm.removeOverlay(state.overlay, queryCaseInsensitive(state.query)), 
        state.overlay = function(query, caseInsensitive) {
            return "string" == typeof query ? query = new RegExp(query.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&"), caseInsensitive ? "gi" : "g") : query.global || (query = new RegExp(query.source, query.ignoreCase ? "gi" : "g")), 
            {
                token: function(stream) {
                    query.lastIndex = stream.pos;
                    var match = query.exec(stream.string);
                    if (match && match.index == stream.pos) return stream.pos += match[0].length || 1, 
                    "searching";
                    match ? stream.pos = match.index : stream.skipToEnd();
                }
            };
        }(state.query, queryCaseInsensitive(state.query)), cm.addOverlay(state.overlay), 
        cm.showMatchesOnScrollbar && (state.annotate && (state.annotate.clear(), 
        state.annotate = null), state.annotate = cm.showMatchesOnScrollbar(state.query, queryCaseInsensitive(state.query)));
    }
    function doSearch(cm, rev, persistent, immediate) {
        var state = getSearchState(cm);
        if (state.query) return findNext(cm, rev);
        var hiding, searchNext, q = cm.getSelection() || state.lastQuery;
        q instanceof RegExp && "x^" == q.source && (q = null), persistent && cm.openDialog ? (hiding = null, 
        searchNext = function(query, event) {
            CodeMirror.e_stop(event), query && (query != state.queryText && (startSearch(cm, state, query), 
            state.posFrom = state.posTo = cm.getCursor()), hiding && (hiding.style.opacity = 1), 
            findNext(cm, event.shiftKey, function(_, to) {
                var dialog;
                to.line < 3 && document.querySelector && (dialog = cm.display.wrapper.querySelector(".CodeMirror-dialog")) && dialog.getBoundingClientRect().bottom - 4 > cm.cursorCoords(to, "window").top && ((hiding = dialog).style.opacity = .4);
            }));
        }, function(cm, text, deflt, onEnter, onKeyDown) {
            cm.openDialog(text, onEnter, {
                value: deflt,
                selectValueOnOpen: !0,
                closeOnEnter: !1,
                onClose: function() {
                    clearSearch(cm);
                },
                onKeyDown: onKeyDown,
                bottom: cm.options.search.bottom
            });
        }(cm, getQueryDialog(cm), q, searchNext, function(event, query) {
            var keyName = CodeMirror.keyName(event), extra = cm.getOption("extraKeys"), extra = extra && extra[keyName] || CodeMirror.keyMap[cm.getOption("keyMap")][keyName];
            "findNext" == extra || "findPrev" == extra || "findPersistentNext" == extra || "findPersistentPrev" == extra ? (CodeMirror.e_stop(event), 
            startSearch(cm, getSearchState(cm), query), cm.execCommand(extra)) : "find" != extra && "findPersistent" != extra || (CodeMirror.e_stop(event), 
            searchNext(query, event));
        }), immediate && q && (startSearch(cm, state, q), findNext(cm, rev))) : dialog(cm, getQueryDialog(cm), "Search for:", q, function(query) {
            query && !state.query && cm.operation(function() {
                startSearch(cm, state, query), state.posFrom = state.posTo = cm.getCursor(), 
                findNext(cm, rev);
            });
        });
    }
    function findNext(cm, rev, callback) {
        cm.operation(function() {
            var state = getSearchState(cm), cursor = getSearchCursor(cm, state.query, rev ? state.posFrom : state.posTo);
            (cursor.find(rev) || (cursor = getSearchCursor(cm, state.query, rev ? CodeMirror.Pos(cm.lastLine()) : CodeMirror.Pos(cm.firstLine(), 0))).find(rev)) && (cm.setSelection(cursor.from(), cursor.to()), 
            cm.scrollIntoView({
                from: cursor.from(),
                to: cursor.to()
            }, 20), state.posFrom = cursor.from(), state.posTo = cursor.to(), callback) && callback(cursor.from(), cursor.to());
        });
    }
    function clearSearch(cm) {
        cm.operation(function() {
            var state = getSearchState(cm);
            state.lastQuery = state.query, state.query && (state.query = state.queryText = null, 
            cm.removeOverlay(state.overlay), state.annotate) && (state.annotate.clear(), 
            state.annotate = null);
        });
    }
    function el(tag, attrs) {
        var key, element = tag ? document.createElement(tag) : document.createDocumentFragment();
        for (key in attrs) element[key] = attrs[key];
        for (var i = 2; i < arguments.length; i++) {
            var child = arguments[i];
            element.appendChild("string" == typeof child ? document.createTextNode(child) : child);
        }
        return element;
    }
    function getQueryDialog(cm) {
        var label = el("label", {
            className: "CodeMirror-search-label"
        }, cm.phrase("Search:"), el("input", {
            type: "text",
            style: "width: 10em",
            className: "CodeMirror-search-field",
            id: "CodeMirror-search-field"
        }));
        return label.setAttribute("for", "CodeMirror-search-field"), el("", null, label, " ", el("span", {
            style: "color: #666",
            className: "CodeMirror-search-hint"
        }, cm.phrase("(Use /re/ syntax for regexp search)")));
    }
    function replaceAll(cm, query, text) {
        cm.operation(function() {
            for (var match, cursor = getSearchCursor(cm, query); cursor.findNext(); ) "string" != typeof query ? (match = cm.getRange(cursor.from(), cursor.to()).match(query), 
            cursor.replace(text.replace(/\$(\d)/g, function(_, i) {
                return match[i];
            }))) : cursor.replace(text);
        });
    }
    function replace(cm, all) {
        var query, dialogText, fragment;
        cm.getOption("readOnly") || (query = cm.getSelection() || getSearchState(cm).lastQuery, 
        fragment = el("", null, el("span", {
            className: "CodeMirror-search-label"
        }, dialogText = all ? cm.phrase("Replace all:") : cm.phrase("Replace:")), function(cm) {
            return el("", null, " ", el("input", {
                type: "text",
                style: "width: 10em",
                className: "CodeMirror-search-field"
            }), " ", el("span", {
                style: "color: #666",
                className: "CodeMirror-search-hint"
            }, cm.phrase("(Use /re/ syntax for regexp search)")));
        }(cm)), dialog(cm, fragment, dialogText, query, function(query) {
            query && (query = parseQuery(query), dialog(cm, function(cm) {
                return el("", null, el("span", {
                    className: "CodeMirror-search-label"
                }, cm.phrase("With:")), " ", el("input", {
                    type: "text",
                    style: "width: 10em",
                    className: "CodeMirror-search-field"
                }));
            }(cm), cm.phrase("Replace with:"), "", function(text) {
                var cursor, advance, doReplace;
                text = parseString(text), all ? replaceAll(cm, query, text) : (clearSearch(cm), 
                cursor = getSearchCursor(cm, query, cm.getCursor("from")), doReplace = function(match) {
                    cursor.replace("string" == typeof query ? text : text.replace(/\$(\d)/g, function(_, i) {
                        return match[i];
                    })), advance();
                }, (advance = function() {
                    var match, start = cursor.from();
                    !(match = cursor.findNext()) && (cursor = getSearchCursor(cm, query), 
                    !(match = cursor.findNext()) || start && cursor.from().line == start.line && cursor.from().ch == start.ch) || (cm.setSelection(cursor.from(), cursor.to()), 
                    cm.scrollIntoView({
                        from: cursor.from(),
                        to: cursor.to()
                    }), function(cm, text, shortText, fs) {
                        cm.openConfirm ? cm.openConfirm(text, fs) : confirm(shortText) && fs[0]();
                    }(cm, function(cm) {
                        return el("", null, el("span", {
                            className: "CodeMirror-search-label"
                        }, cm.phrase("Replace?")), " ", el("button", {}, cm.phrase("Yes")), " ", el("button", {}, cm.phrase("No")), " ", el("button", {}, cm.phrase("All")), " ", el("button", {}, cm.phrase("Stop")));
                    }(cm), cm.phrase("Replace?"), [ function() {
                        doReplace(match);
                    }, advance, function() {
                        replaceAll(cm, query, text);
                    } ]));
                })());
            }));
        }));
    }
    CodeMirror.defineOption("search", {
        bottom: !1
    }), CodeMirror.commands.find = function(cm) {
        clearSearch(cm), doSearch(cm);
    }, CodeMirror.commands.findPersistent = function(cm) {
        clearSearch(cm), doSearch(cm, !1, !0);
    }, CodeMirror.commands.findPersistentNext = function(cm) {
        doSearch(cm, !1, !0, !0);
    }, CodeMirror.commands.findPersistentPrev = function(cm) {
        doSearch(cm, !0, !0, !0);
    }, CodeMirror.commands.findNext = doSearch, CodeMirror.commands.findPrev = function(cm) {
        doSearch(cm, !0);
    }, CodeMirror.commands.clearSearch = clearSearch, CodeMirror.commands.replace = replace, 
    CodeMirror.commands.replaceAll = function(cm) {
        replace(cm, !0);
    };
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    var doFold, noFold, Pos = CodeMirror.Pos;
    function ensureFlags(regexp, flags) {
        for (var current = function(regexp) {
            var flags = regexp.flags;
            return null != flags ? flags : (regexp.ignoreCase ? "i" : "") + (regexp.global ? "g" : "") + (regexp.multiline ? "m" : "");
        }(regexp), target = current, i = 0; i < flags.length; i++) -1 == target.indexOf(flags.charAt(i)) && (target += flags.charAt(i));
        return current == target ? regexp : new RegExp(regexp.source, target);
    }
    function maybeMultiline(regexp) {
        return /\\s|\\n|\n|\\W|\\D|\[\^/.test(regexp.source);
    }
    function searchRegexpForward(doc, regexp, start) {
        regexp = ensureFlags(regexp, "g");
        for (var line = start.line, ch = start.ch, last = doc.lastLine(); line <= last; line++, 
        ch = 0) {
            regexp.lastIndex = ch;
            var string = doc.getLine(line), string = regexp.exec(string);
            if (string) return {
                from: Pos(line, string.index),
                to: Pos(line, string.index + string[0].length),
                match: string
            };
        }
    }
    function searchRegexpForwardMultiline(doc, regexp, start) {
        if (!maybeMultiline(regexp)) return searchRegexpForward(doc, regexp, start);
        regexp = ensureFlags(regexp, "gm");
        for (var chunk = 1, line = start.line, last = doc.lastLine(); line <= last; ) {
            for (var i = 0; i < chunk && !(last < line); i++) var curLine = doc.getLine(line++), string = null == string ? curLine : string + "\n" + curLine;
            chunk *= 2, regexp.lastIndex = start.ch;
            var inside, startLine, before, match = regexp.exec(string);
            if (match) return before = string.slice(0, match.index).split("\n"), 
            inside = match[0].split("\n"), startLine = start.line + before.length - 1, 
            before = before[before.length - 1].length, {
                from: Pos(startLine, before),
                to: Pos(startLine + inside.length - 1, 1 == inside.length ? before + inside[0].length : inside[inside.length - 1].length),
                match: match
            };
        }
    }
    function lastMatchIn(string, regexp, endMargin) {
        for (var match, from = 0; from <= string.length; ) {
            regexp.lastIndex = from;
            var newMatch = regexp.exec(string);
            if (!newMatch) break;
            var end = newMatch.index + newMatch[0].length;
            if (end > string.length - endMargin) break;
            (!match || end > match.index + match[0].length) && (match = newMatch), 
            from = newMatch.index + 1;
        }
        return match;
    }
    function searchRegexpBackward(doc, regexp, start) {
        regexp = ensureFlags(regexp, "g");
        for (var line = start.line, ch = start.ch, first = doc.firstLine(); first <= line; line--, 
        ch = -1) {
            var string = doc.getLine(line), string = lastMatchIn(string, regexp, ch < 0 ? 0 : string.length - ch);
            if (string) return {
                from: Pos(line, string.index),
                to: Pos(line, string.index + string[0].length),
                match: string
            };
        }
    }
    function searchRegexpBackwardMultiline(doc, regexp, start) {
        if (!maybeMultiline(regexp)) return searchRegexpBackward(doc, regexp, start);
        regexp = ensureFlags(regexp, "gm");
        for (var chunkSize = 1, endMargin = doc.getLine(start.line).length - start.ch, line = start.line, first = doc.firstLine(); first <= line; ) {
            for (var i = 0; i < chunkSize && first <= line; i++) var curLine = doc.getLine(line--), string = null == string ? curLine : curLine + "\n" + string;
            chunkSize *= 2;
            var inside, startLine, before, match = lastMatchIn(string, regexp, endMargin);
            if (match) return before = string.slice(0, match.index).split("\n"), 
            inside = match[0].split("\n"), startLine = line + before.length, before = before[before.length - 1].length, 
            {
                from: Pos(startLine, before),
                to: Pos(startLine + inside.length - 1, 1 == inside.length ? before + inside[0].length : inside[inside.length - 1].length),
                match: match
            };
        }
    }
    function adjustPos(orig, folded, pos, foldFunc) {
        if (orig.length == folded.length) return pos;
        for (var min = 0, max = pos + Math.max(0, orig.length - folded.length); ;) {
            if (min == max) return min;
            var mid = min + max >> 1, len = foldFunc(orig.slice(0, mid)).length;
            if (len == pos) return mid;
            pos < len ? max = mid : min = 1 + mid;
        }
    }
    function searchStringForward(doc, query, start, caseFold) {
        if (!query.length) return null;
        var fold = caseFold ? doFold : noFold, lines = fold(query).split(/\r|\n\r?/);
        search: for (var line = start.line, ch = start.ch, last = doc.lastLine() + 1 - lines.length; line <= last; line++, 
        ch = 0) {
            var orig = doc.getLine(line).slice(ch), string = fold(orig);
            if (1 == lines.length) {
                var found = string.indexOf(lines[0]);
                if (-1 != found) return start = adjustPos(orig, string, found, fold) + ch, 
                {
                    from: Pos(line, adjustPos(orig, string, found, fold) + ch),
                    to: Pos(line, adjustPos(orig, string, found + lines[0].length, fold) + ch)
                };
            } else {
                found = string.length - lines[0].length;
                if (string.slice(found) == lines[0]) {
                    for (var i = 1; i < lines.length - 1; i++) if (fold(doc.getLine(line + i)) != lines[i]) continue search;
                    var end = doc.getLine(line + lines.length - 1), endString = fold(end), lastLine = lines[lines.length - 1];
                    if (endString.slice(0, lastLine.length) == lastLine) return {
                        from: Pos(line, adjustPos(orig, string, found, fold) + ch),
                        to: Pos(line + lines.length - 1, adjustPos(end, endString, lastLine.length, fold))
                    };
                }
            }
        }
    }
    function searchStringBackward(doc, query, start, caseFold) {
        if (!query.length) return null;
        var fold = caseFold ? doFold : noFold, lines = fold(query).split(/\r|\n\r?/);
        search: for (var line = start.line, ch = start.ch, first = doc.firstLine() - 1 + lines.length; first <= line; line--, 
        ch = -1) {
            var orig = doc.getLine(line), string = fold(orig = -1 < ch ? orig.slice(0, ch) : orig);
            if (1 == lines.length) {
                var found = string.lastIndexOf(lines[0]);
                if (-1 != found) return {
                    from: Pos(line, adjustPos(orig, string, found, fold)),
                    to: Pos(line, adjustPos(orig, string, found + lines[0].length, fold))
                };
            } else {
                found = lines[lines.length - 1];
                if (string.slice(0, found.length) == found) {
                    for (var i = 1, start = line - lines.length + 1; i < lines.length - 1; i++) if (fold(doc.getLine(start + i)) != lines[i]) continue search;
                    var top = doc.getLine(line + 1 - lines.length), topString = fold(top);
                    if (topString.slice(topString.length - lines[0].length) == lines[0]) return {
                        from: Pos(line + 1 - lines.length, adjustPos(top, topString, top.length - lines[0].length, fold)),
                        to: Pos(line, adjustPos(orig, string, found.length, fold))
                    };
                }
            }
        }
    }
    function SearchCursor(doc, query, pos, options) {
        var caseFold;
        this.atOccurrence = !1, this.afterEmptyMatch = !1, this.doc = doc, pos = pos ? doc.clipPos(pos) : Pos(0, 0), 
        this.pos = {
            from: pos,
            to: pos
        }, "object" == typeof options ? caseFold = options.caseFold : (caseFold = options, 
        options = null), "string" == typeof query ? (null == caseFold && (caseFold = !1), 
        this.matches = function(reverse, pos) {
            return (reverse ? searchStringBackward : searchStringForward)(doc, query, pos, caseFold);
        }) : (query = ensureFlags(query, "gm"), options && !1 === options.multiline ? this.matches = function(reverse, pos) {
            return (reverse ? searchRegexpBackward : searchRegexpForward)(doc, query, pos);
        } : this.matches = function(reverse, pos) {
            return (reverse ? searchRegexpBackwardMultiline : searchRegexpForwardMultiline)(doc, query, pos);
        });
    }
    noFold = String.prototype.normalize ? (doFold = function(str) {
        return str.normalize("NFD").toLowerCase();
    }, function(str) {
        return str.normalize("NFD");
    }) : (doFold = function(str) {
        return str.toLowerCase();
    }, function(str) {
        return str;
    }), SearchCursor.prototype = {
        findNext: function() {
            return this.find(!1);
        },
        findPrevious: function() {
            return this.find(!0);
        },
        find: function(reverse) {
            var head = this.doc.clipPos(reverse ? this.pos.from : this.pos.to);
            return this.afterEmptyMatch && this.atOccurrence && (head = Pos(head.line, head.ch), 
            reverse ? (head.ch--, head.ch < 0 && (head.line--, head.ch = (this.doc.getLine(head.line) || "").length)) : (head.ch++, 
            head.ch > (this.doc.getLine(head.line) || "").length && (head.ch = 0, 
            head.line++)), 0 != CodeMirror.cmpPos(head, this.doc.clipPos(head))) ? this.atOccurrence = !1 : (head = this.matches(reverse, head), 
            this.afterEmptyMatch = head && 0 == CodeMirror.cmpPos(head.from, head.to), 
            head ? (this.pos = head, this.atOccurrence = !0, this.pos.match || !0) : (head = Pos(reverse ? this.doc.firstLine() : this.doc.lastLine() + 1, 0), 
            this.pos = {
                from: head,
                to: head
            }, this.atOccurrence = !1));
        },
        from: function() {
            if (this.atOccurrence) return this.pos.from;
        },
        to: function() {
            if (this.atOccurrence) return this.pos.to;
        },
        replace: function(newText, origin) {
            this.atOccurrence && (newText = CodeMirror.splitLines(newText), this.doc.replaceRange(newText, this.pos.from, this.pos.to, origin), 
            this.pos.to = Pos(this.pos.from.line + newText.length - 1, newText[newText.length - 1].length + (1 == newText.length ? this.pos.from.ch : 0)));
        }
    }, CodeMirror.defineExtension("getSearchCursor", function(query, pos, caseFold) {
        return new SearchCursor(this.doc, query, pos, caseFold);
    }), CodeMirror.defineDocExtension("getSearchCursor", function(query, pos, caseFold) {
        return new SearchCursor(this, query, pos, caseFold);
    }), CodeMirror.defineExtension("selectMatches", function(query, caseFold) {
        for (var ranges = [], cur = this.getSearchCursor(query, this.getCursor("from"), caseFold); cur.findNext() && !(0 < CodeMirror.cmpPos(cur.to(), this.getCursor("to"))); ) ranges.push({
            anchor: cur.from(),
            head: cur.to()
        });
        ranges.length && this.setSelections(ranges, 0);
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    function doFold(cm, pos, options, force) {
        options && options.call ? (finder = options, options = null) : finder = getOption(cm, options, "rangeFinder"), 
        "number" == typeof pos && (pos = CodeMirror.Pos(pos, 0));
        var finder, minSize = getOption(cm, options, "minFoldSize");
        function getRange(allowFolded) {
            var range = finder(cm, pos);
            if (!range || range.to.line - range.from.line < minSize) return null;
            if ("fold" !== force) for (var marks = cm.findMarksAt(range.from), i = 0; i < marks.length; ++i) if (marks[i].__isFold) {
                if (!allowFolded) return null;
                range.cleared = !0, marks[i].clear();
            }
            return range;
        }
        var myWidget, myRange, range = getRange(!0);
        if (getOption(cm, options, "scanUp")) for (;!range && pos.line > cm.firstLine(); ) pos = CodeMirror.Pos(pos.line - 1, 0), 
        range = getRange(!1);
        range && !range.cleared && "unfold" !== force && (myWidget = function(cm, options, range) {
            cm = getOption(cm, options, "widget");
            "function" == typeof cm && (cm = cm(range.from, range.to));
            "string" == typeof cm ? (options = document.createTextNode(cm), (cm = document.createElement("span")).appendChild(options), 
            cm.className = "CodeMirror-foldmarker") : cm = cm && cm.cloneNode(!0);
            return cm;
        }(cm, options, range), CodeMirror.on(myWidget, "mousedown", function(e) {
            myRange.clear(), CodeMirror.e_preventDefault(e);
        }), (myRange = cm.markText(range.from, range.to, {
            replacedWith: myWidget,
            clearOnEnter: getOption(cm, options, "clearOnEnter"),
            __isFold: !0
        })).on("clear", function(from, to) {
            CodeMirror.signal(cm, "unfold", cm, from, to);
        }), CodeMirror.signal(cm, "fold", cm, range.from, range.to));
    }
    CodeMirror.newFoldFunction = function(rangeFinder, widget) {
        return function(cm, pos) {
            doFold(cm, pos, {
                rangeFinder: rangeFinder,
                widget: widget
            });
        };
    }, CodeMirror.defineExtension("foldCode", function(pos, options, force) {
        doFold(this, pos, options, force);
    }), CodeMirror.defineExtension("isFolded", function(pos) {
        for (var marks = this.findMarksAt(pos), i = 0; i < marks.length; ++i) if (marks[i].__isFold) return !0;
    }), CodeMirror.commands.toggleFold = function(cm) {
        cm.foldCode(cm.getCursor());
    }, CodeMirror.commands.fold = function(cm) {
        cm.foldCode(cm.getCursor(), null, "fold");
    }, CodeMirror.commands.unfold = function(cm) {
        cm.foldCode(cm.getCursor(), {
            scanUp: !1
        }, "unfold");
    }, CodeMirror.commands.foldAll = function(cm) {
        cm.operation(function() {
            for (var i = cm.firstLine(), e = cm.lastLine(); i <= e; i++) cm.foldCode(CodeMirror.Pos(i, 0), {
                scanUp: !1
            }, "fold");
        });
    }, CodeMirror.commands.unfoldAll = function(cm) {
        cm.operation(function() {
            for (var i = cm.firstLine(), e = cm.lastLine(); i <= e; i++) cm.foldCode(CodeMirror.Pos(i, 0), {
                scanUp: !1
            }, "unfold");
        });
    }, CodeMirror.registerHelper("fold", "combine", function() {
        var funcs = Array.prototype.slice.call(arguments, 0);
        return function(cm, start) {
            for (var i = 0; i < funcs.length; ++i) {
                var found = funcs[i](cm, start);
                if (found) return found;
            }
        };
    }), CodeMirror.registerHelper("fold", "auto", function(cm, start) {
        for (var helpers = cm.getHelpers(start, "fold"), i = 0; i < helpers.length; i++) {
            var cur = helpers[i](cm, start);
            if (cur) return cur;
        }
    });
    var defaultOptions = {
        rangeFinder: CodeMirror.fold.auto,
        widget: "\u2194",
        minFoldSize: 0,
        scanUp: !1,
        clearOnEnter: !0
    };
    function getOption(cm, options, name) {
        return (options && void 0 !== options[name] || (options = cm.options.foldOptions) && void 0 !== options[name] ? options : defaultOptions)[name];
    }
    CodeMirror.defineOption("foldOptions", null), CodeMirror.defineExtension("foldOption", function(options, name) {
        return getOption(this, options, name);
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror"), require("./foldcode")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror", "./foldcode" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    CodeMirror.defineOption("foldGutter", !1, function(cm, val, old) {
        old && old != CodeMirror.Init && (cm.clearGutter(cm.state.foldGutter.options.gutter), 
        cm.state.foldGutter = null, cm.off("gutterClick", onGutterClick), cm.off("changes", onChange), 
        cm.off("viewportChange", onViewportChange), cm.off("fold", onFold), cm.off("unfold", onFold), 
        cm.off("swapDoc", onChange)), val && (cm.state.foldGutter = new State(function(opts) {
            !0 === opts && (opts = {});
            null == opts.gutter && (opts.gutter = "CodeMirror-foldgutter");
            null == opts.indicatorOpen && (opts.indicatorOpen = "CodeMirror-foldgutter-open");
            null == opts.indicatorFolded && (opts.indicatorFolded = "CodeMirror-foldgutter-folded");
            return opts;
        }(val)), updateInViewport(cm), cm.on("gutterClick", onGutterClick), cm.on("changes", onChange), 
        cm.on("viewportChange", onViewportChange), cm.on("fold", onFold), cm.on("unfold", onFold), 
        cm.on("swapDoc", onChange));
    });
    var Pos = CodeMirror.Pos;
    function State(options) {
        this.options = options, this.from = this.to = 0;
    }
    function isFolded(cm, line) {
        for (var marks = cm.findMarks(Pos(line, 0), Pos(line + 1, 0)), i = 0; i < marks.length; ++i) if (marks[i].__isFold) {
            var fromPos = marks[i].find(-1);
            if (fromPos && fromPos.line === line) return marks[i];
        }
    }
    function marker(spec) {
        var elt;
        return "string" == typeof spec ? ((elt = document.createElement("div")).className = spec + " CodeMirror-guttermarker-subtle", 
        elt) : spec.cloneNode(!0);
    }
    function updateFoldInfo(cm, from, to) {
        var opts = cm.state.foldGutter.options, cur = from - 1, minSize = cm.foldOption(opts, "minFoldSize"), func = cm.foldOption(opts, "rangeFinder"), clsFolded = "string" == typeof opts.indicatorFolded && classTest(opts.indicatorFolded), clsOpen = "string" == typeof opts.indicatorOpen && classTest(opts.indicatorOpen);
        cm.eachLine(from, to, function(line) {
            ++cur;
            var mark = null, old = (old = line.gutterMarkers) && old[opts.gutter];
            if (isFolded(cm, cur)) {
                if (clsFolded && old && clsFolded.test(old.className)) return;
                mark = marker(opts.indicatorFolded);
            } else {
                var pos = Pos(cur, 0), pos = func && func(cm, pos);
                if (pos && pos.to.line - pos.from.line >= minSize) {
                    if (clsOpen && old && clsOpen.test(old.className)) return;
                    mark = marker(opts.indicatorOpen);
                }
            }
            (mark || old) && cm.setGutterMarker(line, opts.gutter, mark);
        });
    }
    function classTest(cls) {
        return new RegExp("(^|\\s)" + cls + "(?:$|\\s)\\s*");
    }
    function updateInViewport(cm) {
        var vp = cm.getViewport(), state = cm.state.foldGutter;
        state && (cm.operation(function() {
            updateFoldInfo(cm, vp.from, vp.to);
        }), state.from = vp.from, state.to = vp.to);
    }
    function onGutterClick(cm, line, gutter) {
        var state = cm.state.foldGutter;
        state && gutter == (gutter = state.options).gutter && ((state = isFolded(cm, line)) ? state.clear() : cm.foldCode(Pos(line, 0), gutter));
    }
    function onChange(cm) {
        var opts, state = cm.state.foldGutter;
        state && (opts = state.options, state.from = state.to = 0, clearTimeout(state.changeUpdate), 
        state.changeUpdate = setTimeout(function() {
            updateInViewport(cm);
        }, opts.foldOnChangeTimeSpan || 600));
    }
    function onViewportChange(cm) {
        var opts, state = cm.state.foldGutter;
        state && (opts = state.options, clearTimeout(state.changeUpdate), state.changeUpdate = setTimeout(function() {
            var vp = cm.getViewport();
            state.from == state.to || 20 < vp.from - state.to || 20 < state.from - vp.to ? updateInViewport(cm) : cm.operation(function() {
                vp.from < state.from && (updateFoldInfo(cm, vp.from, state.from), 
                state.from = vp.from), vp.to > state.to && (updateFoldInfo(cm, state.to, vp.to), 
                state.to = vp.to);
            });
        }, opts.updateViewportTimeSpan || 400));
    }
    function onFold(cm, from) {
        var state = cm.state.foldGutter;
        state && (from = from.line) >= state.from && from < state.to && updateFoldInfo(cm, from, from + 1);
    }
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    function bracketFolding(pairs) {
        return function(cm, start) {
            var line = start.line, lineText = cm.getLine(line);
            for (var found = [], i = 0; i < pairs.length; i++) {
                var open = function(pair) {
                    for (var tokenType, at = start.ch, pass = 0; ;) {
                        var found = at <= 0 ? -1 : lineText.lastIndexOf(pair[0], at - 1);
                        if (-1 == found) {
                            if (1 == pass) break;
                            pass = 1, at = lineText.length;
                        } else {
                            if (1 == pass && found < start.ch) break;
                            if (tokenType = cm.getTokenTypeAt(CodeMirror.Pos(line, found + 1)), 
                            !/^(comment|string)/.test(tokenType)) return {
                                ch: found + 1,
                                tokenType: tokenType,
                                pair: pair
                            };
                            at = found - 1;
                        }
                    }
                }(pairs[i]);
                open && found.push(open);
            }
            found.sort(function(a, b) {
                return a.ch - b.ch;
            });
            for (i = 0; i < found.length; i++) {
                var range = function(found) {
                    var end, endCh, count = 1, lastLine = cm.lastLine(), startCh = found.ch;
                    outer: for (var i = line; i <= lastLine; ++i) for (var text = cm.getLine(i), pos = i == line ? startCh : 0; ;) {
                        var nextOpen = text.indexOf(found.pair[0], pos), nextClose = text.indexOf(found.pair[1], pos);
                        if (nextOpen < 0 && (nextOpen = text.length), nextClose < 0 && (nextClose = text.length), 
                        (pos = Math.min(nextOpen, nextClose)) == text.length) break;
                        if (cm.getTokenTypeAt(CodeMirror.Pos(i, pos + 1)) == found.tokenType) if (pos == nextOpen) ++count; else if (!--count) {
                            end = i, endCh = pos;
                            break outer;
                        }
                        ++pos;
                    }
                    return null == end || line == end ? null : {
                        from: CodeMirror.Pos(line, startCh),
                        to: CodeMirror.Pos(end, endCh)
                    };
                }(found[i]);
                if (range) return range;
            }
            return null;
        };
    }
    CodeMirror.registerHelper("fold", "brace", bracketFolding([ [ "{", "}" ], [ "[", "]" ] ])), 
    CodeMirror.registerHelper("fold", "brace-paren", bracketFolding([ [ "{", "}" ], [ "[", "]" ], [ "(", ")" ] ])), 
    CodeMirror.registerHelper("fold", "import", function(cm, start) {
        function hasImport(line) {
            if (line < cm.firstLine() || line > cm.lastLine()) return null;
            var start = cm.getTokenAt(CodeMirror.Pos(line, 1));
            if ("keyword" != (start = /\S/.test(start.string) ? start : cm.getTokenAt(CodeMirror.Pos(line, start.end + 1))).type || "import" != start.string) return null;
            for (var i = line, e = Math.min(cm.lastLine(), line + 10); i <= e; ++i) {
                var semi = cm.getLine(i).indexOf(";");
                if (-1 != semi) return {
                    startCh: start.end,
                    end: CodeMirror.Pos(i, semi)
                };
            }
        }
        var prev, start = start.line, has = hasImport(start);
        if (!has || hasImport(start - 1) || (prev = hasImport(start - 2)) && prev.end.line == start - 1) return null;
        for (var end = has.end; ;) {
            var next = hasImport(end.line + 1);
            if (null == next) break;
            end = next.end;
        }
        return {
            from: cm.clipPos(CodeMirror.Pos(start, has.startCh + 1)),
            to: end
        };
    }), CodeMirror.registerHelper("fold", "include", function(cm, start) {
        function hasInclude(line) {
            var start;
            return line < cm.firstLine() || line > cm.lastLine() ? null : (start = cm.getTokenAt(CodeMirror.Pos(line, 1)), 
            "meta" == (start = /\S/.test(start.string) ? start : cm.getTokenAt(CodeMirror.Pos(line, start.end + 1))).type && "#include" == start.string.slice(0, 8) ? start.start + 8 : void 0);
        }
        var start = start.line, has = hasInclude(start);
        if (null == has || null != hasInclude(start - 1)) return null;
        for (var end = start; ;) {
            if (null == hasInclude(end + 1)) break;
            ++end;
        }
        return {
            from: CodeMirror.Pos(start, has + 1),
            to: cm.clipPos(CodeMirror.Pos(end))
        };
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    var Pos = CodeMirror.Pos;
    function cmp(a, b) {
        return a.line - b.line || a.ch - b.ch;
    }
    var nameStartChar = "A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD", xmlTagStart = new RegExp("<(/?)([" + nameStartChar + "][A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD-:.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040]*)", "g");
    function Iter(cm, line, ch, range) {
        this.line = line, this.ch = ch, this.cm = cm, this.text = cm.getLine(line), 
        this.min = range ? Math.max(range.from, cm.firstLine()) : cm.firstLine(), 
        this.max = range ? Math.min(range.to - 1, cm.lastLine()) : cm.lastLine();
    }
    function tagAt(iter, ch) {
        iter = iter.cm.getTokenTypeAt(Pos(iter.line, ch));
        return iter && /\btag\b/.test(iter);
    }
    function nextLine(iter) {
        return !(iter.line >= iter.max) && (iter.ch = 0, iter.text = iter.cm.getLine(++iter.line), 
        1);
    }
    function prevLine(iter) {
        return !(iter.line <= iter.min) && (iter.text = iter.cm.getLine(--iter.line), 
        iter.ch = iter.text.length, 1);
    }
    function toTagEnd(iter) {
        for (;;) {
            var lastSlash, gt = iter.text.indexOf(">", iter.ch);
            if (-1 == gt) {
                if (nextLine(iter)) continue;
                return;
            }
            if (tagAt(iter, gt + 1)) return lastSlash = -1 < (lastSlash = iter.text.lastIndexOf("/", gt)) && !/\S/.test(iter.text.slice(lastSlash + 1, gt)), 
            iter.ch = gt + 1, lastSlash ? "selfClose" : "regular";
            iter.ch = gt + 1;
        }
    }
    function toTagStart(iter) {
        for (;;) {
            var lt = iter.ch ? iter.text.lastIndexOf("<", iter.ch - 1) : -1;
            if (-1 == lt) {
                if (prevLine(iter)) continue;
                return;
            }
            if (tagAt(iter, lt + 1)) {
                xmlTagStart.lastIndex = lt, iter.ch = lt;
                var match = xmlTagStart.exec(iter.text);
                if (match && match.index == lt) return match;
            } else iter.ch = lt;
        }
    }
    function toNextTag(iter) {
        for (;;) {
            xmlTagStart.lastIndex = iter.ch;
            var found = xmlTagStart.exec(iter.text);
            if (!found) {
                if (nextLine(iter)) continue;
                return;
            }
            if (tagAt(iter, found.index + 1)) return iter.ch = found.index + found[0].length, 
            found;
            iter.ch = found.index + 1;
        }
    }
    function findMatchingClose(iter, tag) {
        for (var stack = []; ;) {
            var end, next = toNextTag(iter), startLine = iter.line, startCh = iter.ch - (next ? next[0].length : 0);
            if (!next || !(end = toTagEnd(iter))) return;
            if ("selfClose" != end) if (next[1]) {
                for (var i = stack.length - 1; 0 <= i; --i) if (stack[i] == next[2]) {
                    stack.length = i;
                    break;
                }
                if (i < 0 && (!tag || tag == next[2])) return {
                    tag: next[2],
                    from: Pos(startLine, startCh),
                    to: Pos(iter.line, iter.ch)
                };
            } else stack.push(next[2]);
        }
    }
    function findMatchingOpen(iter, tag) {
        for (var stack = []; ;) {
            var prev = function(iter) {
                for (;;) {
                    var lastSlash, gt = iter.ch ? iter.text.lastIndexOf(">", iter.ch - 1) : -1;
                    if (-1 == gt) {
                        if (prevLine(iter)) continue;
                        return;
                    }
                    if (tagAt(iter, gt + 1)) return lastSlash = -1 < (lastSlash = iter.text.lastIndexOf("/", gt)) && !/\S/.test(iter.text.slice(lastSlash + 1, gt)), 
                    iter.ch = gt + 1, lastSlash ? "selfClose" : "regular";
                    iter.ch = gt;
                }
            }(iter);
            if (!prev) return;
            if ("selfClose" == prev) toTagStart(iter); else {
                var prev = iter.line, endCh = iter.ch, start = toTagStart(iter);
                if (!start) return;
                if (start[1]) stack.push(start[2]); else {
                    for (var i = stack.length - 1; 0 <= i; --i) if (stack[i] == start[2]) {
                        stack.length = i;
                        break;
                    }
                    if (i < 0 && (!tag || tag == start[2])) return {
                        tag: start[2],
                        from: Pos(iter.line, iter.ch),
                        to: Pos(prev, endCh)
                    };
                }
            }
        }
    }
    CodeMirror.registerHelper("fold", "xml", function(cm, start) {
        for (var iter = new Iter(cm, start.line, 0); ;) {
            var openTag = toNextTag(iter);
            if (!openTag || iter.line != start.line) return;
            var end = toTagEnd(iter);
            if (!end) return;
            if (!openTag[1] && "selfClose" != end) return end = Pos(iter.line, iter.ch), 
            (openTag = findMatchingClose(iter, openTag[2])) && 0 < cmp(openTag.from, end) ? {
                from: end,
                to: openTag.from
            } : null;
        }
    }), CodeMirror.findMatchingTag = function(cm, pos, range) {
        var iter = new Iter(cm, pos.line, pos.ch, range);
        if (-1 != iter.text.indexOf(">") || -1 != iter.text.indexOf("<")) {
            var end = toTagEnd(iter), to = end && Pos(iter.line, iter.ch), start = end && toTagStart(iter);
            if (end && start && !(0 < cmp(iter, pos))) return pos = {
                from: Pos(iter.line, iter.ch),
                to: to,
                tag: start[2]
            }, "selfClose" == end ? {
                open: pos,
                close: null,
                at: "open"
            } : start[1] ? {
                open: findMatchingOpen(iter, start[2]),
                close: pos,
                at: "close"
            } : {
                open: pos,
                close: findMatchingClose(iter = new Iter(cm, to.line, to.ch, range), start[2]),
                at: "open"
            };
        }
    }, CodeMirror.findEnclosingTag = function(cm, pos, range, tag) {
        for (var iter = new Iter(cm, pos.line, pos.ch, range); ;) {
            var open = findMatchingOpen(iter, tag);
            if (!open) break;
            var close = findMatchingClose(new Iter(cm, pos.line, pos.ch, range), open.tag);
            if (close) return {
                open: open,
                close: close
            };
        }
    }, CodeMirror.scanForClosingTag = function(cm, pos, name, end) {
        return findMatchingClose(new Iter(cm, pos.line, pos.ch, end ? {
            from: 0,
            to: end
        } : null), name);
    };
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    function lineIndent(cm, lineNo) {
        var text = cm.getLine(lineNo), spaceTo = text.search(/\S/);
        return -1 == spaceTo || /\bcomment\b/.test(cm.getTokenTypeAt(CodeMirror.Pos(lineNo, spaceTo + 1))) ? -1 : CodeMirror.countColumn(text, null, cm.getOption("tabSize"));
    }
    CodeMirror.registerHelper("fold", "indent", function(cm, start) {
        var myIndent = lineIndent(cm, start.line);
        if (!(myIndent < 0)) {
            for (var lastLineInFold = null, i = start.line + 1, end = cm.lastLine(); i <= end; ++i) {
                var indent = lineIndent(cm, i);
                if (-1 != indent) {
                    if (!(myIndent < indent)) break;
                    lastLineInFold = i;
                }
            }
            return lastLineInFold ? {
                from: CodeMirror.Pos(start.line, cm.getLine(start.line).length),
                to: CodeMirror.Pos(lastLineInFold, cm.getLine(lastLineInFold).length)
            } : void 0;
        }
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    CodeMirror.registerHelper("fold", "markdown", function(cm, start) {
        function isHeader(lineNo) {
            lineNo = cm.getTokenTypeAt(CodeMirror.Pos(lineNo, 0));
            return lineNo && /\bheader\b/.test(lineNo);
        }
        function headerLevel(lineNo, line, nextLine) {
            line = line && line.match(/^#+/);
            return line && isHeader(lineNo) ? line[0].length : nextLine && nextLine.match(/^[=\-]+\s*$/) && isHeader(lineNo + 1) ? "=" == nextLine[0] ? 1 : 2 : 100;
        }
        var firstLine = cm.getLine(start.line), nextLine = cm.getLine(start.line + 1), level = headerLevel(start.line, firstLine, nextLine);
        if (100 !== level) {
            for (var lastLineNo = cm.lastLine(), end = start.line, nextNextLine = cm.getLine(end + 2); end < lastLineNo && !(headerLevel(end + 1, nextLine, nextNextLine) <= level); ) nextLine = nextNextLine, 
            nextNextLine = cm.getLine(++end + 2);
            return {
                from: CodeMirror.Pos(start.line, firstLine.length),
                to: CodeMirror.Pos(end, cm.getLine(end).length)
            };
        }
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    CodeMirror.registerGlobalHelper("fold", "comment", function(mode) {
        return mode.blockCommentStart && mode.blockCommentEnd;
    }, function(cm, start) {
        var mode = cm.getModeAt(start), startToken = mode.blockCommentStart, endToken = mode.blockCommentEnd;
        if (startToken && endToken) {
            for (var startCh, line = start.line, lineText = cm.getLine(line), at = start.ch, pass = 0; ;) {
                var found = at <= 0 ? -1 : lineText.lastIndexOf(startToken, at - 1);
                if (-1 == found) {
                    if (1 == pass) return;
                    pass = 1, at = lineText.length;
                } else {
                    if (1 == pass && found < start.ch) return;
                    if (/comment/.test(cm.getTokenTypeAt(CodeMirror.Pos(line, found + 1))) && (0 == found || lineText.slice(found - endToken.length, found) == endToken || !/comment/.test(cm.getTokenTypeAt(CodeMirror.Pos(line, found))))) {
                        startCh = found + startToken.length;
                        break;
                    }
                    at = found - 1;
                }
            }
            var end, endCh, depth = 1, lastLine = cm.lastLine();
            outer: for (var i = line; i <= lastLine; ++i) for (var text = cm.getLine(i), pos = i == line ? startCh : 0; ;) {
                var nextOpen = text.indexOf(startToken, pos), nextClose = text.indexOf(endToken, pos);
                if (nextOpen < 0 && (nextOpen = text.length), nextClose < 0 && (nextClose = text.length), 
                (pos = Math.min(nextOpen, nextClose)) == text.length) break;
                if (pos == nextOpen) ++depth; else if (!--depth) {
                    end = i, endCh = pos;
                    break outer;
                }
                ++pos;
            }
            if (null != end && (line != end || endCh != startCh)) return {
                from: CodeMirror.Pos(line, startCh),
                to: CodeMirror.Pos(end, endCh)
            };
        }
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    function Context(indented, column, type, info, align, prev) {
        this.indented = indented, this.column = column, this.type = type, this.info = info, 
        this.align = align, this.prev = prev;
    }
    function pushContext(state, col, type, info) {
        var indent = state.indented;
        state.context && "statement" == state.context.type && "statement" != type && (indent = state.context.indented), 
        state.context = new Context(indent, col, type, info, null, state.context);
    }
    function popContext(state) {
        var t = state.context.type;
        return ")" != t && "]" != t && "}" != t || (state.indented = state.context.indented), 
        state.context = state.context.prev;
    }
    function typeBefore(stream, state, pos) {
        return "variable" == state.prevToken || "type" == state.prevToken || !!/\S(?:[^- ]>|[*\]])\s*$|\*$/.test(stream.string.slice(0, pos)) || !(!state.typeAtEndOfLine || stream.column() != stream.indentation()) || void 0;
    }
    function isTopScope(context) {
        for (;;) {
            if (!context || "top" == context.type) return 1;
            if ("}" == context.type && "namespace" != context.prev.info) return;
            context = context.prev;
        }
    }
    function words(str) {
        for (var obj = {}, words = str.split(" "), i = 0; i < words.length; ++i) obj[words[i]] = !0;
        return obj;
    }
    function contains(words, word) {
        return "function" == typeof words ? words(word) : words.propertyIsEnumerable(word);
    }
    CodeMirror.defineMode("clike", function(config, parserConfig) {
        var curPunc, isDefKeyword, indentUnit = config.indentUnit, statementIndentUnit = parserConfig.statementIndentUnit || indentUnit, dontAlignCalls = parserConfig.dontAlignCalls, keywords = parserConfig.keywords || {}, types = parserConfig.types || {}, builtin = parserConfig.builtin || {}, blockKeywords = parserConfig.blockKeywords || {}, defKeywords = parserConfig.defKeywords || {}, atoms = parserConfig.atoms || {}, hooks = parserConfig.hooks || {}, multiLineStrings = parserConfig.multiLineStrings, indentStatements = !1 !== parserConfig.indentStatements, config = !1 !== parserConfig.indentSwitch, namespaceSeparator = parserConfig.namespaceSeparator, isPunctuationChar = parserConfig.isPunctuationChar || /[\[\]{}\(\),;\:\.]/, numberStart = parserConfig.numberStart || /[\d\.]/, number = parserConfig.number || /^(?:0x[a-f\d]+|0b[01]+|(?:\d+\.?\d*|\.\d+)(?:e[-+]?\d+)?)(u|ll?|l|f)?/i, isOperatorChar = parserConfig.isOperatorChar || /[+\-*&%=<>!?|\/]/, isIdentifierChar = parserConfig.isIdentifierChar || /[\w\$_\xa1-\uffff]/, isReservedIdentifier = parserConfig.isReservedIdentifier || !1;
        function tokenBase(stream, state) {
            var quote, ch = stream.next();
            if (hooks[ch]) {
                var result = hooks[ch](stream, state);
                if (!1 !== result) return result;
            }
            if ('"' == ch || "'" == ch) return state.tokenize = (quote = ch, function(stream, state) {
                for (var next, escaped = !1, end = !1; null != (next = stream.next()); ) {
                    if (next == quote && !escaped) {
                        end = !0;
                        break;
                    }
                    escaped = !escaped && "\\" == next;
                }
                return !end && (escaped || multiLineStrings) || (state.tokenize = null), 
                "string";
            }), state.tokenize(stream, state);
            if (numberStart.test(ch)) {
                if (stream.backUp(1), stream.match(number)) return "number";
                stream.next();
            }
            if (isPunctuationChar.test(ch)) return curPunc = ch, null;
            if ("/" == ch) {
                if (stream.eat("*")) return (state.tokenize = tokenComment)(stream, state);
                if (stream.eat("/")) return stream.skipToEnd(), "comment";
            }
            if (isOperatorChar.test(ch)) {
                for (;!stream.match(/^\/[\/*]/, !1) && stream.eat(isOperatorChar); );
                return "operator";
            }
            if (stream.eatWhile(isIdentifierChar), namespaceSeparator) for (;stream.match(namespaceSeparator); ) stream.eatWhile(isIdentifierChar);
            result = stream.current();
            return contains(keywords, result) ? (contains(blockKeywords, result) && (curPunc = "newstatement"), 
            contains(defKeywords, result) && (isDefKeyword = !0), "keyword") : contains(types, result) ? "type" : contains(builtin, result) || isReservedIdentifier && isReservedIdentifier(result) ? (contains(blockKeywords, result) && (curPunc = "newstatement"), 
            "builtin") : contains(atoms, result) ? "atom" : "variable";
        }
        function tokenComment(stream, state) {
            for (var ch, maybeEnd = !1; ch = stream.next(); ) {
                if ("/" == ch && maybeEnd) {
                    state.tokenize = null;
                    break;
                }
                maybeEnd = "*" == ch;
            }
            return "comment";
        }
        function maybeEOL(stream, state) {
            parserConfig.typeFirstDefinitions && stream.eol() && isTopScope(state.context) && (state.typeAtEndOfLine = typeBefore(stream, state, stream.pos));
        }
        return {
            startState: function(basecolumn) {
                return {
                    tokenize: null,
                    context: new Context((basecolumn || 0) - indentUnit, 0, "top", null, !1),
                    indented: 0,
                    startOfLine: !0,
                    prevToken: null
                };
            },
            token: function(stream, state) {
                var ctx = state.context;
                if (stream.sol() && (null == ctx.align && (ctx.align = !1), state.indented = stream.indentation(), 
                state.startOfLine = !0), stream.eatSpace()) return maybeEOL(stream, state), 
                null;
                curPunc = isDefKeyword = null;
                var result, style = (state.tokenize || tokenBase)(stream, state);
                if ("comment" != style && "meta" != style) {
                    if (null == ctx.align && (ctx.align = !0), ";" == curPunc || ":" == curPunc || "," == curPunc && stream.match(/^\s*(?:\/\/.*)?$/, !1)) for (;"statement" == state.context.type; ) popContext(state); else if ("{" == curPunc) pushContext(state, stream.column(), "}"); else if ("[" == curPunc) pushContext(state, stream.column(), "]"); else if ("(" == curPunc) pushContext(state, stream.column(), ")"); else if ("}" == curPunc) {
                        for (;"statement" == ctx.type; ) ctx = popContext(state);
                        for ("}" == ctx.type && (ctx = popContext(state)); "statement" == ctx.type; ) ctx = popContext(state);
                    } else curPunc == ctx.type ? popContext(state) : indentStatements && (("}" == ctx.type || "top" == ctx.type) && ";" != curPunc || "statement" == ctx.type && "newstatement" == curPunc) && pushContext(state, stream.column(), "statement", stream.current());
                    "variable" == style && ("def" == state.prevToken || parserConfig.typeFirstDefinitions && typeBefore(stream, state, stream.start) && isTopScope(state.context) && stream.match(/^\s*\(/, !1)) && (style = "def"), 
                    "def" == (style = hooks.token && void 0 !== (result = hooks.token(stream, state, style)) ? result : style) && !1 === parserConfig.styleDefs && (style = "variable"), 
                    state.startOfLine = !1, state.prevToken = isDefKeyword ? "def" : style || curPunc, 
                    maybeEOL(stream, state);
                }
                return style;
            },
            indent: function(state, textAfter) {
                if (state.tokenize != tokenBase && null != state.tokenize || state.typeAtEndOfLine) return CodeMirror.Pass;
                var ctx = state.context, firstChar = textAfter && textAfter.charAt(0), closing = firstChar == ctx.type;
                if ("statement" == ctx.type && "}" == firstChar && (ctx = ctx.prev), 
                parserConfig.dontIndentStatements) for (;"statement" == ctx.type && parserConfig.dontIndentStatements.test(ctx.info); ) ctx = ctx.prev;
                if (hooks.indent) {
                    state = hooks.indent(state, ctx, textAfter, indentUnit);
                    if ("number" == typeof state) return state;
                }
                state = ctx.prev && "switch" == ctx.prev.info;
                if (parserConfig.allmanIndentation && /[{(]/.test(firstChar)) {
                    for (;"top" != ctx.type && "}" != ctx.type; ) ctx = ctx.prev;
                    return ctx.indented;
                }
                return "statement" == ctx.type ? ctx.indented + ("{" == firstChar ? 0 : statementIndentUnit) : !ctx.align || dontAlignCalls && ")" == ctx.type ? ")" != ctx.type || closing ? ctx.indented + (closing ? 0 : indentUnit) + (closing || !state || /^(?:case|default)\b/.test(textAfter) ? 0 : indentUnit) : ctx.indented + statementIndentUnit : ctx.column + (closing ? 0 : 1);
            },
            electricInput: config ? /^\s*(?:case .*?:|default:|\{\}?|\})$/ : /^\s*[{}]$/,
            blockCommentStart: "/*",
            blockCommentEnd: "*/",
            blockCommentContinue: " * ",
            lineComment: "//",
            fold: "brace"
        };
    });
    var cKeywords = "auto if break case register continue return default do sizeof static else struct switch extern typedef union for goto while enum const volatile inline restrict asm fortran", cppKeywords = "alignas alignof and and_eq audit axiom bitand bitor catch class compl concept constexpr const_cast decltype delete dynamic_cast explicit export final friend import module mutable namespace new noexcept not not_eq operator or or_eq override private protected public reinterpret_cast requires static_assert static_cast template this thread_local throw try typeid typename using virtual xor xor_eq", objCKeywords = "bycopy byref in inout oneway out self super atomic nonatomic retain copy readwrite readonly strong weak assign typeof nullable nonnull null_resettable _cmd @interface @implementation @end @protocol @encode @property @synthesize @dynamic @class @public @package @private @protected @required @optional @try @catch @finally @import @selector @encode @defs @synchronized @autoreleasepool @compatibility_alias @available", objCBuiltins = "FOUNDATION_EXPORT FOUNDATION_EXTERN NS_INLINE NS_FORMAT_FUNCTION  NS_RETURNS_RETAINEDNS_ERROR_ENUM NS_RETURNS_NOT_RETAINED NS_RETURNS_INNER_POINTER NS_DESIGNATED_INITIALIZER NS_ENUM NS_OPTIONS NS_REQUIRES_NIL_TERMINATION NS_ASSUME_NONNULL_BEGIN NS_ASSUME_NONNULL_END NS_SWIFT_NAME NS_REFINED_FOR_SWIFT", basicCTypes = words("int long char short double float unsigned signed void bool"), basicObjCTypes = words("SEL instancetype id Class Protocol BOOL");
    function cTypes(identifier) {
        return contains(basicCTypes, identifier) || /.+_t$/.test(identifier);
    }
    function objCTypes(identifier) {
        return cTypes(identifier) || contains(basicObjCTypes, identifier);
    }
    var cBlockKeywords = "case do else for if switch while struct enum union";
    function cppHook(stream, state) {
        if (!state.startOfLine) return !1;
        for (var ch, next = null; ch = stream.peek(); ) {
            if ("\\" == ch && stream.match(/^.$/)) {
                next = cppHook;
                break;
            }
            if ("/" == ch && stream.match(/^\/[\/\*]/, !1)) break;
            stream.next();
        }
        return state.tokenize = next, "meta";
    }
    function pointerHook(_stream, state) {
        return "type" == state.prevToken && "type";
    }
    function cIsReservedIdentifier(token) {
        return !(!token || token.length < 2 || "_" != token[0] || "_" != token[1] && token[1] === token[1].toLowerCase());
    }
    function cpp14Literal(stream) {
        return stream.eatWhile(/[\w\.']/), "number";
    }
    function cpp11StringHook(stream, state) {
        var match;
        return stream.backUp(1), stream.match(/^(?:R|u8R|uR|UR|LR)/) ? !!(match = stream.match(/^"([^\s\\()]{0,16})\(/)) && (state.cpp11RawStringDelim = match[1], 
        state.tokenize = tokenRawString, tokenRawString(stream, state)) : stream.match(/^(?:u8|u|U|L)/) ? !!stream.match(/^["']/, !1) && "string" : (stream.next(), 
        !1);
    }
    function cppLooksLikeConstructor(word) {
        word = /(\w+)::~?(\w+)$/.exec(word);
        return word && word[1] == word[2];
    }
    function tokenAtString(stream, state) {
        for (var next; null != (next = stream.next()); ) if ('"' == next && !stream.eat('"')) {
            state.tokenize = null;
            break;
        }
        return "string";
    }
    function tokenRawString(stream, state) {
        var delim = state.cpp11RawStringDelim.replace(/[^\w\s]/g, "\\$&");
        return stream.match(new RegExp(".*?\\)" + delim + '"')) ? state.tokenize = null : stream.skipToEnd(), 
        "string";
    }
    function def(mimes, mode) {
        "string" == typeof mimes && (mimes = [ mimes ]);
        var words = [];
        function add(obj) {
            if (obj) for (var prop in obj) obj.hasOwnProperty(prop) && words.push(prop);
        }
        add(mode.keywords), add(mode.types), add(mode.builtin), add(mode.atoms), 
        words.length && (mode.helperType = mimes[0], CodeMirror.registerHelper("hintWords", mimes[0], words));
        for (var i = 0; i < mimes.length; ++i) CodeMirror.defineMIME(mimes[i], mode);
    }
    function tokenTripleString(stream, state) {
        for (var escaped = !1; !stream.eol(); ) {
            if (!escaped && stream.match('"""')) {
                state.tokenize = null;
                break;
            }
            escaped = "\\" == stream.next() && !escaped;
        }
        return "string";
    }
    function tokenNestedComment(depth) {
        return function(stream, state) {
            for (var ch; ch = stream.next(); ) {
                if ("*" == ch && stream.eat("/")) {
                    if (1 != depth) return state.tokenize = tokenNestedComment(depth - 1), 
                    state.tokenize(stream, state);
                    state.tokenize = null;
                    break;
                }
                if ("/" == ch && stream.eat("*")) return state.tokenize = tokenNestedComment(depth + 1), 
                state.tokenize(stream, state);
            }
            return "comment";
        };
    }
    def([ "text/x-csrc", "text/x-c", "text/x-chdr" ], {
        name: "clike",
        keywords: words(cKeywords),
        types: cTypes,
        blockKeywords: words(cBlockKeywords),
        defKeywords: words("struct enum union"),
        typeFirstDefinitions: !0,
        atoms: words("NULL true false"),
        isReservedIdentifier: cIsReservedIdentifier,
        hooks: {
            "#": cppHook,
            "*": pointerHook
        },
        modeProps: {
            fold: [ "brace", "include" ]
        }
    }), def([ "text/x-c++src", "text/x-c++hdr" ], {
        name: "clike",
        keywords: words(cKeywords + " " + cppKeywords),
        types: cTypes,
        blockKeywords: words(cBlockKeywords + " class try catch"),
        defKeywords: words("struct enum union class namespace"),
        typeFirstDefinitions: !0,
        atoms: words("true false NULL nullptr"),
        dontIndentStatements: /^template$/,
        isIdentifierChar: /[\w\$_~\xa1-\uffff]/,
        isReservedIdentifier: cIsReservedIdentifier,
        hooks: {
            "#": cppHook,
            "*": pointerHook,
            u: cpp11StringHook,
            U: cpp11StringHook,
            L: cpp11StringHook,
            R: cpp11StringHook,
            0: cpp14Literal,
            1: cpp14Literal,
            2: cpp14Literal,
            3: cpp14Literal,
            4: cpp14Literal,
            5: cpp14Literal,
            6: cpp14Literal,
            7: cpp14Literal,
            8: cpp14Literal,
            9: cpp14Literal,
            token: function(stream, state, style) {
                if ("variable" == style && "(" == stream.peek() && (";" == state.prevToken || null == state.prevToken || "}" == state.prevToken) && cppLooksLikeConstructor(stream.current())) return "def";
            }
        },
        namespaceSeparator: "::",
        modeProps: {
            fold: [ "brace", "include" ]
        }
    }), def("text/x-java", {
        name: "clike",
        keywords: words("abstract assert break case catch class const continue default do else enum extends final finally for goto if implements import instanceof interface native new package private protected public return static strictfp super switch synchronized this throw throws transient try volatile while @interface"),
        types: words("var byte short int long float double boolean char void Boolean Byte Character Double Float Integer Long Number Object Short String StringBuffer StringBuilder Void"),
        blockKeywords: words("catch class do else finally for if switch try while"),
        defKeywords: words("class interface enum @interface"),
        typeFirstDefinitions: !0,
        atoms: words("true false null"),
        number: /^(?:0x[a-f\d_]+|0b[01_]+|(?:[\d_]+\.?\d*|\.\d+)(?:e[-+]?[\d_]+)?)(u|ll?|l|f)?/i,
        hooks: {
            "@": function(stream) {
                return !stream.match("interface", !1) && (stream.eatWhile(/[\w\$_]/), 
                "meta");
            },
            '"': function(stream, state) {
                return !!stream.match(/""$/) && (state.tokenize = tokenTripleString, 
                state.tokenize(stream, state));
            }
        },
        modeProps: {
            fold: [ "brace", "import" ]
        }
    }), def("text/x-csharp", {
        name: "clike",
        keywords: words("abstract as async await base break case catch checked class const continue default delegate do else enum event explicit extern finally fixed for foreach goto if implicit in interface internal is lock namespace new operator out override params private protected public readonly ref return sealed sizeof stackalloc static struct switch this throw try typeof unchecked unsafe using virtual void volatile while add alias ascending descending dynamic from get global group into join let orderby partial remove select set value var yield"),
        types: words("Action Boolean Byte Char DateTime DateTimeOffset Decimal Double Func Guid Int16 Int32 Int64 Object SByte Single String Task TimeSpan UInt16 UInt32 UInt64 bool byte char decimal double short int long object sbyte float string ushort uint ulong"),
        blockKeywords: words("catch class do else finally for foreach if struct switch try while"),
        defKeywords: words("class interface namespace struct var"),
        typeFirstDefinitions: !0,
        atoms: words("true false null"),
        hooks: {
            "@": function(stream, state) {
                return stream.eat('"') ? (state.tokenize = tokenAtString)(stream, state) : (stream.eatWhile(/[\w\$_]/), 
                "meta");
            }
        }
    }), def("text/x-scala", {
        name: "clike",
        keywords: words("abstract case catch class def do else extends final finally for forSome if implicit import lazy match new null object override package private protected return sealed super this throw trait try type val var while with yield _ assert assume require print println printf readLine readBoolean readByte readShort readChar readInt readLong readFloat readDouble"),
        types: words("AnyVal App Application Array BufferedIterator BigDecimal BigInt Char Console Either Enumeration Equiv Error Exception Fractional Function IndexedSeq Int Integral Iterable Iterator List Map Numeric Nil NotNull Option Ordered Ordering PartialFunction PartialOrdering Product Proxy Range Responder Seq Serializable Set Specializable Stream StringBuilder StringContext Symbol Throwable Traversable TraversableOnce Tuple Unit Vector Boolean Byte Character CharSequence Class ClassLoader Cloneable Comparable Compiler Double Exception Float Integer Long Math Number Object Package Pair Process Runtime Runnable SecurityManager Short StackTraceElement StrictMath String StringBuffer System Thread ThreadGroup ThreadLocal Throwable Triple Void"),
        multiLineStrings: !0,
        blockKeywords: words("catch class enum do else finally for forSome if match switch try while"),
        defKeywords: words("class enum def object package trait type val var"),
        atoms: words("true false null"),
        indentStatements: !1,
        indentSwitch: !1,
        isOperatorChar: /[+\-*&%=<>!?|\/#:@]/,
        hooks: {
            "@": function(stream) {
                return stream.eatWhile(/[\w\$_]/), "meta";
            },
            '"': function(stream, state) {
                return !!stream.match('""') && (state.tokenize = tokenTripleString, 
                state.tokenize(stream, state));
            },
            "'": function(stream) {
                return stream.eatWhile(/[\w\$_\xa1-\uffff]/), "atom";
            },
            "=": function(stream, state) {
                var cx = state.context;
                return !("}" != cx.type || !cx.align || !stream.eat(">")) && (state.context = new Context(cx.indented, cx.column, cx.type, cx.info, null, cx.prev), 
                "operator");
            },
            "/": function(stream, state) {
                return !!stream.eat("*") && (state.tokenize = tokenNestedComment(1), 
                state.tokenize(stream, state));
            }
        },
        modeProps: {
            closeBrackets: {
                pairs: '()[]{}""',
                triples: '"'
            }
        }
    }), def("text/x-kotlin", {
        name: "clike",
        keywords: words("package as typealias class interface this super val operator var fun for is in This throw return annotation break continue object if else while do try when !in !is as? file import where by get set abstract enum open inner override private public internal protected catch finally out final vararg reified dynamic companion constructor init sealed field property receiver param sparam lateinit data inline noinline tailrec external annotation crossinline const operator infix suspend actual expect setparam value"),
        types: words("Boolean Byte Character CharSequence Class ClassLoader Cloneable Comparable Compiler Double Exception Float Integer Long Math Number Object Package Pair Process Runtime Runnable SecurityManager Short StackTraceElement StrictMath String StringBuffer System Thread ThreadGroup ThreadLocal Throwable Triple Void Annotation Any BooleanArray ByteArray Char CharArray DeprecationLevel DoubleArray Enum FloatArray Function Int IntArray Lazy LazyThreadSafetyMode LongArray Nothing ShortArray Unit"),
        intendSwitch: !1,
        indentStatements: !1,
        multiLineStrings: !0,
        number: /^(?:0x[a-f\d_]+|0b[01_]+|(?:[\d_]+(\.\d+)?|\.\d+)(?:e[-+]?[\d_]+)?)(u|ll?|l|f)?/i,
        blockKeywords: words("catch class do else finally for if where try while enum"),
        defKeywords: words("class val var object interface fun"),
        atoms: words("true false null this"),
        hooks: {
            "@": function(stream) {
                return stream.eatWhile(/[\w\$_]/), "meta";
            },
            "*": function(_stream, state) {
                return "." == state.prevToken ? "variable" : "operator";
            },
            '"': function(stream, state) {
                var tripleString;
                return state.tokenize = (tripleString = stream.match('""'), function(stream, state) {
                    for (var next, escaped = !1, end = !1; !stream.eol(); ) {
                        if (!tripleString && !escaped && stream.match('"')) {
                            end = !0;
                            break;
                        }
                        if (tripleString && stream.match('"""')) {
                            end = !0;
                            break;
                        }
                        next = stream.next(), !escaped && "$" == next && stream.match("{") && stream.skipTo("}"), 
                        escaped = !escaped && "\\" == next && !tripleString;
                    }
                    return !end && tripleString || (state.tokenize = null), "string";
                }), state.tokenize(stream, state);
            },
            "/": function(stream, state) {
                return !!stream.eat("*") && (state.tokenize = tokenNestedComment(1), 
                state.tokenize(stream, state));
            },
            indent: function(state, ctx, textAfter, indentUnit) {
                var firstChar = textAfter && textAfter.charAt(0);
                return "}" != state.prevToken && ")" != state.prevToken || "" != textAfter ? "operator" == state.prevToken && "}" != textAfter && "}" != state.context.type || "variable" == state.prevToken && "." == firstChar || ("}" == state.prevToken || ")" == state.prevToken) && "." == firstChar ? 2 * indentUnit + ctx.indented : ctx.align && "}" == ctx.type ? ctx.indented + (state.context.type == (textAfter || "").charAt(0) ? 0 : indentUnit) : void 0 : state.indented;
            }
        },
        modeProps: {
            closeBrackets: {
                triples: '"'
            }
        }
    }), def([ "x-shader/x-vertex", "x-shader/x-fragment" ], {
        name: "clike",
        keywords: words("sampler1D sampler2D sampler3D samplerCube sampler1DShadow sampler2DShadow const attribute uniform varying break continue discard return for while do if else struct in out inout"),
        types: words("float int bool void vec2 vec3 vec4 ivec2 ivec3 ivec4 bvec2 bvec3 bvec4 mat2 mat3 mat4"),
        blockKeywords: words("for while do if else struct"),
        builtin: words("radians degrees sin cos tan asin acos atan pow exp log exp2 sqrt inversesqrt abs sign floor ceil fract mod min max clamp mix step smoothstep length distance dot cross normalize ftransform faceforward reflect refract matrixCompMult lessThan lessThanEqual greaterThan greaterThanEqual equal notEqual any all not texture1D texture1DProj texture1DLod texture1DProjLod texture2D texture2DProj texture2DLod texture2DProjLod texture3D texture3DProj texture3DLod texture3DProjLod textureCube textureCubeLod shadow1D shadow2D shadow1DProj shadow2DProj shadow1DLod shadow2DLod shadow1DProjLod shadow2DProjLod dFdx dFdy fwidth noise1 noise2 noise3 noise4"),
        atoms: words("true false gl_FragColor gl_SecondaryColor gl_Normal gl_Vertex gl_MultiTexCoord0 gl_MultiTexCoord1 gl_MultiTexCoord2 gl_MultiTexCoord3 gl_MultiTexCoord4 gl_MultiTexCoord5 gl_MultiTexCoord6 gl_MultiTexCoord7 gl_FogCoord gl_PointCoord gl_Position gl_PointSize gl_ClipVertex gl_FrontColor gl_BackColor gl_FrontSecondaryColor gl_BackSecondaryColor gl_TexCoord gl_FogFragCoord gl_FragCoord gl_FrontFacing gl_FragData gl_FragDepth gl_ModelViewMatrix gl_ProjectionMatrix gl_ModelViewProjectionMatrix gl_TextureMatrix gl_NormalMatrix gl_ModelViewMatrixInverse gl_ProjectionMatrixInverse gl_ModelViewProjectionMatrixInverse gl_TextureMatrixTranspose gl_ModelViewMatrixInverseTranspose gl_ProjectionMatrixInverseTranspose gl_ModelViewProjectionMatrixInverseTranspose gl_TextureMatrixInverseTranspose gl_NormalScale gl_DepthRange gl_ClipPlane gl_Point gl_FrontMaterial gl_BackMaterial gl_LightSource gl_LightModel gl_FrontLightModelProduct gl_BackLightModelProduct gl_TextureColor gl_EyePlaneS gl_EyePlaneT gl_EyePlaneR gl_EyePlaneQ gl_FogParameters gl_MaxLights gl_MaxClipPlanes gl_MaxTextureUnits gl_MaxTextureCoords gl_MaxVertexAttribs gl_MaxVertexUniformComponents gl_MaxVaryingFloats gl_MaxVertexTextureImageUnits gl_MaxTextureImageUnits gl_MaxFragmentUniformComponents gl_MaxCombineTextureImageUnits gl_MaxDrawBuffers"),
        indentSwitch: !1,
        hooks: {
            "#": cppHook
        },
        modeProps: {
            fold: [ "brace", "include" ]
        }
    }), def("text/x-nesc", {
        name: "clike",
        keywords: words(cKeywords + " as atomic async call command component components configuration event generic implementation includes interface module new norace nx_struct nx_union post provides signal task uses abstract extends"),
        types: cTypes,
        blockKeywords: words(cBlockKeywords),
        atoms: words("null true false"),
        hooks: {
            "#": cppHook
        },
        modeProps: {
            fold: [ "brace", "include" ]
        }
    }), def("text/x-objectivec", {
        name: "clike",
        keywords: words(cKeywords + " " + objCKeywords),
        types: objCTypes,
        builtin: words(objCBuiltins),
        blockKeywords: words(cBlockKeywords + " @synthesize @try @catch @finally @autoreleasepool @synchronized"),
        defKeywords: words("struct enum union @interface @implementation @protocol @class"),
        dontIndentStatements: /^@.*$/,
        typeFirstDefinitions: !0,
        atoms: words("YES NO NULL Nil nil true false nullptr"),
        isReservedIdentifier: cIsReservedIdentifier,
        hooks: {
            "#": cppHook,
            "*": pointerHook
        },
        modeProps: {
            fold: [ "brace", "include" ]
        }
    }), def("text/x-objectivec++", {
        name: "clike",
        keywords: words(cKeywords + " " + objCKeywords + " " + cppKeywords),
        types: objCTypes,
        builtin: words(objCBuiltins),
        blockKeywords: words(cBlockKeywords + " @synthesize @try @catch @finally @autoreleasepool @synchronized class try catch"),
        defKeywords: words("struct enum union @interface @implementation @protocol @class class namespace"),
        dontIndentStatements: /^@.*$|^template$/,
        typeFirstDefinitions: !0,
        atoms: words("YES NO NULL Nil nil true false nullptr"),
        isReservedIdentifier: cIsReservedIdentifier,
        hooks: {
            "#": cppHook,
            "*": pointerHook,
            u: cpp11StringHook,
            U: cpp11StringHook,
            L: cpp11StringHook,
            R: cpp11StringHook,
            0: cpp14Literal,
            1: cpp14Literal,
            2: cpp14Literal,
            3: cpp14Literal,
            4: cpp14Literal,
            5: cpp14Literal,
            6: cpp14Literal,
            7: cpp14Literal,
            8: cpp14Literal,
            9: cpp14Literal,
            token: function(stream, state, style) {
                if ("variable" == style && "(" == stream.peek() && (";" == state.prevToken || null == state.prevToken || "}" == state.prevToken) && cppLooksLikeConstructor(stream.current())) return "def";
            }
        },
        namespaceSeparator: "::",
        modeProps: {
            fold: [ "brace", "include" ]
        }
    }), def("text/x-squirrel", {
        name: "clike",
        keywords: words("base break clone continue const default delete enum extends function in class foreach local resume return this throw typeof yield constructor instanceof static"),
        types: cTypes,
        blockKeywords: words("case catch class else for foreach if switch try while"),
        defKeywords: words("function local class"),
        typeFirstDefinitions: !0,
        atoms: words("true false null"),
        hooks: {
            "#": cppHook
        },
        modeProps: {
            fold: [ "brace", "include" ]
        }
    });
    var stringTokenizer = null;
    def("text/x-ceylon", {
        name: "clike",
        keywords: words("abstracts alias assembly assert assign break case catch class continue dynamic else exists extends finally for function given if import in interface is let module new nonempty object of out outer package return satisfies super switch then this throw try value void while"),
        types: function(word) {
            word = word.charAt(0);
            return word === word.toUpperCase() && word !== word.toLowerCase();
        },
        blockKeywords: words("case catch class dynamic else finally for function if interface module new object switch try while"),
        defKeywords: words("class dynamic function interface module object package value"),
        builtin: words("abstract actual aliased annotation by default deprecated doc final formal late license native optional sealed see serializable shared suppressWarnings tagged throws variable"),
        isPunctuationChar: /[\[\]{}\(\),;\:\.`]/,
        isOperatorChar: /[+\-*&%=<>!?|^~:\/]/,
        numberStart: /[\d#$]/,
        number: /^(?:#[\da-fA-F_]+|\$[01_]+|[\d_]+[kMGTPmunpf]?|[\d_]+\.[\d_]+(?:[eE][-+]?\d+|[kMGTPmunpf]|)|)/i,
        multiLineStrings: !0,
        typeFirstDefinitions: !0,
        atoms: words("true false null larger smaller equal empty finished"),
        indentSwitch: !1,
        styleDefs: !1,
        hooks: {
            "@": function(stream) {
                return stream.eatWhile(/[\w\$_]/), "meta";
            },
            '"': function(stream, state) {
                return state.tokenize = function tokenCeylonString(type) {
                    return function(stream, state) {
                        for (var next, escaped = !1, end = !1; !stream.eol(); ) {
                            if (!escaped && stream.match('"') && ("single" == type || stream.match('""'))) {
                                end = !0;
                                break;
                            }
                            if (!escaped && stream.match("``")) {
                                stringTokenizer = tokenCeylonString(type), end = !0;
                                break;
                            }
                            next = stream.next(), escaped = "single" == type && !escaped && "\\" == next;
                        }
                        return end && (state.tokenize = null), "string";
                    };
                }(stream.match('""') ? "triple" : "single"), state.tokenize(stream, state);
            },
            "`": function(stream, state) {
                return !(!stringTokenizer || !stream.match("`")) && (state.tokenize = stringTokenizer, 
                stringTokenizer = null, state.tokenize(stream, state));
            },
            "'": function(stream) {
                return stream.eatWhile(/[\w\$_\xa1-\uffff]/), "atom";
            },
            token: function(_stream, state, style) {
                if (("variable" == style || "type" == style) && "." == state.prevToken) return "variable-2";
            }
        },
        modeProps: {
            fold: [ "brace", "import" ],
            closeBrackets: {
                triples: '"'
            }
        }
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    function keySet(array) {
        for (var keys = {}, i = 0; i < array.length; ++i) keys[array[i].toLowerCase()] = !0;
        return keys;
    }
    CodeMirror.defineMode("css", function(config, parserConfig) {
        var type, override, inline = parserConfig.inline, indentUnit = (parserConfig.propertyKeywords || (parserConfig = CodeMirror.resolveMode("text/css")), 
        config.indentUnit), tokenHooks = parserConfig.tokenHooks, documentTypes = parserConfig.documentTypes || {}, mediaTypes = parserConfig.mediaTypes || {}, mediaFeatures = parserConfig.mediaFeatures || {}, mediaValueKeywords = parserConfig.mediaValueKeywords || {}, propertyKeywords = parserConfig.propertyKeywords || {}, nonStandardPropertyKeywords = parserConfig.nonStandardPropertyKeywords || {}, fontProperties = parserConfig.fontProperties || {}, counterDescriptors = parserConfig.counterDescriptors || {}, colorKeywords = parserConfig.colorKeywords || {}, valueKeywords = parserConfig.valueKeywords || {}, allowNested = parserConfig.allowNested, lineComment = parserConfig.lineComment, supportsAtComponent = !0 === parserConfig.supportsAtComponent, highlightNonStandardPropertyKeywords = !1 !== config.highlightNonStandardPropertyKeywords;
        function ret(style, tp) {
            return type = tp, style;
        }
        function tokenString(quote) {
            return function(stream, state) {
                for (var ch, escaped = !1; null != (ch = stream.next()); ) {
                    if (ch == quote && !escaped) {
                        ")" == quote && stream.backUp(1);
                        break;
                    }
                    escaped = !escaped && "\\" == ch;
                }
                return ch != quote && (escaped || ")" == quote) || (state.tokenize = null), 
                type = "string";
            };
        }
        function tokenParenthesized(stream, state) {
            return stream.next(), stream.match(/^\s*[\"\')]/, !1) ? state.tokenize = null : state.tokenize = tokenString(")"), 
            type = "(", null;
        }
        function Context(type, indent, prev) {
            this.type = type, this.indent = indent, this.prev = prev;
        }
        function pushContext(state, stream, type, indent) {
            return state.context = new Context(type, stream.indentation() + (!1 === indent ? 0 : indentUnit), state.context), 
            type;
        }
        function popContext(state) {
            return state.context.prev && (state.context = state.context.prev), state.context.type;
        }
        function pass(type, stream, state) {
            return states[state.context.type](type, stream, state);
        }
        function popAndPass(type, stream, state, n) {
            for (var i = n || 1; 0 < i; i--) state.context = state.context.prev;
            return pass(type, stream, state);
        }
        function wordAsValue(stream) {
            stream = stream.current().toLowerCase();
            override = valueKeywords.hasOwnProperty(stream) ? "atom" : colorKeywords.hasOwnProperty(stream) ? "keyword" : "variable";
        }
        var states = {
            top: function(type, stream, state) {
                if ("{" == type) return pushContext(state, stream, "block");
                if ("}" == type && state.context.prev) return popContext(state);
                if (supportsAtComponent && /@component/i.test(type)) return pushContext(state, stream, "atComponentBlock");
                if (/^@(-moz-)?document$/i.test(type)) return pushContext(state, stream, "documentTypes");
                if (/^@(media|supports|(-moz-)?document|import)$/i.test(type)) return pushContext(state, stream, "atBlock");
                if (/^@(font-face|counter-style)/i.test(type)) return state.stateArg = type, 
                "restricted_atBlock_before";
                if (/^@(-(moz|ms|o|webkit)-)?keyframes$/i.test(type)) return "keyframes";
                if (type && "@" == type.charAt(0)) return pushContext(state, stream, "at");
                if ("hash" == type) override = "builtin"; else if ("word" == type) override = "tag"; else {
                    if ("variable-definition" == type) return "maybeprop";
                    if ("interpolation" == type) return pushContext(state, stream, "interpolation");
                    if (":" == type) return "pseudo";
                    if (allowNested && "(" == type) return pushContext(state, stream, "parens");
                }
                return state.context.type;
            },
            block: function(type, stream, state) {
                var word;
                return "word" == type ? (word = stream.current().toLowerCase(), 
                propertyKeywords.hasOwnProperty(word) ? (override = "property", 
                "maybeprop") : nonStandardPropertyKeywords.hasOwnProperty(word) ? (override = highlightNonStandardPropertyKeywords ? "string-2" : "property", 
                "maybeprop") : allowNested ? (override = stream.match(/^\s*:(?:\s|$)/, !1) ? "property" : "tag", 
                "block") : (override += " error", "maybeprop")) : "meta" == type ? "block" : allowNested || "hash" != type && "qualifier" != type ? states.top(type, stream, state) : (override = "error", 
                "block");
            },
            maybeprop: function(type, stream, state) {
                return ":" == type ? pushContext(state, stream, "prop") : pass(type, stream, state);
            },
            prop: function(type, stream, state) {
                if (";" == type) return popContext(state);
                if ("{" == type && allowNested) return pushContext(state, stream, "propBlock");
                if ("}" == type || "{" == type) return popAndPass(type, stream, state);
                if ("(" == type) return pushContext(state, stream, "parens");
                if ("hash" != type || /^#([0-9a-fA-f]{3,4}|[0-9a-fA-f]{6}|[0-9a-fA-f]{8})$/.test(stream.current())) {
                    if ("word" == type) wordAsValue(stream); else if ("interpolation" == type) return pushContext(state, stream, "interpolation");
                } else override += " error";
                return "prop";
            },
            propBlock: function(type, _stream, state) {
                return "}" == type ? popContext(state) : "word" == type ? (override = "property", 
                "maybeprop") : state.context.type;
            },
            parens: function(type, stream, state) {
                return "{" == type || "}" == type ? popAndPass(type, stream, state) : ")" == type ? popContext(state) : "(" == type ? pushContext(state, stream, "parens") : "interpolation" == type ? pushContext(state, stream, "interpolation") : ("word" == type && wordAsValue(stream), 
                "parens");
            },
            pseudo: function(type, stream, state) {
                return "meta" == type ? "pseudo" : "word" == type ? (override = "variable-3", 
                state.context.type) : pass(type, stream, state);
            },
            documentTypes: function(type, stream, state) {
                return "word" == type && documentTypes.hasOwnProperty(stream.current()) ? (override = "tag", 
                state.context.type) : states.atBlock(type, stream, state);
            },
            atBlock: function(type, stream, state) {
                return "(" == type ? pushContext(state, stream, "atBlock_parens") : "}" == type || ";" == type ? popAndPass(type, stream, state) : "{" == type ? popContext(state) && pushContext(state, stream, allowNested ? "block" : "top") : "interpolation" == type ? pushContext(state, stream, "interpolation") : ("word" == type && (type = stream.current().toLowerCase(), 
                override = "only" == type || "not" == type || "and" == type || "or" == type ? "keyword" : mediaTypes.hasOwnProperty(type) ? "attribute" : mediaFeatures.hasOwnProperty(type) ? "property" : mediaValueKeywords.hasOwnProperty(type) ? "keyword" : propertyKeywords.hasOwnProperty(type) ? "property" : nonStandardPropertyKeywords.hasOwnProperty(type) ? highlightNonStandardPropertyKeywords ? "string-2" : "property" : valueKeywords.hasOwnProperty(type) ? "atom" : colorKeywords.hasOwnProperty(type) ? "keyword" : "error"), 
                state.context.type);
            },
            atComponentBlock: function(type, stream, state) {
                return "}" == type ? popAndPass(type, stream, state) : "{" == type ? popContext(state) && pushContext(state, stream, allowNested ? "block" : "top", !1) : ("word" == type && (override = "error"), 
                state.context.type);
            },
            atBlock_parens: function(type, stream, state) {
                return ")" == type ? popContext(state) : "{" == type || "}" == type ? popAndPass(type, stream, state, 2) : states.atBlock(type, stream, state);
            },
            restricted_atBlock_before: function(type, stream, state) {
                return "{" == type ? pushContext(state, stream, "restricted_atBlock") : "word" == type && "@counter-style" == state.stateArg ? (override = "variable", 
                "restricted_atBlock_before") : pass(type, stream, state);
            },
            restricted_atBlock: function(type, stream, state) {
                return "}" == type ? (state.stateArg = null, popContext(state)) : "word" == type ? (override = "@font-face" == state.stateArg && !fontProperties.hasOwnProperty(stream.current().toLowerCase()) || "@counter-style" == state.stateArg && !counterDescriptors.hasOwnProperty(stream.current().toLowerCase()) ? "error" : "property", 
                "maybeprop") : "restricted_atBlock";
            },
            keyframes: function(type, stream, state) {
                return "word" == type ? (override = "variable", "keyframes") : "{" == type ? pushContext(state, stream, "top") : pass(type, stream, state);
            },
            at: function(type, stream, state) {
                return ";" == type ? popContext(state) : "{" == type || "}" == type ? popAndPass(type, stream, state) : ("word" == type ? override = "tag" : "hash" == type && (override = "builtin"), 
                "at");
            },
            interpolation: function(type, stream, state) {
                return "}" == type ? popContext(state) : "{" == type || ";" == type ? popAndPass(type, stream, state) : ("word" == type ? override = "variable" : "variable" != type && "(" != type && ")" != type && (override = "error"), 
                "interpolation");
            }
        };
        return {
            startState: function(base) {
                return {
                    tokenize: null,
                    state: inline ? "block" : "top",
                    stateArg: null,
                    context: new Context(inline ? "block" : "top", base || 0, null)
                };
            },
            token: function(stream, state) {
                var style;
                return !state.tokenize && stream.eatSpace() ? null : ((style = (state.tokenize || function(stream, state) {
                    var ch = stream.next();
                    if (tokenHooks[ch]) {
                        var result = tokenHooks[ch](stream, state);
                        if (!1 !== result) return result;
                    }
                    return "@" == ch ? (stream.eatWhile(/[\w\\\-]/), ret("def", stream.current())) : "=" == ch || ("~" == ch || "|" == ch) && stream.eat("=") ? (type = "compare", 
                    null) : '"' == ch || "'" == ch ? (state.tokenize = tokenString(ch), 
                    state.tokenize(stream, state)) : "#" == ch ? (stream.eatWhile(/[\w\\\-]/), 
                    type = "hash", "atom") : "!" == ch ? (stream.match(/^\s*\w*/), 
                    type = "important", "keyword") : /\d/.test(ch) || "." == ch && stream.eat(/\d/) ? (stream.eatWhile(/[\w.%]/), 
                    type = "unit", "number") : "-" === ch ? /[\d.]/.test(stream.peek()) ? (stream.eatWhile(/[\w.%]/), 
                    type = "unit", "number") : stream.match(/^-[\w\\\-]*/) ? (stream.eatWhile(/[\w\\\-]/), 
                    type = stream.match(/^\s*:/, !1) ? "variable-definition" : "variable", 
                    "variable-2") : stream.match(/^\w+-/) ? type = "meta" : void 0 : /[,+>*\/]/.test(ch) ? (type = "select-op", 
                    null) : "." == ch && stream.match(/^-?[_a-z][_a-z0-9-]*/i) ? type = "qualifier" : /[:;{}\[\]\(\)]/.test(ch) ? ret(null, ch) : stream.match(/^[\w-.]+(?=\()/) ? (/^(url(-prefix)?|domain|regexp)$/i.test(stream.current()) && (state.tokenize = tokenParenthesized), 
                    type = "variable", "variable callee") : /[\w\\\-]/.test(ch) ? (stream.eatWhile(/[\w\\\-]/), 
                    type = "word", "property") : type = null;
                })(stream, state)) && "object" == typeof style && (type = style[1], 
                style = style[0]), override = style, "comment" != type && (state.state = states[state.state](type, stream, state)), 
                override);
            },
            indent: function(state, textAfter) {
                var state = state.context, textAfter = textAfter && textAfter.charAt(0), indent = state.indent;
                return (state = "prop" != state.type || "}" != textAfter && ")" != textAfter ? state : state.prev).prev && ("}" != textAfter || "block" != state.type && "top" != state.type && "interpolation" != state.type && "restricted_atBlock" != state.type ? (")" != textAfter || "parens" != state.type && "atBlock_parens" != state.type) && ("{" != textAfter || "at" != state.type && "atBlock" != state.type) || (indent = Math.max(0, state.indent - indentUnit)) : indent = (state = state.prev).indent), 
                indent;
            },
            electricChars: "}",
            blockCommentStart: "/*",
            blockCommentEnd: "*/",
            blockCommentContinue: " * ",
            lineComment: lineComment,
            fold: "brace"
        };
    });
    var documentTypes_ = [ "domain", "regexp", "url", "url-prefix" ], documentTypes = keySet(documentTypes_), mediaTypes_ = [ "all", "aural", "braille", "handheld", "print", "projection", "screen", "tty", "tv", "embossed" ], mediaTypes = keySet(mediaTypes_), mediaFeatures_ = [ "width", "min-width", "max-width", "height", "min-height", "max-height", "device-width", "min-device-width", "max-device-width", "device-height", "min-device-height", "max-device-height", "aspect-ratio", "min-aspect-ratio", "max-aspect-ratio", "device-aspect-ratio", "min-device-aspect-ratio", "max-device-aspect-ratio", "color", "min-color", "max-color", "color-index", "min-color-index", "max-color-index", "monochrome", "min-monochrome", "max-monochrome", "resolution", "min-resolution", "max-resolution", "scan", "grid", "orientation", "device-pixel-ratio", "min-device-pixel-ratio", "max-device-pixel-ratio", "pointer", "any-pointer", "hover", "any-hover", "prefers-color-scheme", "dynamic-range", "video-dynamic-range" ], mediaFeatures = keySet(mediaFeatures_), mediaValueKeywords_ = [ "landscape", "portrait", "none", "coarse", "fine", "on-demand", "hover", "interlace", "progressive", "dark", "light", "standard", "high" ], mediaValueKeywords = keySet(mediaValueKeywords_), propertyKeywords_ = [ "align-content", "align-items", "align-self", "alignment-adjust", "alignment-baseline", "all", "anchor-point", "animation", "animation-delay", "animation-direction", "animation-duration", "animation-fill-mode", "animation-iteration-count", "animation-name", "animation-play-state", "animation-timing-function", "appearance", "azimuth", "backdrop-filter", "backface-visibility", "background", "background-attachment", "background-blend-mode", "background-clip", "background-color", "background-image", "background-origin", "background-position", "background-position-x", "background-position-y", "background-repeat", "background-size", "baseline-shift", "binding", "bleed", "block-size", "bookmark-label", "bookmark-level", "bookmark-state", "bookmark-target", "border", "border-bottom", "border-bottom-color", "border-bottom-left-radius", "border-bottom-right-radius", "border-bottom-style", "border-bottom-width", "border-collapse", "border-color", "border-image", "border-image-outset", "border-image-repeat", "border-image-slice", "border-image-source", "border-image-width", "border-left", "border-left-color", "border-left-style", "border-left-width", "border-radius", "border-right", "border-right-color", "border-right-style", "border-right-width", "border-spacing", "border-style", "border-top", "border-top-color", "border-top-left-radius", "border-top-right-radius", "border-top-style", "border-top-width", "border-width", "bottom", "box-decoration-break", "box-shadow", "box-sizing", "break-after", "break-before", "break-inside", "caption-side", "caret-color", "clear", "clip", "color", "color-profile", "column-count", "column-fill", "column-gap", "column-rule", "column-rule-color", "column-rule-style", "column-rule-width", "column-span", "column-width", "columns", "contain", "content", "counter-increment", "counter-reset", "crop", "cue", "cue-after", "cue-before", "cursor", "direction", "display", "dominant-baseline", "drop-initial-after-adjust", "drop-initial-after-align", "drop-initial-before-adjust", "drop-initial-before-align", "drop-initial-size", "drop-initial-value", "elevation", "empty-cells", "fit", "fit-content", "fit-position", "flex", "flex-basis", "flex-direction", "flex-flow", "flex-grow", "flex-shrink", "flex-wrap", "float", "float-offset", "flow-from", "flow-into", "font", "font-family", "font-feature-settings", "font-kerning", "font-language-override", "font-optical-sizing", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-synthesis", "font-variant", "font-variant-alternates", "font-variant-caps", "font-variant-east-asian", "font-variant-ligatures", "font-variant-numeric", "font-variant-position", "font-variation-settings", "font-weight", "gap", "grid", "grid-area", "grid-auto-columns", "grid-auto-flow", "grid-auto-rows", "grid-column", "grid-column-end", "grid-column-gap", "grid-column-start", "grid-gap", "grid-row", "grid-row-end", "grid-row-gap", "grid-row-start", "grid-template", "grid-template-areas", "grid-template-columns", "grid-template-rows", "hanging-punctuation", "height", "hyphens", "icon", "image-orientation", "image-rendering", "image-resolution", "inline-box-align", "inset", "inset-block", "inset-block-end", "inset-block-start", "inset-inline", "inset-inline-end", "inset-inline-start", "isolation", "justify-content", "justify-items", "justify-self", "left", "letter-spacing", "line-break", "line-height", "line-height-step", "line-stacking", "line-stacking-ruby", "line-stacking-shift", "line-stacking-strategy", "list-style", "list-style-image", "list-style-position", "list-style-type", "margin", "margin-bottom", "margin-left", "margin-right", "margin-top", "marks", "marquee-direction", "marquee-loop", "marquee-play-count", "marquee-speed", "marquee-style", "mask-clip", "mask-composite", "mask-image", "mask-mode", "mask-origin", "mask-position", "mask-repeat", "mask-size", "mask-type", "max-block-size", "max-height", "max-inline-size", "max-width", "min-block-size", "min-height", "min-inline-size", "min-width", "mix-blend-mode", "move-to", "nav-down", "nav-index", "nav-left", "nav-right", "nav-up", "object-fit", "object-position", "offset", "offset-anchor", "offset-distance", "offset-path", "offset-position", "offset-rotate", "opacity", "order", "orphans", "outline", "outline-color", "outline-offset", "outline-style", "outline-width", "overflow", "overflow-style", "overflow-wrap", "overflow-x", "overflow-y", "padding", "padding-bottom", "padding-left", "padding-right", "padding-top", "page", "page-break-after", "page-break-before", "page-break-inside", "page-policy", "pause", "pause-after", "pause-before", "perspective", "perspective-origin", "pitch", "pitch-range", "place-content", "place-items", "place-self", "play-during", "position", "presentation-level", "punctuation-trim", "quotes", "region-break-after", "region-break-before", "region-break-inside", "region-fragment", "rendering-intent", "resize", "rest", "rest-after", "rest-before", "richness", "right", "rotate", "rotation", "rotation-point", "row-gap", "ruby-align", "ruby-overhang", "ruby-position", "ruby-span", "scale", "scroll-behavior", "scroll-margin", "scroll-margin-block", "scroll-margin-block-end", "scroll-margin-block-start", "scroll-margin-bottom", "scroll-margin-inline", "scroll-margin-inline-end", "scroll-margin-inline-start", "scroll-margin-left", "scroll-margin-right", "scroll-margin-top", "scroll-padding", "scroll-padding-block", "scroll-padding-block-end", "scroll-padding-block-start", "scroll-padding-bottom", "scroll-padding-inline", "scroll-padding-inline-end", "scroll-padding-inline-start", "scroll-padding-left", "scroll-padding-right", "scroll-padding-top", "scroll-snap-align", "scroll-snap-type", "shape-image-threshold", "shape-inside", "shape-margin", "shape-outside", "size", "speak", "speak-as", "speak-header", "speak-numeral", "speak-punctuation", "speech-rate", "stress", "string-set", "tab-size", "table-layout", "target", "target-name", "target-new", "target-position", "text-align", "text-align-last", "text-combine-upright", "text-decoration", "text-decoration-color", "text-decoration-line", "text-decoration-skip", "text-decoration-skip-ink", "text-decoration-style", "text-emphasis", "text-emphasis-color", "text-emphasis-position", "text-emphasis-style", "text-height", "text-indent", "text-justify", "text-orientation", "text-outline", "text-overflow", "text-rendering", "text-shadow", "text-size-adjust", "text-space-collapse", "text-transform", "text-underline-position", "text-wrap", "top", "touch-action", "transform", "transform-origin", "transform-style", "transition", "transition-delay", "transition-duration", "transition-property", "transition-timing-function", "translate", "unicode-bidi", "user-select", "vertical-align", "visibility", "voice-balance", "voice-duration", "voice-family", "voice-pitch", "voice-range", "voice-rate", "voice-stress", "voice-volume", "volume", "white-space", "widows", "width", "will-change", "word-break", "word-spacing", "word-wrap", "writing-mode", "z-index", "clip-path", "clip-rule", "mask", "enable-background", "filter", "flood-color", "flood-opacity", "lighting-color", "stop-color", "stop-opacity", "pointer-events", "color-interpolation", "color-interpolation-filters", "color-rendering", "fill", "fill-opacity", "fill-rule", "image-rendering", "marker", "marker-end", "marker-mid", "marker-start", "paint-order", "shape-rendering", "stroke", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke-width", "text-rendering", "baseline-shift", "dominant-baseline", "glyph-orientation-horizontal", "glyph-orientation-vertical", "text-anchor", "writing-mode" ], propertyKeywords = keySet(propertyKeywords_), nonStandardPropertyKeywords_ = [ "accent-color", "aspect-ratio", "border-block", "border-block-color", "border-block-end", "border-block-end-color", "border-block-end-style", "border-block-end-width", "border-block-start", "border-block-start-color", "border-block-start-style", "border-block-start-width", "border-block-style", "border-block-width", "border-inline", "border-inline-color", "border-inline-end", "border-inline-end-color", "border-inline-end-style", "border-inline-end-width", "border-inline-start", "border-inline-start-color", "border-inline-start-style", "border-inline-start-width", "border-inline-style", "border-inline-width", "content-visibility", "margin-block", "margin-block-end", "margin-block-start", "margin-inline", "margin-inline-end", "margin-inline-start", "overflow-anchor", "overscroll-behavior", "padding-block", "padding-block-end", "padding-block-start", "padding-inline", "padding-inline-end", "padding-inline-start", "scroll-snap-stop", "scrollbar-3d-light-color", "scrollbar-arrow-color", "scrollbar-base-color", "scrollbar-dark-shadow-color", "scrollbar-face-color", "scrollbar-highlight-color", "scrollbar-shadow-color", "scrollbar-track-color", "searchfield-cancel-button", "searchfield-decoration", "searchfield-results-button", "searchfield-results-decoration", "shape-inside", "zoom" ], nonStandardPropertyKeywords = keySet(nonStandardPropertyKeywords_), fontProperties = keySet([ "font-display", "font-family", "src", "unicode-range", "font-variant", "font-feature-settings", "font-stretch", "font-weight", "font-style" ]), counterDescriptors = keySet([ "additive-symbols", "fallback", "negative", "pad", "prefix", "range", "speak-as", "suffix", "symbols", "system" ]), colorKeywords_ = [ "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkgrey", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkslategrey", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dimgrey", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "grey", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgray", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightslategrey", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "rebeccapurple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "slategrey", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen" ], colorKeywords = keySet(colorKeywords_), valueKeywords_ = [ "above", "absolute", "activeborder", "additive", "activecaption", "afar", "after-white-space", "ahead", "alias", "all", "all-scroll", "alphabetic", "alternate", "always", "amharic", "amharic-abegede", "antialiased", "appworkspace", "arabic-indic", "armenian", "asterisks", "attr", "auto", "auto-flow", "avoid", "avoid-column", "avoid-page", "avoid-region", "axis-pan", "background", "backwards", "baseline", "below", "bidi-override", "binary", "bengali", "blink", "block", "block-axis", "blur", "bold", "bolder", "border", "border-box", "both", "bottom", "break", "break-all", "break-word", "brightness", "bullets", "button", "buttonface", "buttonhighlight", "buttonshadow", "buttontext", "calc", "cambodian", "capitalize", "caps-lock-indicator", "caption", "captiontext", "caret", "cell", "center", "checkbox", "circle", "cjk-decimal", "cjk-earthly-branch", "cjk-heavenly-stem", "cjk-ideographic", "clear", "clip", "close-quote", "col-resize", "collapse", "color", "color-burn", "color-dodge", "column", "column-reverse", "compact", "condensed", "conic-gradient", "contain", "content", "contents", "content-box", "context-menu", "continuous", "contrast", "copy", "counter", "counters", "cover", "crop", "cross", "crosshair", "cubic-bezier", "currentcolor", "cursive", "cyclic", "darken", "dashed", "decimal", "decimal-leading-zero", "default", "default-button", "dense", "destination-atop", "destination-in", "destination-out", "destination-over", "devanagari", "difference", "disc", "discard", "disclosure-closed", "disclosure-open", "document", "dot-dash", "dot-dot-dash", "dotted", "double", "down", "drop-shadow", "e-resize", "ease", "ease-in", "ease-in-out", "ease-out", "element", "ellipse", "ellipsis", "embed", "end", "ethiopic", "ethiopic-abegede", "ethiopic-abegede-am-et", "ethiopic-abegede-gez", "ethiopic-abegede-ti-er", "ethiopic-abegede-ti-et", "ethiopic-halehame-aa-er", "ethiopic-halehame-aa-et", "ethiopic-halehame-am-et", "ethiopic-halehame-gez", "ethiopic-halehame-om-et", "ethiopic-halehame-sid-et", "ethiopic-halehame-so-et", "ethiopic-halehame-ti-er", "ethiopic-halehame-ti-et", "ethiopic-halehame-tig", "ethiopic-numeric", "ew-resize", "exclusion", "expanded", "extends", "extra-condensed", "extra-expanded", "fantasy", "fast", "fill", "fill-box", "fixed", "flat", "flex", "flex-end", "flex-start", "footnotes", "forwards", "from", "geometricPrecision", "georgian", "grayscale", "graytext", "grid", "groove", "gujarati", "gurmukhi", "hand", "hangul", "hangul-consonant", "hard-light", "hebrew", "help", "hidden", "hide", "higher", "highlight", "highlighttext", "hiragana", "hiragana-iroha", "horizontal", "hsl", "hsla", "hue", "hue-rotate", "icon", "ignore", "inactiveborder", "inactivecaption", "inactivecaptiontext", "infinite", "infobackground", "infotext", "inherit", "initial", "inline", "inline-axis", "inline-block", "inline-flex", "inline-grid", "inline-table", "inset", "inside", "intrinsic", "invert", "italic", "japanese-formal", "japanese-informal", "justify", "kannada", "katakana", "katakana-iroha", "keep-all", "khmer", "korean-hangul-formal", "korean-hanja-formal", "korean-hanja-informal", "landscape", "lao", "large", "larger", "left", "level", "lighter", "lighten", "line-through", "linear", "linear-gradient", "lines", "list-item", "listbox", "listitem", "local", "logical", "loud", "lower", "lower-alpha", "lower-armenian", "lower-greek", "lower-hexadecimal", "lower-latin", "lower-norwegian", "lower-roman", "lowercase", "ltr", "luminosity", "malayalam", "manipulation", "match", "matrix", "matrix3d", "media-play-button", "media-slider", "media-sliderthumb", "media-volume-slider", "media-volume-sliderthumb", "medium", "menu", "menulist", "menulist-button", "menutext", "message-box", "middle", "min-intrinsic", "mix", "mongolian", "monospace", "move", "multiple", "multiple_mask_images", "multiply", "myanmar", "n-resize", "narrower", "ne-resize", "nesw-resize", "no-close-quote", "no-drop", "no-open-quote", "no-repeat", "none", "normal", "not-allowed", "nowrap", "ns-resize", "numbers", "numeric", "nw-resize", "nwse-resize", "oblique", "octal", "opacity", "open-quote", "optimizeLegibility", "optimizeSpeed", "oriya", "oromo", "outset", "outside", "outside-shape", "overlay", "overline", "padding", "padding-box", "painted", "page", "paused", "persian", "perspective", "pinch-zoom", "plus-darker", "plus-lighter", "pointer", "polygon", "portrait", "pre", "pre-line", "pre-wrap", "preserve-3d", "progress", "push-button", "radial-gradient", "radio", "read-only", "read-write", "read-write-plaintext-only", "rectangle", "region", "relative", "repeat", "repeating-linear-gradient", "repeating-radial-gradient", "repeating-conic-gradient", "repeat-x", "repeat-y", "reset", "reverse", "rgb", "rgba", "ridge", "right", "rotate", "rotate3d", "rotateX", "rotateY", "rotateZ", "round", "row", "row-resize", "row-reverse", "rtl", "run-in", "running", "s-resize", "sans-serif", "saturate", "saturation", "scale", "scale3d", "scaleX", "scaleY", "scaleZ", "screen", "scroll", "scrollbar", "scroll-position", "se-resize", "searchfield", "searchfield-cancel-button", "searchfield-decoration", "searchfield-results-button", "searchfield-results-decoration", "self-start", "self-end", "semi-condensed", "semi-expanded", "separate", "sepia", "serif", "show", "sidama", "simp-chinese-formal", "simp-chinese-informal", "single", "skew", "skewX", "skewY", "skip-white-space", "slide", "slider-horizontal", "slider-vertical", "sliderthumb-horizontal", "sliderthumb-vertical", "slow", "small", "small-caps", "small-caption", "smaller", "soft-light", "solid", "somali", "source-atop", "source-in", "source-out", "source-over", "space", "space-around", "space-between", "space-evenly", "spell-out", "square", "square-button", "start", "static", "status-bar", "stretch", "stroke", "stroke-box", "sub", "subpixel-antialiased", "svg_masks", "super", "sw-resize", "symbolic", "symbols", "system-ui", "table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row", "table-row-group", "tamil", "telugu", "text", "text-bottom", "text-top", "textarea", "textfield", "thai", "thick", "thin", "threeddarkshadow", "threedface", "threedhighlight", "threedlightshadow", "threedshadow", "tibetan", "tigre", "tigrinya-er", "tigrinya-er-abegede", "tigrinya-et", "tigrinya-et-abegede", "to", "top", "trad-chinese-formal", "trad-chinese-informal", "transform", "translate", "translate3d", "translateX", "translateY", "translateZ", "transparent", "ultra-condensed", "ultra-expanded", "underline", "unidirectional-pan", "unset", "up", "upper-alpha", "upper-armenian", "upper-greek", "upper-hexadecimal", "upper-latin", "upper-norwegian", "upper-roman", "uppercase", "urdu", "url", "var", "vertical", "vertical-text", "view-box", "visible", "visibleFill", "visiblePainted", "visibleStroke", "visual", "w-resize", "wait", "wave", "wider", "window", "windowframe", "windowtext", "words", "wrap", "wrap-reverse", "x-large", "x-small", "xor", "xx-large", "xx-small" ], valueKeywords = keySet(valueKeywords_), documentTypes_ = documentTypes_.concat(mediaTypes_).concat(mediaFeatures_).concat(mediaValueKeywords_).concat(propertyKeywords_).concat(nonStandardPropertyKeywords_).concat(colorKeywords_).concat(valueKeywords_);
    function tokenCComment(stream, state) {
        for (var ch, maybeEnd = !1; null != (ch = stream.next()); ) {
            if (maybeEnd && "/" == ch) {
                state.tokenize = null;
                break;
            }
            maybeEnd = "*" == ch;
        }
        return [ "comment", "comment" ];
    }
    CodeMirror.registerHelper("hintWords", "css", documentTypes_), CodeMirror.defineMIME("text/css", {
        documentTypes: documentTypes,
        mediaTypes: mediaTypes,
        mediaFeatures: mediaFeatures,
        mediaValueKeywords: mediaValueKeywords,
        propertyKeywords: propertyKeywords,
        nonStandardPropertyKeywords: nonStandardPropertyKeywords,
        fontProperties: fontProperties,
        counterDescriptors: counterDescriptors,
        colorKeywords: colorKeywords,
        valueKeywords: valueKeywords,
        tokenHooks: {
            "/": function(stream, state) {
                return !!stream.eat("*") && (state.tokenize = tokenCComment)(stream, state);
            }
        },
        name: "css"
    }), CodeMirror.defineMIME("text/x-scss", {
        mediaTypes: mediaTypes,
        mediaFeatures: mediaFeatures,
        mediaValueKeywords: mediaValueKeywords,
        propertyKeywords: propertyKeywords,
        nonStandardPropertyKeywords: nonStandardPropertyKeywords,
        colorKeywords: colorKeywords,
        valueKeywords: valueKeywords,
        fontProperties: fontProperties,
        allowNested: !0,
        lineComment: "//",
        tokenHooks: {
            "/": function(stream, state) {
                return stream.eat("/") ? (stream.skipToEnd(), [ "comment", "comment" ]) : stream.eat("*") ? (state.tokenize = tokenCComment)(stream, state) : [ "operator", "operator" ];
            },
            ":": function(stream) {
                return !!stream.match(/^\s*\{/, !1) && [ null, null ];
            },
            $: function(stream) {
                return stream.match(/^[\w-]+/), stream.match(/^\s*:/, !1) ? [ "variable-2", "variable-definition" ] : [ "variable-2", "variable" ];
            },
            "#": function(stream) {
                return !!stream.eat("{") && [ null, "interpolation" ];
            }
        },
        name: "css",
        helperType: "scss"
    }), CodeMirror.defineMIME("text/x-less", {
        mediaTypes: mediaTypes,
        mediaFeatures: mediaFeatures,
        mediaValueKeywords: mediaValueKeywords,
        propertyKeywords: propertyKeywords,
        nonStandardPropertyKeywords: nonStandardPropertyKeywords,
        colorKeywords: colorKeywords,
        valueKeywords: valueKeywords,
        fontProperties: fontProperties,
        allowNested: !0,
        lineComment: "//",
        tokenHooks: {
            "/": function(stream, state) {
                return stream.eat("/") ? (stream.skipToEnd(), [ "comment", "comment" ]) : stream.eat("*") ? (state.tokenize = tokenCComment)(stream, state) : [ "operator", "operator" ];
            },
            "@": function(stream) {
                return stream.eat("{") ? [ null, "interpolation" ] : !stream.match(/^(charset|document|font-face|import|(-(moz|ms|o|webkit)-)?keyframes|media|namespace|page|supports)\b/i, !1) && (stream.eatWhile(/[\w\\\-]/), 
                stream.match(/^\s*:/, !1) ? [ "variable-2", "variable-definition" ] : [ "variable-2", "variable" ]);
            },
            "&": function() {
                return [ "atom", "atom" ];
            }
        },
        name: "css",
        helperType: "less"
    }), CodeMirror.defineMIME("text/x-gss", {
        documentTypes: documentTypes,
        mediaTypes: mediaTypes,
        mediaFeatures: mediaFeatures,
        propertyKeywords: propertyKeywords,
        nonStandardPropertyKeywords: nonStandardPropertyKeywords,
        fontProperties: fontProperties,
        counterDescriptors: counterDescriptors,
        colorKeywords: colorKeywords,
        valueKeywords: valueKeywords,
        supportsAtComponent: !0,
        tokenHooks: {
            "/": function(stream, state) {
                return !!stream.eat("*") && (state.tokenize = tokenCComment)(stream, state);
            }
        },
        name: "css",
        helperType: "gss"
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror"), require("../xml/xml"), require("../javascript/javascript"), require("../css/css")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror", "../xml/xml", "../javascript/javascript", "../css/css" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    var defaultTags = {
        script: [ [ "lang", /(javascript|babel)/i, "javascript" ], [ "type", /^(?:text|application)\/(?:x-)?(?:java|ecma)script$|^module$|^$/i, "javascript" ], [ "type", /./, "text/plain" ], [ null, null, "javascript" ] ],
        style: [ [ "lang", /^css$/i, "css" ], [ "type", /^(text\/)?(x-)?(stylesheet|css)$/i, "css" ], [ "type", /./, "text/plain" ], [ null, null, "css" ] ]
    };
    var attrRegexpCache = {};
    function getAttrValue(text, attr) {
        text = text.match(function(attr) {
            var regexp = attrRegexpCache[attr];
            return regexp || (attrRegexpCache[attr] = new RegExp("\\s+" + attr + "\\s*=\\s*('|\")?([^'\"]+)('|\")?\\s*"));
        }(attr));
        return text ? /^\s*(.*?)\s*$/.exec(text[2])[1] : "";
    }
    function getTagRegexp(tagName, anchored) {
        return new RegExp((anchored ? "^" : "") + "</\\s*" + tagName + "\\s*>", "i");
    }
    function addTags(from, to) {
        for (var tag in from) for (var dest = to[tag] || (to[tag] = []), source = from[tag], i = source.length - 1; 0 <= i; i--) dest.unshift(source[i]);
    }
    CodeMirror.defineMode("htmlmixed", function(config, parserConfig) {
        var htmlMode = CodeMirror.getMode(config, {
            name: "xml",
            htmlMode: !0,
            multilineTagIndentFactor: parserConfig.multilineTagIndentFactor,
            multilineTagIndentPastTag: parserConfig.multilineTagIndentPastTag,
            allowMissingTagName: parserConfig.allowMissingTagName
        }), tags = {}, configTags = parserConfig && parserConfig.tags, configScript = parserConfig && parserConfig.scriptTypes;
        if (addTags(defaultTags, tags), configTags && addTags(configTags, tags), 
        configScript) for (var i = configScript.length - 1; 0 <= i; i--) tags.script.unshift([ "type", configScript[i].matches, configScript[i].mode ]);
        function html(stream, state) {
            var tagName, endTagA, endTag, style = htmlMode.token(stream, state.htmlState), tag = /\btag\b/.test(style);
            return tag && !/[<>\s\/]/.test(stream.current()) && (tagName = state.htmlState.tagName && state.htmlState.tagName.toLowerCase()) && tags.hasOwnProperty(tagName) ? state.inTag = tagName + " " : state.inTag && tag && />$/.test(stream.current()) ? (tagName = /^([\S]+) (.*)/.exec(state.inTag), 
            state.inTag = null, tag = ">" == stream.current() && function(tagInfo, tagText) {
                for (var i = 0; i < tagInfo.length; i++) {
                    var spec = tagInfo[i];
                    if (!spec[0] || spec[1].test(getAttrValue(tagText, spec[0]))) return spec[2];
                }
            }(tags[tagName[1]], tagName[2]), tag = CodeMirror.getMode(config, tag), 
            endTagA = getTagRegexp(tagName[1], !0), endTag = getTagRegexp(tagName[1], !1), 
            state.token = function(stream, state) {
                return stream.match(endTagA, !1) ? (state.token = html, state.localState = state.localMode = null) : function(stream, pat, style) {
                    var cur = stream.current(), close = cur.search(pat);
                    return -1 < close ? stream.backUp(cur.length - close) : cur.match(/<\/?$/) && (stream.backUp(cur.length), 
                    stream.match(pat, !1) || stream.match(cur)), style;
                }(stream, endTag, state.localMode.token(stream, state.localState));
            }, state.localMode = tag, state.localState = CodeMirror.startState(tag, htmlMode.indent(state.htmlState, "", ""))) : state.inTag && (state.inTag += stream.current(), 
            stream.eol()) && (state.inTag += " "), style;
        }
        return {
            startState: function() {
                return {
                    token: html,
                    inTag: null,
                    localMode: null,
                    localState: null,
                    htmlState: CodeMirror.startState(htmlMode)
                };
            },
            copyState: function(state) {
                var local;
                return state.localState && (local = CodeMirror.copyState(state.localMode, state.localState)), 
                {
                    token: state.token,
                    inTag: state.inTag,
                    localMode: state.localMode,
                    localState: local,
                    htmlState: CodeMirror.copyState(htmlMode, state.htmlState)
                };
            },
            token: function(stream, state) {
                return state.token(stream, state);
            },
            indent: function(state, textAfter, line) {
                return !state.localMode || /^\s*<\//.test(textAfter) ? htmlMode.indent(state.htmlState, textAfter, line) : state.localMode.indent ? state.localMode.indent(state.localState, textAfter, line) : CodeMirror.Pass;
            },
            innerMode: function(state) {
                return {
                    state: state.localState || state.htmlState,
                    mode: state.localMode || htmlMode
                };
            }
        };
    }, "xml", "javascript", "css"), CodeMirror.defineMIME("text/html", "htmlmixed");
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    CodeMirror.defineMode("javascript", function(config, parserConfig) {
        var B, C, D, operator, indentUnit = config.indentUnit, statementIndent = parserConfig.statementIndent, jsonldMode = parserConfig.jsonld, jsonMode = parserConfig.json || jsonldMode, trackScope = !1 !== parserConfig.trackScope, isTS = parserConfig.typescript, wordRE = parserConfig.wordCharacters || /[\w$\xa1-\uffff]/, keywords = (config = kw("keyword a"), 
        B = kw("keyword b"), C = kw("keyword c"), D = kw("keyword d"), operator = kw("operator"), 
        {
            if: kw("if"),
            while: config,
            with: config,
            else: B,
            do: B,
            try: B,
            finally: B,
            return: D,
            break: D,
            continue: D,
            new: kw("new"),
            delete: C,
            void: C,
            throw: C,
            debugger: kw("debugger"),
            var: kw("var"),
            const: kw("var"),
            let: kw("var"),
            function: kw("function"),
            catch: kw("catch"),
            for: kw("for"),
            switch: kw("switch"),
            case: kw("case"),
            default: kw("default"),
            in: operator,
            typeof: operator,
            instanceof: operator,
            true: config = {
                type: "atom",
                style: "atom"
            },
            false: config,
            null: config,
            undefined: config,
            NaN: config,
            Infinity: config,
            this: kw("this"),
            class: kw("class"),
            super: kw("atom"),
            yield: C,
            export: kw("export"),
            import: kw("import"),
            extends: C,
            await: C
        });
        function kw(type) {
            return {
                type: type,
                style: "keyword"
            };
        }
        var type, content, isOperatorChar = /[+\-*&%=<>!?|~^@]/, isJsonldKeyword = /^@(context|id|value|language|type|container|list|set|reverse|index|base|vocab|graph)"/;
        function ret(tp, style, cont) {
            return type = tp, content = cont, style;
        }
        function tokenBase(stream, state) {
            var quote, ch = stream.next();
            if ('"' == ch || "'" == ch) return state.tokenize = (quote = ch, function(stream, state) {
                var next, escaped = !1;
                if (jsonldMode && "@" == stream.peek() && stream.match(isJsonldKeyword)) return state.tokenize = tokenBase, 
                ret("jsonld-keyword", "meta");
                for (;null != (next = stream.next()) && (next != quote || escaped); ) escaped = !escaped && "\\" == next;
                return escaped || (state.tokenize = tokenBase), ret("string", "string");
            }), state.tokenize(stream, state);
            if ("." == ch && stream.match(/^\d[\d_]*(?:[eE][+\-]?[\d_]+)?/)) return ret("number", "number");
            if ("." == ch && stream.match("..")) return ret("spread", "meta");
            if (/[\[\]{}\(\),;\:\.]/.test(ch)) return ret(ch);
            if ("=" == ch && stream.eat(">")) return ret("=>", "operator");
            if ("0" == ch && stream.match(/^(?:x[\dA-Fa-f_]+|o[0-7_]+|b[01_]+)n?/)) return ret("number", "number");
            if (/\d/.test(ch)) return stream.match(/^[\d_]*(?:n|(?:\.[\d_]*)?(?:[eE][+\-]?[\d_]+)?)?/), 
            ret("number", "number");
            if ("/" == ch) return stream.eat("*") ? (state.tokenize = tokenComment)(stream, state) : stream.eat("/") ? (stream.skipToEnd(), 
            ret("comment", "comment")) : expressionAllowed(stream, state, 1) ? (function(stream) {
                for (var next, escaped = !1, inSet = !1; null != (next = stream.next()); ) {
                    if (!escaped) {
                        if ("/" == next && !inSet) return;
                        "[" == next ? inSet = !0 : inSet && "]" == next && (inSet = !1);
                    }
                    escaped = !escaped && "\\" == next;
                }
            }(stream), stream.match(/^\b(([gimyus])(?![gimyus]*\2))+\b/), ret("regexp", "string-2")) : (stream.eat("="), 
            ret("operator", "operator", stream.current()));
            if ("`" == ch) return (state.tokenize = tokenQuasi)(stream, state);
            if ("#" == ch && "!" == stream.peek()) return stream.skipToEnd(), ret("meta", "meta");
            if ("#" == ch && stream.eatWhile(wordRE)) return ret("variable", "property");
            if ("<" == ch && stream.match("!--") || "-" == ch && stream.match("->") && !/\S/.test(stream.string.slice(0, stream.start))) return stream.skipToEnd(), 
            ret("comment", "comment");
            if (isOperatorChar.test(ch)) return ">" == ch && state.lexical && ">" == state.lexical.type || (stream.eat("=") ? "!" != ch && "=" != ch || stream.eat("=") : /[<>*+\-|&?]/.test(ch) && (stream.eat(ch), 
            ">" == ch) && stream.eat(ch)), "?" == ch && stream.eat(".") ? ret(".") : ret("operator", "operator", stream.current());
            if (wordRE.test(ch)) {
                stream.eatWhile(wordRE);
                ch = stream.current();
                if ("." != state.lastType) {
                    if (keywords.propertyIsEnumerable(ch)) return ret((state = keywords[ch]).type, state.style, ch);
                    if ("async" == ch && stream.match(/^(\s|\/\*([^*]|\*(?!\/))*?\*\/)*[\[\(\w]/, !1)) return ret("async", "keyword", ch);
                }
                return ret("variable", "variable", ch);
            }
        }
        function tokenComment(stream, state) {
            for (var ch, maybeEnd = !1; ch = stream.next(); ) {
                if ("/" == ch && maybeEnd) {
                    state.tokenize = tokenBase;
                    break;
                }
                maybeEnd = "*" == ch;
            }
            return ret("comment", "comment");
        }
        function tokenQuasi(stream, state) {
            for (var next, escaped = !1; null != (next = stream.next()); ) {
                if (!escaped && ("`" == next || "$" == next && stream.eat("{"))) {
                    state.tokenize = tokenBase;
                    break;
                }
                escaped = !escaped && "\\" == next;
            }
            return ret("quasi", "string-2", stream.current());
        }
        function findFatArrow(stream, state) {
            state.fatArrowAt && (state.fatArrowAt = null);
            var arrow = stream.string.indexOf("=>", stream.start);
            if (!(arrow < 0)) {
                for (var m, depth = 0, sawSomething = !1, pos = (arrow = isTS && (m = /:\s*(?:\w+(?:<[^>]*>|\[\])?|\{[^}]*\})\s*$/.exec(stream.string.slice(stream.start, arrow))) ? m.index : arrow) - 1; 0 <= pos; --pos) {
                    var ch = stream.string.charAt(pos), bracket = "([{}])".indexOf(ch);
                    if (0 <= bracket && bracket < 3) {
                        if (!depth) {
                            ++pos;
                            break;
                        }
                        if (0 == --depth) {
                            "(" == ch && (sawSomething = !0);
                            break;
                        }
                    } else if (3 <= bracket && bracket < 6) ++depth; else if (wordRE.test(ch)) sawSomething = !0; else if (/["'\/`]/.test(ch)) for (;;--pos) {
                        if (0 == pos) return;
                        if (stream.string.charAt(pos - 1) == ch && "\\" != stream.string.charAt(pos - 2)) {
                            pos--;
                            break;
                        }
                    } else if (sawSomething && !depth) {
                        ++pos;
                        break;
                    }
                }
                sawSomething && !depth && (state.fatArrowAt = pos);
            }
        }
        var atomicTypes = {
            atom: !0,
            number: !0,
            variable: !0,
            string: !0,
            regexp: !0,
            this: !0,
            import: !0,
            "jsonld-keyword": !0
        };
        function JSLexical(indented, column, type, align, prev, info) {
            this.indented = indented, this.column = column, this.type = type, this.prev = prev, 
            this.info = info, null != align && (this.align = align);
        }
        function parseJS(state, style, type, content, stream) {
            var cc = state.cc;
            for (cx.state = state, cx.stream = stream, cx.marked = null, cx.cc = cc, 
            cx.style = style, state.lexical.hasOwnProperty("align") || (state.lexical.align = !0); ;) if ((cc.length ? cc.pop() : jsonMode ? expression : statement)(type, content)) {
                for (;cc.length && cc[cc.length - 1].lex; ) cc.pop()();
                return cx.marked ? cx.marked : "variable" == type && function(state, varname) {
                    if (trackScope) {
                        for (var v = state.localVars; v; v = v.next) if (v.name == varname) return 1;
                        for (var cx = state.context; cx; cx = cx.prev) for (v = cx.vars; v; v = v.next) if (v.name == varname) return 1;
                    }
                }(state, content) ? "variable-2" : style;
            }
        }
        var cx = {
            state: null,
            column: null,
            marked: null,
            cc: null
        };
        function pass() {
            for (var i = arguments.length - 1; 0 <= i; i--) cx.cc.push(arguments[i]);
        }
        function cont() {
            return pass.apply(null, arguments), !0;
        }
        function inList(name, list) {
            for (var v = list; v; v = v.next) if (v.name == name) return 1;
        }
        function register(varname) {
            var state = cx.state;
            if (cx.marked = "def", trackScope) {
                if (state.context) if ("var" == state.lexical.info && state.context && state.context.block) {
                    var newContext = function registerVarScoped(varname, context) {
                        {
                            var inner;
                            return context ? context.block ? (inner = registerVarScoped(varname, context.prev)) ? inner == context.prev ? context : new Context(inner, context.vars, !0) : null : inList(varname, context.vars) ? context : new Context(context.prev, new Var(varname, context.vars), !1) : null;
                        }
                    }(varname, state.context);
                    if (null != newContext) return void (state.context = newContext);
                } else if (!inList(varname, state.localVars)) return void (state.localVars = new Var(varname, state.localVars));
                parserConfig.globalVars && !inList(varname, state.globalVars) && (state.globalVars = new Var(varname, state.globalVars));
            }
        }
        function isModifier(name) {
            return "public" == name || "private" == name || "protected" == name || "abstract" == name || "readonly" == name;
        }
        function Context(prev, vars, block) {
            this.prev = prev, this.vars = vars, this.block = block;
        }
        function Var(name, next) {
            this.name = name, this.next = next;
        }
        var defaultVars = new Var("this", new Var("arguments", null));
        function pushcontext() {
            cx.state.context = new Context(cx.state.context, cx.state.localVars, !1), 
            cx.state.localVars = defaultVars;
        }
        function pushblockcontext() {
            cx.state.context = new Context(cx.state.context, cx.state.localVars, !0), 
            cx.state.localVars = null;
        }
        function popcontext() {
            cx.state.localVars = cx.state.context.vars, cx.state.context = cx.state.context.prev;
        }
        function pushlex(type, info) {
            function result() {
                var state = cx.state, indent = state.indented;
                if ("stat" == state.lexical.type) indent = state.lexical.indented; else for (var outer = state.lexical; outer && ")" == outer.type && outer.align; outer = outer.prev) indent = outer.indented;
                state.lexical = new JSLexical(indent, cx.stream.column(), type, null, state.lexical, info);
            }
            return result.lex = !0, result;
        }
        function poplex() {
            var state = cx.state;
            state.lexical.prev && (")" == state.lexical.type && (state.indented = state.lexical.indented), 
            state.lexical = state.lexical.prev);
        }
        function expect(wanted) {
            return function exp(type) {
                return type == wanted ? cont() : ";" == wanted || "}" == type || ")" == type || "]" == type ? pass() : cont(exp);
            };
        }
        function statement(type, value) {
            return "var" == type ? cont(pushlex("vardef", value), vardef, expect(";"), poplex) : "keyword a" == type ? cont(pushlex("form"), parenExpr, statement, poplex) : "keyword b" == type ? cont(pushlex("form"), statement, poplex) : "keyword d" == type ? cx.stream.match(/^\s*$/, !1) ? cont() : cont(pushlex("stat"), maybeexpression, expect(";"), poplex) : "debugger" == type ? cont(expect(";")) : "{" == type ? cont(pushlex("}"), pushblockcontext, block, poplex, popcontext) : ";" == type ? cont() : "if" == type ? ("else" == cx.state.lexical.info && cx.state.cc[cx.state.cc.length - 1] == poplex && cx.state.cc.pop()(), 
            cont(pushlex("form"), parenExpr, statement, poplex, maybeelse)) : "function" == type ? cont(functiondef) : "for" == type ? cont(pushlex("form"), pushblockcontext, forspec, statement, popcontext, poplex) : "class" == type || isTS && "interface" == value ? (cx.marked = "keyword", 
            cont(pushlex("form", "class" == type ? type : value), className, poplex)) : "variable" == type ? isTS && "declare" == value ? (cx.marked = "keyword", 
            cont(statement)) : isTS && ("module" == value || "enum" == value || "type" == value) && cx.stream.match(/^\s*\w/, !1) ? (cx.marked = "keyword", 
            "enum" == value ? cont(enumdef) : "type" == value ? cont(typename, expect("operator"), typeexpr, expect(";")) : cont(pushlex("form"), pattern, expect("{"), pushlex("}"), block, poplex, poplex)) : isTS && "namespace" == value ? (cx.marked = "keyword", 
            cont(pushlex("form"), expression, statement, poplex)) : isTS && "abstract" == value ? (cx.marked = "keyword", 
            cont(statement)) : cont(pushlex("stat"), maybelabel) : "switch" == type ? cont(pushlex("form"), parenExpr, expect("{"), pushlex("}", "switch"), pushblockcontext, block, poplex, poplex, popcontext) : "case" == type ? cont(expression, expect(":")) : "default" == type ? cont(expect(":")) : "catch" == type ? cont(pushlex("form"), pushcontext, maybeCatchBinding, statement, poplex, popcontext) : "export" == type ? cont(pushlex("stat"), afterExport, poplex) : "import" == type ? cont(pushlex("stat"), afterImport, poplex) : "async" == type ? cont(statement) : "@" == value ? cont(expression, statement) : pass(pushlex("stat"), expression, expect(";"), poplex);
        }
        function maybeCatchBinding(type) {
            if ("(" == type) return cont(funarg, expect(")"));
        }
        function expression(type, value) {
            return expressionInner(type, value, !1);
        }
        function expressionNoComma(type, value) {
            return expressionInner(type, value, !0);
        }
        function parenExpr(type) {
            return "(" != type ? pass() : cont(pushlex(")"), maybeexpression, expect(")"), poplex);
        }
        function expressionInner(type, value, noComma) {
            if (cx.state.fatArrowAt == cx.stream.start) {
                var body = noComma ? arrowBodyNoComma : arrowBody;
                if ("(" == type) return cont(pushcontext, pushlex(")"), commasep(funarg, ")"), poplex, expect("=>"), body, popcontext);
                if ("variable" == type) return pass(pushcontext, pattern, expect("=>"), body, popcontext);
            }
            body = noComma ? maybeoperatorNoComma : maybeoperatorComma;
            return atomicTypes.hasOwnProperty(type) ? cont(body) : "function" == type ? cont(functiondef, body) : "class" == type || isTS && "interface" == value ? (cx.marked = "keyword", 
            cont(pushlex("form"), classExpression, poplex)) : "keyword c" == type || "async" == type ? cont(noComma ? expressionNoComma : expression) : "(" == type ? cont(pushlex(")"), maybeexpression, expect(")"), poplex, body) : "operator" == type || "spread" == type ? cont(noComma ? expressionNoComma : expression) : "[" == type ? cont(pushlex("]"), arrayLiteral, poplex, body) : "{" == type ? contCommasep(objprop, "}", null, body) : "quasi" == type ? pass(quasi, body) : "new" == type ? cont(function(noComma) {
                return function(type) {
                    return "." == type ? cont(noComma ? targetNoComma : target) : "variable" == type && isTS ? cont(maybeTypeArgs, noComma ? maybeoperatorNoComma : maybeoperatorComma) : pass(noComma ? expressionNoComma : expression);
                };
            }(noComma)) : cont();
        }
        function maybeexpression(type) {
            return type.match(/[;\}\)\],]/) ? pass() : pass(expression);
        }
        function maybeoperatorComma(type, value) {
            return "," == type ? cont(maybeexpression) : maybeoperatorNoComma(type, value, !1);
        }
        function maybeoperatorNoComma(type, value, noComma) {
            var me = 0 == noComma ? maybeoperatorComma : maybeoperatorNoComma, expr = 0 == noComma ? expression : expressionNoComma;
            return "=>" == type ? cont(pushcontext, noComma ? arrowBodyNoComma : arrowBody, popcontext) : "operator" == type ? /\+\+|--/.test(value) || isTS && "!" == value ? cont(me) : isTS && "<" == value && cx.stream.match(/^([^<>]|<[^<>]*>)*>\s*\(/, !1) ? cont(pushlex(">"), commasep(typeexpr, ">"), poplex, me) : "?" == value ? cont(expression, expect(":"), expr) : cont(expr) : "quasi" == type ? pass(quasi, me) : ";" != type ? "(" == type ? contCommasep(expressionNoComma, ")", "call", me) : "." == type ? cont(property, me) : "[" == type ? cont(pushlex("]"), maybeexpression, expect("]"), poplex, me) : isTS && "as" == value ? (cx.marked = "keyword", 
            cont(typeexpr, me)) : "regexp" == type ? (cx.state.lastType = cx.marked = "operator", 
            cx.stream.backUp(cx.stream.pos - cx.stream.start - 1), cont(expr)) : void 0 : void 0;
        }
        function quasi(type, value) {
            return "quasi" != type ? pass() : "${" != value.slice(value.length - 2) ? cont(quasi) : cont(maybeexpression, continueQuasi);
        }
        function continueQuasi(type) {
            if ("}" == type) return cx.marked = "string-2", cx.state.tokenize = tokenQuasi, 
            cont(quasi);
        }
        function arrowBody(type) {
            return findFatArrow(cx.stream, cx.state), pass("{" == type ? statement : expression);
        }
        function arrowBodyNoComma(type) {
            return findFatArrow(cx.stream, cx.state), pass("{" == type ? statement : expressionNoComma);
        }
        function target(_, value) {
            if ("target" == value) return cx.marked = "keyword", cont(maybeoperatorComma);
        }
        function targetNoComma(_, value) {
            if ("target" == value) return cx.marked = "keyword", cont(maybeoperatorNoComma);
        }
        function maybelabel(type) {
            return ":" == type ? cont(poplex, statement) : pass(maybeoperatorComma, expect(";"), poplex);
        }
        function property(type) {
            if ("variable" == type) return cx.marked = "property", cont();
        }
        function objprop(type, value) {
            var m;
            return "async" == type ? (cx.marked = "property", cont(objprop)) : "variable" == type || "keyword" == cx.style ? (cx.marked = "property", 
            "get" == value || "set" == value ? cont(getterSetter) : (isTS && cx.state.fatArrowAt == cx.stream.start && (m = cx.stream.match(/^\s*:\s*/, !1)) && (cx.state.fatArrowAt = cx.stream.pos + m[0].length), 
            cont(afterprop))) : "number" == type || "string" == type ? (cx.marked = jsonldMode ? "property" : cx.style + " property", 
            cont(afterprop)) : "jsonld-keyword" == type ? cont(afterprop) : isTS && isModifier(value) ? (cx.marked = "keyword", 
            cont(objprop)) : "[" == type ? cont(expression, maybetype, expect("]"), afterprop) : "spread" == type ? cont(expressionNoComma, afterprop) : "*" == value ? (cx.marked = "keyword", 
            cont(objprop)) : ":" == type ? pass(afterprop) : void 0;
        }
        function getterSetter(type) {
            return "variable" != type ? pass(afterprop) : (cx.marked = "property", 
            cont(functiondef));
        }
        function afterprop(type) {
            return ":" == type ? cont(expressionNoComma) : "(" == type ? pass(functiondef) : void 0;
        }
        function commasep(what, end, sep) {
            function proceed(type, value) {
                var lex;
                return (sep ? -1 < sep.indexOf(type) : "," == type) ? ("call" == (lex = cx.state.lexical).info && (lex.pos = (lex.pos || 0) + 1), 
                cont(function(type, value) {
                    return type == end || value == end ? pass() : pass(what);
                }, proceed)) : type == end || value == end ? cont() : sep && -1 < sep.indexOf(";") ? pass(what) : cont(expect(end));
            }
            return function(type, value) {
                return type == end || value == end ? cont() : pass(what, proceed);
            };
        }
        function contCommasep(what, end, info) {
            for (var i = 3; i < arguments.length; i++) cx.cc.push(arguments[i]);
            return cont(pushlex(end, info), commasep(what, end), poplex);
        }
        function block(type) {
            return "}" == type ? cont() : pass(statement, block);
        }
        function maybetype(type, value) {
            if (isTS) return ":" == type ? cont(typeexpr) : "?" == value ? cont(maybetype) : void 0;
        }
        function maybetypeOrIn(type, value) {
            if (isTS && (":" == type || "in" == value)) return cont(typeexpr);
        }
        function mayberettype(type) {
            if (isTS && ":" == type) return cx.stream.match(/^\s*\w+\s+is\b/, !1) ? cont(expression, isKW, typeexpr) : cont(typeexpr);
        }
        function isKW(_, value) {
            if ("is" == value) return cx.marked = "keyword", cont();
        }
        function typeexpr(type, value) {
            return "keyof" == value || "typeof" == value || "infer" == value || "readonly" == value ? (cx.marked = "keyword", 
            cont("typeof" == value ? expressionNoComma : typeexpr)) : "variable" == type || "void" == value ? (cx.marked = "type", 
            cont(afterType)) : "|" == value || "&" == value ? cont(typeexpr) : "string" == type || "number" == type || "atom" == type ? cont(afterType) : "[" == type ? cont(pushlex("]"), commasep(typeexpr, "]", ","), poplex, afterType) : "{" == type ? cont(pushlex("}"), typeprops, poplex, afterType) : "(" == type ? cont(commasep(typearg, ")"), maybeReturnType, afterType) : "<" == type ? cont(commasep(typeexpr, ">"), typeexpr) : "quasi" == type ? pass(quasiType, afterType) : void 0;
        }
        function maybeReturnType(type) {
            if ("=>" == type) return cont(typeexpr);
        }
        function typeprops(type) {
            return type.match(/[\}\)\]]/) ? cont() : "," == type || ";" == type ? cont(typeprops) : pass(typeprop, typeprops);
        }
        function typeprop(type, value) {
            return "variable" == type || "keyword" == cx.style ? (cx.marked = "property", 
            cont(typeprop)) : "?" == value || "number" == type || "string" == type ? cont(typeprop) : ":" == type ? cont(typeexpr) : "[" == type ? cont(expect("variable"), maybetypeOrIn, expect("]"), typeprop) : "(" == type ? pass(functiondecl, typeprop) : type.match(/[;\}\)\],]/) ? void 0 : cont();
        }
        function quasiType(type, value) {
            return "quasi" != type ? pass() : "${" != value.slice(value.length - 2) ? cont(quasiType) : cont(typeexpr, continueQuasiType);
        }
        function continueQuasiType(type) {
            if ("}" == type) return cx.marked = "string-2", cx.state.tokenize = tokenQuasi, 
            cont(quasiType);
        }
        function typearg(type, value) {
            return "variable" == type && cx.stream.match(/^\s*[?:]/, !1) || "?" == value ? cont(typearg) : ":" == type ? cont(typeexpr) : "spread" == type ? cont(typearg) : pass(typeexpr);
        }
        function afterType(type, value) {
            return "<" == value ? cont(pushlex(">"), commasep(typeexpr, ">"), poplex, afterType) : "|" == value || "." == type || "&" == value ? cont(typeexpr) : "[" == type ? cont(typeexpr, expect("]"), afterType) : "extends" == value || "implements" == value ? (cx.marked = "keyword", 
            cont(typeexpr)) : "?" == value ? cont(typeexpr, expect(":"), typeexpr) : void 0;
        }
        function maybeTypeArgs(_, value) {
            if ("<" == value) return cont(pushlex(">"), commasep(typeexpr, ">"), poplex, afterType);
        }
        function typeparam() {
            return pass(typeexpr, maybeTypeDefault);
        }
        function maybeTypeDefault(_, value) {
            if ("=" == value) return cont(typeexpr);
        }
        function vardef(_, value) {
            return "enum" == value ? (cx.marked = "keyword", cont(enumdef)) : pass(pattern, maybetype, maybeAssign, vardefCont);
        }
        function pattern(type, value) {
            return isTS && isModifier(value) ? (cx.marked = "keyword", cont(pattern)) : "variable" == type ? (register(value), 
            cont()) : "spread" == type ? cont(pattern) : "[" == type ? contCommasep(eltpattern, "]") : "{" == type ? contCommasep(proppattern, "}") : void 0;
        }
        function proppattern(type, value) {
            return "variable" != type || cx.stream.match(/^\s*:/, !1) ? ("variable" == type && (cx.marked = "property"), 
            "spread" == type ? cont(pattern) : "}" == type ? pass() : "[" == type ? cont(expression, expect("]"), expect(":"), proppattern) : cont(expect(":"), pattern, maybeAssign)) : (register(value), 
            cont(maybeAssign));
        }
        function eltpattern() {
            return pass(pattern, maybeAssign);
        }
        function maybeAssign(_type, value) {
            if ("=" == value) return cont(expressionNoComma);
        }
        function vardefCont(type) {
            if ("," == type) return cont(vardef);
        }
        function maybeelse(type, value) {
            if ("keyword b" == type && "else" == value) return cont(pushlex("form", "else"), statement, poplex);
        }
        function forspec(type, value) {
            return "await" == value ? cont(forspec) : "(" == type ? cont(pushlex(")"), forspec1, poplex) : void 0;
        }
        function forspec1(type) {
            return "var" == type ? cont(vardef, forspec2) : ("variable" == type ? cont : pass)(forspec2);
        }
        function forspec2(type, value) {
            return ")" == type ? cont() : ";" == type ? cont(forspec2) : ("in" == value || "of" == value ? (cx.marked = "keyword", 
            cont) : pass)(expression, forspec2);
        }
        function functiondef(type, value) {
            return "*" == value ? (cx.marked = "keyword", cont(functiondef)) : "variable" == type ? (register(value), 
            cont(functiondef)) : "(" == type ? cont(pushcontext, pushlex(")"), commasep(funarg, ")"), poplex, mayberettype, statement, popcontext) : isTS && "<" == value ? cont(pushlex(">"), commasep(typeparam, ">"), poplex, functiondef) : void 0;
        }
        function functiondecl(type, value) {
            return "*" == value ? (cx.marked = "keyword", cont(functiondecl)) : "variable" == type ? (register(value), 
            cont(functiondecl)) : "(" == type ? cont(pushcontext, pushlex(")"), commasep(funarg, ")"), poplex, mayberettype, popcontext) : isTS && "<" == value ? cont(pushlex(">"), commasep(typeparam, ">"), poplex, functiondecl) : void 0;
        }
        function typename(type, value) {
            return "keyword" == type || "variable" == type ? (cx.marked = "type", 
            cont(typename)) : "<" == value ? cont(pushlex(">"), commasep(typeparam, ">"), poplex) : void 0;
        }
        function funarg(type, value) {
            return "@" == value && cont(expression, funarg), "spread" == type ? cont(funarg) : isTS && isModifier(value) ? (cx.marked = "keyword", 
            cont(funarg)) : isTS && "this" == type ? cont(maybetype, maybeAssign) : pass(pattern, maybetype, maybeAssign);
        }
        function classExpression(type, value) {
            return ("variable" == type ? className : classNameAfter)(type, value);
        }
        function className(type, value) {
            if ("variable" == type) return register(value), cont(classNameAfter);
        }
        function classNameAfter(type, value) {
            return "<" == value ? cont(pushlex(">"), commasep(typeparam, ">"), poplex, classNameAfter) : "extends" == value || "implements" == value || isTS && "," == type ? ("implements" == value && (cx.marked = "keyword"), 
            cont(isTS ? typeexpr : expression, classNameAfter)) : "{" == type ? cont(pushlex("}"), classBody, poplex) : void 0;
        }
        function classBody(type, value) {
            return "async" == type || "variable" == type && ("static" == value || "get" == value || "set" == value || isTS && isModifier(value)) && cx.stream.match(/^\s+[\w$\xa1-\uffff]/, !1) ? (cx.marked = "keyword", 
            cont(classBody)) : "variable" == type || "keyword" == cx.style ? (cx.marked = "property", 
            cont(classfield, classBody)) : "number" == type || "string" == type ? cont(classfield, classBody) : "[" == type ? cont(expression, maybetype, expect("]"), classfield, classBody) : "*" == value ? (cx.marked = "keyword", 
            cont(classBody)) : isTS && "(" == type ? pass(functiondecl, classBody) : ";" == type || "," == type ? cont(classBody) : "}" == type ? cont() : "@" == value ? cont(expression, classBody) : void 0;
        }
        function classfield(type, value) {
            return "!" == value || "?" == value ? cont(classfield) : ":" == type ? cont(typeexpr, maybeAssign) : "=" == value ? cont(expressionNoComma) : pass((type = cx.state.lexical.prev) && "interface" == type.info ? functiondecl : functiondef);
        }
        function afterExport(type, value) {
            return "*" == value ? (cx.marked = "keyword", cont(maybeFrom, expect(";"))) : "default" == value ? (cx.marked = "keyword", 
            cont(expression, expect(";"))) : "{" == type ? cont(commasep(exportField, "}"), maybeFrom, expect(";")) : pass(statement);
        }
        function exportField(type, value) {
            return "as" == value ? (cx.marked = "keyword", cont(expect("variable"))) : "variable" == type ? pass(expressionNoComma, exportField) : void 0;
        }
        function afterImport(type) {
            return "string" == type ? cont() : "(" == type ? pass(expression) : "." == type ? pass(maybeoperatorComma) : pass(importSpec, maybeMoreImports, maybeFrom);
        }
        function importSpec(type, value) {
            return "{" == type ? contCommasep(importSpec, "}") : ("variable" == type && register(value), 
            "*" == value && (cx.marked = "keyword"), cont(maybeAs));
        }
        function maybeMoreImports(type) {
            if ("," == type) return cont(importSpec, maybeMoreImports);
        }
        function maybeAs(_type, value) {
            if ("as" == value) return cx.marked = "keyword", cont(importSpec);
        }
        function maybeFrom(_type, value) {
            if ("from" == value) return cx.marked = "keyword", cont(expression);
        }
        function arrayLiteral(type) {
            return "]" == type ? cont() : pass(commasep(expressionNoComma, "]"));
        }
        function enumdef() {
            return pass(pushlex("form"), pattern, expect("{"), pushlex("}"), commasep(enummember, "}"), poplex, poplex);
        }
        function enummember() {
            return pass(pattern, maybeAssign);
        }
        function expressionAllowed(stream, state, backUp) {
            return state.tokenize == tokenBase && /^(?:operator|sof|keyword [bcd]|case|new|export|default|spread|[\[{}\(,;:]|=>)$/.test(state.lastType) || "quasi" == state.lastType && /\{\s*$/.test(stream.string.slice(0, stream.pos - (backUp || 0)));
        }
        return pushcontext.lex = pushblockcontext.lex = !0, poplex.lex = popcontext.lex = !0, 
        {
            startState: function(basecolumn) {
                basecolumn = {
                    tokenize: tokenBase,
                    lastType: "sof",
                    cc: [],
                    lexical: new JSLexical((basecolumn || 0) - indentUnit, 0, "block", !1),
                    localVars: parserConfig.localVars,
                    context: parserConfig.localVars && new Context(null, null, !1),
                    indented: basecolumn || 0
                };
                return parserConfig.globalVars && "object" == typeof parserConfig.globalVars && (basecolumn.globalVars = parserConfig.globalVars), 
                basecolumn;
            },
            token: function(stream, state) {
                var style;
                return stream.sol() && (state.lexical.hasOwnProperty("align") || (state.lexical.align = !1), 
                state.indented = stream.indentation(), findFatArrow(stream, state)), 
                state.tokenize != tokenComment && stream.eatSpace() ? null : (style = state.tokenize(stream, state), 
                "comment" == type ? style : (state.lastType = "operator" != type || "++" != content && "--" != content ? type : "incdec", 
                parseJS(state, style, type, content, stream)));
            },
            indent: function(state, textAfter) {
                if (state.tokenize == tokenComment || state.tokenize == tokenQuasi) return CodeMirror.Pass;
                if (state.tokenize != tokenBase) return 0;
                var top, firstChar = textAfter && textAfter.charAt(0), lexical = state.lexical;
                if (!/^\s*else\b/.test(textAfter)) for (var i = state.cc.length - 1; 0 <= i; --i) {
                    var c = state.cc[i];
                    if (c == poplex) lexical = lexical.prev; else if (c != maybeelse && c != popcontext) break;
                }
                for (;("stat" == lexical.type || "form" == lexical.type) && ("}" == firstChar || (top = state.cc[state.cc.length - 1]) && (top == maybeoperatorComma || top == maybeoperatorNoComma) && !/^[,\.=+\-*:?[\(]/.test(textAfter)); ) lexical = lexical.prev;
                var type = (lexical = statementIndent && ")" == lexical.type && "stat" == lexical.prev.type ? lexical.prev : lexical).type, closing = firstChar == type;
                return "vardef" == type ? lexical.indented + ("operator" == state.lastType || "," == state.lastType ? lexical.info.length + 1 : 0) : "form" == type && "{" == firstChar ? lexical.indented : "form" == type ? lexical.indented + indentUnit : "stat" == type ? lexical.indented + (function(state, textAfter) {
                    return "operator" == state.lastType || "," == state.lastType || isOperatorChar.test(textAfter.charAt(0)) || /[,.]/.test(textAfter.charAt(0));
                }(state, textAfter) ? statementIndent || indentUnit : 0) : "switch" != lexical.info || closing || 0 == parserConfig.doubleIndentSwitch ? lexical.align ? lexical.column + (closing ? 0 : 1) : lexical.indented + (closing ? 0 : indentUnit) : lexical.indented + (/^(?:case|default)\b/.test(textAfter) ? indentUnit : 2 * indentUnit);
            },
            electricInput: /^\s*(?:case .*?:|default:|\{|\})$/,
            blockCommentStart: jsonMode ? null : "/*",
            blockCommentEnd: jsonMode ? null : "*/",
            blockCommentContinue: jsonMode ? null : " * ",
            lineComment: jsonMode ? null : "//",
            fold: "brace",
            closeBrackets: "()[]{}''\"\"``",
            helperType: jsonMode ? "json" : "javascript",
            jsonldMode: jsonldMode,
            jsonMode: jsonMode,
            expressionAllowed: expressionAllowed,
            skipExpression: function(state) {
                parseJS(state, "atom", "atom", "true", new CodeMirror.StringStream("", 2, null));
            }
        };
    }), CodeMirror.registerHelper("wordChars", "javascript", /[\w$]/), CodeMirror.defineMIME("text/javascript", "javascript"), 
    CodeMirror.defineMIME("text/ecmascript", "javascript"), CodeMirror.defineMIME("application/javascript", "javascript"), 
    CodeMirror.defineMIME("application/x-javascript", "javascript"), CodeMirror.defineMIME("application/ecmascript", "javascript"), 
    CodeMirror.defineMIME("application/json", {
        name: "javascript",
        json: !0
    }), CodeMirror.defineMIME("application/x-json", {
        name: "javascript",
        json: !0
    }), CodeMirror.defineMIME("application/manifest+json", {
        name: "javascript",
        json: !0
    }), CodeMirror.defineMIME("application/ld+json", {
        name: "javascript",
        jsonld: !0
    }), CodeMirror.defineMIME("text/typescript", {
        name: "javascript",
        typescript: !0
    }), CodeMirror.defineMIME("application/typescript", {
        name: "javascript",
        typescript: !0
    });
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror"), require("../htmlmixed/htmlmixed"), require("../clike/clike")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror", "../htmlmixed/htmlmixed", "../clike/clike" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    function keywords(str) {
        for (var obj = {}, words = str.split(" "), i = 0; i < words.length; ++i) obj[words[i]] = !0;
        return obj;
    }
    function matchSequence(list, end, escapes) {
        return 0 == list.length ? phpString(end) : function(stream, state) {
            for (var patterns = list[0], i = 0; i < patterns.length; i++) if (stream.match(patterns[i][0])) return state.tokenize = matchSequence(list.slice(1), end), 
            patterns[i][1];
            return state.tokenize = phpString(end, escapes), "string";
        };
    }
    function phpString(closing, escapes) {
        return function(stream, state) {
            return function(stream, state, closing, escapes) {
                if (!1 !== escapes && stream.match("${", !1) || stream.match("{$", !1)) state.tokenize = null; else {
                    if (!1 !== escapes && stream.match(/^\$[a-zA-Z_][a-zA-Z0-9_]*/)) return stream.match("[", !1) && (state.tokenize = matchSequence([ [ [ "[", null ] ], [ [ /\d[\w\.]*/, "number" ], [ /\$[a-zA-Z_][a-zA-Z0-9_]*/, "variable-2" ], [ /[\w\$]+/, "variable" ] ], [ [ "]", null ] ] ], closing, escapes)), 
                    stream.match(/^->\w/, !1) && (state.tokenize = matchSequence([ [ [ "->", null ] ], [ [ /[\w]+/, "variable" ] ] ], closing, escapes)), 
                    "variable-2";
                    for (var escaped = !1; !stream.eol() && (escaped || !1 === escapes || !stream.match("{$", !1) && !stream.match(/^(\$[a-zA-Z_][a-zA-Z0-9_]*|\$\{)/, !1)); ) {
                        if (!escaped && stream.match(closing)) {
                            state.tokenize = null, state.tokStack.pop(), state.tokStack.pop();
                            break;
                        }
                        escaped = "\\" == stream.next() && !escaped;
                    }
                }
                return "string";
            }(stream, state, closing, escapes);
        };
    }
    var phpKeywords = "abstract and array as break case catch class clone const continue declare default do else elseif enddeclare endfor endforeach endif endswitch endwhile enum extends final for foreach function global goto if implements interface instanceof namespace new or private protected public static switch throw trait try use var while xor die echo empty exit eval include include_once isset list require require_once return print unset __halt_compiler self static parent yield insteadof finally readonly match", phpAtoms = "true false null TRUE FALSE NULL __CLASS__ __DIR__ __FILE__ __LINE__ __METHOD__ __FUNCTION__ __NAMESPACE__ __TRAIT__", phpBuiltin = "func_num_args func_get_arg func_get_args strlen strcmp strncmp strcasecmp strncasecmp each error_reporting define defined trigger_error user_error set_error_handler restore_error_handler get_declared_classes get_loaded_extensions extension_loaded get_extension_funcs debug_backtrace constant bin2hex hex2bin sleep usleep time mktime gmmktime strftime gmstrftime strtotime date gmdate getdate localtime checkdate flush wordwrap htmlspecialchars htmlentities html_entity_decode md5 md5_file crc32 getimagesize image_type_to_mime_type phpinfo phpversion phpcredits strnatcmp strnatcasecmp substr_count strspn strcspn strtok strtoupper strtolower strpos strrpos strrev hebrev hebrevc nl2br basename dirname pathinfo stripslashes stripcslashes strstr stristr strrchr str_shuffle str_word_count strcoll substr substr_replace quotemeta ucfirst ucwords strtr addslashes addcslashes rtrim str_replace str_repeat count_chars chunk_split trim ltrim strip_tags similar_text explode implode setlocale localeconv parse_str str_pad chop strchr sprintf printf vprintf vsprintf sscanf fscanf parse_url urlencode urldecode rawurlencode rawurldecode readlink linkinfo link unlink exec system escapeshellcmd escapeshellarg passthru shell_exec proc_open proc_close rand srand getrandmax mt_rand mt_srand mt_getrandmax base64_decode base64_encode abs ceil floor round is_finite is_nan is_infinite bindec hexdec octdec decbin decoct dechex base_convert number_format fmod ip2long long2ip getenv putenv getopt microtime gettimeofday getrusage uniqid quoted_printable_decode set_time_limit get_cfg_var magic_quotes_runtime set_magic_quotes_runtime get_magic_quotes_gpc get_magic_quotes_runtime import_request_variables error_log serialize unserialize memory_get_usage memory_get_peak_usage var_dump var_export debug_zval_dump print_r highlight_file show_source highlight_string ini_get ini_get_all ini_set ini_alter ini_restore get_include_path set_include_path restore_include_path setcookie header headers_sent connection_aborted connection_status ignore_user_abort parse_ini_file is_uploaded_file move_uploaded_file intval floatval doubleval strval gettype settype is_null is_resource is_bool is_long is_float is_int is_integer is_double is_real is_numeric is_string is_array is_object is_scalar ereg ereg_replace eregi eregi_replace split spliti join sql_regcase dl pclose popen readfile rewind rmdir umask fclose feof fgetc fgets fgetss fread fopen fpassthru ftruncate fstat fseek ftell fflush fwrite fputs mkdir rename copy tempnam tmpfile file file_get_contents file_put_contents stream_select stream_context_create stream_context_set_params stream_context_set_option stream_context_get_options stream_filter_prepend stream_filter_append fgetcsv flock get_meta_tags stream_set_write_buffer set_file_buffer set_socket_blocking stream_set_blocking socket_set_blocking stream_get_meta_data stream_register_wrapper stream_wrapper_register stream_set_timeout socket_set_timeout socket_get_status realpath fnmatch fsockopen pfsockopen pack unpack get_browser crypt opendir closedir chdir getcwd rewinddir readdir dir glob fileatime filectime filegroup fileinode filemtime fileowner fileperms filesize filetype file_exists is_writable is_writeable is_readable is_executable is_file is_dir is_link stat lstat chown touch clearstatcache mail ob_start ob_flush ob_clean ob_end_flush ob_end_clean ob_get_flush ob_get_clean ob_get_length ob_get_level ob_get_status ob_get_contents ob_implicit_flush ob_list_handlers ksort krsort natsort natcasesort asort arsort sort rsort usort uasort uksort shuffle array_walk count end prev next reset current key min max in_array array_search extract compact array_fill range array_multisort array_push array_pop array_shift array_unshift array_splice array_slice array_merge array_merge_recursive array_keys array_values array_count_values array_reverse array_reduce array_pad array_flip array_change_key_case array_rand array_unique array_intersect array_intersect_assoc array_diff array_diff_assoc array_sum array_filter array_map array_chunk array_key_exists array_intersect_key array_combine array_column pos sizeof key_exists assert assert_options version_compare ftok str_rot13 aggregate session_name session_module_name session_save_path session_id session_regenerate_id session_decode session_register session_unregister session_is_registered session_encode session_start session_destroy session_unset session_set_save_handler session_cache_limiter session_cache_expire session_set_cookie_params session_get_cookie_params session_write_close preg_match preg_match_all preg_replace preg_replace_callback preg_split preg_quote preg_grep overload ctype_alnum ctype_alpha ctype_cntrl ctype_digit ctype_lower ctype_graph ctype_print ctype_punct ctype_space ctype_upper ctype_xdigit virtual apache_request_headers apache_note apache_lookup_uri apache_child_terminate apache_setenv apache_response_headers apache_get_version getallheaders mysql_connect mysql_pconnect mysql_close mysql_select_db mysql_create_db mysql_drop_db mysql_query mysql_unbuffered_query mysql_db_query mysql_list_dbs mysql_list_tables mysql_list_fields mysql_list_processes mysql_error mysql_errno mysql_affected_rows mysql_insert_id mysql_result mysql_num_rows mysql_num_fields mysql_fetch_row mysql_fetch_array mysql_fetch_assoc mysql_fetch_object mysql_data_seek mysql_fetch_lengths mysql_fetch_field mysql_field_seek mysql_free_result mysql_field_name mysql_field_table mysql_field_len mysql_field_type mysql_field_flags mysql_escape_string mysql_real_escape_string mysql_stat mysql_thread_id mysql_client_encoding mysql_get_client_info mysql_get_host_info mysql_get_proto_info mysql_get_server_info mysql_info mysql mysql_fieldname mysql_fieldtable mysql_fieldlen mysql_fieldtype mysql_fieldflags mysql_selectdb mysql_createdb mysql_dropdb mysql_freeresult mysql_numfields mysql_numrows mysql_listdbs mysql_listtables mysql_listfields mysql_db_name mysql_dbname mysql_tablename mysql_table_name pg_connect pg_pconnect pg_close pg_connection_status pg_connection_busy pg_connection_reset pg_host pg_dbname pg_port pg_tty pg_options pg_ping pg_query pg_send_query pg_cancel_query pg_fetch_result pg_fetch_row pg_fetch_assoc pg_fetch_array pg_fetch_object pg_fetch_all pg_affected_rows pg_get_result pg_result_seek pg_result_status pg_free_result pg_last_oid pg_num_rows pg_num_fields pg_field_name pg_field_num pg_field_size pg_field_type pg_field_prtlen pg_field_is_null pg_get_notify pg_get_pid pg_result_error pg_last_error pg_last_notice pg_put_line pg_end_copy pg_copy_to pg_copy_from pg_trace pg_untrace pg_lo_create pg_lo_unlink pg_lo_open pg_lo_close pg_lo_read pg_lo_write pg_lo_read_all pg_lo_import pg_lo_export pg_lo_seek pg_lo_tell pg_escape_string pg_escape_bytea pg_unescape_bytea pg_client_encoding pg_set_client_encoding pg_meta_data pg_convert pg_insert pg_update pg_delete pg_select pg_exec pg_getlastoid pg_cmdtuples pg_errormessage pg_numrows pg_numfields pg_fieldname pg_fieldsize pg_fieldtype pg_fieldnum pg_fieldprtlen pg_fieldisnull pg_freeresult pg_result pg_loreadall pg_locreate pg_lounlink pg_loopen pg_loclose pg_loread pg_lowrite pg_loimport pg_loexport http_response_code get_declared_traits getimagesizefromstring socket_import_stream stream_set_chunk_size trait_exists header_register_callback class_uses session_status session_register_shutdown echo print global static exit array empty eval isset unset die include require include_once require_once json_decode json_encode json_last_error json_last_error_msg curl_close curl_copy_handle curl_errno curl_error curl_escape curl_exec curl_file_create curl_getinfo curl_init curl_multi_add_handle curl_multi_close curl_multi_exec curl_multi_getcontent curl_multi_info_read curl_multi_init curl_multi_remove_handle curl_multi_select curl_multi_setopt curl_multi_strerror curl_pause curl_reset curl_setopt_array curl_setopt curl_share_close curl_share_init curl_share_setopt curl_strerror curl_unescape curl_version mysqli_affected_rows mysqli_autocommit mysqli_change_user mysqli_character_set_name mysqli_close mysqli_commit mysqli_connect_errno mysqli_connect_error mysqli_connect mysqli_data_seek mysqli_debug mysqli_dump_debug_info mysqli_errno mysqli_error_list mysqli_error mysqli_fetch_all mysqli_fetch_array mysqli_fetch_assoc mysqli_fetch_field_direct mysqli_fetch_field mysqli_fetch_fields mysqli_fetch_lengths mysqli_fetch_object mysqli_fetch_row mysqli_field_count mysqli_field_seek mysqli_field_tell mysqli_free_result mysqli_get_charset mysqli_get_client_info mysqli_get_client_stats mysqli_get_client_version mysqli_get_connection_stats mysqli_get_host_info mysqli_get_proto_info mysqli_get_server_info mysqli_get_server_version mysqli_info mysqli_init mysqli_insert_id mysqli_kill mysqli_more_results mysqli_multi_query mysqli_next_result mysqli_num_fields mysqli_num_rows mysqli_options mysqli_ping mysqli_prepare mysqli_query mysqli_real_connect mysqli_real_escape_string mysqli_real_query mysqli_reap_async_query mysqli_refresh mysqli_rollback mysqli_select_db mysqli_set_charset mysqli_set_local_infile_default mysqli_set_local_infile_handler mysqli_sqlstate mysqli_ssl_set mysqli_stat mysqli_stmt_init mysqli_store_result mysqli_thread_id mysqli_thread_safe mysqli_use_result mysqli_warning_count", phpConfig = (CodeMirror.registerHelper("hintWords", "php", [ phpKeywords, phpAtoms, phpBuiltin ].join(" ").split(" ")), 
    CodeMirror.registerHelper("wordChars", "php", /[\w$]/), {
        name: "clike",
        helperType: "php",
        keywords: keywords(phpKeywords),
        blockKeywords: keywords("catch do else elseif for foreach if switch try while finally"),
        defKeywords: keywords("class enum function interface namespace trait"),
        atoms: keywords(phpAtoms),
        builtin: keywords(phpBuiltin),
        multiLineStrings: !0,
        hooks: {
            $: function(stream) {
                return stream.eatWhile(/[\w\$_]/), "variable-2";
            },
            "<": function(stream, state) {
                if (before = stream.match(/^<<\s*/)) {
                    var quoted = stream.eat(/['"]/), before = (stream.eatWhile(/[\w\.]/), 
                    stream.current().slice(before[0].length + (quoted ? 2 : 1)));
                    if (quoted && stream.eat(quoted), before) return (state.tokStack || (state.tokStack = [])).push(before, 0), 
                    state.tokenize = phpString(before, "'" != quoted), "string";
                }
                return !1;
            },
            "#": function(stream) {
                for (;!stream.eol() && !stream.match("?>", !1); ) stream.next();
                return "comment";
            },
            "/": function(stream) {
                if (stream.eat("/")) {
                    for (;!stream.eol() && !stream.match("?>", !1); ) stream.next();
                    return "comment";
                }
                return !1;
            },
            '"': function(_stream, state) {
                return (state.tokStack || (state.tokStack = [])).push('"', 0), state.tokenize = phpString('"'), 
                "string";
            },
            "{": function(_stream, state) {
                return state.tokStack && state.tokStack.length && state.tokStack[state.tokStack.length - 1]++, 
                !1;
            },
            "}": function(_stream, state) {
                return state.tokStack && 0 < state.tokStack.length && !--state.tokStack[state.tokStack.length - 1] && (state.tokenize = phpString(state.tokStack[state.tokStack.length - 2])), 
                !1;
            }
        }
    });
    CodeMirror.defineMode("php", function(config, parserConfig) {
        var htmlMode = CodeMirror.getMode(config, parserConfig && parserConfig.htmlMode || "text/html"), phpMode = CodeMirror.getMode(config, phpConfig);
        return {
            startState: function() {
                var html = CodeMirror.startState(htmlMode), php = parserConfig.startOpen ? CodeMirror.startState(phpMode) : null;
                return {
                    html: html,
                    php: php,
                    curMode: parserConfig.startOpen ? phpMode : htmlMode,
                    curState: parserConfig.startOpen ? php : html,
                    pending: null
                };
            },
            copyState: function(state) {
                var html = state.html, html = CodeMirror.copyState(htmlMode, html), php = state.php, php = php && CodeMirror.copyState(phpMode, php), cur = state.curMode == htmlMode ? html : php;
                return {
                    html: html,
                    php: php,
                    curMode: state.curMode,
                    curState: cur,
                    pending: state.pending
                };
            },
            token: function(stream, state) {
                var isPHP = state.curMode == phpMode;
                if (stream.sol() && state.pending && '"' != state.pending && "'" != state.pending && (state.pending = null), 
                isPHP) return null == state.php.tokenize && stream.match("?>") ? (state.curMode = htmlMode, 
                state.curState = state.html, state.php.context.prev || (state.php = null), 
                "meta") : phpMode.token(stream, state.curState);
                if (stream.match(/^<\?\w*/)) return state.curMode = phpMode, state.php || (state.php = CodeMirror.startState(phpMode, htmlMode.indent(state.html, "", ""))), 
                state.curState = state.php, "meta";
                if ('"' == state.pending || "'" == state.pending) {
                    for (;!stream.eol() && stream.next() != state.pending; );
                    var style = "string";
                } else style = state.pending && stream.pos < state.pending.end ? (stream.pos = state.pending.end, 
                state.pending.style) : htmlMode.token(stream, state.curState);
                state.pending && (state.pending = null);
                var m, openPHP = (isPHP = stream.current()).search(/<\?/);
                return -1 != openPHP && ("string" == style && (m = isPHP.match(/[\'\"]$/)) && !/\?>/.test(isPHP) ? state.pending = m[0] : state.pending = {
                    end: stream.pos,
                    style: style
                }, stream.backUp(isPHP.length - openPHP)), style;
            },
            indent: function(state, textAfter, line) {
                return state.curMode != phpMode && /^\s*<\//.test(textAfter) || state.curMode == phpMode && /^\?>/.test(textAfter) ? htmlMode.indent(state.html, textAfter, line) : state.curMode.indent(state.curState, textAfter, line);
            },
            blockCommentStart: "/*",
            blockCommentEnd: "*/",
            lineComment: "//",
            innerMode: function(state) {
                return {
                    state: state.curState,
                    mode: state.curMode
                };
            }
        };
    }, "htmlmixed", "clike"), CodeMirror.defineMIME("application/x-httpd-php", "php"), 
    CodeMirror.defineMIME("application/x-httpd-php-open", {
        name: "php",
        startOpen: !0
    }), CodeMirror.defineMIME("text/x-php", phpConfig);
}), function(mod) {
    "object" == typeof exports && "object" == typeof module ? mod(require("../../lib/codemirror")) : "function" == typeof define && define.amd ? define([ "../../lib/codemirror" ], mod) : mod(CodeMirror);
}(function(CodeMirror) {
    "use strict";
    var htmlConfig = {
        autoSelfClosers: {
            area: !0,
            base: !0,
            br: !0,
            col: !0,
            command: !0,
            embed: !0,
            frame: !0,
            hr: !0,
            img: !0,
            input: !0,
            keygen: !0,
            link: !0,
            meta: !0,
            param: !0,
            source: !0,
            track: !0,
            wbr: !0,
            menuitem: !0
        },
        implicitlyClosed: {
            dd: !0,
            li: !0,
            optgroup: !0,
            option: !0,
            p: !0,
            rp: !0,
            rt: !0,
            tbody: !0,
            td: !0,
            tfoot: !0,
            th: !0,
            tr: !0
        },
        contextGrabbers: {
            dd: {
                dd: !0,
                dt: !0
            },
            dt: {
                dd: !0,
                dt: !0
            },
            li: {
                li: !0
            },
            option: {
                option: !0,
                optgroup: !0
            },
            optgroup: {
                optgroup: !0
            },
            p: {
                address: !0,
                article: !0,
                aside: !0,
                blockquote: !0,
                dir: !0,
                div: !0,
                dl: !0,
                fieldset: !0,
                footer: !0,
                form: !0,
                h1: !0,
                h2: !0,
                h3: !0,
                h4: !0,
                h5: !0,
                h6: !0,
                header: !0,
                hgroup: !0,
                hr: !0,
                menu: !0,
                nav: !0,
                ol: !0,
                p: !0,
                pre: !0,
                section: !0,
                table: !0,
                ul: !0
            },
            rp: {
                rp: !0,
                rt: !0
            },
            rt: {
                rp: !0,
                rt: !0
            },
            tbody: {
                tbody: !0,
                tfoot: !0
            },
            td: {
                td: !0,
                th: !0
            },
            tfoot: {
                tbody: !0
            },
            th: {
                td: !0,
                th: !0
            },
            thead: {
                tbody: !0,
                tfoot: !0
            },
            tr: {
                tr: !0
            }
        },
        doNotIndent: {
            pre: !0
        },
        allowUnquoted: !0,
        allowMissing: !0,
        caseFold: !0
    }, xmlConfig = {
        autoSelfClosers: {},
        implicitlyClosed: {},
        contextGrabbers: {},
        doNotIndent: {},
        allowUnquoted: !1,
        allowMissing: !1,
        allowMissingTagName: !1,
        caseFold: !1
    };
    CodeMirror.defineMode("xml", function(editorConf, config_) {
        var prop, type, setStyle, indentUnit = editorConf.indentUnit, config = {}, defaults = config_.htmlMode ? htmlConfig : xmlConfig;
        for (prop in defaults) config[prop] = defaults[prop];
        for (prop in config_) config[prop] = config_[prop];
        function inText(stream, state) {
            function chain(parser) {
                return (state.tokenize = parser)(stream, state);
            }
            var ch = stream.next();
            return "<" == ch ? stream.eat("!") ? stream.eat("[") ? stream.match("CDATA[") ? chain(inBlock("atom", "]]>")) : null : stream.match("--") ? chain(inBlock("comment", "--\x3e")) : stream.match("DOCTYPE", !0, !0) ? (stream.eatWhile(/[\w\._\-]/), 
            chain(function doctype(depth) {
                return function(stream, state) {
                    for (var ch; null != (ch = stream.next()); ) {
                        if ("<" == ch) return state.tokenize = doctype(depth + 1), 
                        state.tokenize(stream, state);
                        if (">" == ch) {
                            if (1 != depth) return state.tokenize = doctype(depth - 1), 
                            state.tokenize(stream, state);
                            state.tokenize = inText;
                            break;
                        }
                    }
                    return "meta";
                };
            }(1))) : null : stream.eat("?") ? (stream.eatWhile(/[\w\._\-]/), state.tokenize = inBlock("meta", "?>"), 
            "meta") : (type = stream.eat("/") ? "closeTag" : "openTag", state.tokenize = inTag, 
            "tag bracket") : "&" == ch ? (stream.eat("#") ? stream.eat("x") ? stream.eatWhile(/[a-fA-F\d]/) && stream.eat(";") : stream.eatWhile(/[\d]/) && stream.eat(";") : stream.eatWhile(/[\w\.\-:]/) && stream.eat(";")) ? "atom" : "error" : (stream.eatWhile(/[^&<]/), 
            null);
        }
        function inTag(stream, state) {
            var next, quote, ch = stream.next();
            return ">" == ch || "/" == ch && stream.eat(">") ? (state.tokenize = inText, 
            type = ">" == ch ? "endTag" : "selfcloseTag", "tag bracket") : "=" == ch ? (type = "equals", 
            null) : "<" == ch ? (state.tokenize = inText, state.state = baseState, 
            state.tagName = state.tagStart = null, (next = state.tokenize(stream, state)) ? next + " tag error" : "tag error") : /[\'\"]/.test(ch) ? (state.tokenize = (quote = ch, 
            closure.isInAttribute = !0, closure), state.stringStartCol = stream.column(), 
            state.tokenize(stream, state)) : (stream.match(/^[^\s\u00a0=<>\"\']*[^\s\u00a0=<>\"\'\/]/), 
            "word");
            function closure(stream, state) {
                for (;!stream.eol(); ) if (stream.next() == quote) {
                    state.tokenize = inTag;
                    break;
                }
                return "string";
            }
        }
        function inBlock(style, terminator) {
            return function(stream, state) {
                for (;!stream.eol(); ) {
                    if (stream.match(terminator)) {
                        state.tokenize = inText;
                        break;
                    }
                    stream.next();
                }
                return style;
            };
        }
        function lower(tagName) {
            return tagName && tagName.toLowerCase();
        }
        function Context(state, tagName, startOfLine) {
            this.prev = state.context, this.tagName = tagName || "", this.indent = state.indented, 
            this.startOfLine = startOfLine, (config.doNotIndent.hasOwnProperty(tagName) || state.context && state.context.noIndent) && (this.noIndent = !0);
        }
        function popContext(state) {
            state.context && (state.context = state.context.prev);
        }
        function maybePopContext(state, nextTagName) {
            for (var parentTagName; ;) {
                if (!state.context) return;
                if (parentTagName = state.context.tagName, !config.contextGrabbers.hasOwnProperty(lower(parentTagName)) || !config.contextGrabbers[lower(parentTagName)].hasOwnProperty(lower(nextTagName))) return;
                popContext(state);
            }
        }
        function baseState(type, stream, state) {
            return "openTag" == type ? (state.tagStart = stream.column(), tagNameState) : "closeTag" == type ? closeTagNameState : baseState;
        }
        function tagNameState(type, stream, state) {
            return "word" == type ? (state.tagName = stream.current(), setStyle = "tag", 
            attrState) : config.allowMissingTagName && "endTag" == type ? (setStyle = "tag bracket", 
            attrState(type, 0, state)) : (setStyle = "error", tagNameState);
        }
        function closeTagNameState(type, stream, state) {
            var tagName;
            return "word" == type ? (tagName = stream.current(), state.context && state.context.tagName != tagName && config.implicitlyClosed.hasOwnProperty(lower(state.context.tagName)) && popContext(state), 
            state.context && state.context.tagName == tagName || !1 === config.matchClosing ? (setStyle = "tag", 
            closeState) : (setStyle = "tag error", closeStateErr)) : config.allowMissingTagName && "endTag" == type ? (setStyle = "tag bracket", 
            closeState(type, 0, state)) : (setStyle = "error", closeStateErr);
        }
        function closeState(type, _stream, state) {
            return "endTag" != type ? (setStyle = "error", closeState) : (popContext(state), 
            baseState);
        }
        function closeStateErr(type, stream, state) {
            return setStyle = "error", closeState(type, 0, state);
        }
        function attrState(type, _stream, state) {
            var tagName, tagStart;
            return "word" == type ? (setStyle = "attribute", attrEqState) : "endTag" == type || "selfcloseTag" == type ? (tagName = state.tagName, 
            tagStart = state.tagStart, state.tagName = state.tagStart = null, "selfcloseTag" == type || config.autoSelfClosers.hasOwnProperty(lower(tagName)) ? maybePopContext(state, tagName) : (maybePopContext(state, tagName), 
            state.context = new Context(state, tagName, tagStart == state.indented)), 
            baseState) : (setStyle = "error", attrState);
        }
        function attrEqState(type, stream, state) {
            return "equals" == type ? attrValueState : (config.allowMissing || (setStyle = "error"), 
            attrState(type, 0, state));
        }
        function attrValueState(type, stream, state) {
            return "string" == type ? attrContinuedState : "word" == type && config.allowUnquoted ? (setStyle = "string", 
            attrState) : (setStyle = "error", attrState(type, 0, state));
        }
        function attrContinuedState(type, stream, state) {
            return "string" == type ? attrContinuedState : attrState(type, 0, state);
        }
        return inText.isInText = !0, {
            startState: function(baseIndent) {
                var state = {
                    tokenize: inText,
                    state: baseState,
                    indented: baseIndent || 0,
                    tagName: null,
                    tagStart: null,
                    context: null
                };
                return null != baseIndent && (state.baseIndent = baseIndent), state;
            },
            token: function(stream, state) {
                if (!state.tagName && stream.sol() && (state.indented = stream.indentation()), 
                stream.eatSpace()) return null;
                type = null;
                var style = state.tokenize(stream, state);
                return style = (style || type) && "comment" != style && (setStyle = null, 
                state.state = state.state(type || style, stream, state), setStyle) ? "error" == setStyle ? style + " error" : setStyle : style;
            },
            indent: function(state, textAfter, fullLine) {
                var context = state.context;
                if (state.tokenize.isInAttribute) return state.tagStart == state.indented ? state.stringStartCol + 1 : state.indented + indentUnit;
                if (context && context.noIndent) return CodeMirror.Pass;
                if (state.tokenize != inTag && state.tokenize != inText) return fullLine ? fullLine.match(/^(\s*)/)[0].length : 0;
                if (state.tagName) return !1 !== config.multilineTagIndentPastTag ? state.tagStart + state.tagName.length + 2 : state.tagStart + indentUnit * (config.multilineTagIndentFactor || 1);
                if (config.alignCDATA && /<!\[CDATA\[/.test(textAfter)) return 0;
                var tagAfter = textAfter && /^<(\/)?([\w_:\.-]*)/.exec(textAfter);
                if (tagAfter && tagAfter[1]) for (;context; ) {
                    if (context.tagName == tagAfter[2]) {
                        context = context.prev;
                        break;
                    }
                    if (!config.implicitlyClosed.hasOwnProperty(lower(context.tagName))) break;
                    context = context.prev;
                } else if (tagAfter) for (;context; ) {
                    var grabbers = config.contextGrabbers[lower(context.tagName)];
                    if (!grabbers || !grabbers.hasOwnProperty(lower(tagAfter[2]))) break;
                    context = context.prev;
                }
                for (;context && context.prev && !context.startOfLine; ) context = context.prev;
                return context ? context.indent + indentUnit : state.baseIndent || 0;
            },
            electricInput: /<\/[\s\w:]+>$/,
            blockCommentStart: "\x3c!--",
            blockCommentEnd: "--\x3e",
            configuration: config.htmlMode ? "html" : "xml",
            helperType: config.htmlMode ? "html" : "xml",
            skipAttribute: function(state) {
                state.state == attrValueState && (state.state = attrState);
            },
            xmlCurrentTag: function(state) {
                return state.tagName ? {
                    name: state.tagName,
                    close: "closeTag" == state.type
                } : null;
            },
            xmlCurrentContext: function(state) {
                for (var context = [], cx = state.context; cx; cx = cx.prev) context.push(cx.tagName);
                return context.reverse();
            }
        };
    }), CodeMirror.defineMIME("text/xml", "xml"), CodeMirror.defineMIME("application/xml", "xml"), 
    CodeMirror.mimeModes.hasOwnProperty("text/html") || CodeMirror.defineMIME("text/html", {
        name: "xml",
        htmlMode: !0
    });
});