/* jce - 2.9.63 | 2024-03-11 | https://www.joomlacontenteditor.net | Copyright (C) 2006 - 2024 Ryan Demmer. All rights reserved | GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html */
!function($) {
    $.fn.codemirror = function(options) {
        return this.each(function() {
            if ("undefined" == typeof CodeMirror) throw "CodeMirror is not loaded!";
            "codemirror" == options.theme && (options.theme = "default");
            var settings = {
                mode: options.mode || "text/html",
                theme: options.theme,
                indentWithTabs: !0,
                smartIndent: !0,
                tabMode: "indent",
                styleActiveLine: !0,
                highlightSelectionMatches: !!options.selection_match,
                autoCloseTags: !!options.tag_closing,
                foldGutter: !0,
                gutters: [ "CodeMirror-linenumbers", "CodeMirror-foldgutter" ],
                widget: "..."
            }, cm = CodeMirror($(this).get(0), settings);
            cm.activeLine = 0, $(this).on("codemirror:wrap", function(evt, state) {
                cm.setOption("lineWrapping", state);
                try {
                    cm.focus();
                } catch (e) {}
            }), options.font_size && (/px/.test(options.font_size) || (options.font_size += "px"), 
            cm.getWrapperElement().style.fontSize = options.font_size), $(this).on("codemirror:linenumbers", function(evt, state) {
                cm.setOption("lineNumbers", state);
                try {
                    cm.focus();
                } catch (e) {}
            }), $(this).on("codemirror:highlight", function(evt, state) {
                var c = cm.getCursor();
                state ? cm.setOption("mode", settings.mode) : cm.setOption("mode", "text/plain"), 
                cm.setCursor(c);
                try {
                    cm.focus();
                } catch (e) {}
            }), $(this).on("codemirror:resize", function(evt, w, h) {
                cm.setSize(w || null, h);
            }), $(this).on("codemirror:setcontent", function(evt, value) {
                cm.setValue(value = "" === value ? "\xa0" : value);
                try {
                    cm.focus();
                } catch (e) {}
            }), $(this).on("codemirror:insertcontent", function(value) {
                return cm.replaceSelection(value);
            }), $(this).on("codemirror:getcontent", function() {
                return cm.getValue().replace(/^\s*|\s*$/g, "");
            }), cm.getSearchState = function() {
                return cm.state.search || (cm.state.search = new function() {
                    this.posFrom = this.posTo = this.query = null, this.marked = [];
                }());
            }, cm.clearSearch = function() {
                cm.operation(function() {
                    var state = cm.getSearchState(cm);
                    if (state.query) {
                        state.query = null;
                        for (var i = 0; i < state.marked.length; ++i) state.marked[i].clear();
                        state.marked.length = 0, cm.removeOverlay(state.overlay);
                    }
                });
            }, $(this).on("codemirror:clearsearch", cm.clearSearch), $(this).on("codemirror:search", function(evt, query, rev, re) {
                function getSearchCursor(cm, query, pos) {
                    return cm.getSearchCursor(query, pos, "string" == typeof query && query == query.toLowerCase());
                }
                function findNext(cm, rev) {
                    cm.operation(function() {
                        var state = cm.getSearchState(), cursor = getSearchCursor(cm, state.query, rev ? state.posFrom : state.posTo);
                        (cursor.find(rev) || (cursor = getSearchCursor(cm, state.query, rev ? CodeMirror.Pos(cm.lastLine()) : CodeMirror.Pos(cm.firstLine(), 0))).find(rev)) && (cm.setSelection(cursor.pos.from, cursor.pos.to), 
                        state.posFrom = cursor.pos.from, state.posTo = cursor.pos.to, 
                        cm.scrollIntoView(cursor.pos.from));
                    });
                }
                re && (query = new RegExp(query)), cm.getSearchState(cm).query !== query && cm.clearSearch(), 
                function(cm, rev, query) {
                    var state = cm.getSearchState(cm);
                    state.query ? findNext(cm, rev) : query && (state.query = query, 
                    cm.removeOverlay(state.overlay), state.overlay = function(query) {
                        return "string" == typeof query ? {
                            token: function(stream) {
                                if (stream.match(query)) return "searching";
                                stream.next(), stream.skipTo(query.charAt(0)) || stream.skipToEnd();
                            }
                        } : {
                            token: function(stream) {
                                if (stream.match(query)) return "searching";
                                for (;!stream.eol() && (stream.next(), !stream.match(query, !1)); );
                            }
                        };
                    }(state.query), cm.addOverlay(state.overlay), state.posFrom = state.posTo = cm.getCursor(), 
                    findNext(cm, rev));
                }(cm, rev, query);
            }), $(this).on("codemirror:replace", function(evt, query, text, all, re) {
                function getSearchCursor(cm, query, pos) {
                    return cm.getSearchCursor(query, pos, "string" == typeof query && query == query.toLowerCase());
                }
                if (re && (query = new RegExp(query)), all) for (var cursor = getSearchCursor(cm, query); cursor.findNext(); ) if ("string" != typeof query) {
                    var match = cm.getRange(cursor.from(), cursor.to()).match(query);
                    if (!match) return;
                    cursor.replace(text.replace(/\$(\d)/g, function(w, i) {
                        return match[i];
                    }));
                } else cursor.replace(text); else {
                    cm.clearSearch();
                    cursor = getSearchCursor(cm, query, cm.getCursor());
                    !function() {
                        var match, start = cursor.pos.from;
                        !(match = cursor.findNext()) && (cursor = cm.getSearchCursor(query), 
                        !start || !(match = cursor.findNext()) || cursor.pos.from.line == start.line && cursor.pos.from.ch == start.ch) || (cm.setSelection(cursor.pos.from, cursor.pos.to), 
                        function(match) {
                            cursor.replace("string" == typeof query ? text : text.replace(/\$(\d)/, function(w, i) {
                                return match[i];
                            }));
                        }(match), cm.setCursor(cursor.pos.to), cm.scrollIntoView(cursor.pos.to)), 
                        cm.focus();
                    }();
                }
            }), cm.format = function() {
                CodeMirror.commands.selectAll(cm);
                var range = {
                    from: cm.getCursor(!0),
                    to: cm.getCursor(!1)
                };
                cm.autoFormatRange(range.from, range.to);
            }, cm.setCursorPos = function(pos) {
                cm.setCursor({
                    line: pos,
                    ch: 0
                }, {
                    scroll: !1
                });
                var doc = cm.getDoc(), cursor = doc.getCursor(), doc = doc.getLine(cursor.line);
                cm.setCursor({
                    line: pos,
                    ch: doc.length
                }, {
                    scroll: !0
                }), cm.activeLine = pos;
            }, cm.getCursorPos = function() {
                return cm.getCursor().line || cm.activeLine || 1;
            }, cm.on("mousedown", function() {
                window.setTimeout(function() {
                    cm.activeLine = cm.getCursor().line;
                }, 10);
            }), cm.on("keyup", function() {
                window.setTimeout(function() {
                    cm.activeLine = cm.getCursor().line;
                }, 10);
            }), cm.refresh(), cm.isActive = !0;
        });
    };
}(jQuery), function($) {
    function getExtension(filename) {
        return (filename = filename.split("."))[filename.length - 1];
    }
    var mimeMap = {
        html: "html",
        htm: "html",
        js: "javascript",
        css: "css",
        scss: "css",
        less: "css",
        json: "javascript",
        xml: "xml",
        txt: "plain",
        md: "plain"
    };
    window.CodeEditor = {
        options: {
            format: !0,
            width: "100%",
            height: "100%",
            theme: "codemirror",
            font_size: "",
            fullscreen: !1,
            editor: {},
            format_options: {},
            linenumbers: !0,
            wrap: !0,
            onsave: function() {}
        },
        init: function(options) {
            var self = this, content = ($.extend(this.options, options), this.src = tinyMCEPopup.getWindowArg("url"), 
            tinyMCEPopup.getWindowArg("content") || "\xa0");
            function loadContent(content) {
                self.options.format && (content = content && self.formatHTML(content)), 
                self._load(content);
            }
            $(document).ready(function() {
                self._createToolbar();
                var extension = getExtension(self.src);
                self.options.mode = "text/" + (mimeMap[extension] || "html"), $(".source-editor-container").codemirror(self.options), 
                loadContent(content), self.src && $.ajax({
                    url: self.src + "?" + $.now(),
                    dataType: "text"
                }).done(function(content) {
                    loadContent(content);
                }).fail(function(e, status, txt) {
                    "abort" !== status && Wf.Modal.alert(status);
                }), $("button.save").on("click", function(e) {
                    self.save(), e.preventDefault();
                });
            });
        },
        formatHTML: function(html, options) {
            var extension;
            if (this.src && /\.json$/i.test(this.src)) try {
                html = JSON.stringify(JSON.parse(html), null, "\t");
            } catch (e) {} else options = $.extend({
                max_char: 0,
                wrap_line_length: 0,
                inline: [ "a", "abbr", "b", "bdi", "bdo", "br", "cite", "code", "data", "del", "dfn", "em", "i", "img", "ins", "kbd", "keygen", "map", "mark", "math", "meter", "noscript", "output", "progress", "q", "ruby", "s", "samp", "small", "span", "strong", "sub", "sup", "time", "u", "var", "wbr", "text", "acronym", "big", "strike", "tt" ]
            }, this.options.format_options), "undefined" != typeof html_beautify && (extension = getExtension(this.src), 
            html = "javascript" === (extension = mimeMap[extension] || "html") ? js_beautify(html) : "css" === extension ? css_beautify(html) : html_beautify(html, options));
            return html;
        },
        _createToolbar: function() {
            var opt = this.options, $elm = $(".source-editor-container");
            $(".source-editor .uk-navbar button").click(function(e) {
                e.preventDefault();
                var f, r, e = $(this).data("action");
                return "search" == e || "search-previous" == e ? (f = $("#source_search_value").val(), 
                $elm.trigger("codemirror:search", [ f, !("search-previous" != e), $('button[data-action="regex"]').hasClass("uk-active") ])) : "replace" == e || "replace-all" == e ? (f = $("#source_search_value").val(), 
                r = $("#source_replace_value").val(), $elm.trigger("codemirror:replace", [ f, r, !("replace-all" != e), $('button[data-action="regex"]').hasClass("uk-active") ])) : ($(this).hasClass("uk-button-checkbox") && $(this).toggleClass("uk-active"), 
                void $elm.trigger("codemirror:" + e, $(this).hasClass("uk-active")));
            }).filter(".uk-button-checkbox").each(function() {
                var action = $(this).data("action");
                opt[action] && $(this).addClass("uk-active");
            }), $("#source_search_value").change(function() {
                "" === this.value && $elm.trigger("codemirror:clearsearch");
            });
        },
        setButtonState: function(button, state) {
            $('.source-editor .uk-navbar button[data-action="' + button + '"]').toggleClass("uk-active", state);
        },
        _load: function(content) {
            var self = this;
            $(".source-editor-container").on("codemirror:format", function() {
                var html = $(this).triggerHandler("codemirror:getcontent");
                self.setContent(html, !0);
            }), this._loaded(content);
        },
        _loaded: function(content) {
            this.setContent(content), $(".source-editor-container").trigger("codemirror:wrap", !!this.options.wrap), 
            $(".source-editor-container").trigger("codemirror:linenumbers", !!this.options.linenumbers), 
            $(".source-editor-container").trigger("codemirror:focus");
        },
        setContent: function(value, format) {
            format && (value = this.formatHTML(value)), $(".source-editor-container").trigger("codemirror:setcontent", value);
        },
        getContent: function() {
            return $(".source-editor-container").triggerHandler("codemirror:getcontent");
        },
        resize: function(w, h, init) {
            h -= $(".uk-navbar").outerHeight(), $(".source-editor-container").css({
                width: w,
                height: h
            });
        },
        undo: function() {
            this.editor.undo(), this.focus();
        },
        redo: function() {
            this.editor.redo(), this.focus();
        },
        indent: function() {},
        getContainer: function() {
            return this.container || null;
        },
        format: function() {
            var html = this.getContent(), html = this._format(html);
            this.setContent(html);
        },
        setActive: function(state) {
            this.editor.isActive = !!state;
        },
        _setLoader: function() {
            $('<div class="loading"></div>').appendTo("body");
        },
        _removeLoader: function() {
            $("div.loading", "body").remove();
        },
        save: function() {
            var self = this, src = tinyMCEPopup.getWindowArg("src"), content = this.getContent(), name = "", ext = "html", options = (src && (name = Wf.String.basename(src), 
            name = Wf.String.stripExt(name), ext = Wf.String.getExt(src)), self._setLoader(), 
            FileBrowser.options);
            Wf.Modal.prompt(tinyMCEPopup.getLang("dlg.save_file", "Save File"), function(name) {
                name = Wf.String.safe(name, options.websafe_mode, options.websafe_spaces, options.websafe_textcase);
                var saveResolve = tinyMCEPopup.getWindowArg("save");
                "function" == typeof saveResolve ? saveResolve(name, content).finally(function() {
                    self._removeLoader();
                }) : (saveResolve = name + "." + ext || Wf.String.basename(src), 
                Wf.JSON.request("saveTextFile", {
                    json: [ src, saveResolve ],
                    data: content
                }, function(o) {
                    self.options.onsave.apply(self.options.scope || self, [ src ]), 
                    self._removeLoader();
                }));
            }, {
                text: tinyMCEPopup.getLang("dlg.name", "Name"),
                value: name,
                open: function(e) {
                    $(".uk-modal-footer .uk-text", e.target).text(tinyMCEPopup.getLang("dlg.save", "Save")), 
                    $("#dialog-prompt-input").parent().addClass("uk-form-icon uk-form-icon-flip").append('<span class="uk-text-muted uk-icon-none">.' + ext + "</span>");
                },
                validate: function(value) {
                    return !!value && Wf.String.safe(value, options.websafe_mode, options.websafe_spaces, options.websafe_textcase);
                }
            });
        }
    };
}(jQuery);