/* jce - 2.9.63 | 2024-03-11 | https://www.joomlacontenteditor.net | Copyright (C) 2006 - 2024 Ryan Demmer. All rights reserved | GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html */
!function(window) {
    function WebGLProgram(gl, vertexSource, fragmentSource) {
        function _collect(source, prefix, collection) {
            prefix = new RegExp("\\b" + prefix + " \\w+ (\\w+)", "ig"), source.replace(prefix, function(match, name) {
                return collection[name] = 0, match;
            });
        }
        function _compile(gl, source, type) {
            return type = gl.createShader(type), gl.shaderSource(type, source), 
            gl.compileShader(type), gl.getShaderParameter(type, gl.COMPILE_STATUS) ? type : (console.log(gl.getShaderInfoLog(type)), 
            null);
        }
        this.uniform = {}, this.attribute = {};
        var a, u, _vsh = _compile(gl, vertexSource, gl.VERTEX_SHADER), _fsh = _compile(gl, fragmentSource, gl.FRAGMENT_SHADER);
        for (a in this.id = gl.createProgram(), gl.attachShader(this.id, _vsh), 
        gl.attachShader(this.id, _fsh), gl.linkProgram(this.id), gl.getProgramParameter(this.id, gl.LINK_STATUS) || console.log(gl.getProgramInfoLog(this.id)), 
        gl.useProgram(this.id), _collect(vertexSource, "attribute", this.attribute), 
        this.attribute) this.attribute[a] = gl.getAttribLocation(this.id, a);
        for (u in _collect(vertexSource, "uniform", this.uniform), _collect(fragmentSource, "uniform", this.uniform), 
        this.uniform) this.uniform[u] = gl.getUniformLocation(this.id, u);
    }
    window.WebGLImageFilter = function() {
        var gl = null, _drawCount = 0, _sourceTexture = null, _lastInChain = !1, _currentFramebufferIndex = -1, _tempFramebuffers = [ null, null ], _filterChain = [], _width = -1, _height = -1, _vertexBuffer = null, _currentProgram = null, _canvas = document.createElement("canvas");
        try {
            gl = _canvas.getContext("webgl") || _canvas.getContext("experimental-webgl");
        } catch (e) {
            return !1;
        }
        this.addFilter = function(name) {
            var args = Array.prototype.slice.call(arguments, 1), filter = _filter[name];
            _filterChain.push({
                func: filter,
                args: args
            });
        }, this.reset = function() {
            _filterChain = [];
        }, this.apply = function(image) {
            if (_resize(image.width, image.height), _drawCount = 0, _sourceTexture = gl.createTexture(), 
            gl.bindTexture(gl.TEXTURE_2D, _sourceTexture), gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE), 
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE), 
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST), 
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST), 
            gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, image), 
            0 == _filterChain.length) _compileShader(SHADER.FRAGMENT_IDENTITY), 
            _draw(); else for (var i = 0; i < _filterChain.length; i++) {
                _lastInChain = i == _filterChain.length - 1;
                var f = _filterChain[i];
                f.func.apply(this, f.args || []);
            }
            return _canvas;
        };
        var _resize = function(width, height) {
            width == _width && height == _height || (_canvas.width = _width = width, 
            _canvas.height = _height = height, _vertexBuffer || (width = new Float32Array([ -1, -1, 0, 1, 1, -1, 1, 1, -1, 1, 0, 0, -1, 1, 0, 0, 1, -1, 1, 1, 1, 1, 1, 0 ]), 
            _vertexBuffer = gl.createBuffer(), gl.bindBuffer(gl.ARRAY_BUFFER, _vertexBuffer), 
            gl.bufferData(gl.ARRAY_BUFFER, width, gl.STATIC_DRAW), gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, !0)), 
            gl.viewport(0, 0, _width, _height), _tempFramebuffers = [ null, null ]);
        }, _getTempFramebuffer = function(index) {
            return _tempFramebuffers[index] = _tempFramebuffers[index] || _createFramebufferTexture(_width, _height), 
            _tempFramebuffers[index];
        }, _createFramebufferTexture = function(width, height) {
            var fbo = gl.createFramebuffer(), renderbuffer = (gl.bindFramebuffer(gl.FRAMEBUFFER, fbo), 
            gl.createRenderbuffer()), renderbuffer = (gl.bindRenderbuffer(gl.RENDERBUFFER, renderbuffer), 
            gl.createTexture());
            return gl.bindTexture(gl.TEXTURE_2D, renderbuffer), gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, width, height, 0, gl.RGBA, gl.UNSIGNED_BYTE, null), 
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR), gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR), 
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE), 
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE), 
            gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, renderbuffer, 0), 
            gl.bindTexture(gl.TEXTURE_2D, null), gl.bindFramebuffer(gl.FRAMEBUFFER, null), 
            {
                fbo: fbo,
                texture: renderbuffer
            };
        }, _draw = function(flags) {
            var source = null, target = null, flipY = !1, source = 0 == _drawCount ? _sourceTexture : _getTempFramebuffer(_currentFramebufferIndex).texture;
            _drawCount++, !_lastInChain || flags & DRAW.INTERMEDIATE ? target = _getTempFramebuffer(_currentFramebufferIndex = (_currentFramebufferIndex + 1) % 2).fbo : (target = null, 
            flipY = _drawCount % 2 == 0), gl.bindTexture(gl.TEXTURE_2D, source), 
            gl.bindFramebuffer(gl.FRAMEBUFFER, target), gl.uniform1f(_currentProgram.uniform.flipY, flipY ? -1 : 1), 
            gl.drawArrays(gl.TRIANGLES, 0, 6);
        }, _compileShader = function(fragmentSource) {
            var floatSize, vertSize;
            return fragmentSource.__program ? (_currentProgram = fragmentSource.__program, 
            gl.useProgram(_currentProgram.id)) : (_currentProgram = new WebGLProgram(gl, SHADER.VERTEX_IDENTITY, fragmentSource), 
            vertSize = 4 * (floatSize = Float32Array.BYTES_PER_ELEMENT), gl.enableVertexAttribArray(_currentProgram.attribute.pos), 
            gl.vertexAttribPointer(_currentProgram.attribute.pos, 2, gl.FLOAT, !1, vertSize, 0 * floatSize), 
            gl.enableVertexAttribArray(_currentProgram.attribute.uv), gl.vertexAttribPointer(_currentProgram.attribute.uv, 2, gl.FLOAT, !1, vertSize, 2 * floatSize), 
            fragmentSource.__program = _currentProgram), _currentProgram;
        }, DRAW = {
            INTERMEDIATE: 1
        }, SHADER = {}, _filter = (SHADER.VERTEX_IDENTITY = [ "precision highp float;", "attribute vec2 pos;", "attribute vec2 uv;", "varying vec2 vUv;", "uniform float flipY;", "void main(void) {", "vUv = uv;", "gl_Position = vec4(pos.x, pos.y*flipY, 0.0, 1.);", "}" ].join("\n"), 
        SHADER.FRAGMENT_IDENTITY = [ "precision highp float;", "varying vec2 vUv;", "uniform sampler2D texture;", "void main(void) {", "gl_FragColor = texture2D(texture, vUv);", "}" ].join("\n"), 
        {});
        _filter.colorMatrix = function(matrix) {
            var matrix = new Float32Array(matrix), shader = (matrix[4] /= 255, matrix[9] /= 255, 
            matrix[14] /= 255, matrix[19] /= 255, 1 == matrix[18] && 0 == matrix[3] && 0 == matrix[8] && 0 == matrix[13] && 0 == matrix[15] && 0 == matrix[16] && 0 == matrix[17] && 0 == matrix[19] ? _filter.colorMatrix.SHADER.WITHOUT_ALPHA : _filter.colorMatrix.SHADER.WITH_ALPHA), shader = _compileShader(shader);
            gl.uniform1fv(shader.uniform.m, matrix), _draw();
        }, _filter.colorMatrix.SHADER = {}, _filter.colorMatrix.SHADER.WITH_ALPHA = [ "precision highp float;", "varying vec2 vUv;", "uniform sampler2D texture;", "uniform float m[20];", "void main(void) {", "vec4 c = texture2D(texture, vUv);", "gl_FragColor.r = m[0] * c.r + m[1] * c.g + m[2] * c.b + m[3] * c.a + m[4];", "gl_FragColor.g = m[5] * c.r + m[6] * c.g + m[7] * c.b + m[8] * c.a + m[9];", "gl_FragColor.b = m[10] * c.r + m[11] * c.g + m[12] * c.b + m[13] * c.a + m[14];", "gl_FragColor.a = m[15] * c.r + m[16] * c.g + m[17] * c.b + m[18] * c.a + m[19];", "}" ].join("\n"), 
        _filter.colorMatrix.SHADER.WITHOUT_ALPHA = [ "precision highp float;", "varying vec2 vUv;", "uniform sampler2D texture;", "uniform float m[20];", "void main(void) {", "vec4 c = texture2D(texture, vUv);", "gl_FragColor.r = m[0] * c.r + m[1] * c.g + m[2] * c.b + m[4];", "gl_FragColor.g = m[5] * c.r + m[6] * c.g + m[7] * c.b + m[9];", "gl_FragColor.b = m[10] * c.r + m[11] * c.g + m[12] * c.b + m[14];", "gl_FragColor.a = c.a;", "}" ].join("\n"), 
        _filter.brightness = function(brightness) {
            brightness = (brightness || 0) + 1;
            _filter.colorMatrix([ brightness, 0, 0, 0, 0, 0, brightness, 0, 0, 0, 0, 0, brightness, 0, 0, 0, 0, 0, 1, 0 ]);
        }, _filter.saturation = function(amount) {
            var amount = 2 * (amount || 0) / 3 + 1, y = -.5 * (amount - 1);
            _filter.colorMatrix([ amount, y, y, 0, 0, y, amount, y, 0, 0, y, y, amount, 0, 0, 0, 0, 0, 1, 0 ]);
        }, _filter.desaturate = function() {
            _filter.saturation(-1);
        }, _filter.contrast = function(amount) {
            var amount = (amount || 0) + 1, o = -128 * (amount - 1);
            _filter.colorMatrix([ amount, 0, 0, 0, o, 0, amount, 0, 0, o, 0, 0, amount, 0, o, 0, 0, 0, 1, 0 ]);
        }, _filter.negative = function() {
            _filter.contrast(-2);
        }, _filter.hue = function(rotation) {
            rotation = (rotation || 0) / 180 * Math.PI;
            var cos = Math.cos(rotation), rotation = Math.sin(rotation);
            _filter.colorMatrix([ .213 + .787 * cos + -.213 * rotation, .715 + -.715 * cos + -.715 * rotation, .072 + -.072 * cos + .928 * rotation, 0, 0, .213 + -.213 * cos + .143 * rotation, .715 + cos * (1 - .715) + .14 * rotation, .072 + -.072 * cos + -.283 * rotation, 0, 0, .213 + -.213 * cos + -.787 * rotation, .715 + -.715 * cos + .715 * rotation, .072 + .928 * cos + .072 * rotation, 0, 0, 0, 0, 0, 1, 0 ]);
        }, _filter.desaturateLuminance = function() {
            _filter.colorMatrix([ .2764723, .929708, .0938197, 0, -37.1, .2764723, .929708, .0938197, 0, -37.1, .2764723, .929708, .0938197, 0, -37.1, 0, 0, 0, 1, 0 ]);
        }, _filter.sepia = function() {
            _filter.colorMatrix([ .393, .7689999, .18899999, 0, 0, .349, .6859999, .16799999, 0, 0, .272, .5339999, .13099999, 0, 0, 0, 0, 0, 1, 0 ]);
        }, _filter.brownie = function() {
            _filter.colorMatrix([ .5997023498159715, .34553243048391263, -.2708298674538042, 0, 47.43192855600873, -.037703249837783157, .8609577587992641, .15059552388459913, 0, -36.96841498319127, .24113635128153335, -.07441037908422492, .44972182064877153, 0, -7.562075277591283, 0, 0, 0, 1, 0 ]);
        }, _filter.vintagePinhole = function() {
            _filter.colorMatrix([ .6279345635605994, .3202183420819367, -.03965408211312453, 0, 9.651285835294123, .02578397704808868, .6441188644374771, .03259127616149294, 0, 7.462829176470591, .0466055556782719, -.0851232987247891, .5241648018700465, 0, 5.159190588235296, 0, 0, 0, 1, 0 ]);
        }, _filter.kodachrome = function() {
            _filter.colorMatrix([ 1.1285582396593525, -.3967382283601348, -.03992559172921793, 0, 63.72958762196502, -.16404339962244616, 1.0835251566291304, -.05498805115633132, 0, 24.732407896706203, -.16786010706155763, -.5603416277695248, 1.6014850761964943, 0, 35.62982807460946, 0, 0, 0, 1, 0 ]);
        }, _filter.technicolor = function() {
            _filter.colorMatrix([ 1.9125277891456083, -.8545344976951645, -.09155508482755585, 0, 11.793603434377337, -.3087833385928097, 1.7658908555458428, -.10601743074722245, 0, -70.35205161461398, -.231103377548616, -.7501899197440212, 1.847597816108189, 0, 30.950940869491138, 0, 0, 0, 1, 0 ]);
        }, _filter.polaroid = function() {
            _filter.colorMatrix([ 1.438, -.062, -.062, 0, 0, -.122, 1.378, -.122, 0, 0, -.016, -.016, 1.483, 0, 0, 0, 0, 0, 1, 0 ]);
        }, _filter.shiftToBGR = function() {
            _filter.colorMatrix([ 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0 ]);
        }, _filter.convolution = function(matrix) {
            var matrix = new Float32Array(matrix), pixelSizeX = 1 / _width, pixelSizeY = 1 / _height, program = _compileShader(_filter.convolution.SHADER);
            gl.uniform1fv(program.uniform.m, matrix), gl.uniform2f(program.uniform.px, pixelSizeX, pixelSizeY), 
            _draw();
        }, _filter.convolution.SHADER = [ "precision highp float;", "varying vec2 vUv;", "uniform sampler2D texture;", "uniform vec2 px;", "uniform float m[9];", "void main(void) {", "vec4 c11 = texture2D(texture, vUv - px);", "vec4 c12 = texture2D(texture, vec2(vUv.x, vUv.y - px.y));", "vec4 c13 = texture2D(texture, vec2(vUv.x + px.x, vUv.y - px.y));", "vec4 c21 = texture2D(texture, vec2(vUv.x - px.x, vUv.y) );", "vec4 c22 = texture2D(texture, vUv);", "vec4 c23 = texture2D(texture, vec2(vUv.x + px.x, vUv.y) );", "vec4 c31 = texture2D(texture, vec2(vUv.x - px.x, vUv.y + px.y) );", "vec4 c32 = texture2D(texture, vec2(vUv.x, vUv.y + px.y) );", "vec4 c33 = texture2D(texture, vUv + px );", "gl_FragColor = ", "c11 * m[0] + c12 * m[1] + c22 * m[2] +", "c21 * m[3] + c22 * m[4] + c23 * m[5] +", "c31 * m[6] + c32 * m[7] + c33 * m[8];", "gl_FragColor.a = c22.a;", "}" ].join("\n"), 
        _filter.detectEdges = function() {
            _filter.convolution.call(this, [ 0, 1, 0, -3, 1, 0, 1, 0 ]);
        }, _filter.sobelX = function() {
            _filter.convolution.call(this, [ -1, 0, 1, -2, 0, 2, -1, 0, 1 ]);
        }, _filter.sobelY = function() {
            _filter.convolution.call(this, [ -1, -2, -1, 0, 0, 0, 1, 2, 1 ]);
        }, _filter.sharpen = function(amount) {
            amount = amount || 1;
            _filter.convolution.call(this, [ 0, -1 * amount, 0, -1 * amount, 1 + 4 * amount, -1 * amount, 0, -1 * amount, 0 ]);
        }, _filter.emboss = function(size) {
            size = size || 1;
            _filter.convolution.call(this, [ -2 * size, -1 * size, 0, -1 * size, 1, +size, 0, +size, 2 * size ]);
        }, _filter.blur = function(size) {
            var blurSizeX = size / 7 / _width, size = size / 7 / _height, program = _compileShader(_filter.blur.SHADER);
            gl.uniform2f(program.uniform.px, 0, size), _draw(DRAW.INTERMEDIATE), 
            gl.uniform2f(program.uniform.px, blurSizeX, 0), _draw();
        }, _filter.blur.SHADER = [ "precision highp float;", "varying vec2 vUv;", "uniform sampler2D texture;", "uniform vec2 px;", "void main(void) {", "gl_FragColor = vec4(0.0);", "gl_FragColor += texture2D(texture, vUv + vec2(-7.0*px.x, -7.0*px.y))*0.0044299121055113265;", "gl_FragColor += texture2D(texture, vUv + vec2(-6.0*px.x, -6.0*px.y))*0.00895781211794;", "gl_FragColor += texture2D(texture, vUv + vec2(-5.0*px.x, -5.0*px.y))*0.0215963866053;", "gl_FragColor += texture2D(texture, vUv + vec2(-4.0*px.x, -4.0*px.y))*0.0443683338718;", "gl_FragColor += texture2D(texture, vUv + vec2(-3.0*px.x, -3.0*px.y))*0.0776744219933;", "gl_FragColor += texture2D(texture, vUv + vec2(-2.0*px.x, -2.0*px.y))*0.115876621105;", "gl_FragColor += texture2D(texture, vUv + vec2(-1.0*px.x, -1.0*px.y))*0.147308056121;", "gl_FragColor += texture2D(texture, vUv                             )*0.159576912161;", "gl_FragColor += texture2D(texture, vUv + vec2( 1.0*px.x,  1.0*px.y))*0.147308056121;", "gl_FragColor += texture2D(texture, vUv + vec2( 2.0*px.x,  2.0*px.y))*0.115876621105;", "gl_FragColor += texture2D(texture, vUv + vec2( 3.0*px.x,  3.0*px.y))*0.0776744219933;", "gl_FragColor += texture2D(texture, vUv + vec2( 4.0*px.x,  4.0*px.y))*0.0443683338718;", "gl_FragColor += texture2D(texture, vUv + vec2( 5.0*px.x,  5.0*px.y))*0.0215963866053;", "gl_FragColor += texture2D(texture, vUv + vec2( 6.0*px.x,  6.0*px.y))*0.00895781211794;", "gl_FragColor += texture2D(texture, vUv + vec2( 7.0*px.x,  7.0*px.y))*0.0044299121055113265;", "}" ].join("\n"), 
        _filter.gamma = function(amount) {
            var program = _compileShader(_filter.gamma.SHADER);
            gl.uniform1f(program.uniform.gamma, amount), _draw();
        }, _filter.gamma.SHADER = [ "varying vec2 texCoord;", "uniform sampler2D texture;", "uniform highp float gamma;", "void main() {", "vec4 color = texture2D(texture, texCoord);", "color.r = pow(color.r, gamma);", "color.g = pow(color.g, gamma);", "color.b = pow(color.b, gamma);", "gl_FragColor = color;", "}" ].join("\n"), 
        _filter.exposure = function(amount) {
            var program = _compileShader(_filter.exposure.SHADER);
            gl.uniform1f(program.uniform.exposure, amount), _draw();
        }, _filter.exposure.SHADER = [ "varying vec2 texCoord;", "uniform sampler2D texture;", "uniform highp float exposure;", "void main() {", "vec4 textureColor = texture2D(texture, texCoord);", "gl_FragColor = vec4(textureColor.rgb * pow(2.0, exposure), textureColor.a);", "}" ].join("\n"), 
        _filter.dotscreen = function(angle, amount) {
            var program = _compileShader(_filter.dotscreen.SHADER);
            gl.uniform1f(program.uniform.angle, 1), _draw(DRAW.INTERMEDIATE), gl.uniform1f(program.uniform.scale, 5), 
            _draw(DRAW.INTERMEDIATE), gl.uniform4fv(program.uniform.dimensions, [ 0, 0, 0, 0 ]), 
            _draw();
        }, _filter.dotscreen.SHADER = [ "precision mediump float;", "varying vec2 vTextureCoord;", "varying vec4 vColor;", "uniform vec4 dimensions;", "uniform sampler2D uSampler;", "uniform float angle;", "uniform float scale;", "float pattern() {", "float s = sin(angle), c = cos(angle);", "vec2 tex = vTextureCoord * dimensions.xy;", "vec2 point = vec2(", "\tc * tex.x - s * tex.y,", "\ts * tex.x + c * tex.y", ") * scale;", "return (sin(point.x) * sin(point.y)) * 4.0;", "}", "void main() {", "vec4 color = texture2D(uSampler, vTextureCoord);", "float average = (color.r + color.g + color.b) / 3.0;", "gl_FragColor = vec4(vec3(average * 10.0 - 5.0 + pattern()), color.a);", "}" ].join("\n"), 
        _filter.pixelate = function(size) {
            var blurSizeX = size / _width, size = size / _height, program = _compileShader(_filter.pixelate.SHADER);
            gl.uniform2f(program.uniform.size, blurSizeX, size), _draw();
        }, _filter.pixelate.SHADER = [ "precision highp float;", "varying vec2 vUv;", "uniform vec2 size;", "uniform sampler2D texture;", "vec2 pixelate(vec2 coord, vec2 size) {", "return floor( coord / size ) * size;", "}", "void main(void) {", "gl_FragColor = vec4(0.0);", "vec2 coord = pixelate(vUv, size);", "gl_FragColor += texture2D(texture, coord);", "}" ].join("\n");
    };
}(window), function() {
    var DELTA_INDEX = [ 0, .01, .02, .04, .05, .06, .07, .08, .1, .11, .12, .14, .15, .16, .17, .18, .2, .21, .22, .24, .25, .27, .28, .3, .32, .34, .36, .38, .4, .42, .44, .46, .48, .5, .53, .56, .59, .62, .65, .68, .71, .74, .77, .8, .83, .86, .89, .92, .95, .98, 1, 1.06, 1.12, 1.18, 1.24, 1.3, 1.36, 1.42, 1.48, 1.54, 1.6, 1.66, 1.72, 1.78, 1.84, 1.9, 1.96, 2, 2.12, 2.25, 2.37, 2.5, 2.62, 2.75, 2.87, 3, 3.2, 3.4, 3.6, 3.8, 4, 4.3, 4.7, 4.9, 5, 5.5, 6, 6.5, 6.8, 7, 7.3, 7.5, 7.8, 8, 8.4, 8.7, 9, 9.4, 9.6, 9.8, 10 ];
    function multiply(a, b) {
        for (var j, col = [], i = 0; i < 5; i++) {
            for (j = 0; j < 5; j++) col[j] = a[j + 5 * i];
            for (j = 0; j < 5; j++) {
                for (var val = 0, k = 0; k < 5; k++) val += b[j + 5 * k] * col[k];
                a[j + 5 * i] = val;
            }
        }
        return a;
    }
    var identity = [ 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 ];
    function adjustValue(value, limit) {
        return Math.min(limit, Math.max(-limit, value));
    }
    function ColorMatrix(data) {
        this.data = data;
    }
    ColorMatrix.prototype = {
        brightness: function(value) {
            return value = adjustValue(value, 255), this.apply(multiply(identity, [ 1, 0, 0, 0, value, 0, 1, 0, 0, value, 0, 0, 1, 0, value, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 ]));
        },
        contrast: function(value) {
            var x = (value = adjustValue(value, 100)) < 0 ? 127 + value / 100 * 127 : 127 * (x = 0 == (x = value % 1) ? DELTA_INDEX[value] : DELTA_INDEX[value << 0] * (1 - x) + DELTA_INDEX[1 + (value << 0)] * x) + 127;
            return this.apply(multiply(identity, [ x / 127, 0, 0, 0, .5 * (127 - x), 0, x / 127, 0, 0, .5 * (127 - x), 0, 0, x / 127, 0, .5 * (127 - x), 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 ]));
        },
        saturate: function(value) {
            value = 1 + (0 < (value = adjustValue(value, 100)) ? 3 * value / 100 : value / 100);
            return this.apply(multiply(identity, [ .3086 * (1 - value) + value, .6094 * (1 - value), .082 * (1 - value), 0, 0, .3086 * (1 - value), .6094 * (1 - value) + value, .082 * (1 - value), 0, 0, .3086 * (1 - value), .6094 * (1 - value), .082 * (1 - value) + value, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 ]));
        },
        hue: function(value) {
            value = adjustValue(value, 180) / 180 * Math.PI;
            var cosVal = Math.cos(value), value = Math.sin(value);
            return this.apply(multiply(identity, [ .213 + .787 * cosVal + -.213 * value, .715 + -.715 * cosVal + -.715 * value, .072 + -.072 * cosVal + .928 * value, 0, 0, .213 + -.213 * cosVal + .143 * value, .715 + cosVal * (1 - .715) + .14 * value, .072 + -.072 * cosVal + -.283 * value, 0, 0, .213 + -.213 * cosVal + -.787 * value, .715 + -.715 * cosVal + .715 * value, .072 + .928 * cosVal + .072 * value, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 ]));
        },
        polaroid: function() {
            return this.apply(multiply(identity, [ 1.438, -.062, -.062, 0, 0, -.122, 1.378, -.122, 0, 0, -.016, -.016, 1.483, 0, 0, 0, 0, 0, 1, 0 ]));
        },
        filter: function(name, value) {
            name = this[name];
            return name ? name.apply(this, [ value ]) : this;
        },
        apply: function(matrix) {
            for (var r, g, b, a, data = this.data, l = data.length, m0 = matrix[0], m1 = matrix[1], m2 = matrix[2], m3 = matrix[3], m4 = matrix[4], m5 = matrix[5], m6 = matrix[6], m7 = matrix[7], m8 = matrix[8], m9 = matrix[9], m10 = matrix[10], m11 = matrix[11], m12 = matrix[12], m13 = matrix[13], m14 = matrix[14], m15 = matrix[15], m16 = matrix[16], m17 = matrix[17], m18 = matrix[18], m19 = matrix[19], i = 0; i < l; i += 4) r = data[i], 
            g = data[i + 1], b = data[i + 2], a = data[i + 3], data[i] = r * m0 + g * m1 + b * m2 + a * m3 + m4, 
            data[i + 1] = r * m5 + g * m6 + b * m7 + a * m8 + m9, data[i + 2] = r * m10 + g * m11 + b * m12 + a * m13 + m14, 
            data[i + 3] = r * m15 + g * m16 + b * m17 + a * m18 + m19;
            return this;
        }
    }, window.ColorMatrix = ColorMatrix;
}(), function() {
    var ImageFilter = new WebGLImageFilter();
    function Filter(canvas) {
        return this.canvas = canvas, this.context = canvas.getContext("2d"), this.filters = [], 
        this;
    }
    Filter.prototype = {
        apply: function() {
            for (var i = 0; i < this.filters.length; i++) {
                var item = this.filters[i], fn = this[item.name];
                fn && fn.call(this, [ item.values ]), this.filters.splice(i);
            }
            return this;
        },
        add: function(filter, values) {
            return this.filters.push({
                name: filter,
                values: values
            }), this;
        },
        reset: function() {
            return this.filters = [], this;
        },
        _applyWebGlFilter: function(filter, value) {
            var filteredImage;
            ImageFilter.addFilter(filter, value);
            try {
                filteredImage = ImageFilter.apply(this.canvas);
            } catch (err) {}
            filteredImage && this.context.drawImage(filteredImage, 0, 0), ImageFilter.reset();
        },
        _applyColorMatrixFilter: function(filter, amount) {
            var imageData = this.context.getImageData(0, 0, this.canvas.width, this.canvas.height);
            new ColorMatrix(imageData.data).filter(filter, amount), this.context.putImageData(imageData, 0, 0);
        },
        grayscale: function(amount, save) {
            this._filter(function(data) {
                for (var i = 0, len = data.length; i < len; i += 4) {
                    var v = .299 * data[i] + .587 * data[i + 1] + .114 * data[i + 2];
                    data[i] = v, data[i + 1] = v, data[i + 2] = v;
                }
            });
        },
        sepia: function(amount, save) {
            this._filter(function(data, start, end) {
                for (var i = 0, len = data.length; i < len; i += 4) {
                    var r = data[i], g = data[i + 1], b = data[i + 2];
                    data[i] = .393 * r + .769 * g + .189 * b, data[i + 1] = .349 * r + .686 * g + .168 * b, 
                    data[i + 2] = .272 * r + .534 * g + .131 * b;
                }
            });
        },
        invert: function(amount, save) {
            this._filter(function(data) {
                for (var i = 0, len = data.length; i < len; i += 4) data[i] = 255 - data[i], 
                data[i + 1] = 255 - data[i + 1], data[i + 2] = 255 - data[i + 2];
            });
        },
        threshold: function(threshold, save) {
            save && this.save(), threshold = parseInt(threshold) || 128, this._filter(function(data, start, end) {
                for (var i = 0, len = data.length; i < len; i += 4) {
                    var r = data[i], g = data[i + 1], b = data[i + 2], r = Math.round((r + g + b) / 3) >= threshold ? 255 : 0;
                    data[i] = r, data[i + 1] = r, data[i + 2] = r;
                }
            }, threshold);
        },
        brightness: function(amount, save) {
            amount = Math.min(100, Math.max(-100, amount)), this._filter(function(data) {
                for (var i = 0, len = data.length; i < len; i += 4) {
                    var r = data[i], g = data[i + 1], b = data[i + 2];
                    data[i] = Math.max(0, Math.min(255, Math.round(r + amount))), 
                    data[i + 1] = Math.max(0, Math.min(255, Math.round(g + amount))), 
                    data[i + 2] = Math.max(0, Math.min(255, Math.round(b + amount)));
                }
            });
        },
        contrast: function(amount, save) {
            amount = Math.max(-100, Math.min(100, amount));
            var factor = 1;
            function n(x) {
                return Math.max(0, Math.min(255, x));
            }
            factor = 0 < amount ? 1 + amount / 100 : (100 - Math.abs(amount)) / 100, 
            this._filter(function(data) {
                for (var i = 0, len = data.length; i < len; i += 4) {
                    var r = data[i], g = data[i + 1], b = data[i + 2], r = n(factor * (r - 128) + 128), g = n(factor * (g - 128) + 128), b = n(factor * (b - 128) + 128);
                    data[i] = Math.min(255, Math.max(0, Math.round(r))), data[i + 1] = Math.min(255, Math.max(0, Math.round(g))), 
                    data[i + 2] = Math.min(255, Math.max(0, Math.round(b)));
                }
            });
        },
        saturate: function(amount, save) {
            amount = parseFloat(amount) / 100, amount = Math.max(-1, Math.min(1, amount)), 
            this._filter(function(data) {
                for (var i = 0, len = data.length; i < len; i += 4) {
                    var r = data[i], g = data[i + 1], b = data[i + 2], average = (r + g + b) / 3;
                    r += Math.round((r - average) * amount), g += Math.round((g - average) * amount), 
                    b += Math.round((b - average) * amount), data[i] = Math.min(255, Math.max(0, r)), 
                    data[i + 1] = Math.min(255, Math.max(0, g)), data[i + 2] = Math.min(255, Math.max(0, b));
                }
            });
        },
        desaturate: function(amount, save) {
            return this.saturate(0 - amount, save), this;
        },
        hue: function(amount, save) {
            return this._applyColorMatrixFilter("hue", amount), this;
        },
        gamma: function(amount, save) {
            return amount /= 100, this._filter(function(data, start, end) {
                for (var i = 0, len = data.length; i < len; i += 4) {
                    var r = data[i], g = data[i + 1], b = data[i + 2];
                    data[i] = 255 * Math.pow(r / 255, 1 - amount), data[i + 1] = 255 * Math.pow(g / 255, 1 - amount), 
                    data[i + 2] = 255 * Math.pow(b / 255, 1 - amount);
                }
            }), this;
        },
        exposure: function(amount, save) {
            return amount /= 10, this._filter(function(data, start, end) {
                for (var i = 0, len = data.length; i < len; i += 4) {
                    var r = data[i], g = data[i + 1], b = data[i + 2];
                    data[i] = 255 * (1 - Math.exp(-r / 255 * amount)), data[i + 1] = 255 * (1 - Math.exp(-g / 255 * amount)), 
                    data[i + 2] = 255 * (1 - Math.exp(-b / 255 * amount));
                }
            }), this;
        },
        blur: function(amount, save) {
            if (ImageFilter) return this._applyWebGlFilter("blur", amount /= 5);
            var matrix = [ 1 / 9, 1 / 9, 1 / 9, 1 / 9, 1 / 9, 1 / 9, 1 / 9, 1 / 9, 1 / 9 ];
            if (amount) {
                amount = Math.floor(amount / 5), amount = Math.max(1, amount);
                for (var i = 0; i < amount; i++) this.convolution(matrix);
            }
        },
        sharpen: function(amount, save) {
            if (ImageFilter) return this._applyWebGlFilter("sharpen", amount /= 100);
            var matrix = [ 0, -1, 0, -1, 5, -1, 0, -1, 0 ];
            if (amount) {
                amount = Math.floor(amount / 10), amount = Math.max(1, amount);
                for (var i = 0; i < amount; i++) this.convolution(matrix);
            }
        },
        polaroid: function(save) {
            if (ImageFilter) return this._applyWebGlFilter("polaroid");
        },
        vintage: function(save) {
            if (ImageFilter) return this._applyWebGlFilter("vintagePinhole");
        },
        brownie: function(save) {
            if (ImageFilter) return this._applyWebGlFilter("brownie");
        },
        kodachrome: function(save) {
            if (ImageFilter) return this._applyWebGlFilter("kodachrome");
        },
        technicolor: function(save) {
            if (ImageFilter) return this._applyWebGlFilter("technicolor");
        },
        convolution: function(matrix) {
            for (var ctx = this.context, sw = this.canvas.width, sh = this.canvas.height, side = Math.round(Math.sqrt(matrix.length)), halfSide = Math.floor(side / 2), w = sw, h = sh, input = ctx.getImageData(0, 0, sw, sh), output = ctx.createImageData(sw, sh), src = input.data, dst = output.data, y = 0; y < h; y++) for (var x = 0; x < w; x++) {
                for (var sy = y, sx = x, dstOff = 4 * (y * w + x), r = 0, g = 0, b = 0, a = 0, cy = 0; cy < side; cy++) for (var cx = 0; cx < side; cx++) {
                    var wt, scy = sy + cy - halfSide, scx = sx + cx - halfSide;
                    0 <= scy && scy < sh && 0 <= scx && scx < sw && (wt = matrix[cy * side + cx], 
                    r += src[scy = 4 * (scy * sw + scx)] * wt, g += src[1 + scy] * wt, 
                    b += src[2 + scy] * wt, a += src[3 + scy] * wt);
                }
                dst[dstOff] = r, dst[1 + dstOff] = g, dst[2 + dstOff] = b, dst[3 + dstOff] = a;
            }
            ctx.putImageData(output, 0, 0);
        },
        _filter: function(fn, amount) {
            for (var rx, imageData, lastTime, ctx = this.context, rects = [], rectIndex = 0, w = this.canvas.width, h = this.canvas.height, ry = 0; ry < h; ry += 480) for (rx = 0; rx < w; rx += 480) rects.push({
                x: rx,
                y: ry,
                w: w < rx + 480 ? w - rx : 480,
                h: h < ry + 480 ? h - ry : 480
            });
            lastTime = new Date().getTime(), function processNext() {
                var rect = rects[rectIndex++];
                rect && (imageData = ctx.getImageData(rect.x, rect.y, rect.w, rect.h), 
                fn(imageData.data), ctx.putImageData(imageData, rect.x, rect.y), 
                (rect = new Date().getTime()) - lastTime < 1e3 ? processNext() : (lastTime = rect, 
                window.setTimeout(processNext, 0)));
            }();
        }
    }, window.Filter = Filter;
}(jQuery), function($, Wf) {
    $.support.canvas = !!document.createElement("canvas").getContext, $.widget("ui.canvas", {
        stack: [],
        options: {
            onfilterstart: $.noop,
            onfilterprogress: $.noop
        },
        _create: function() {
            this.canvas = document.createElement("canvas"), this.context = this.canvas.getContext("2d", {
                willReadFrequently: !0
            }), this.draw();
        },
        getContext: function() {
            return this.context;
        },
        getCanvas: function() {
            return this.canvas;
        },
        setSize: function(w, h) {
            $.extend(this.options, {
                width: w,
                height: h
            }), this.draw();
        },
        draw: function(el, w, h) {
            el = el || $(this.element).get(0);
            w = w || this.options.width || el.width, h = h || this.options.height || el.height;
            this.save(), $(this.canvas).attr({
                width: w,
                height: h
            }), this.context.drawImage(el, 0, 0, w, h);
        },
        free: function(n) {
            n.getContext("2d").clearRect(0, 0, 0, 0), $(n).remove();
        },
        clone: function() {
            return $(this.canvas).clone().get(0);
        },
        copy: function() {
            var copy = this.clone();
            return copy.getContext("2d").drawImage(this.canvas, 0, 0), copy;
        },
        clear: function() {
            var ctx = this.context, w = $(this.element).width(), h = $(this.element).height();
            ctx && ctx.clearRect(0, 0, w, h);
        },
        resize: function(w, h, save) {
            var ctx = this.context;
            w = parseInt(w), h = parseInt(h), ctx && (save && this.save(), ctx.imageSmoothingEnabled = ctx.mozImageSmoothingEnabled = ctx.webkitImageSmoothingEnabled = !0, 
            (save = this.copy()).getContext("2d").drawImage(this.canvas, 0, 0, w, h), 
            $(this.canvas, save).attr({
                width: w,
                height: h
            }), ctx.drawImage(save, 0, 0), this.free(save));
        },
        crop: function(w, h, x, y, save) {
            var ctx = this.context;
            w = parseInt(w), h = parseInt(h), x = parseInt(x), y = parseInt(y), 
            ctx && (save && this.save(), (x = x < 0 ? 0 : x) > this.canvas.width - 1 && (x = this.canvas.width - 1), 
            (y = y < 0 ? 0 : y) > this.canvas.height - 1 && (y = this.canvas.height - 1), 
            x + (w = w < 1 ? 1 : w) > this.canvas.width && (w = this.canvas.width - x), 
            y + (h = h < 1 ? 1 : h) > this.canvas.height && (h = this.canvas.height - y), 
            ctx.imageSmoothingEnabled = ctx.mozImageSmoothingEnabled = ctx.webkitImageSmoothingEnabled = !0, 
            (save = this.copy()).getContext("2d").drawImage(this.canvas, 0, 0), 
            $(this.canvas).attr({
                width: w,
                height: h
            }), ctx.drawImage(save, x, y, w, h, 0, 0, w, h), this.free(save));
        },
        rotate: function(angle, save) {
            var cw, ch, ctx = this.context, w = this.canvas.width, h = this.canvas.height;
            switch (angle < 0 && (angle += 360), angle) {
              case 90:
              case 270:
                cw = h, ch = w;
                break;

              case 180:
                cw = w, ch = h;
            }
            ctx && (save && this.save(), save = this.copy(), $(this.canvas).attr({
                width: cw,
                height: ch
            }), ctx.translate(cw / 2, ch / 2), ctx.rotate(angle * Math.PI / 180), 
            ctx.drawImage(save, -w / 2, -h / 2), this.free(save));
        },
        flip: function(axis, save) {
            var ctx = this.context, w = this.canvas.width, h = this.canvas.height;
            ctx && (save && this.save(), (save = this.copy()).getContext("2d").drawImage(this.canvas, 0, 0, w, h, 0, 0, w, h), 
            ctx.clearRect(0, 0, w, h), $(this.canvas).attr({
                width: w,
                height: h
            }), "horizontal" == axis ? (ctx.scale(-1, 1), ctx.drawImage(save, -w, 0, w, h)) : (ctx.scale(1, -1), 
            ctx.drawImage(save, 0, -h, w, h)), this.free(save));
        },
        filter: function(filter, amount, save) {
            save && this.save(), new Filter(this.canvas).add(filter, amount).apply();
        },
        save: function() {
            var ctx = this.context, w = this.canvas.width, h = this.canvas.height;
            this.stack.push({
                width: w,
                height: h,
                data: ctx.getImageData(0, 0, w, h)
            });
        },
        restore: function() {
            var ctx = this.context, img = $(this.element).get(0);
            ctx.restore(), ctx.drawImage(img, 0, 0);
        },
        undo: function() {
            var ctx = this.context, item = this.stack.pop();
            item && ($(this.canvas).attr({
                width: item.width,
                height: item.height
            }), item.data ? ctx.putImageData(item.data, 0, 0) : this.restore());
        },
        load: function() {
            var ctx = this.context, w = this.canvas.width, h = this.canvas.height, data = ctx.getImageData(0, 0, w, h);
            ctx.clearRect(0, 0, w, h), ctx.putImageData(data, 0, 0);
        },
        update: function() {
            this.load(), this.stack = [];
        },
        getMime: function(s) {
            var mime = "image/jpeg";
            switch (Wf.String.getExt(s)) {
              case "jpg":
              case "jpeg":
                mime = "image/jpeg";
                break;

              case "png":
                mime = "image/png";
                break;

              case "webp":
                mime = "image/webp";
                break;

              case "bmp":
                mime = "image/bmp";
            }
            return mime;
        },
        resample: function(callback, nw, nh) {
            var self = this, ctx = this.context, w = this.canvas.width, h = this.canvas.height, ctx = ctx.getImageData(0, 0, w, h), data2 = this.copy().getContext("2d").getImageData(0, 0, w, h), worker = new Worker(Wf.getPath() + "/js/worker-hermite.js");
            worker.onmessage = function(event) {
                event = event.data.data;
                self.clear(), self.context.putImageData(event, 0, 0), "function" == typeof callback && callback();
            }, worker.postMessage([ ctx, w, h, nw || w, nh || h, data2 ]);
        },
        output: function(mime, quality, blob) {
            return mime = mime || this.getMime($(this.element).get(0).src), quality = parseInt(quality) || 100, 
            quality = Math.max(Math.min(quality, 100), 10), quality /= 100, this.load(), 
            blob ? function(dataURI, mime) {
                for (var byteString = (0 <= dataURI.split(",")[0].indexOf("base64") ? atob : decodeURIComponent)(dataURI.split(",")[1]), dataURI = new ArrayBuffer(byteString.length), intArray = new Uint8Array(dataURI), i = 0; i < byteString.length; i += 1) intArray[i] = byteString.charCodeAt(i);
                return new Blob([ dataURI ], {
                    type: mime
                });
            }(this.canvas.toDataURL(mime, quality), mime) : this.canvas.toDataURL(mime, quality);
        },
        remove: function() {
            $(this.canvas).remove(), this.destroy();
        }
    });
}(jQuery, Wf), function($, Wf) {
    var $tmp = document.createElement("div"), prefixes = [ "-ms-", "-moz-", "-webkit-", "-o-", "" ], counter = ($.support.filter = !document.documentMode && !window.opera && ($tmp.style.cssText = prefixes.join("filter:grayscale(1); "), 
    !!$tmp.style.length), $.fn.cssFilter = function(o) {
        var filter = o.filter || "", amount = o.amount || 1;
        if (filter) {
            switch (filter) {
              case "desaturate":
              case "saturate":
                0, amount = (100 + amount) / 100, 1, 2, 3, 4, 0, 5, 6, 7, 8, 9, 
                0, 10, 11, 12, 13, 14, 0, 15, 16, 17, 19, 0, 18, filter = "saturate";
                break;

              case "contrast":
              case "invert":
              case "grayscale":
              case "sepia":
                break;

              case "brightness":
                amount /= 100, filter = "brightness";
                break;

              case "blur":
                amount = amount / 100 + "px";
                break;

              case "sharpen":
              case "gamma":
              case "exposure":
                break;

              case "hue":
                amount += "deg", filter = "hue-rotate";
            }
            $(this).attr("style", [ "", "-moz-", "-webkit-", "-ms-", "" ].join("filter:" + filter + "(" + amount + "); "));
        }
        return this;
    }, $.fn.cssTransform = function(transform, amount) {
        var keys = [ "transform", "msTransform", "Transform", "WebkitTransform", "OTransform" ];
        return this.each(function() {
            var n = $(this).get(0);
            switch (transform) {
              case "flip":
                transform = "horizontal" == amount ? "scaleX" : "scaleY", amount = -1;
                break;

              case "rotate":
                amount += "deg";
            }
            $.each(keys, function(o, s) {
                var transforms = n.style[s] || [];
                (transforms = transforms.length ? transforms.split(" ") : transforms).push(transform + "(" + amount + ")"), 
                n.style[s] = transforms.join(" ");
            });
        }), this;
    }, 0);
    function uid() {
        for (var guid = new Date().getTime().toString(32), i = 0; i < 5; i++) guid += Math.floor(65535 * Math.random()).toString(32);
        return "wf_" + guid + (counter++).toString(32);
    }
    function getRatio(o) {
        var r = function gcd(a, b) {
            return 0 == b ? a : gcd(b, a % b);
        }(o.width, o.height);
        return o.width / r / (o.height / r);
    }
    prefixes = {
        stack: [],
        fxstack: [],
        settings: {
            resize_quality: 80,
            onsave: $.noop
        },
        _setLoader: function() {
            $("div.loading", "#editor").show(), $(":input", "#editor").addClass("working-disabled").prop("disabled", !0), 
            this.working = !0;
        },
        _removeLoader: function() {
            $("div.loading", "#editor").hide(), $(":input.working-disabled", "#editor").removeClass("working-disabled").prop("disabled", !1), 
            this.working = !1;
        },
        init: function(options) {
            var self = this;
            if (Wf.init(options), $("#editor").removeClass("offleft"), $(window).on("resize orientationchange", function() {
                self._resizeWin();
            }), this.src = tinyMCEPopup.getWindowArg("url"), !this._validatePath(this.src)) return Wf.Modal.alert("Invalid image file"), 
            !1;
            $.extend(this.settings, {
                width: tinyMCEPopup.getWindowArg("width"),
                height: tinyMCEPopup.getWindowArg("height"),
                onsave: tinyMCEPopup.getWindowArg("onsave")
            }), this._setLoader(), $("<img />").attr("src", this._loadImage(this.src)).one("load", function() {
                var n = this, canvas = ($(n).data("width", n.width).data("height", n.height).appendTo("#editor-image"), 
                $(n).canvas({
                    width: n.width,
                    height: n.height,
                    onfilterprogress: function(e, n) {
                        1 == n && self._removeLoader();
                    }
                }), $(n).canvas("getCanvas"));
                $(canvas).insertAfter(n), self.position(), self._createToolBox(), 
                self._createFX(), self._removeLoader();
            }).on("error", function() {
                return Wf.Modal.alert("Invalid image file"), !1;
            }).hide(), $("#transform_tab").accordion().on("accordion.activate", function(e, tab, panel) {
                tab = $(tab).data("action");
                self.reset(!0), tab && self._initTransform(tab);
            }).children(".uk-accordion-title").first().click, $("#tabs").tabs().on("tabs.activate", function() {
                self.reset(!0), self._resetFX();
            }), $("button.save").on("click", function(e) {
                self.save(), e.preventDefault();
            }).prop("disabled", !0), $("button.revert").on("click", function(e) {
                self.revert(e), e.preventDefault();
            }).prop("disabled", !0), $("button.undo").on("click", function(e) {
                e.preventDefault(), self.undo(e);
            }).prop("disabled", !0), $("button.apply", "#editor").on("click", function(e) {
                e.preventDefault(), self._applyTransform($(this).data("function"));
            }), $("button.reset", "#transform_tab").on("click", function(e) {
                e.preventDefault(), self._resetTransform($(this).data("function"));
            }), $("#effects_apply").on("click", function(e) {
                e.preventDefault(), self._resetFX(), $("img", "#editor-image").canvas("update"), 
                self.stack = [], $("button.undo").prop("disabled", !0);
            }), $("#effects_reset").on("click", function(e) {
                e.preventDefault(), self._resetFX(), self.revert(e);
            });
        },
        _createToolBox: function() {
            var self = this, $img = $("img", "#editor-image"), canvas = $img.canvas("getCanvas"), iw = canvas.width, ih = canvas.height;
            $("#crop_presets option, #resize_presets option").each(function() {
                var w, v = $(this).val();
                v && /[0-9]+x[0-9]+/.test(v) && (v = v.split("x"), w = parseFloat(v[0]), 
                v = parseFloat(v[1]), w >= $img.data("width")) && v >= $img.data("height") && $(this).remove();
            }), $("#resize_presets").on("change", function() {
                var r, r1, v = $(this).val();
                v && (v = -1 != v.indexOf(":") ? (r = v.split(":"), r1 = parseInt($.trim(r[0])), 
                r = parseInt($.trim(r[1])), r1 = ih < iw && r1 < r || r1 < r ? r / r1 : r1 / r, 
                r = Math.round(iw / r1), Math.round(ih / r1)) : (v = v.split("x"), 
                r = parseFloat($.trim(v[0])), parseFloat($.trim(v[1]))), $("#resize_width").val(r).data("tmp", r), 
                $("#resize_height").val(v).data("tmp", v), r1 = !!$("#resize_constrain").prop("checked") && r / v, 
                $(canvas).resize("setRatio", r1), $(canvas).resize("setSize", r, v));
            }), $("option", "#resize_presets").first().text(function(i, txt) {
                return iw + " x " + ih + " (" + txt + ")";
            }), $("#resize_width").val(iw).data("tmp", iw).on("change", function() {
                var tw, w = $(this).val(), $height = $("#resize_height"), w = w || $(this).data("tmp");
                $("#resize_constrain").prop("checked") && (tw = $(this).data("tmp"), 
                tw = ($height.val() / tw * w).toFixed(0), $height.val(tw).data("tmp", tw)), 
                $(this).data("tmp", w), $(canvas).resize("setSize", w, $height.val());
            }), $("#resize_height").val(ih).data("tmp", ih).on("change", function() {
                var th, h = $(this).val(), $width = $("#resize_width"), h = h || $(this).data("tmp");
                $("#resize_constrain").prop("checked") && (th = $(this).data("tmp"), 
                th = ($width.val() / th * h).toFixed(0), $width.val(th).data("tmp", th)), 
                $(this).data("tmp", h), $(canvas).resize("setSize", $width.val(), h);
            }), $("#resize_constrain").on("click", function() {
                var ratio = !!this.checked && {
                    width: $("#resize_width").val(),
                    height: $("#resize_height").val()
                };
                $(canvas).resize("setConstrain", ratio);
            }), $.each([ "width", "height" ], function(i, key) {
                $("#crop_" + key).val(canvas[key]).data("tmp", canvas[key]);
            }), $("#crop_width, #crop_height").on("change", function() {
                var w = $("#crop_width").val(), h = $("#crop_height").val(), s = {
                    width: w,
                    height: h
                }, ratio = s.width / s.height;
                $("#crop_constrain").is(":checked") && $(canvas).crop("setRatio", ratio), 
                $("#crop_presets").val(w + "x" + h), $(canvas).crop("setArea", s, !0);
            }), $("#crop_x, #crop_y").val(0).on("change", function() {
                var data = {}, ratio = ($(this).parents(".uk-form").find('input[type="text"]').each(function() {
                    var key = this.id.replace("crop_", ""), val = $(this).val() || 0;
                    data[key] = parseInt(val);
                }), data.width / data.height);
                $("#crop_constrain").is(":checked") && $(canvas).crop("setRatio", ratio), 
                $(canvas).crop("setArea", data, !0);
            }), $("#crop_constrain").on("click", function() {
                var state = $(this).is(":checked");
                state ? ($("#crop_presets").trigger("change"), $(this).addClass("checked")) : $(this).removeClass("checked"), 
                $(canvas).crop("setConstrain", state);
            }), $("#crop_presets").on("change", function() {
                var r1, r, ratio, img = $img.get(0), v = $(this).val();
                v && (img = {
                    width: img.width,
                    height: img.height
                }, -1 != v.indexOf(":") ? (r = v.split(":"), ratio = (r1 = parseInt($.trim(r[0]))) < (r = parseInt($.trim(r[1]))) ? r / r1 : r1 / r, 
                img.height < img.width ? (r1 < r && (ratio = r / r1), img.height = Math.round(img.width / ratio)) : img.width = Math.round(img.height / ratio)) : (v = v.split("x"), 
                img.width = parseInt($.trim(v[0])), img.height = parseInt($.trim(v[1])), 
                ratio = img.width / img.height), $("#crop_constrain").is(":checked") && $(canvas).crop("setRatio", ratio), 
                $("#crop_width").val(img.width).data("tmp", img.width), $("#crop_height").val(img.height).data("tmp", img.height), 
                $(canvas).crop("setArea", img, !1));
            }), $("option", "#crop_presets").first().text(function(i, txt) {
                return iw + " x " + ih + " (" + txt + ")";
            }).val(iw + "x" + ih), $("#transform-crop-cancel").on("click", function() {
                self.reset();
            }), $("#rotate-angle-clockwise").on("click", function() {
                self._applyTransform("rotate", 90);
            }), $("#rotate-angle-anticlockwise").on("click", function() {
                self._applyTransform("rotate", -90);
            }), $("#rotate-flip-vertical").on("click", function() {
                self._applyTransform("flip", "vertical");
            }), $("#rotate-flip-horizontal").on("click", function() {
                self._applyTransform("flip", "horizontal");
            });
        },
        _createFX: function() {
            var func, wait, immediate, timeout, self = this, $img = $("img", "#editor-image"), debounceApply = ($("#editor_effects").empty(), 
            func = function(fx, amount) {
                self._applyFx(fx, amount);
            }, wait = 500, function() {
                var context = this, args = arguments, callNow = immediate && !timeout;
                clearTimeout(timeout), timeout = setTimeout(function() {
                    timeout = null, immediate || func.apply(context, args);
                }, wait), callNow && func.apply(context, args);
            });
            $.each({
                brightness: {
                    factor: 10,
                    preview: 150
                },
                contrast: {
                    factor: 10,
                    preview: 2
                },
                hue: {
                    factor: 1,
                    preview: 90,
                    min: -180,
                    max: 180
                },
                saturation: {
                    factor: 10,
                    preview: 200,
                    filter: "saturate",
                    min: -10,
                    max: 10,
                    step: 1,
                    value: 0
                },
                sharpen: {
                    factor: 10,
                    preview: 70,
                    min: 0,
                    webgl: !0
                },
                blur: {
                    factor: 10,
                    preview: 70,
                    min: 0,
                    webgl: !0
                },
                gamma: {
                    factor: 1,
                    preview: 50,
                    min: -100,
                    max: 100,
                    value: 0,
                    step: 1
                }
            }, function(k, v) {
                var canvas, fx = $img.clone().addClass("uk-responsive-width").appendTo("#editor_effects").wrap('<div class="editor_effect uk-width-1-1 uk-grid uk-grid-small"></div>').wrap('<div class="editor_effect_preview uk-width-1-4 uk-float-left"></div>'), filter = v.filter || k, controls = (v = $.extend({
                    step: 1,
                    min: -10,
                    max: 10,
                    value: 0
                }, v), $.support.filter ? ($(fx).show().cssFilter({
                    filter: filter,
                    amount: v.preview
                }), canvas = fx) : ($(fx).canvas().canvas("filter", [ filter, v.preview ]), 
                canvas = $(fx).canvas("getCanvas"), $(canvas).insertAfter(fx)), 
                $('<div class="uk-form-row uk-width-3-4 uk-float-left"><label class="uk-form-label uk-width-7-10 uk-text-left uk-text-bold">' + tinyMCEPopup.getLang("dlg.fx_" + k, k) + '</label><div class="uk-width-3-10"><input type="number" class="uk-width-1-1" value="" /></div><div class="uk-width-1-1 uk-margin-small-top"><input type="range" class="uk-width-1-1" value="" /></div></div>').insertAfter($(fx).parent()));
                $('input[type="number"], input[type="range"]', controls).on("change", function(event) {
                    var x = parseInt(this.value);
                    $("input", controls).not(this).val(x), debounceApply(filter, v.factor * x);
                }), $('input[type="range"]', controls).on("input", function(event) {
                    $('input[type="number"]', controls).val(parseInt(this.value));
                }), $.each(v, function(attr, value) {
                    "preview" !== attr && "factor" !== attr && "filter" !== attr && $('input[type="number"], input[type="range"]', controls).attr(attr, value);
                });
            }), $.each({
                grayscale: 1,
                invert: 1,
                sepia: 1,
                polaroid: 1,
                vintage: 1,
                brownie: 1,
                kodachrome: 1,
                technicolor: 1
            }, function(k, v) {
                var canvas, fx = $img.clone().addClass("uk-responsive-width");
                fx.appendTo("#editor_effects").wrap('<div class="editor_effect uk-width-1-3 uk-flex uk-flex-column uk-margin-top" role="button" aria-label="' + tinyMCEPopup.getLang("dlg.fx_" + k, k) + '"></div>').after('<span class="uk-label uk-text-small">' + tinyMCEPopup.getLang("dlg.fx_" + k, k) + "</span>").wrap('<div class="editor_effect_preview" role="presentation"></div>'), 
                fx.on("load", function() {
                    $.support.filter && 0 <= $.inArray(k, [ "grayscale", "invert", "sepia" ]) ? ($(fx).show().cssFilter({
                        filter: k
                    }), canvas = fx) : ($(fx).canvas(), $(fx).canvas("filter", k), 
                    canvas = $(fx).canvas("getCanvas"), $(canvas).insertAfter(fx)), 
                    $(canvas).on("click", function() {
                        self._applyFx(k, v);
                    });
                });
            });
        },
        _resetFX: function() {
            $('input[type="range"], input[type="number"]', "#editor_effects").val(0);
        },
        _resizeWin: function() {},
        _initTransform: function(fn) {
            var img = $("img", "#editor-image").get(0), canvas = $(img).canvas("getCanvas");
            switch (this.position(), fn) {
              case "resize":
                $(canvas).resize({
                    width: canvas.width,
                    height: canvas.height,
                    ratio: !!$("span.checkbox", "#resize_constrain").is(".checked") && getRatio(canvas),
                    resize: function(e, size) {
                        $("#resize_width").val(size.width).data("tmp", size.width), 
                        $("#resize_height").val(size.height).data("tmp", size.height);
                    },
                    stop: function() {
                        $("#resize_reset").prop("disabled", !1);
                    }
                });
                break;

              case "crop":
                $(canvas).crop({
                    width: canvas.width,
                    height: canvas.height,
                    ratio: !!$("#crop_constrain").is(":checked") && getRatio(canvas),
                    clone: $(img).canvas("copy"),
                    start: function() {
                        $("#crop_presets").val("");
                    },
                    stop: function(e, props) {
                        $("#crop_reset").prop("disabled", !1), $("#crop_presets").val(props.width + "x" + props.height);
                    },
                    change: function(e, props) {
                        e.originalEvent && "drag" == e.originalEvent.type && (props.width = props.height = null), 
                        $(e.target).trigger("update", props);
                    },
                    reset: function(e, props) {
                        $(e.target).trigger("update", props);
                    }
                }).on("update", function(e, props) {
                    $("#crop_width").val(function(i, value) {
                        return props.width || value;
                    }), $("#crop_height").val(function(i, value) {
                        return props.height || value;
                    }), $("#crop_x").val(props.x), $("#crop_y").val(props.y);
                });
            }
        },
        _resetTransform: function(fn) {
            var img = $("img", "#editor-image").get(0), canvas = $(img).canvas("getCanvas"), w = canvas.width || $(canvas).width(), h = canvas.height || $(canvas).height();
            switch (fn) {
              case "resize":
                this.position(), $.data(canvas, "uiResize") && $(canvas).resize("reset"), 
                $("#resize_reset").prop("disabled", !0), $("#resize_width").val(w).data("tmp", w), 
                $("#resize_height").val(h).data("tmp", h), $("#resize_presets").val($("#resize_presets option:first").val());
                break;

              case "crop":
                $.data(canvas, "uiCrop") && $(canvas).crop("reset"), $("#crop_reset").prop("disabled", !0), 
                $("#crop_presets").val($("#crop_presets option:first").val()), $("#crop_width").val(w).data("tmp", w), 
                $("#crop_height").val(h).data("tmp", h), $("#crop_x, #crop_y").val(0);
            }
        },
        updateCSSTransform: function(k, v) {
            $("#rotate_angle img, #rotate_flip img, #editor_effects img, #editor_effects canvas").cssTransform(k, v);
        },
        undoCSSTransform: function(revert) {
            var keys = [ "transform", "msTransform", "Transform", "WebkitTransform", "OTransform" ];
            $("#rotate_angle img, #rotate_flip img").each(function() {
                var n = $(this).get(0);
                $.each(keys, function(i, s) {
                    var transforms = n.style[s] || [];
                    transforms.length && (transforms = transforms.split(" ")), revert ? transforms = [ transforms.shift() ] : transforms.pop(), 
                    n.style[s] = transforms.join(" ");
                });
            }), $("#editor_effects img, #editor_effects canvas").each(function() {
                var n = $(this).get(0);
                $.each(keys, function(i, s) {
                    var transforms = n.style[s] || [];
                    transforms.length && (transforms = transforms.split(" ")), revert ? transforms = [] : transforms.pop(), 
                    n.style[s] = transforms.join(" ");
                });
            });
        },
        undo: function(e) {
            var data = this.stack.pop();
            $("img", "#editor-image").canvas("undo"), this.stack.length || $("button.undo, button.revert, button.save").prop("disabled", !0), 
            "resize" === data.task || "crop" === data.task ? (this.reset(!0), this._initTransform(data.task)) : (this.position(), 
            e && this._resetFX());
        },
        revert: function(e) {
            var $img = $("img", "#editor-image"), img = $img.get(0);
            $img.canvas("clear").canvas("draw", img, img.width, img.height), this.stack = [], 
            $("button.undo, button.revert, button.save").prop("disabled", !0), e && this._resetFX(), 
            this.reset(!0);
        },
        reset: function(rw) {
            var self = this, canvas = $("img", "#editor-image").canvas("getCanvas");
            $.each([ "resize", "crop", "rotate" ], function(i, fn) {
                self._resetTransform(fn);
            }), rw && ($.data(canvas, "uiResize") && $(canvas).resize("remove"), 
            $.data(canvas, "uiCrop") && $(canvas).crop("remove"), $.data(canvas, "uiRotate")) && $(canvas).rotate("remove"), 
            this.position();
        },
        position: function() {
            var w, h, canvas = $("img", "#editor-image").canvas("getCanvas"), pw = $("#editor-image").width() - 20, ph = $("#editor-image").height() - 20, pct = 10, pw = ($(canvas).css({
                width: "",
                height: ""
            }), $(canvas).width() > pw && (w = Math.round(pw - pw / 100 * pct), 
            h = Math.round(canvas.height * (w / canvas.width)), $(canvas).width(w).height(h), 
            pct += 10), $(canvas).height() > ph && (h = Math.round(ph - ph / 100 * pct), 
            w = Math.round(canvas.width * (h / canvas.height)), $(canvas).height(h).width(w), 
            pct += 10), $(canvas).height() || canvas.height);
            $(canvas).css({
                top: (ph - pw) / 2
            });
        },
        _apply: function(k, v) {
            var self = this, deferred = $.Deferred(), $img = $("img", "#editor-image"), name = Wf.String.basename(self.src), src = tinyMCEPopup.getWindowArg("src"), name = $img.canvas("output", self.getMime(name), 100, !0);
            function cleanTemp(src) {
                Wf.JSON.request("cleanEditorTmp", {
                    json: [ src ]
                });
            }
            return self.sendBinary(name, {
                method: "applyImageEdit",
                id: uid(),
                params: [ src, k, v ]
            }).then(function(o) {
                if (o.files) {
                    var img = new Image(), o = (img.onload = function() {
                        return $img.canvas("draw", img, img.width, img.height), 
                        self.position(), self._removeLoader(), cleanTemp(src), deferred.resolve(), 
                        !0;
                    }, img.onerror = function() {
                        return self._removeLoader(), Wf.Modal.alert('Action "' + k + '" failed. Temp image could not be loaded.'), 
                        cleanTemp(src), deferred.reject(), !1;
                    }, o.files[0] || "");
                    if (!(o = o.replace(/[^\w\.\-\/\\\\\s ]/gi, ""))) return cleanTemp(src), 
                    !1;
                    img.src = self._loadImage(Wf.String.path(Wf.getURI(), o));
                }
            }).fail(function(s) {
                return s && Wf.Modal.alert(s), deferred.reject(), cleanTemp(src), 
                !1;
            }).always(function() {
                self._removeLoader();
            }), deferred;
        },
        _applyFx: function() {
            var length = this.stack.length, $img = $("img", "#editor-image"), args = $.makeArray(arguments), filter = args.shift(), amount = args.shift();
            this._setLoader(), length && (length = this.stack[length - 1], args) && length.task === filter && this.undo(), 
            this.addUndo({
                task: filter,
                args: amount
            }), $img.canvas("filter", filter, amount, !0), this._removeLoader(), 
            $("button.undo, button.revert, button.save").prop("disabled", !1);
        },
        addUndo: function(data) {
            this.stack.push(data);
        },
        _applyTransform: function() {
            var self = this, $img = $("img", "#editor-image"), args = $.makeArray(arguments), fn = args.shift(), amount = args.shift();
            function done(fn) {
                $("button.undo, button.revert, button.save").prop("disabled", !1), 
                self.reset(!0), self._initTransform(fn);
            }
            switch (self._setLoader(), fn) {
              case "resize":
                var w = $("#resize_width").val(), h = $("#resize_height").val();
                this._apply("resize", {
                    width: w,
                    height: h
                }).then(function() {
                    args = [ w, h ], self.addUndo({
                        task: fn,
                        args: args
                    });
                }).always(function() {
                    done(fn);
                });
                break;

              case "crop":
                var s = {
                    width: $("#crop_width").val(),
                    height: $("#crop_height").val(),
                    x: $("#crop_x").val(),
                    y: $("#crop_y").val()
                };
                this._apply("crop", s).then(function() {
                    args = [ s.width, s.height, s.x, s.y ], self.addUndo({
                        task: fn,
                        args: args
                    });
                }).always(function() {
                    done(fn);
                });
                break;

              case "rotate":
                $img.canvas("rotate", amount, !0), self.position(), self._removeLoader(), 
                this.addUndo({
                    task: fn,
                    args: amount
                }), done(fn);
                break;

              case "flip":
                $img.canvas("flip", amount, !0), self.position(), self._removeLoader(), 
                this.addUndo({
                    task: fn,
                    args: amount
                }), done(fn);
            }
        },
        getMime: function(s) {
            var mime = "image/jpeg";
            switch (Wf.String.getExt(s)) {
              case "jpg":
              case "jpeg":
                mime = "image/jpeg";
                break;

              case "png":
                mime = "image/png";
                break;

              case "webp":
                mime = "image/webp";
                break;

              case "bmp":
                mime = "image/bmp";
            }
            return mime;
        },
        save: function(name) {
            var self = this, $img = $("img", "#editor-image"), extras = '<div class="uk-form-row uk-grid"><label for="image_quality" class="uk-form-label uk-width-3-10">' + tinyMCEPopup.getLang("dlg.quality", "Quality") + '</label><div class="uk-form-controls uk-width-7-10 uk-margin-remove"><input type="range" min="1" max="100" id="image_quality_slider" value="100" class="uk-width-3-5" /><input type="number" id="image_quality" min="1" max="100" value="100" class="quality" /> %</div></div>', name = Wf.String.basename(this.src), ext = (name = Wf.String.stripExt(name), 
            Wf.String.getExt(this.src)), options = FileBrowser.options;
            Wf.Modal.prompt(tinyMCEPopup.getLang("dlg.save_image", "Save Image"), function(name) {
                name = Wf.String.safe(name, options.websafe_mode, options.websafe_spaces, options.websafe_textcase);
                var quality = $("#image_quality").val() || 100, src = (self._setLoader(), 
                name = name + "." + ext || Wf.String.basename(self.src), tinyMCEPopup.getWindowArg("src")), quality = $img.canvas("output", self.getMime(name), quality, !0);
                quality && self.sendBinary(quality, {
                    method: "saveImageEdit",
                    id: uid(),
                    params: [ src, name ]
                }).then(function(o) {
                    if (o.files) {
                        if (self.src = o.files[0] || "", !self.src || !self._validatePath(self.src)) return Wf.Modal.alert("Invalid image file"), 
                        !1;
                        var img = new Image(), o = (img.onload = function() {
                            $("img", "#editor-image").attr("src", img.src).on("load", function() {
                                self._createFX(), $(this).canvas("draw", img, img.width, img.height);
                            });
                        }, img.src = self._loadImage(Wf.getURI() + self.src), self.settings);
                        o.onsave.apply(o.scope || self, [ self.src ]), self.stack = [], 
                        $("button.undo, button.revert, button.save").prop("disabled", !0);
                    }
                }).fail(function(s) {
                    Wf.Modal.alert(s);
                }).always(function() {
                    self._removeLoader();
                });
            }, {
                text: tinyMCEPopup.getLang("dlg.name", "Name"),
                elements: extras,
                height: 240,
                value: name,
                open: function() {
                    $("#dialog-prompt-input").parent().addClass("uk-form-icon uk-form-icon-flip").append('<span class="uk-text-muted uk-icon-none">.' + ext + "</span>"), 
                    $("#image_quality_slider").on("change", function() {
                        $("#image_quality").val(this.value);
                    }), $("#image_quality").on("change", function() {
                        $("#image_quality_slider").val(this.value);
                    });
                },
                validate: function(value) {
                    return !!value && Wf.String.safe(value, options.websafe_mode, options.websafe_spaces, options.websafe_textcase);
                }
            });
        },
        sendBinary: function(data, json, cb) {
            var ed = tinyMCEPopup.editor, deferred = $.Deferred(), url = (url = document.location.href).replace(/&wf([a-z0-9]+)=1/, ""), fd = (url += "&" + ed.settings.query, 
            new FormData()), ed = new XMLHttpRequest(), url = (ed.open("POST", url, !0), 
            ed.setRequestHeader("X-Requested-With", "XMLHttpRequest"), ed.onload = function() {
                var r = {}, error = "An error occured processing this image.";
                if (data = fd = null, 200 == this.status) try {
                    r = JSON.parse(this.response);
                } catch (e) {
                    return deferred.reject("The server returned an invalid JSON response."), 
                    !1;
                }
                if ($.isPlainObject(r)) return r.error ? (deferred.reject(r.error.message || error), 
                !1) : r.result ? void deferred.resolve(r.result) : (deferred.reject(error), 
                !1);
                /[{}]/.test(r) && (error = "The server returned an invalid JSON response."), 
                deferred.reject(error);
            }, fd.append("json", JSON.stringify(json)), Wf.String.basename(json.params[0]));
            return fd.append("file", data, url), ed.send(fd), deferred;
        },
        _validatePath: function(s) {
            if (/\.{2,}/.test(s) || /:\/\//.test(s) && -1 == s.indexOf(Wf.getURI(!0))) return !1;
            if (/:\/\//.test(s) && (s = Wf.URL.toRelative(s)), /[^\w~\.\-\s \/\\\\]/i.test(s)) for (var i = 0, ln = s.length; i < ln; i++) {
                var ch = s[i];
                if (/[^\w~\.\-\s \/\\\\]/i.test(ch) && function(c) {
                    for (c = c.toString(16).toUpperCase(); c.length < 4; ) c = "0" + c;
                    return "\\u" + c;
                }(ch.charCodeAt(0)) < "\\u007F") return !1;
            }
            return !0;
        },
        _loadImage: function(src) {
            return src + "?" + new Date().getTime();
        }
    };
    window.ImageEditor = prefixes;
}(jQuery, Wf);